# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InterceptDeploymentArgs', 'InterceptDeployment']

@pulumi.input_type
class InterceptDeploymentArgs:
    def __init__(__self__, *,
                 forwarding_rule: pulumi.Input[builtins.str],
                 intercept_deployment_group: pulumi.Input[builtins.str],
                 intercept_deployment_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InterceptDeployment resource.
        :param pulumi.Input[builtins.str] forwarding_rule: The regional forwarding rule that fronts the interceptors, for example:
               `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_group: The deployment group that this deployment is a part of, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_id: The ID to use for the new deployment, which will become the final
               component of the deployment's resource name.
        :param pulumi.Input[builtins.str] location: The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        :param pulumi.Input[builtins.str] description: User-provided description of the deployment.
               Used as additional context for the deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "intercept_deployment_group", intercept_deployment_group)
        pulumi.set(__self__, "intercept_deployment_id", intercept_deployment_id)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> pulumi.Input[builtins.str]:
        """
        The regional forwarding rule that fronts the interceptors, for example:
        `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "forwarding_rule")

    @forwarding_rule.setter
    def forwarding_rule(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "forwarding_rule", value)

    @property
    @pulumi.getter(name="interceptDeploymentGroup")
    def intercept_deployment_group(self) -> pulumi.Input[builtins.str]:
        """
        The deployment group that this deployment is a part of, for example:
        `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_deployment_group")

    @intercept_deployment_group.setter
    def intercept_deployment_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "intercept_deployment_group", value)

    @property
    @pulumi.getter(name="interceptDeploymentId")
    def intercept_deployment_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the new deployment, which will become the final
        component of the deployment's resource name.
        """
        return pulumi.get(self, "intercept_deployment_id")

    @intercept_deployment_id.setter
    def intercept_deployment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "intercept_deployment_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the deployment.
        Used as additional context for the deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InterceptDeploymentState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InterceptDeployment resources.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[builtins.str] description: User-provided description of the deployment.
               Used as additional context for the deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] forwarding_rule: The regional forwarding rule that fronts the interceptors, for example:
               `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_group: The deployment group that this deployment is a part of, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_id: The ID to use for the new deployment, which will become the final
               component of the deployment's resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        :param pulumi.Input[builtins.str] name: The resource name of this deployment, for example:
               `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
               See https://google.aip.dev/122 for more details.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This part of the normal
               operation (e.g. linking a new association to the parent group).
               See https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] state: The current state of the deployment.
               See https://google.aip.dev/216.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               CREATING
               DELETING
               OUT_OF_SYNC
               DELETE_FAILED
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if intercept_deployment_group is not None:
            pulumi.set(__self__, "intercept_deployment_group", intercept_deployment_group)
        if intercept_deployment_id is not None:
            pulumi.set(__self__, "intercept_deployment_id", intercept_deployment_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the deployment.
        Used as additional context for the deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The regional forwarding rule that fronts the interceptors, for example:
        `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "forwarding_rule")

    @forwarding_rule.setter
    def forwarding_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forwarding_rule", value)

    @property
    @pulumi.getter(name="interceptDeploymentGroup")
    def intercept_deployment_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deployment group that this deployment is a part of, for example:
        `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_deployment_group")

    @intercept_deployment_group.setter
    def intercept_deployment_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "intercept_deployment_group", value)

    @property
    @pulumi.getter(name="interceptDeploymentId")
    def intercept_deployment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the new deployment, which will become the final
        component of the deployment's resource name.
        """
        return pulumi.get(self, "intercept_deployment_id")

    @intercept_deployment_id.setter
    def intercept_deployment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "intercept_deployment_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of this deployment, for example:
        `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
        See https://google.aip.dev/122 for more details.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This part of the normal
        operation (e.g. linking a new association to the parent group).
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the deployment.
        See https://google.aip.dev/216.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        CREATING
        DELETING
        OUT_OF_SYNC
        DELETE_FAILED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/interceptDeployment:InterceptDeployment")
class InterceptDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A deployment represents a zonal intercept backend ready to accept
        GENEVE-encapsulated traffic, e.g. a zonal instance group fronted by an
        internal passthrough load balancer. Deployments are always part of a
        global deployment group which represents a global intercept service.

        ## Example Usage

        ### Network Security Intercept Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="example-network",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="example-subnet",
            region="us-central1",
            ip_cidr_range="10.1.0.0/16",
            network=network.name)
        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="example-hc",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        backend_service = gcp.compute.RegionBackendService("backend_service",
            name="example-bs",
            region="us-central1",
            health_checks=health_check.id,
            protocol="UDP",
            load_balancing_scheme="INTERNAL")
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="example-fwr",
            region="us-central1",
            network=network.name,
            subnetwork=subnetwork.name,
            backend_service=backend_service.id,
            load_balancing_scheme="INTERNAL",
            ports=["6081"],
            ip_protocol="UDP")
        deployment_group = gcp.networksecurity.InterceptDeploymentGroup("deployment_group",
            intercept_deployment_group_id="example-dg",
            location="global",
            network=network.id)
        default = gcp.networksecurity.InterceptDeployment("default",
            intercept_deployment_id="example-deployment",
            location="us-central1-a",
            forwarding_rule=forwarding_rule.id,
            intercept_deployment_group=deployment_group.id,
            description="some description",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        InterceptDeployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/interceptDeployments/{{intercept_deployment_id}}`

        * `{{project}}/{{location}}/{{intercept_deployment_id}}`

        * `{{location}}/{{intercept_deployment_id}}`

        When using the `pulumi import` command, InterceptDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default projects/{{project}}/locations/{{location}}/interceptDeployments/{{intercept_deployment_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default {{project}}/{{location}}/{{intercept_deployment_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default {{location}}/{{intercept_deployment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User-provided description of the deployment.
               Used as additional context for the deployment.
        :param pulumi.Input[builtins.str] forwarding_rule: The regional forwarding rule that fronts the interceptors, for example:
               `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_group: The deployment group that this deployment is a part of, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_id: The ID to use for the new deployment, which will become the final
               component of the deployment's resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterceptDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A deployment represents a zonal intercept backend ready to accept
        GENEVE-encapsulated traffic, e.g. a zonal instance group fronted by an
        internal passthrough load balancer. Deployments are always part of a
        global deployment group which represents a global intercept service.

        ## Example Usage

        ### Network Security Intercept Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="example-network",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="example-subnet",
            region="us-central1",
            ip_cidr_range="10.1.0.0/16",
            network=network.name)
        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="example-hc",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        backend_service = gcp.compute.RegionBackendService("backend_service",
            name="example-bs",
            region="us-central1",
            health_checks=health_check.id,
            protocol="UDP",
            load_balancing_scheme="INTERNAL")
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="example-fwr",
            region="us-central1",
            network=network.name,
            subnetwork=subnetwork.name,
            backend_service=backend_service.id,
            load_balancing_scheme="INTERNAL",
            ports=["6081"],
            ip_protocol="UDP")
        deployment_group = gcp.networksecurity.InterceptDeploymentGroup("deployment_group",
            intercept_deployment_group_id="example-dg",
            location="global",
            network=network.id)
        default = gcp.networksecurity.InterceptDeployment("default",
            intercept_deployment_id="example-deployment",
            location="us-central1-a",
            forwarding_rule=forwarding_rule.id,
            intercept_deployment_group=deployment_group.id,
            description="some description",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        InterceptDeployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/interceptDeployments/{{intercept_deployment_id}}`

        * `{{project}}/{{location}}/{{intercept_deployment_id}}`

        * `{{location}}/{{intercept_deployment_id}}`

        When using the `pulumi import` command, InterceptDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default projects/{{project}}/locations/{{location}}/interceptDeployments/{{intercept_deployment_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default {{project}}/{{location}}/{{intercept_deployment_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptDeployment:InterceptDeployment default {{location}}/{{intercept_deployment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InterceptDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterceptDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterceptDeploymentArgs.__new__(InterceptDeploymentArgs)

            __props__.__dict__["description"] = description
            if forwarding_rule is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_rule'")
            __props__.__dict__["forwarding_rule"] = forwarding_rule
            if intercept_deployment_group is None and not opts.urn:
                raise TypeError("Missing required property 'intercept_deployment_group'")
            __props__.__dict__["intercept_deployment_group"] = intercept_deployment_group
            if intercept_deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'intercept_deployment_id'")
            __props__.__dict__["intercept_deployment_id"] = intercept_deployment_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(InterceptDeployment, __self__).__init__(
            'gcp:networksecurity/interceptDeployment:InterceptDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
            intercept_deployment_group: Optional[pulumi.Input[builtins.str]] = None,
            intercept_deployment_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'InterceptDeployment':
        """
        Get an existing InterceptDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[builtins.str] description: User-provided description of the deployment.
               Used as additional context for the deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] forwarding_rule: The regional forwarding rule that fronts the interceptors, for example:
               `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_group: The deployment group that this deployment is a part of, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_deployment_id: The ID to use for the new deployment, which will become the final
               component of the deployment's resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        :param pulumi.Input[builtins.str] name: The resource name of this deployment, for example:
               `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
               See https://google.aip.dev/122 for more details.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This part of the normal
               operation (e.g. linking a new association to the parent group).
               See https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] state: The current state of the deployment.
               See https://google.aip.dev/216.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               CREATING
               DELETING
               OUT_OF_SYNC
               DELETE_FAILED
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterceptDeploymentState.__new__(_InterceptDeploymentState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["forwarding_rule"] = forwarding_rule
        __props__.__dict__["intercept_deployment_group"] = intercept_deployment_group
        __props__.__dict__["intercept_deployment_id"] = intercept_deployment_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return InterceptDeployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided description of the deployment.
        Used as additional context for the deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> pulumi.Output[builtins.str]:
        """
        The regional forwarding rule that fronts the interceptors, for example:
        `projects/123456789/regions/us-central1/forwardingRules/my-rule`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "forwarding_rule")

    @property
    @pulumi.getter(name="interceptDeploymentGroup")
    def intercept_deployment_group(self) -> pulumi.Output[builtins.str]:
        """
        The deployment group that this deployment is a part of, for example:
        `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_deployment_group")

    @property
    @pulumi.getter(name="interceptDeploymentId")
    def intercept_deployment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the new deployment, which will become the final
        component of the deployment's resource name.
        """
        return pulumi.get(self, "intercept_deployment_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The cloud location of the deployment, e.g. `us-central1-a` or `asia-south1-b`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of this deployment, for example:
        `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
        See https://google.aip.dev/122 for more details.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This part of the normal
        operation (e.g. linking a new association to the parent group).
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the deployment.
        See https://google.aip.dev/216.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        CREATING
        DELETING
        OUT_OF_SYNC
        DELETE_FAILED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

