# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterceptEndpointGroupAssociationInitArgs', 'InterceptEndpointGroupAssociation']

@pulumi.input_type
class InterceptEndpointGroupAssociationInitArgs:
    def __init__(__self__, *,
                 intercept_endpoint_group: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 intercept_endpoint_group_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InterceptEndpointGroupAssociation resource.
        :param pulumi.Input[builtins.str] intercept_endpoint_group: The endpoint group that this association is connected to, for example:
               `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] location: The cloud location of the association, currently restricted to `global`.
        :param pulumi.Input[builtins.str] network: The VPC network that is associated. for example:
               `projects/123456789/global/networks/my-network`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_endpoint_group_association_id: The ID to use for the new association, which will become the final
               component of the endpoint group's resource name. If not provided, the
               server will generate a unique ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "intercept_endpoint_group", intercept_endpoint_group)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        if intercept_endpoint_group_association_id is not None:
            pulumi.set(__self__, "intercept_endpoint_group_association_id", intercept_endpoint_group_association_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="interceptEndpointGroup")
    def intercept_endpoint_group(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint group that this association is connected to, for example:
        `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_endpoint_group")

    @intercept_endpoint_group.setter
    def intercept_endpoint_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "intercept_endpoint_group", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The VPC network that is associated. for example:
        `projects/123456789/global/networks/my-network`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="interceptEndpointGroupAssociationId")
    def intercept_endpoint_group_association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the new association, which will become the final
        component of the endpoint group's resource name. If not provided, the
        server will generate a unique ID.
        """
        return pulumi.get(self, "intercept_endpoint_group_association_id")

    @intercept_endpoint_group_association_id.setter
    def intercept_endpoint_group_association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "intercept_endpoint_group_association_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InterceptEndpointGroupAssociationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 intercept_endpoint_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_endpoint_group_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationArgs']]]] = None,
                 locations_details: Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationsDetailArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InterceptEndpointGroupAssociation resources.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] intercept_endpoint_group: The endpoint group that this association is connected to, for example:
               `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_endpoint_group_association_id: The ID to use for the new association, which will become the final
               component of the endpoint group's resource name. If not provided, the
               server will generate a unique ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the association, currently restricted to `global`.
        :param pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationArgs']]] locations: The list of locations where the association is configured. This information
               is retrieved from the linked endpoint group.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationsDetailArgs']]] locations_details: (Deprecated)
               The list of locations where the association is present. This information
               is retrieved from the linked endpoint group, and not configured as part
               of the association itself.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of this endpoint group association, for example:
               `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg-association`.
               See https://google.aip.dev/122 for more details.
        :param pulumi.Input[builtins.str] network: The VPC network that is associated. for example:
               `projects/123456789/global/networks/my-network`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This part of the normal
               operation (e.g. adding a new location to the target deployment group).
               See https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if intercept_endpoint_group is not None:
            pulumi.set(__self__, "intercept_endpoint_group", intercept_endpoint_group)
        if intercept_endpoint_group_association_id is not None:
            pulumi.set(__self__, "intercept_endpoint_group_association_id", intercept_endpoint_group_association_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if locations_details is not None:
            warnings.warn("""`locationsDetails` is deprecated and will be removed in a future major release. Use `locations` instead.""", DeprecationWarning)
            pulumi.log.warn("""locations_details is deprecated: `locationsDetails` is deprecated and will be removed in a future major release. Use `locations` instead.""")
        if locations_details is not None:
            pulumi.set(__self__, "locations_details", locations_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="interceptEndpointGroup")
    def intercept_endpoint_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint group that this association is connected to, for example:
        `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_endpoint_group")

    @intercept_endpoint_group.setter
    def intercept_endpoint_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "intercept_endpoint_group", value)

    @property
    @pulumi.getter(name="interceptEndpointGroupAssociationId")
    def intercept_endpoint_group_association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the new association, which will become the final
        component of the endpoint group's resource name. If not provided, the
        server will generate a unique ID.
        """
        return pulumi.get(self, "intercept_endpoint_group_association_id")

    @intercept_endpoint_group_association_id.setter
    def intercept_endpoint_group_association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "intercept_endpoint_group_association_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationArgs']]]]:
        """
        The list of locations where the association is configured. This information
        is retrieved from the linked endpoint group.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="locationsDetails")
    @_utilities.deprecated("""`locationsDetails` is deprecated and will be removed in a future major release. Use `locations` instead.""")
    def locations_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationsDetailArgs']]]]:
        """
        (Deprecated)
        The list of locations where the association is present. This information
        is retrieved from the linked endpoint group, and not configured as part
        of the association itself.
        Structure is documented below.
        """
        return pulumi.get(self, "locations_details")

    @locations_details.setter
    def locations_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterceptEndpointGroupAssociationLocationsDetailArgs']]]]):
        pulumi.set(self, "locations_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of this endpoint group association, for example:
        `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg-association`.
        See https://google.aip.dev/122 for more details.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC network that is associated. for example:
        `projects/123456789/global/networks/my-network`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This part of the normal
        operation (e.g. adding a new location to the target deployment group).
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation")
class InterceptEndpointGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 intercept_endpoint_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_endpoint_group_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An endpoint group association represents a link between a network and an
        endpoint group in the organization.

        Creating an association creates the networking infrastructure linking the
        network to the endpoint group, but does not enable intercept by itself.
        To enable intercept, the user must also create a network firewall policy
        containing intercept rules and associate it with the network.

        ## Example Usage

        ### Network Security Intercept Endpoint Group Association Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_network = gcp.compute.Network("producer_network",
            name="example-prod-network",
            auto_create_subnetworks=False)
        consumer_network = gcp.compute.Network("consumer_network",
            name="example-cons-network",
            auto_create_subnetworks=False)
        deployment_group = gcp.networksecurity.InterceptDeploymentGroup("deployment_group",
            intercept_deployment_group_id="example-dg",
            location="global",
            network=producer_network.id)
        endpoint_group = gcp.networksecurity.InterceptEndpointGroup("endpoint_group",
            intercept_endpoint_group_id="example-eg",
            location="global",
            intercept_deployment_group=deployment_group.id)
        default = gcp.networksecurity.InterceptEndpointGroupAssociation("default",
            intercept_endpoint_group_association_id="example-ega",
            location="global",
            network=consumer_network.id,
            intercept_endpoint_group=endpoint_group.id,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        InterceptEndpointGroupAssociation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/interceptEndpointGroupAssociations/{{intercept_endpoint_group_association_id}}`

        * `{{project}}/{{location}}/{{intercept_endpoint_group_association_id}}`

        * `{{location}}/{{intercept_endpoint_group_association_id}}`

        When using the `pulumi import` command, InterceptEndpointGroupAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default projects/{{project}}/locations/{{location}}/interceptEndpointGroupAssociations/{{intercept_endpoint_group_association_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default {{project}}/{{location}}/{{intercept_endpoint_group_association_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default {{location}}/{{intercept_endpoint_group_association_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] intercept_endpoint_group: The endpoint group that this association is connected to, for example:
               `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_endpoint_group_association_id: The ID to use for the new association, which will become the final
               component of the endpoint group's resource name. If not provided, the
               server will generate a unique ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the association, currently restricted to `global`.
        :param pulumi.Input[builtins.str] network: The VPC network that is associated. for example:
               `projects/123456789/global/networks/my-network`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterceptEndpointGroupAssociationInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An endpoint group association represents a link between a network and an
        endpoint group in the organization.

        Creating an association creates the networking infrastructure linking the
        network to the endpoint group, but does not enable intercept by itself.
        To enable intercept, the user must also create a network firewall policy
        containing intercept rules and associate it with the network.

        ## Example Usage

        ### Network Security Intercept Endpoint Group Association Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_network = gcp.compute.Network("producer_network",
            name="example-prod-network",
            auto_create_subnetworks=False)
        consumer_network = gcp.compute.Network("consumer_network",
            name="example-cons-network",
            auto_create_subnetworks=False)
        deployment_group = gcp.networksecurity.InterceptDeploymentGroup("deployment_group",
            intercept_deployment_group_id="example-dg",
            location="global",
            network=producer_network.id)
        endpoint_group = gcp.networksecurity.InterceptEndpointGroup("endpoint_group",
            intercept_endpoint_group_id="example-eg",
            location="global",
            intercept_deployment_group=deployment_group.id)
        default = gcp.networksecurity.InterceptEndpointGroupAssociation("default",
            intercept_endpoint_group_association_id="example-ega",
            location="global",
            network=consumer_network.id,
            intercept_endpoint_group=endpoint_group.id,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        InterceptEndpointGroupAssociation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/interceptEndpointGroupAssociations/{{intercept_endpoint_group_association_id}}`

        * `{{project}}/{{location}}/{{intercept_endpoint_group_association_id}}`

        * `{{location}}/{{intercept_endpoint_group_association_id}}`

        When using the `pulumi import` command, InterceptEndpointGroupAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default projects/{{project}}/locations/{{location}}/interceptEndpointGroupAssociations/{{intercept_endpoint_group_association_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default {{project}}/{{location}}/{{intercept_endpoint_group_association_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation default {{location}}/{{intercept_endpoint_group_association_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InterceptEndpointGroupAssociationInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterceptEndpointGroupAssociationInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 intercept_endpoint_group: Optional[pulumi.Input[builtins.str]] = None,
                 intercept_endpoint_group_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterceptEndpointGroupAssociationInitArgs.__new__(InterceptEndpointGroupAssociationInitArgs)

            if intercept_endpoint_group is None and not opts.urn:
                raise TypeError("Missing required property 'intercept_endpoint_group'")
            __props__.__dict__["intercept_endpoint_group"] = intercept_endpoint_group
            __props__.__dict__["intercept_endpoint_group_association_id"] = intercept_endpoint_group_association_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["locations"] = None
            __props__.__dict__["locations_details"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(InterceptEndpointGroupAssociation, __self__).__init__(
            'gcp:networksecurity/interceptEndpointGroupAssociation:InterceptEndpointGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            intercept_endpoint_group: Optional[pulumi.Input[builtins.str]] = None,
            intercept_endpoint_group_association_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterceptEndpointGroupAssociationLocationArgs', 'InterceptEndpointGroupAssociationLocationArgsDict']]]]] = None,
            locations_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterceptEndpointGroupAssociationLocationsDetailArgs', 'InterceptEndpointGroupAssociationLocationsDetailArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'InterceptEndpointGroupAssociation':
        """
        Get an existing InterceptEndpointGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] intercept_endpoint_group: The endpoint group that this association is connected to, for example:
               `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] intercept_endpoint_group_association_id: The ID to use for the new association, which will become the final
               component of the endpoint group's resource name. If not provided, the
               server will generate a unique ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The cloud location of the association, currently restricted to `global`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterceptEndpointGroupAssociationLocationArgs', 'InterceptEndpointGroupAssociationLocationArgsDict']]]] locations: The list of locations where the association is configured. This information
               is retrieved from the linked endpoint group.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterceptEndpointGroupAssociationLocationsDetailArgs', 'InterceptEndpointGroupAssociationLocationsDetailArgsDict']]]] locations_details: (Deprecated)
               The list of locations where the association is present. This information
               is retrieved from the linked endpoint group, and not configured as part
               of the association itself.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of this endpoint group association, for example:
               `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg-association`.
               See https://google.aip.dev/122 for more details.
        :param pulumi.Input[builtins.str] network: The VPC network that is associated. for example:
               `projects/123456789/global/networks/my-network`.
               See https://google.aip.dev/124.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This part of the normal
               operation (e.g. adding a new location to the target deployment group).
               See https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterceptEndpointGroupAssociationState.__new__(_InterceptEndpointGroupAssociationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["intercept_endpoint_group"] = intercept_endpoint_group
        __props__.__dict__["intercept_endpoint_group_association_id"] = intercept_endpoint_group_association_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["locations"] = locations
        __props__.__dict__["locations_details"] = locations_details
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return InterceptEndpointGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="interceptEndpointGroup")
    def intercept_endpoint_group(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint group that this association is connected to, for example:
        `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "intercept_endpoint_group")

    @property
    @pulumi.getter(name="interceptEndpointGroupAssociationId")
    def intercept_endpoint_group_association_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID to use for the new association, which will become the final
        component of the endpoint group's resource name. If not provided, the
        server will generate a unique ID.
        """
        return pulumi.get(self, "intercept_endpoint_group_association_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence['outputs.InterceptEndpointGroupAssociationLocation']]:
        """
        The list of locations where the association is configured. This information
        is retrieved from the linked endpoint group.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="locationsDetails")
    @_utilities.deprecated("""`locationsDetails` is deprecated and will be removed in a future major release. Use `locations` instead.""")
    def locations_details(self) -> pulumi.Output[Sequence['outputs.InterceptEndpointGroupAssociationLocationsDetail']]:
        """
        (Deprecated)
        The list of locations where the association is present. This information
        is retrieved from the linked endpoint group, and not configured as part
        of the association itself.
        Structure is documented below.
        """
        return pulumi.get(self, "locations_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of this endpoint group association, for example:
        `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg-association`.
        See https://google.aip.dev/122 for more details.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The VPC network that is associated. for example:
        `projects/123456789/global/networks/my-network`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This part of the normal
        operation (e.g. adding a new location to the target deployment group).
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

