# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddressGroupIamBindingCondition',
    'AddressGroupIamMemberCondition',
    'AuthorizationPolicyRule',
    'AuthorizationPolicyRuleDestination',
    'AuthorizationPolicyRuleDestinationHttpHeaderMatch',
    'AuthorizationPolicyRuleSource',
    'AuthzPolicyCustomProvider',
    'AuthzPolicyCustomProviderAuthzExtension',
    'AuthzPolicyCustomProviderCloudIap',
    'AuthzPolicyHttpRule',
    'AuthzPolicyHttpRuleFrom',
    'AuthzPolicyHttpRuleFromNotSource',
    'AuthzPolicyHttpRuleFromNotSourcePrincipal',
    'AuthzPolicyHttpRuleFromNotSourceResource',
    'AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount',
    'AuthzPolicyHttpRuleFromNotSourceResourceTagValueIdSet',
    'AuthzPolicyHttpRuleFromSource',
    'AuthzPolicyHttpRuleFromSourcePrincipal',
    'AuthzPolicyHttpRuleFromSourceResource',
    'AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount',
    'AuthzPolicyHttpRuleFromSourceResourceTagValueIdSet',
    'AuthzPolicyHttpRuleTo',
    'AuthzPolicyHttpRuleToNotOperation',
    'AuthzPolicyHttpRuleToNotOperationHeaderSet',
    'AuthzPolicyHttpRuleToNotOperationHeaderSetHeader',
    'AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue',
    'AuthzPolicyHttpRuleToNotOperationHost',
    'AuthzPolicyHttpRuleToNotOperationPath',
    'AuthzPolicyHttpRuleToOperation',
    'AuthzPolicyHttpRuleToOperationHeaderSet',
    'AuthzPolicyHttpRuleToOperationHeaderSetHeader',
    'AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue',
    'AuthzPolicyHttpRuleToOperationHost',
    'AuthzPolicyHttpRuleToOperationPath',
    'AuthzPolicyTarget',
    'ClientTlsPolicyClientCertificate',
    'ClientTlsPolicyClientCertificateCertificateProviderInstance',
    'ClientTlsPolicyClientCertificateGrpcEndpoint',
    'ClientTlsPolicyServerValidationCa',
    'ClientTlsPolicyServerValidationCaCertificateProviderInstance',
    'ClientTlsPolicyServerValidationCaGrpcEndpoint',
    'InterceptDeploymentGroupConnectedEndpointGroup',
    'InterceptDeploymentGroupLocation',
    'InterceptEndpointGroupAssociation',
    'InterceptEndpointGroupAssociationLocation',
    'InterceptEndpointGroupAssociationLocationsDetail',
    'InterceptEndpointGroupConnectedDeploymentGroup',
    'InterceptEndpointGroupConnectedDeploymentGroupLocation',
    'MirroringDeploymentGroupConnectedEndpointGroup',
    'MirroringDeploymentGroupLocation',
    'MirroringEndpointGroupAssociation',
    'MirroringEndpointGroupAssociationLocation',
    'MirroringEndpointGroupAssociationLocationsDetail',
    'MirroringEndpointGroupConnectedDeploymentGroup',
    'MirroringEndpointGroupConnectedDeploymentGroupLocation',
    'SecurityProfileCustomInterceptProfile',
    'SecurityProfileCustomMirroringProfile',
    'SecurityProfileThreatPreventionProfile',
    'SecurityProfileThreatPreventionProfileAntivirusOverride',
    'SecurityProfileThreatPreventionProfileSeverityOverride',
    'SecurityProfileThreatPreventionProfileThreatOverride',
    'ServerTlsPolicyMtlsPolicy',
    'ServerTlsPolicyMtlsPolicyClientValidationCa',
    'ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance',
    'ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint',
    'ServerTlsPolicyServerCertificate',
    'ServerTlsPolicyServerCertificateCertificateProviderInstance',
    'ServerTlsPolicyServerCertificateGrpcEndpoint',
]

@pulumi.output_type
class AddressGroupIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AddressGroupIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AuthorizationPolicyRule(dict):
    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.AuthorizationPolicyRuleDestination']] = None,
                 sources: Optional[Sequence['outputs.AuthorizationPolicyRuleSource']] = None):
        """
        :param Sequence['AuthorizationPolicyRuleDestinationArgs'] destinations: List of attributes for the traffic destination. All of the destinations must match. A destination is a match if a request matches all the specified hosts, ports, methods and headers.
               If not set, the action specified in the 'action' field will be applied without any rule checks for the destination.
               Structure is documented below.
        :param Sequence['AuthorizationPolicyRuleSourceArgs'] sources: List of attributes for the traffic source. All of the sources must match. A source is a match if both principals and ipBlocks match.
               If not set, the action specified in the 'action' field will be applied without any rule checks for the source.
               Structure is documented below.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.AuthorizationPolicyRuleDestination']]:
        """
        List of attributes for the traffic destination. All of the destinations must match. A destination is a match if a request matches all the specified hosts, ports, methods and headers.
        If not set, the action specified in the 'action' field will be applied without any rule checks for the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AuthorizationPolicyRuleSource']]:
        """
        List of attributes for the traffic source. All of the sources must match. A source is a match if both principals and ipBlocks match.
        If not set, the action specified in the 'action' field will be applied without any rule checks for the source.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class AuthorizationPolicyRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaderMatch":
            suggest = "http_header_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[builtins.str],
                 methods: Sequence[builtins.str],
                 ports: Sequence[builtins.int],
                 http_header_match: Optional['outputs.AuthorizationPolicyRuleDestinationHttpHeaderMatch'] = None):
        """
        :param Sequence[builtins.str] hosts: List of host names to match. Matched against the ":authority" header in http requests. At least one host should match. Each host can be an exact match, or a prefix match (example "mydomain.*") or a suffix match (example "*.myorg.com") or a presence (any) match "*".
        :param Sequence[builtins.str] methods: A list of HTTP methods to match. At least one method should match. Should not be set for gRPC services.
        :param Sequence[builtins.int] ports: List of destination ports to match. At least one port should match.
        :param 'AuthorizationPolicyRuleDestinationHttpHeaderMatchArgs' http_header_match: Match against key:value pair in http header. Provides a flexible match based on HTTP headers, for potentially advanced use cases. At least one header should match.
               Avoid using header matches to make authorization decisions unless there is a strong guarantee that requests arrive through a trusted client or proxy.
               Structure is documented below.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "ports", ports)
        if http_header_match is not None:
            pulumi.set(__self__, "http_header_match", http_header_match)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[builtins.str]:
        """
        List of host names to match. Matched against the ":authority" header in http requests. At least one host should match. Each host can be an exact match, or a prefix match (example "mydomain.*") or a suffix match (example "*.myorg.com") or a presence (any) match "*".
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> Sequence[builtins.str]:
        """
        A list of HTTP methods to match. At least one method should match. Should not be set for gRPC services.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[builtins.int]:
        """
        List of destination ports to match. At least one port should match.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="httpHeaderMatch")
    def http_header_match(self) -> Optional['outputs.AuthorizationPolicyRuleDestinationHttpHeaderMatch']:
        """
        Match against key:value pair in http header. Provides a flexible match based on HTTP headers, for potentially advanced use cases. At least one header should match.
        Avoid using header matches to make authorization decisions unless there is a strong guarantee that requests arrive through a trusted client or proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "http_header_match")


@pulumi.output_type
class AuthorizationPolicyRuleDestinationHttpHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleDestinationHttpHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleDestinationHttpHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleDestinationHttpHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 regex_match: builtins.str):
        """
        :param builtins.str header_name: The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method".
        :param builtins.str regex_match: The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port specified in the HTTP request, use a headerMatch with headerName set to Host and a regular expression that satisfies the RFC2616 Host header's port specifier.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method".
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> builtins.str:
        """
        The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port specified in the HTTP request, use a headerMatch with headerName set to Host and a regular expression that satisfies the RFC2616 Host header's port specifier.
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class AuthorizationPolicyRuleSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlocks":
            suggest = "ip_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_blocks: Optional[Sequence[builtins.str]] = None,
                 principals: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] ip_blocks: List of CIDR ranges to match based on source IP address. At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone should be avoided.
               The IP addresses of any load balancers or proxies should be considered untrusted.
        :param Sequence[builtins.str] principals: List of peer identities to match for authorization. At least one principal should match. Each peer can be an exact match, or a prefix match (example, "namespace/*") or a suffix match (example, "*/service-account") or a presence match "*".
               Authorization based on the principal name without certificate validation (configured by ServerTlsPolicy resource) is considered insecure.
        """
        if ip_blocks is not None:
            pulumi.set(__self__, "ip_blocks", ip_blocks)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter(name="ipBlocks")
    def ip_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        List of CIDR ranges to match based on source IP address. At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone should be avoided.
        The IP addresses of any load balancers or proxies should be considered untrusted.
        """
        return pulumi.get(self, "ip_blocks")

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence[builtins.str]]:
        """
        List of peer identities to match for authorization. At least one principal should match. Each peer can be an exact match, or a prefix match (example, "namespace/*") or a suffix match (example, "*/service-account") or a presence match "*".
        Authorization based on the principal name without certificate validation (configured by ServerTlsPolicy resource) is considered insecure.
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class AuthzPolicyCustomProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authzExtension":
            suggest = "authz_extension"
        elif key == "cloudIap":
            suggest = "cloud_iap"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyCustomProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyCustomProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyCustomProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authz_extension: Optional['outputs.AuthzPolicyCustomProviderAuthzExtension'] = None,
                 cloud_iap: Optional['outputs.AuthzPolicyCustomProviderCloudIap'] = None):
        """
        :param 'AuthzPolicyCustomProviderAuthzExtensionArgs' authz_extension: Delegate authorization decision to user authored Service Extension. Only one of cloudIap or authzExtension can be specified.
               Structure is documented below.
        :param 'AuthzPolicyCustomProviderCloudIapArgs' cloud_iap: Delegates authorization decisions to Cloud IAP. Applicable only for managed load balancers. Enabling Cloud IAP at the AuthzPolicy level is not compatible with Cloud IAP settings in the BackendService. Enabling IAP in both places will result in request failure. Ensure that IAP is enabled in either the AuthzPolicy or the BackendService but not in both places.
               Structure is documented below.
        """
        if authz_extension is not None:
            pulumi.set(__self__, "authz_extension", authz_extension)
        if cloud_iap is not None:
            pulumi.set(__self__, "cloud_iap", cloud_iap)

    @property
    @pulumi.getter(name="authzExtension")
    def authz_extension(self) -> Optional['outputs.AuthzPolicyCustomProviderAuthzExtension']:
        """
        Delegate authorization decision to user authored Service Extension. Only one of cloudIap or authzExtension can be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "authz_extension")

    @property
    @pulumi.getter(name="cloudIap")
    def cloud_iap(self) -> Optional['outputs.AuthzPolicyCustomProviderCloudIap']:
        """
        Delegates authorization decisions to Cloud IAP. Applicable only for managed load balancers. Enabling Cloud IAP at the AuthzPolicy level is not compatible with Cloud IAP settings in the BackendService. Enabling IAP in both places will result in request failure. Ensure that IAP is enabled in either the AuthzPolicy or the BackendService but not in both places.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_iap")


@pulumi.output_type
class AuthzPolicyCustomProviderAuthzExtension(dict):
    def __init__(__self__, *,
                 resources: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] resources: A list of references to authorization extensions that will be invoked for requests matching this policy. Limited to 1 custom provider.
        """
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def resources(self) -> Sequence[builtins.str]:
        """
        A list of references to authorization extensions that will be invoked for requests matching this policy. Limited to 1 custom provider.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class AuthzPolicyCustomProviderCloudIap(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Enable Cloud IAP at the AuthzPolicy level.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable Cloud IAP at the AuthzPolicy level.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AuthzPolicyHttpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional['outputs.AuthzPolicyHttpRuleFrom'] = None,
                 to: Optional['outputs.AuthzPolicyHttpRuleTo'] = None,
                 when: Optional[builtins.str] = None):
        """
        :param 'AuthzPolicyHttpRuleFromArgs' from_: Describes properties of one or more sources of a request.
               Structure is documented below.
        :param 'AuthzPolicyHttpRuleToArgs' to: Describes properties of one or more targets of a request
               Structure is documented below.
        :param builtins.str when: CEL expression that describes the conditions to be satisfied for the action. The result of the CEL expression is ANDed with the from and to. Refer to the CEL language reference for a list of available attributes.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional['outputs.AuthzPolicyHttpRuleFrom']:
        """
        Describes properties of one or more sources of a request.
        Structure is documented below.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional['outputs.AuthzPolicyHttpRuleTo']:
        """
        Describes properties of one or more targets of a request
        Structure is documented below.
        """
        return pulumi.get(self, "to")

    @property
    @pulumi.getter
    def when(self) -> Optional[builtins.str]:
        """
        CEL expression that describes the conditions to be satisfied for the action. The result of the CEL expression is ANDed with the from and to. Refer to the CEL language reference for a list of available attributes.
        """
        return pulumi.get(self, "when")


@pulumi.output_type
class AuthzPolicyHttpRuleFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notSources":
            suggest = "not_sources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_sources: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSource']] = None,
                 sources: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSource']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleFromNotSourceArgs'] not_sources: Describes the properties of a request's sources. At least one of sources or notSources must be specified. Limited to 5 sources. A match occurs when ANY source (in sources or notSources) matches the request. Within a single source, the match follows AND semantics across fields and OR semantics within a single field, i.e. a match occurs when ANY principal matches AND ANY ipBlocks match.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleFromSourceArgs'] sources: Describes the properties of a request's sources. At least one of sources or notSources must be specified. Limited to 5 sources. A match occurs when ANY source (in sources or notSources) matches the request. Within a single source, the match follows AND semantics across fields and OR semantics within a single field, i.e. a match occurs when ANY principal matches AND ANY ipBlocks match.
               Structure is documented below.
        """
        if not_sources is not None:
            pulumi.set(__self__, "not_sources", not_sources)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="notSources")
    def not_sources(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSource']]:
        """
        Describes the properties of a request's sources. At least one of sources or notSources must be specified. Limited to 5 sources. A match occurs when ANY source (in sources or notSources) matches the request. Within a single source, the match follows AND semantics across fields and OR semantics within a single field, i.e. a match occurs when ANY principal matches AND ANY ipBlocks match.
        Structure is documented below.
        """
        return pulumi.get(self, "not_sources")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSource']]:
        """
        Describes the properties of a request's sources. At least one of sources or notSources must be specified. Limited to 5 sources. A match occurs when ANY source (in sources or notSources) matches the request. Within a single source, the match follows AND semantics across fields and OR semantics within a single field, i.e. a match occurs when ANY principal matches AND ANY ipBlocks match.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class AuthzPolicyHttpRuleFromNotSource(dict):
    def __init__(__self__, *,
                 principals: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSourcePrincipal']] = None,
                 resources: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSourceResource']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleFromNotSourcePrincipalArgs'] principals: A list of identities derived from the client's certificate. This field will not match on a request unless mutual TLS is enabled for the Forwarding rule or Gateway. Each identity is a string whose value is matched against the URI SAN, or DNS SAN or the subject field in the client's certificate. The match can be exact, prefix, suffix or a substring match. One of exact, prefix, suffix or contains must be specified.
               Limited to 5 principals.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleFromNotSourceResourceArgs'] resources: A list of resources to match against the resource of the source VM of a request.
               Limited to 5 resources.
               Structure is documented below.
        """
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSourcePrincipal']]:
        """
        A list of identities derived from the client's certificate. This field will not match on a request unless mutual TLS is enabled for the Forwarding rule or Gateway. Each identity is a string whose value is matched against the URI SAN, or DNS SAN or the subject field in the client's certificate. The match can be exact, prefix, suffix or a substring match. One of exact, prefix, suffix or contains must be specified.
        Limited to 5 principals.
        Structure is documented below.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromNotSourceResource']]:
        """
        A list of resources to match against the resource of the source VM of a request.
        Limited to 5 resources.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class AuthzPolicyHttpRuleFromNotSourcePrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromNotSourcePrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromNotSourcePrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromNotSourcePrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleFromNotSourceResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamServiceAccount":
            suggest = "iam_service_account"
        elif key == "tagValueIdSet":
            suggest = "tag_value_id_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromNotSourceResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromNotSourceResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromNotSourceResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_service_account: Optional['outputs.AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount'] = None,
                 tag_value_id_set: Optional['outputs.AuthzPolicyHttpRuleFromNotSourceResourceTagValueIdSet'] = None):
        """
        :param 'AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccountArgs' iam_service_account: An IAM service account to match against the source service account of the VM sending the request.
               Structure is documented below.
        :param 'AuthzPolicyHttpRuleFromNotSourceResourceTagValueIdSetArgs' tag_value_id_set: A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request.
               Structure is documented below.
        """
        if iam_service_account is not None:
            pulumi.set(__self__, "iam_service_account", iam_service_account)
        if tag_value_id_set is not None:
            pulumi.set(__self__, "tag_value_id_set", tag_value_id_set)

    @property
    @pulumi.getter(name="iamServiceAccount")
    def iam_service_account(self) -> Optional['outputs.AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount']:
        """
        An IAM service account to match against the source service account of the VM sending the request.
        Structure is documented below.
        """
        return pulumi.get(self, "iam_service_account")

    @property
    @pulumi.getter(name="tagValueIdSet")
    def tag_value_id_set(self) -> Optional['outputs.AuthzPolicyHttpRuleFromNotSourceResourceTagValueIdSet']:
        """
        A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request.
        Structure is documented below.
        """
        return pulumi.get(self, "tag_value_id_set")


@pulumi.output_type
class AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromNotSourceResourceIamServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleFromNotSourceResourceTagValueIdSet(dict):
    def __init__(__self__, *,
                 ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] ids: A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request. The match follows AND semantics which means all the ids must match.
               Limited to 5 matches.
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request. The match follows AND semantics which means all the ids must match.
        Limited to 5 matches.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class AuthzPolicyHttpRuleFromSource(dict):
    def __init__(__self__, *,
                 principals: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSourcePrincipal']] = None,
                 resources: Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSourceResource']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleFromSourcePrincipalArgs'] principals: A list of identities derived from the client's certificate. This field will not match on a request unless mutual TLS is enabled for the Forwarding rule or Gateway. Each identity is a string whose value is matched against the URI SAN, or DNS SAN or the subject field in the client's certificate. The match can be exact, prefix, suffix or a substring match. One of exact, prefix, suffix or contains must be specified.
               Limited to 5 principals.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleFromSourceResourceArgs'] resources: A list of resources to match against the resource of the source VM of a request.
               Limited to 5 resources.
               Structure is documented below.
        """
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSourcePrincipal']]:
        """
        A list of identities derived from the client's certificate. This field will not match on a request unless mutual TLS is enabled for the Forwarding rule or Gateway. Each identity is a string whose value is matched against the URI SAN, or DNS SAN or the subject field in the client's certificate. The match can be exact, prefix, suffix or a substring match. One of exact, prefix, suffix or contains must be specified.
        Limited to 5 principals.
        Structure is documented below.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleFromSourceResource']]:
        """
        A list of resources to match against the resource of the source VM of a request.
        Limited to 5 resources.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class AuthzPolicyHttpRuleFromSourcePrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromSourcePrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromSourcePrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromSourcePrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleFromSourceResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamServiceAccount":
            suggest = "iam_service_account"
        elif key == "tagValueIdSet":
            suggest = "tag_value_id_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromSourceResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromSourceResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromSourceResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_service_account: Optional['outputs.AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount'] = None,
                 tag_value_id_set: Optional['outputs.AuthzPolicyHttpRuleFromSourceResourceTagValueIdSet'] = None):
        """
        :param 'AuthzPolicyHttpRuleFromSourceResourceIamServiceAccountArgs' iam_service_account: An IAM service account to match against the source service account of the VM sending the request.
               Structure is documented below.
        :param 'AuthzPolicyHttpRuleFromSourceResourceTagValueIdSetArgs' tag_value_id_set: A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request.
               Structure is documented below.
        """
        if iam_service_account is not None:
            pulumi.set(__self__, "iam_service_account", iam_service_account)
        if tag_value_id_set is not None:
            pulumi.set(__self__, "tag_value_id_set", tag_value_id_set)

    @property
    @pulumi.getter(name="iamServiceAccount")
    def iam_service_account(self) -> Optional['outputs.AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount']:
        """
        An IAM service account to match against the source service account of the VM sending the request.
        Structure is documented below.
        """
        return pulumi.get(self, "iam_service_account")

    @property
    @pulumi.getter(name="tagValueIdSet")
    def tag_value_id_set(self) -> Optional['outputs.AuthzPolicyHttpRuleFromSourceResourceTagValueIdSet']:
        """
        A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request.
        Structure is documented below.
        """
        return pulumi.get(self, "tag_value_id_set")


@pulumi.output_type
class AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleFromSourceResourceIamServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleFromSourceResourceTagValueIdSet(dict):
    def __init__(__self__, *,
                 ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] ids: A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request. The match follows AND semantics which means all the ids must match.
               Limited to 5 matches.
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of resource tag value permanent IDs to match against the resource manager tags value associated with the source VM of a request. The match follows AND semantics which means all the ids must match.
        Limited to 5 matches.
        """
        return pulumi.get(self, "ids")


@pulumi.output_type
class AuthzPolicyHttpRuleTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notOperations":
            suggest = "not_operations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_operations: Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperation']] = None,
                 operations: Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperation']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleToNotOperationArgs'] not_operations: Describes the negated properties of the targets of a request. Matches requests for operations that do not match the criteria specified in this field. At least one of operations or notOperations must be specified.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleToOperationArgs'] operations: Describes properties of one or more targets of a request. At least one of operations or notOperations must be specified. Limited to 5 operations. A match occurs when ANY operation (in operations or notOperations) matches. Within an operation, the match follows AND semantics across fields and OR semantics within a field, i.e. a match occurs when ANY path matches AND ANY header matches and ANY method matches.
               Structure is documented below.
        """
        if not_operations is not None:
            pulumi.set(__self__, "not_operations", not_operations)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)

    @property
    @pulumi.getter(name="notOperations")
    def not_operations(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperation']]:
        """
        Describes the negated properties of the targets of a request. Matches requests for operations that do not match the criteria specified in this field. At least one of operations or notOperations must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "not_operations")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperation']]:
        """
        Describes properties of one or more targets of a request. At least one of operations or notOperations must be specified. Limited to 5 operations. A match occurs when ANY operation (in operations or notOperations) matches. Within an operation, the match follows AND semantics across fields and OR semantics within a field, i.e. a match occurs when ANY path matches AND ANY header matches and ANY method matches.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerSet":
            suggest = "header_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToNotOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToNotOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToNotOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_set: Optional['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSet'] = None,
                 hosts: Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationHost']] = None,
                 methods: Optional[Sequence[builtins.str]] = None,
                 paths: Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationPath']] = None):
        """
        :param 'AuthzPolicyHttpRuleToNotOperationHeaderSetArgs' header_set: A list of headers to match against in http header.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleToNotOperationHostArgs'] hosts: A list of HTTP Hosts to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
               Limited to 5 matches.
               Structure is documented below.
        :param Sequence[builtins.str] methods: A list of HTTP methods to match against. Each entry must be a valid HTTP method name (GET, PUT, POST, HEAD, PATCH, DELETE, OPTIONS). It only allows exact match and is always case sensitive.
        :param Sequence['AuthzPolicyHttpRuleToNotOperationPathArgs'] paths: A list of paths to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
               Limited to 5 matches.
               Note that this path match includes the query parameters. For gRPC services, this should be a fully-qualified name of the form /package.service/method.
               Structure is documented below.
        """
        if header_set is not None:
            pulumi.set(__self__, "header_set", header_set)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="headerSet")
    def header_set(self) -> Optional['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSet']:
        """
        A list of headers to match against in http header.
        Structure is documented below.
        """
        return pulumi.get(self, "header_set")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationHost']]:
        """
        A list of HTTP Hosts to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
        Limited to 5 matches.
        Structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of HTTP methods to match against. Each entry must be a valid HTTP method name (GET, PUT, POST, HEAD, PATCH, DELETE, OPTIONS). It only allows exact match and is always case sensitive.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationPath']]:
        """
        A list of paths to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
        Limited to 5 matches.
        Note that this path match includes the query parameters. For gRPC services, this should be a fully-qualified name of the form /package.service/method.
        Structure is documented below.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperationHeaderSet(dict):
    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSetHeader']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderArgs'] headers: A list of headers to match against in http header. The match can be one of exact, prefix, suffix, or contains (substring match). The match follows AND semantics which means all the headers must match. Matches are always case sensitive unless the ignoreCase is set. Limited to 5 matches.
               Structure is documented below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSetHeader']]:
        """
        A list of headers to match against in http header. The match can be one of exact, prefix, suffix, or contains (substring match). The match follows AND semantics which means all the headers must match. Matches are always case sensitive unless the ignoreCase is set. Limited to 5 matches.
        Structure is documented below.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperationHeaderSetHeader(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue'] = None):
        """
        :param builtins.str name: Specifies the name of the header in the request.
        :param 'AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValueArgs' value: Specifies how the header match will be performed.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the header in the request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue']:
        """
        Specifies how the header match will be performed.
        Structure is documented below.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToNotOperationHeaderSetHeaderValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperationHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToNotOperationHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToNotOperationHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToNotOperationHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleToNotOperationPath(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToNotOperationPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToNotOperationPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToNotOperationPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerSet":
            suggest = "header_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_set: Optional['outputs.AuthzPolicyHttpRuleToOperationHeaderSet'] = None,
                 hosts: Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationHost']] = None,
                 methods: Optional[Sequence[builtins.str]] = None,
                 paths: Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationPath']] = None):
        """
        :param 'AuthzPolicyHttpRuleToOperationHeaderSetArgs' header_set: A list of headers to match against in http header.
               Structure is documented below.
        :param Sequence['AuthzPolicyHttpRuleToOperationHostArgs'] hosts: A list of HTTP Hosts to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
               Limited to 5 matches.
               Structure is documented below.
        :param Sequence[builtins.str] methods: A list of HTTP methods to match against. Each entry must be a valid HTTP method name (GET, PUT, POST, HEAD, PATCH, DELETE, OPTIONS). It only allows exact match and is always case sensitive.
        :param Sequence['AuthzPolicyHttpRuleToOperationPathArgs'] paths: A list of paths to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
               Limited to 5 matches.
               Note that this path match includes the query parameters. For gRPC services, this should be a fully-qualified name of the form /package.service/method.
               Structure is documented below.
        """
        if header_set is not None:
            pulumi.set(__self__, "header_set", header_set)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="headerSet")
    def header_set(self) -> Optional['outputs.AuthzPolicyHttpRuleToOperationHeaderSet']:
        """
        A list of headers to match against in http header.
        Structure is documented below.
        """
        return pulumi.get(self, "header_set")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationHost']]:
        """
        A list of HTTP Hosts to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
        Limited to 5 matches.
        Structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of HTTP methods to match against. Each entry must be a valid HTTP method name (GET, PUT, POST, HEAD, PATCH, DELETE, OPTIONS). It only allows exact match and is always case sensitive.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationPath']]:
        """
        A list of paths to match against. The match can be one of exact, prefix, suffix, or contains (substring match). Matches are always case sensitive unless the ignoreCase is set.
        Limited to 5 matches.
        Note that this path match includes the query parameters. For gRPC services, this should be a fully-qualified name of the form /package.service/method.
        Structure is documented below.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperationHeaderSet(dict):
    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationHeaderSetHeader']] = None):
        """
        :param Sequence['AuthzPolicyHttpRuleToOperationHeaderSetHeaderArgs'] headers: A list of headers to match against in http header. The match can be one of exact, prefix, suffix, or contains (substring match). The match follows AND semantics which means all the headers must match. Matches are always case sensitive unless the ignoreCase is set. Limited to 5 matches.
               Structure is documented below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.AuthzPolicyHttpRuleToOperationHeaderSetHeader']]:
        """
        A list of headers to match against in http header. The match can be one of exact, prefix, suffix, or contains (substring match). The match follows AND semantics which means all the headers must match. Matches are always case sensitive unless the ignoreCase is set. Limited to 5 matches.
        Structure is documented below.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperationHeaderSetHeader(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional['outputs.AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue'] = None):
        """
        :param builtins.str name: Specifies the name of the header in the request.
        :param 'AuthzPolicyHttpRuleToOperationHeaderSetHeaderValueArgs' value: Specifies how the header match will be performed.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the header in the request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue']:
        """
        Specifies how the header match will be performed.
        Structure is documented below.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToOperationHeaderSetHeaderValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperationHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToOperationHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToOperationHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToOperationHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyHttpRuleToOperationPath(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyHttpRuleToOperationPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyHttpRuleToOperationPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyHttpRuleToOperationPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc.def
        :param builtins.str exact: The input string must match exactly the string specified here.
               Examples:
               * abc only matches the value abc.
        :param builtins.bool ignore_case: If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        :param builtins.str prefix: The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value abc.xyz
        :param builtins.str suffix: The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
               Examples:
               * abc matches the value xyz.abc
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        The input string must have the substring specified here. Note: empty contains match is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc.def
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The input string must match exactly the string specified here.
        Examples:
        * abc only matches the value abc.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        If true, indicates the exact/prefix/suffix/contains matching should be case insensitive. For example, the matcher data will match both input string Data and data if set to true.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The input string must have the prefix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value abc.xyz
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The input string must have the suffix specified here. Note: empty prefix is not allowed, please use regex instead.
        Examples:
        * abc matches the value xyz.abc
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class AuthzPolicyTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancingScheme":
            suggest = "load_balancing_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthzPolicyTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthzPolicyTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthzPolicyTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancing_scheme: builtins.str,
                 resources: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str load_balancing_scheme: All gateways and forwarding rules referenced by this policy and extensions must share the same load balancing scheme.
               For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param Sequence[builtins.str] resources: A list of references to the Forwarding Rules on which this policy will be applied.
        """
        pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> builtins.str:
        """
        All gateways and forwarding rules referenced by this policy and extensions must share the same load balancing scheme.
        For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of references to the Forwarding Rules on which this policy will be applied.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ClientTlsPolicyClientCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ClientTlsPolicyClientCertificateCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ClientTlsPolicyClientCertificateGrpcEndpoint'] = None):
        """
        :param 'ClientTlsPolicyClientCertificateCertificateProviderInstanceArgs' certificate_provider_instance: The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
               Structure is documented below.
        :param 'ClientTlsPolicyClientCertificateGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ClientTlsPolicyClientCertificateCertificateProviderInstance']:
        """
        The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ClientTlsPolicyClientCertificateGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ClientTlsPolicyClientCertificateCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificateCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificateCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificateCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: builtins.str):
        """
        :param builtins.str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> builtins.str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ClientTlsPolicyClientCertificateGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificateGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificateGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificateGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: builtins.str):
        """
        :param builtins.str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> builtins.str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class ClientTlsPolicyServerValidationCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ClientTlsPolicyServerValidationCaCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ClientTlsPolicyServerValidationCaGrpcEndpoint'] = None):
        """
        :param 'ClientTlsPolicyServerValidationCaCertificateProviderInstanceArgs' certificate_provider_instance: The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
               Structure is documented below.
        :param 'ClientTlsPolicyServerValidationCaGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ClientTlsPolicyServerValidationCaCertificateProviderInstance']:
        """
        The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ClientTlsPolicyServerValidationCaGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ClientTlsPolicyServerValidationCaCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCaCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCaCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCaCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: builtins.str):
        """
        :param builtins.str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> builtins.str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ClientTlsPolicyServerValidationCaGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCaGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCaGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCaGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: builtins.str):
        """
        :param builtins.str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> builtins.str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class InterceptDeploymentGroupConnectedEndpointGroup(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: (Output)
               The connected endpoint group's resource name, for example:
               `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected endpoint group's resource name, for example:
        `projects/123456789/locations/global/interceptEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InterceptDeploymentGroupLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the deployment group, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the deployment group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InterceptEndpointGroupAssociation(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 network: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str name: (Output)
               The connected deployment group's resource name, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param builtins.str network: (Output)
               The associated network, for example:
               projects/123456789/global/networks/my-network.
               See https://google.aip.dev/124.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected deployment group's resource name, for example:
        `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        (Output)
        The associated network, for example:
        projects/123456789/global/networks/my-network.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InterceptEndpointGroupAssociationLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the association, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InterceptEndpointGroupAssociationLocationsDetail(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the association, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InterceptEndpointGroupConnectedDeploymentGroup(dict):
    def __init__(__self__, *,
                 locations: Optional[Sequence['outputs.InterceptEndpointGroupConnectedDeploymentGroupLocation']] = None,
                 name: Optional[builtins.str] = None):
        """
        :param Sequence['InterceptEndpointGroupConnectedDeploymentGroupLocationArgs'] locations: (Output)
               The list of locations where the deployment group is present.
               Structure is documented below.
        :param builtins.str name: (Output)
               The connected deployment group's resource name, for example:
               `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.InterceptEndpointGroupConnectedDeploymentGroupLocation']]:
        """
        (Output)
        The list of locations where the deployment group is present.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected deployment group's resource name, for example:
        `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InterceptEndpointGroupConnectedDeploymentGroupLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the endpoint group, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the endpoint group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MirroringDeploymentGroupConnectedEndpointGroup(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: (Output)
               The connected endpoint group's resource name, for example:
               `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected endpoint group's resource name, for example:
        `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MirroringDeploymentGroupLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the deployment group, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the deployment group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MirroringEndpointGroupAssociation(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 network: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str name: (Output)
               The connected deployment group's resource name, for example:
               `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        :param builtins.str network: (Output)
               The associated network, for example:
               projects/123456789/global/networks/my-network.
               See https://google.aip.dev/124.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected deployment group's resource name, for example:
        `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        (Output)
        The associated network, for example:
        projects/123456789/global/networks/my-network.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MirroringEndpointGroupAssociationLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the association, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MirroringEndpointGroupAssociationLocationsDetail(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the association, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the association, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MirroringEndpointGroupConnectedDeploymentGroup(dict):
    def __init__(__self__, *,
                 locations: Optional[Sequence['outputs.MirroringEndpointGroupConnectedDeploymentGroupLocation']] = None,
                 name: Optional[builtins.str] = None):
        """
        :param Sequence['MirroringEndpointGroupConnectedDeploymentGroupLocationArgs'] locations: (Output)
               The list of locations where the deployment group is present.
               Structure is documented below.
        :param builtins.str name: (Output)
               The connected deployment group's resource name, for example:
               `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`.
               See https://google.aip.dev/124.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.MirroringEndpointGroupConnectedDeploymentGroupLocation']]:
        """
        (Output)
        The list of locations where the deployment group is present.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The connected deployment group's resource name, for example:
        `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MirroringEndpointGroupConnectedDeploymentGroupLocation(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str location: The cloud location of the endpoint group, currently restricted to `global`.
        :param builtins.str state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The cloud location of the endpoint group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SecurityProfileCustomInterceptProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interceptEndpointGroup":
            suggest = "intercept_endpoint_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileCustomInterceptProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileCustomInterceptProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileCustomInterceptProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intercept_endpoint_group: builtins.str):
        """
        :param builtins.str intercept_endpoint_group: The Intercept Endpoint Group to which matching traffic should be intercepted.
               Format: projects/{project_id}/locations/global/interceptEndpointGroups/{endpoint_group_id}
        """
        pulumi.set(__self__, "intercept_endpoint_group", intercept_endpoint_group)

    @property
    @pulumi.getter(name="interceptEndpointGroup")
    def intercept_endpoint_group(self) -> builtins.str:
        """
        The Intercept Endpoint Group to which matching traffic should be intercepted.
        Format: projects/{project_id}/locations/global/interceptEndpointGroups/{endpoint_group_id}
        """
        return pulumi.get(self, "intercept_endpoint_group")


@pulumi.output_type
class SecurityProfileCustomMirroringProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mirroringEndpointGroup":
            suggest = "mirroring_endpoint_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileCustomMirroringProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileCustomMirroringProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileCustomMirroringProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mirroring_endpoint_group: builtins.str):
        """
        :param builtins.str mirroring_endpoint_group: The Mirroring Endpoint Group to which matching traffic should be mirrored.
               Format: projects/{project_id}/locations/global/mirroringEndpointGroups/{endpoint_group_id}
        """
        pulumi.set(__self__, "mirroring_endpoint_group", mirroring_endpoint_group)

    @property
    @pulumi.getter(name="mirroringEndpointGroup")
    def mirroring_endpoint_group(self) -> builtins.str:
        """
        The Mirroring Endpoint Group to which matching traffic should be mirrored.
        Format: projects/{project_id}/locations/global/mirroringEndpointGroups/{endpoint_group_id}
        """
        return pulumi.get(self, "mirroring_endpoint_group")


@pulumi.output_type
class SecurityProfileThreatPreventionProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antivirusOverrides":
            suggest = "antivirus_overrides"
        elif key == "severityOverrides":
            suggest = "severity_overrides"
        elif key == "threatOverrides":
            suggest = "threat_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileThreatPreventionProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileThreatPreventionProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileThreatPreventionProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 antivirus_overrides: Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileAntivirusOverride']] = None,
                 severity_overrides: Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileSeverityOverride']] = None,
                 threat_overrides: Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileThreatOverride']] = None):
        """
        :param Sequence['SecurityProfileThreatPreventionProfileAntivirusOverrideArgs'] antivirus_overrides: Defines what action to take for antivirus threats per protocol.
               Structure is documented below.
        :param Sequence['SecurityProfileThreatPreventionProfileSeverityOverrideArgs'] severity_overrides: The configuration for overriding threats actions by severity match.
               Structure is documented below.
        :param Sequence['SecurityProfileThreatPreventionProfileThreatOverrideArgs'] threat_overrides: The configuration for overriding threats actions by threat id match.
               If a threat is matched both by configuration provided in severity overrides
               and threat overrides, the threat overrides action is applied.
               Structure is documented below.
        """
        if antivirus_overrides is not None:
            pulumi.set(__self__, "antivirus_overrides", antivirus_overrides)
        if severity_overrides is not None:
            pulumi.set(__self__, "severity_overrides", severity_overrides)
        if threat_overrides is not None:
            pulumi.set(__self__, "threat_overrides", threat_overrides)

    @property
    @pulumi.getter(name="antivirusOverrides")
    def antivirus_overrides(self) -> Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileAntivirusOverride']]:
        """
        Defines what action to take for antivirus threats per protocol.
        Structure is documented below.
        """
        return pulumi.get(self, "antivirus_overrides")

    @property
    @pulumi.getter(name="severityOverrides")
    def severity_overrides(self) -> Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileSeverityOverride']]:
        """
        The configuration for overriding threats actions by severity match.
        Structure is documented below.
        """
        return pulumi.get(self, "severity_overrides")

    @property
    @pulumi.getter(name="threatOverrides")
    def threat_overrides(self) -> Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileThreatOverride']]:
        """
        The configuration for overriding threats actions by threat id match.
        If a threat is matched both by configuration provided in severity overrides
        and threat overrides, the threat overrides action is applied.
        Structure is documented below.
        """
        return pulumi.get(self, "threat_overrides")


@pulumi.output_type
class SecurityProfileThreatPreventionProfileAntivirusOverride(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 protocol: builtins.str):
        """
        :param builtins.str action: Threat action override. For some threat types, only a subset of actions applies.
               Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        :param builtins.str protocol: Required protocol to match.
               Possible values are: `SMTP`, `SMB`, `POP3`, `IMAP`, `HTTP2`, `HTTP`, `FTP`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Threat action override. For some threat types, only a subset of actions applies.
        Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        Required protocol to match.
        Possible values are: `SMTP`, `SMB`, `POP3`, `IMAP`, `HTTP2`, `HTTP`, `FTP`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityProfileThreatPreventionProfileSeverityOverride(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 severity: builtins.str):
        """
        :param builtins.str action: Threat action override.
               Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        :param builtins.str severity: Severity level to match.
               Possible values are: `CRITICAL`, `HIGH`, `INFORMATIONAL`, `LOW`, `MEDIUM`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Threat action override.
        Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        Severity level to match.
        Possible values are: `CRITICAL`, `HIGH`, `INFORMATIONAL`, `LOW`, `MEDIUM`.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class SecurityProfileThreatPreventionProfileThreatOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threatId":
            suggest = "threat_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileThreatPreventionProfileThreatOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileThreatPreventionProfileThreatOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileThreatPreventionProfileThreatOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 threat_id: builtins.str,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str action: Threat action.
               Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        :param builtins.str threat_id: Vendor-specific ID of a threat to override.
        :param builtins.str type: (Output)
               Type of threat.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "threat_id", threat_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Threat action.
        Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="threatId")
    def threat_id(self) -> builtins.str:
        """
        Vendor-specific ID of a threat to override.
        """
        return pulumi.get(self, "threat_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        (Output)
        Type of threat.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientValidationCas":
            suggest = "client_validation_cas"
        elif key == "clientValidationMode":
            suggest = "client_validation_mode"
        elif key == "clientValidationTrustConfig":
            suggest = "client_validation_trust_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_validation_cas: Optional[Sequence['outputs.ServerTlsPolicyMtlsPolicyClientValidationCa']] = None,
                 client_validation_mode: Optional[builtins.str] = None,
                 client_validation_trust_config: Optional[builtins.str] = None):
        """
        :param Sequence['ServerTlsPolicyMtlsPolicyClientValidationCaArgs'] client_validation_cas: Required if the policy is to be used with Traffic Director. For external HTTPS load balancers it must be empty.
               Defines the mechanism to obtain the Certificate Authority certificate to validate the client certificate.
               Structure is documented below.
        :param builtins.str client_validation_mode: When the client presents an invalid certificate or no certificate to the load balancer, the clientValidationMode specifies how the client connection is handled.
               Required if the policy is to be used with the external HTTPS load balancing. For Traffic Director it must be empty.
               Possible values are: `CLIENT_VALIDATION_MODE_UNSPECIFIED`, `ALLOW_INVALID_OR_MISSING_CLIENT_CERT`, `REJECT_INVALID`.
        :param builtins.str client_validation_trust_config: Reference to the TrustConfig from certificatemanager.googleapis.com namespace.
               If specified, the chain validation will be performed against certificates configured in the given TrustConfig.
               Allowed only if the policy is to be used with external HTTPS load balancers.
        """
        if client_validation_cas is not None:
            pulumi.set(__self__, "client_validation_cas", client_validation_cas)
        if client_validation_mode is not None:
            pulumi.set(__self__, "client_validation_mode", client_validation_mode)
        if client_validation_trust_config is not None:
            pulumi.set(__self__, "client_validation_trust_config", client_validation_trust_config)

    @property
    @pulumi.getter(name="clientValidationCas")
    def client_validation_cas(self) -> Optional[Sequence['outputs.ServerTlsPolicyMtlsPolicyClientValidationCa']]:
        """
        Required if the policy is to be used with Traffic Director. For external HTTPS load balancers it must be empty.
        Defines the mechanism to obtain the Certificate Authority certificate to validate the client certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "client_validation_cas")

    @property
    @pulumi.getter(name="clientValidationMode")
    def client_validation_mode(self) -> Optional[builtins.str]:
        """
        When the client presents an invalid certificate or no certificate to the load balancer, the clientValidationMode specifies how the client connection is handled.
        Required if the policy is to be used with the external HTTPS load balancing. For Traffic Director it must be empty.
        Possible values are: `CLIENT_VALIDATION_MODE_UNSPECIFIED`, `ALLOW_INVALID_OR_MISSING_CLIENT_CERT`, `REJECT_INVALID`.
        """
        return pulumi.get(self, "client_validation_mode")

    @property
    @pulumi.getter(name="clientValidationTrustConfig")
    def client_validation_trust_config(self) -> Optional[builtins.str]:
        """
        Reference to the TrustConfig from certificatemanager.googleapis.com namespace.
        If specified, the chain validation will be performed against certificates configured in the given TrustConfig.
        Allowed only if the policy is to be used with external HTTPS load balancers.
        """
        return pulumi.get(self, "client_validation_trust_config")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint'] = None):
        """
        :param 'ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceArgs' certificate_provider_instance: Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
               Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
               Structure is documented below.
        :param 'ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance']:
        """
        Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
        Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: builtins.str):
        """
        :param builtins.str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> builtins.str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: builtins.str):
        """
        :param builtins.str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> builtins.str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class ServerTlsPolicyServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ServerTlsPolicyServerCertificateCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ServerTlsPolicyServerCertificateGrpcEndpoint'] = None):
        """
        :param 'ServerTlsPolicyServerCertificateCertificateProviderInstanceArgs' certificate_provider_instance: Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
               Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
               Structure is documented below.
        :param 'ServerTlsPolicyServerCertificateGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ServerTlsPolicyServerCertificateCertificateProviderInstance']:
        """
        Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
        Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ServerTlsPolicyServerCertificateGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ServerTlsPolicyServerCertificateCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificateCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificateCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificateCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: builtins.str):
        """
        :param builtins.str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> builtins.str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ServerTlsPolicyServerCertificateGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificateGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificateGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificateGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: builtins.str):
        """
        :param builtins.str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> builtins.str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


