# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 ports: pulumi.Input[Sequence[pulumi.Input[builtins.int]]],
                 type: pulumi.Input[builtins.str],
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delete_swg_autogen_router_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 envoy_headers: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: One or more port numbers (1-65535), on which the Gateway will receive traffic.
               The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        :param pulumi.Input[builtins.str] type: Immutable. The type of the customer managed gateway.
               Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
               When no address is provided, an IP from the subnetwork is allocated.
               This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_urls: A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
               This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.bool] delete_swg_autogen_router_on_destroy: When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
               If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[builtins.str] envoy_headers: Determines if envoy will insert internal debug headers into upstream requests.
               Other Envoy headers may still be injected.
               By default, envoy will not insert any debug headers.
               Possible values are: `NONE`, `DEBUG_HEADERS`.
        :param pulumi.Input[builtins.str] gateway_security_policy: A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
               For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
               This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this gateway.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Gateway resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the Gateway resource.
        :param pulumi.Input[builtins.str] network: The relative resource name identifying the VPC network that is using this configuration.
               For example: 'projects/*/global/networks/network-1'.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] routing_mode: The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
               Possible values are: `NEXT_HOP_ROUTING_MODE`.
        :param pulumi.Input[builtins.str] scope: Immutable. Scope determines how configuration across multiple Gateway instances are merged.
               The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
               Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        :param pulumi.Input[builtins.str] server_tls_policy: A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        :param pulumi.Input[builtins.str] subnetwork: The relative resource name identifying the subnetwork in which this SWG is allocated.
               For example: projects/*/regions/us-central1/subnetworks/network-1.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "type", type)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if certificate_urls is not None:
            pulumi.set(__self__, "certificate_urls", certificate_urls)
        if delete_swg_autogen_router_on_destroy is not None:
            pulumi.set(__self__, "delete_swg_autogen_router_on_destroy", delete_swg_autogen_router_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if envoy_headers is not None:
            pulumi.set(__self__, "envoy_headers", envoy_headers)
        if gateway_security_policy is not None:
            pulumi.set(__self__, "gateway_security_policy", gateway_security_policy)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.int]]]:
        """
        One or more port numbers (1-65535), on which the Gateway will receive traffic.
        The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. The type of the customer managed gateway.
        Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
        When no address is provided, an IP from the subnetwork is allocated.
        This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="certificateUrls")
    def certificate_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
        This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "certificate_urls")

    @certificate_urls.setter
    def certificate_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_urls", value)

    @property
    @pulumi.getter(name="deleteSwgAutogenRouterOnDestroy")
    def delete_swg_autogen_router_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
        If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        """
        return pulumi.get(self, "delete_swg_autogen_router_on_destroy")

    @delete_swg_autogen_router_on_destroy.setter
    def delete_swg_autogen_router_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_swg_autogen_router_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="envoyHeaders")
    def envoy_headers(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines if envoy will insert internal debug headers into upstream requests.
        Other Envoy headers may still be injected.
        By default, envoy will not insert any debug headers.
        Possible values are: `NONE`, `DEBUG_HEADERS`.
        """
        return pulumi.get(self, "envoy_headers")

    @envoy_headers.setter
    def envoy_headers(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "envoy_headers", value)

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
        For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
        This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "gateway_security_policy")

    @gateway_security_policy.setter
    def gateway_security_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_security_policy", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version that will be used by this gateway.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the Gateway resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the gateway.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Gateway resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name identifying the VPC network that is using this configuration.
        For example: 'projects/*/global/networks/network-1'.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
        Possible values are: `NEXT_HOP_ROUTING_MODE`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_mode", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Scope determines how configuration across multiple Gateway instances are merged.
        The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
        Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name identifying the subnetwork in which this SWG is allocated.
        For example: projects/*/regions/us-central1/subnetworks/network-1.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delete_swg_autogen_router_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 envoy_headers: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 routing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
               When no address is provided, an IP from the subnetwork is allocated.
               This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_urls: A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
               This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.bool] delete_swg_autogen_router_on_destroy: When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
               If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] envoy_headers: Determines if envoy will insert internal debug headers into upstream requests.
               Other Envoy headers may still be injected.
               By default, envoy will not insert any debug headers.
               Possible values are: `NONE`, `DEBUG_HEADERS`.
        :param pulumi.Input[builtins.str] gateway_security_policy: A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
               For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
               This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this gateway.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Gateway resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the Gateway resource.
        :param pulumi.Input[builtins.str] network: The relative resource name identifying the VPC network that is using this configuration.
               For example: 'projects/*/global/networks/network-1'.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: One or more port numbers (1-65535), on which the Gateway will receive traffic.
               The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] routing_mode: The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
               Possible values are: `NEXT_HOP_ROUTING_MODE`.
        :param pulumi.Input[builtins.str] scope: Immutable. Scope determines how configuration across multiple Gateway instances are merged.
               The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
               Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        :param pulumi.Input[builtins.str] subnetwork: The relative resource name identifying the subnetwork in which this SWG is allocated.
               For example: projects/*/regions/us-central1/subnetworks/network-1.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] type: Immutable. The type of the customer managed gateway.
               Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if certificate_urls is not None:
            pulumi.set(__self__, "certificate_urls", certificate_urls)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_swg_autogen_router_on_destroy is not None:
            pulumi.set(__self__, "delete_swg_autogen_router_on_destroy", delete_swg_autogen_router_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if envoy_headers is not None:
            pulumi.set(__self__, "envoy_headers", envoy_headers)
        if gateway_security_policy is not None:
            pulumi.set(__self__, "gateway_security_policy", gateway_security_policy)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
        When no address is provided, an IP from the subnetwork is allocated.
        This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="certificateUrls")
    def certificate_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
        This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "certificate_urls")

    @certificate_urls.setter
    def certificate_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_urls", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteSwgAutogenRouterOnDestroy")
    def delete_swg_autogen_router_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
        If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        """
        return pulumi.get(self, "delete_swg_autogen_router_on_destroy")

    @delete_swg_autogen_router_on_destroy.setter
    def delete_swg_autogen_router_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_swg_autogen_router_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="envoyHeaders")
    def envoy_headers(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines if envoy will insert internal debug headers into upstream requests.
        Other Envoy headers may still be injected.
        By default, envoy will not insert any debug headers.
        Possible values are: `NONE`, `DEBUG_HEADERS`.
        """
        return pulumi.get(self, "envoy_headers")

    @envoy_headers.setter
    def envoy_headers(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "envoy_headers", value)

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
        For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
        This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "gateway_security_policy")

    @gateway_security_policy.setter
    def gateway_security_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_security_policy", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version that will be used by this gateway.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the Gateway resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the gateway.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Gateway resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name identifying the VPC network that is using this configuration.
        For example: 'projects/*/global/networks/network-1'.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        One or more port numbers (1-65535), on which the Gateway will receive traffic.
        The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
        Possible values are: `NEXT_HOP_ROUTING_MODE`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_mode", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Scope determines how configuration across multiple Gateway instances are merged.
        The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
        Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name identifying the subnetwork in which this SWG is allocated.
        For example: projects/*/regions/us-central1/subnetworks/network-1.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The type of the customer managed gateway.
        Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delete_swg_autogen_router_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 envoy_headers: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Gateway represents the configuration for a proxy, typically a load balancer.
        It captures the ip:port over which the services are exposed by the proxy,
        along with any policy configurations. Routes have reference to to Gateways
        to dictate how requests should be routed by this Gateway.

        To get more information about Gateway, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1/projects.locations.gateways)

        ## Example Usage

        ### Network Services Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.Gateway("default",
            name="my-gateway",
            scope="default-scope-basic",
            type="OPEN_MESH",
            ports=[443])
        ```
        ### Network Services Gateway Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.Gateway("default",
            name="my-gateway",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="OPEN_MESH",
            ports=[443],
            scope="default-scope-advance")
        ```
        ### Network Services Gateway Secure Web Proxy

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            location="us-central1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_network = gcp.compute.Network("default",
            name="my-network",
            routing_mode="REGIONAL",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork-name",
            purpose="PRIVATE",
            ip_cidr_range="10.128.0.0/20",
            region="us-central1",
            network=default_network.id,
            role="ACTIVE")
        proxyonlysubnet = gcp.compute.Subnetwork("proxyonlysubnet",
            name="my-proxy-only-subnetwork",
            purpose="REGIONAL_MANAGED_PROXY",
            ip_cidr_range="192.168.0.0/23",
            region="us-central1",
            network=default_network.id,
            role="ACTIVE")
        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("default",
            name="my-policy-name",
            location="us-central1")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("default",
            name="my-policyrule-name",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            priority=1,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-gateway1",
            location="us-central1",
            addresses=["10.128.0.99"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope1",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        ```
        ### Network Services Gateway Multiple Swp Same Network

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            location="us-south1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_network = gcp.compute.Network("default",
            name="my-network",
            routing_mode="REGIONAL",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork-name",
            purpose="PRIVATE",
            ip_cidr_range="10.128.0.0/20",
            region="us-south1",
            network=default_network.id,
            role="ACTIVE")
        proxyonlysubnet = gcp.compute.Subnetwork("proxyonlysubnet",
            name="my-proxy-only-subnetwork",
            purpose="REGIONAL_MANAGED_PROXY",
            ip_cidr_range="192.168.0.0/23",
            region="us-south1",
            network=default_network.id,
            role="ACTIVE")
        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("default",
            name="my-policy-name",
            location="us-south1")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("default",
            name="my-policyrule-name",
            location="us-south1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            priority=1,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-gateway1",
            location="us-south1",
            addresses=["10.128.0.99"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope1",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        gateway2 = gcp.networkservices.Gateway("gateway2",
            name="my-gateway2",
            location="us-south1",
            addresses=["10.128.0.98"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope2",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        ```

        ## Import

        Gateway can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/gateways/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Gateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default projects/{{project}}/locations/{{location}}/gateways/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
               When no address is provided, an IP from the subnetwork is allocated.
               This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_urls: A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
               This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.bool] delete_swg_autogen_router_on_destroy: When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
               If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[builtins.str] envoy_headers: Determines if envoy will insert internal debug headers into upstream requests.
               Other Envoy headers may still be injected.
               By default, envoy will not insert any debug headers.
               Possible values are: `NONE`, `DEBUG_HEADERS`.
        :param pulumi.Input[builtins.str] gateway_security_policy: A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
               For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
               This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this gateway.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Gateway resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the Gateway resource.
        :param pulumi.Input[builtins.str] network: The relative resource name identifying the VPC network that is using this configuration.
               For example: 'projects/*/global/networks/network-1'.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: One or more port numbers (1-65535), on which the Gateway will receive traffic.
               The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] routing_mode: The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
               Possible values are: `NEXT_HOP_ROUTING_MODE`.
        :param pulumi.Input[builtins.str] scope: Immutable. Scope determines how configuration across multiple Gateway instances are merged.
               The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
               Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        :param pulumi.Input[builtins.str] server_tls_policy: A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        :param pulumi.Input[builtins.str] subnetwork: The relative resource name identifying the subnetwork in which this SWG is allocated.
               For example: projects/*/regions/us-central1/subnetworks/network-1.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] type: Immutable. The type of the customer managed gateway.
               Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Gateway represents the configuration for a proxy, typically a load balancer.
        It captures the ip:port over which the services are exposed by the proxy,
        along with any policy configurations. Routes have reference to to Gateways
        to dictate how requests should be routed by this Gateway.

        To get more information about Gateway, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1/projects.locations.gateways)

        ## Example Usage

        ### Network Services Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.Gateway("default",
            name="my-gateway",
            scope="default-scope-basic",
            type="OPEN_MESH",
            ports=[443])
        ```
        ### Network Services Gateway Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.Gateway("default",
            name="my-gateway",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="OPEN_MESH",
            ports=[443],
            scope="default-scope-advance")
        ```
        ### Network Services Gateway Secure Web Proxy

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            location="us-central1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_network = gcp.compute.Network("default",
            name="my-network",
            routing_mode="REGIONAL",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork-name",
            purpose="PRIVATE",
            ip_cidr_range="10.128.0.0/20",
            region="us-central1",
            network=default_network.id,
            role="ACTIVE")
        proxyonlysubnet = gcp.compute.Subnetwork("proxyonlysubnet",
            name="my-proxy-only-subnetwork",
            purpose="REGIONAL_MANAGED_PROXY",
            ip_cidr_range="192.168.0.0/23",
            region="us-central1",
            network=default_network.id,
            role="ACTIVE")
        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("default",
            name="my-policy-name",
            location="us-central1")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("default",
            name="my-policyrule-name",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            priority=1,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-gateway1",
            location="us-central1",
            addresses=["10.128.0.99"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope1",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        ```
        ### Network Services Gateway Multiple Swp Same Network

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            location="us-south1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_network = gcp.compute.Network("default",
            name="my-network",
            routing_mode="REGIONAL",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="my-subnetwork-name",
            purpose="PRIVATE",
            ip_cidr_range="10.128.0.0/20",
            region="us-south1",
            network=default_network.id,
            role="ACTIVE")
        proxyonlysubnet = gcp.compute.Subnetwork("proxyonlysubnet",
            name="my-proxy-only-subnetwork",
            purpose="REGIONAL_MANAGED_PROXY",
            ip_cidr_range="192.168.0.0/23",
            region="us-south1",
            network=default_network.id,
            role="ACTIVE")
        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("default",
            name="my-policy-name",
            location="us-south1")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("default",
            name="my-policyrule-name",
            location="us-south1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            priority=1,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-gateway1",
            location="us-south1",
            addresses=["10.128.0.99"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope1",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        gateway2 = gcp.networkservices.Gateway("gateway2",
            name="my-gateway2",
            location="us-south1",
            addresses=["10.128.0.98"],
            type="SECURE_WEB_GATEWAY",
            ports=[443],
            scope="my-default-scope2",
            certificate_urls=[default.id],
            gateway_security_policy=default_gateway_security_policy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            delete_swg_autogen_router_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[proxyonlysubnet]))
        ```

        ## Import

        Gateway can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/gateways/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Gateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default projects/{{project}}/locations/{{location}}/gateways/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/gateway:Gateway default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delete_swg_autogen_router_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 envoy_headers: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["certificate_urls"] = certificate_urls
            __props__.__dict__["delete_swg_autogen_router_on_destroy"] = delete_swg_autogen_router_on_destroy
            __props__.__dict__["description"] = description
            __props__.__dict__["envoy_headers"] = envoy_headers
            __props__.__dict__["gateway_security_policy"] = gateway_security_policy
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            if ports is None and not opts.urn:
                raise TypeError("Missing required property 'ports'")
            __props__.__dict__["ports"] = ports
            __props__.__dict__["project"] = project
            __props__.__dict__["routing_mode"] = routing_mode
            __props__.__dict__["scope"] = scope
            __props__.__dict__["server_tls_policy"] = server_tls_policy
            __props__.__dict__["subnetwork"] = subnetwork
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Gateway, __self__).__init__(
            'gcp:networkservices/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            certificate_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delete_swg_autogen_router_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            envoy_headers: Optional[pulumi.Input[builtins.str]] = None,
            gateway_security_policy: Optional[pulumi.Input[builtins.str]] = None,
            ip_version: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            routing_mode: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
            subnetwork: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
               When no address is provided, an IP from the subnetwork is allocated.
               This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_urls: A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
               This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.bool] delete_swg_autogen_router_on_destroy: When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
               If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] envoy_headers: Determines if envoy will insert internal debug headers into upstream requests.
               Other Envoy headers may still be injected.
               By default, envoy will not insert any debug headers.
               Possible values are: `NONE`, `DEBUG_HEADERS`.
        :param pulumi.Input[builtins.str] gateway_security_policy: A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
               For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
               This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this gateway.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Gateway resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the Gateway resource.
        :param pulumi.Input[builtins.str] network: The relative resource name identifying the VPC network that is using this configuration.
               For example: 'projects/*/global/networks/network-1'.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: One or more port numbers (1-65535), on which the Gateway will receive traffic.
               The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
               Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] routing_mode: The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
               Possible values are: `NEXT_HOP_ROUTING_MODE`.
        :param pulumi.Input[builtins.str] scope: Immutable. Scope determines how configuration across multiple Gateway instances are merged.
               The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
               Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        :param pulumi.Input[builtins.str] subnetwork: The relative resource name identifying the subnetwork in which this SWG is allocated.
               For example: projects/*/regions/us-central1/subnetworks/network-1.
               Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        :param pulumi.Input[builtins.str] type: Immutable. The type of the customer managed gateway.
               Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["certificate_urls"] = certificate_urls
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_swg_autogen_router_on_destroy"] = delete_swg_autogen_router_on_destroy
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["envoy_headers"] = envoy_headers
        __props__.__dict__["gateway_security_policy"] = gateway_security_policy
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["routing_mode"] = routing_mode
        __props__.__dict__["scope"] = scope
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["server_tls_policy"] = server_tls_policy
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Zero or one IPv4 or IPv6 address on which the Gateway will receive the traffic.
        When no address is provided, an IP from the subnetwork is allocated.
        This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="certificateUrls")
    def certificate_urls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
        This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "certificate_urls")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteSwgAutogenRouterOnDestroy")
    def delete_swg_autogen_router_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
        If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
        """
        return pulumi.get(self, "delete_swg_autogen_router_on_destroy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="envoyHeaders")
    def envoy_headers(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Determines if envoy will insert internal debug headers into upstream requests.
        Other Envoy headers may still be injected.
        By default, envoy will not insert any debug headers.
        Possible values are: `NONE`, `DEBUG_HEADERS`.
        """
        return pulumi.get(self, "envoy_headers")

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
        For example: 'projects/*/locations/*/gatewaySecurityPolicies/swg-policy'.
        This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "gateway_security_policy")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP Version that will be used by this gateway.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the Gateway resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location of the gateway.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Gateway resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative resource name identifying the VPC network that is using this configuration.
        For example: 'projects/*/global/networks/network-1'.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence[builtins.int]]:
        """
        One or more port numbers (1-65535), on which the Gateway will receive traffic.
        The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
        Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple ports.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The routing mode of the Gateway. This field is configurable only for gateways of type SECURE_WEB_GATEWAY. This field is required for gateways of type SECURE_WEB_GATEWAY.
        Possible values are: `NEXT_HOP_ROUTING_MODE`.
        """
        return pulumi.get(self, "routing_mode")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. Scope determines how configuration across multiple Gateway instances are merged.
        The configuration for multiple Gateway instances with the same scope will be merged as presented as a single coniguration to the proxy/load balancer.
        Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
        """
        return pulumi.get(self, "server_tls_policy")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative resource name identifying the subnetwork in which this SWG is allocated.
        For example: projects/*/regions/us-central1/subnetworks/network-1.
        Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. The type of the customer managed gateway.
        Possible values are: `OPEN_MESH`, `SECURE_WEB_GATEWAY`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

