# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EnvironmentContainerImage',
    'EnvironmentVmImage',
    'InstanceAcceleratorConfig',
    'InstanceContainerImage',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'InstanceReservationAffinity',
    'InstanceShieldedInstanceConfig',
    'InstanceVmImage',
    'RuntimeAccessConfig',
    'RuntimeIamBindingCondition',
    'RuntimeIamMemberCondition',
    'RuntimeMetric',
    'RuntimeSoftwareConfig',
    'RuntimeSoftwareConfigKernel',
    'RuntimeVirtualMachine',
    'RuntimeVirtualMachineVirtualMachineConfig',
    'RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig',
    'RuntimeVirtualMachineVirtualMachineConfigContainerImage',
    'RuntimeVirtualMachineVirtualMachineConfigDataDisk',
    'RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams',
    'RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig',
    'RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig',
]

@pulumi.output_type
class EnvironmentContainerImage(dict):
    def __init__(__self__, *,
                 repository: builtins.str,
                 tag: Optional[builtins.str] = None):
        """
        :param builtins.str repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param builtins.str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class EnvironmentVmImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageFamily":
            suggest = "image_family"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVmImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVmImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVmImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: builtins.str,
                 image_family: Optional[builtins.str] = None,
                 image_name: Optional[builtins.str] = None):
        """
        :param builtins.str project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param builtins.str image_family: Use this VM image family to find the image; the newest image in this family will be used.
        :param builtins.str image_name: Use VM image name to find the image.
        """
        pulumi.set(__self__, "project", project)
        if image_family is not None:
            pulumi.set(__self__, "image_family", image_family)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> Optional[builtins.str]:
        """
        Use this VM image family to find the image; the newest image in this family will be used.
        """
        return pulumi.get(self, "image_family")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[builtins.str]:
        """
        Use VM image name to find the image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class InstanceAcceleratorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAcceleratorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAcceleratorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAcceleratorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int core_count: Count of cores of this accelerator.
        :param builtins.str type: Type of this accelerator.
               Possible values are: `ACCELERATOR_TYPE_UNSPECIFIED`, `NVIDIA_TESLA_K80`, `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`, `NVIDIA_TESLA_A100`, `TPU_V2`, `TPU_V3`.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> builtins.int:
        """
        Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of this accelerator.
        Possible values are: `ACCELERATOR_TYPE_UNSPECIFIED`, `NVIDIA_TESLA_K80`, `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`, `NVIDIA_TESLA_A100`, `TPU_V2`, `TPU_V3`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceContainerImage(dict):
    def __init__(__self__, *,
                 repository: builtins.str,
                 tag: Optional[builtins.str] = None):
        """
        :param builtins.str repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param builtins.str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceReservationAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReservationAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReservationAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReservationAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: builtins.str,
                 key: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str consume_reservation_type: The type of Compute Reservation.
               Possible values are: `NO_RESERVATION`, `ANY_RESERVATION`, `SPECIFIC_RESERVATION`.
        :param builtins.str key: Corresponds to the label key of reservation resource.
        :param Sequence[builtins.str] values: Corresponds to the label values of reservation resource.
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> builtins.str:
        """
        The type of Compute Reservation.
        Possible values are: `NO_RESERVATION`, `ANY_RESERVATION`, `SPECIFIC_RESERVATION`.
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class InstanceShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[builtins.bool] = None,
                 enable_secure_boot: Optional[builtins.bool] = None,
                 enable_vtpm: Optional[builtins.bool] = None):
        """
        :param builtins.bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the
               boot integrity of the instance. The attestation is performed against the integrity policy baseline.
               This baseline is initially derived from the implicitly trusted boot image when the instance is created.
               Enabled by default.
        :param builtins.bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs
               authentic software by verifying the digital signature of all boot components, and halting the boot process
               if signature verification fails.
               Disabled by default.
        :param builtins.bool enable_vtpm: Defines whether the instance has the vTPM enabled.
               Enabled by default.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the
        boot integrity of the instance. The attestation is performed against the integrity policy baseline.
        This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs
        authentic software by verifying the digital signature of all boot components, and halting the boot process
        if signature verification fails.
        Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has the vTPM enabled.
        Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class InstanceVmImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageFamily":
            suggest = "image_family"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVmImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVmImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVmImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: builtins.str,
                 image_family: Optional[builtins.str] = None,
                 image_name: Optional[builtins.str] = None):
        """
        :param builtins.str project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param builtins.str image_family: Use this VM image family to find the image; the newest image in this family will be used.
        :param builtins.str image_name: Use VM image name to find the image.
        """
        pulumi.set(__self__, "project", project)
        if image_family is not None:
            pulumi.set(__self__, "image_family", image_family)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> Optional[builtins.str]:
        """
        Use this VM image family to find the image; the newest image in this family will be used.
        """
        return pulumi.get(self, "image_family")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[builtins.str]:
        """
        Use VM image name to find the image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class RuntimeAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "proxyUri":
            suggest = "proxy_uri"
        elif key == "runtimeOwner":
            suggest = "runtime_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: Optional[builtins.str] = None,
                 proxy_uri: Optional[builtins.str] = None,
                 runtime_owner: Optional[builtins.str] = None):
        """
        :param builtins.str access_type: The type of access mode this instance. For valid values, see
               `https://cloud.google.com/vertex-ai/docs/workbench/reference/
               rest/v1/projects.locations.runtimes#RuntimeAccessType`.
        :param builtins.str proxy_uri: (Output)
               The proxy endpoint that is used to access the runtime.
        :param builtins.str runtime_owner: The owner of this runtime after creation. Format: `alias@example.com`.
               Currently supports one owner only.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if proxy_uri is not None:
            pulumi.set(__self__, "proxy_uri", proxy_uri)
        if runtime_owner is not None:
            pulumi.set(__self__, "runtime_owner", runtime_owner)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[builtins.str]:
        """
        The type of access mode this instance. For valid values, see
        `https://cloud.google.com/vertex-ai/docs/workbench/reference/
        rest/v1/projects.locations.runtimes#RuntimeAccessType`.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        The proxy endpoint that is used to access the runtime.
        """
        return pulumi.get(self, "proxy_uri")

    @property
    @pulumi.getter(name="runtimeOwner")
    def runtime_owner(self) -> Optional[builtins.str]:
        """
        The owner of this runtime after creation. Format: `alias@example.com`.
        Currently supports one owner only.
        """
        return pulumi.get(self, "runtime_owner")


@pulumi.output_type
class RuntimeIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RuntimeIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RuntimeMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemMetrics":
            suggest = "system_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_metrics: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] system_metrics: (Output)
               Contains runtime daemon metrics, such as OS and kernels and
               sessions stats.
        """
        if system_metrics is not None:
            pulumi.set(__self__, "system_metrics", system_metrics)

    @property
    @pulumi.getter(name="systemMetrics")
    def system_metrics(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Output)
        Contains runtime daemon metrics, such as OS and kernels and
        sessions stats.
        """
        return pulumi.get(self, "system_metrics")


@pulumi.output_type
class RuntimeSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customGpuDriverPath":
            suggest = "custom_gpu_driver_path"
        elif key == "enableHealthMonitoring":
            suggest = "enable_health_monitoring"
        elif key == "idleShutdown":
            suggest = "idle_shutdown"
        elif key == "idleShutdownTimeout":
            suggest = "idle_shutdown_timeout"
        elif key == "installGpuDriver":
            suggest = "install_gpu_driver"
        elif key == "notebookUpgradeSchedule":
            suggest = "notebook_upgrade_schedule"
        elif key == "postStartupScript":
            suggest = "post_startup_script"
        elif key == "postStartupScriptBehavior":
            suggest = "post_startup_script_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_gpu_driver_path: Optional[builtins.str] = None,
                 enable_health_monitoring: Optional[builtins.bool] = None,
                 idle_shutdown: Optional[builtins.bool] = None,
                 idle_shutdown_timeout: Optional[builtins.int] = None,
                 install_gpu_driver: Optional[builtins.bool] = None,
                 kernels: Optional[Sequence['outputs.RuntimeSoftwareConfigKernel']] = None,
                 notebook_upgrade_schedule: Optional[builtins.str] = None,
                 post_startup_script: Optional[builtins.str] = None,
                 post_startup_script_behavior: Optional[builtins.str] = None,
                 upgradeable: Optional[builtins.bool] = None):
        """
        :param builtins.str custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param builtins.bool enable_health_monitoring: Verifies core internal services are running. Default: True.
        :param builtins.bool idle_shutdown: Runtime will automatically shutdown after idle_shutdown_time.
               Default: True
        :param builtins.int idle_shutdown_timeout: Time in minutes to wait before shuting down runtime.
               Default: 180 minutes
        :param builtins.bool install_gpu_driver: Install Nvidia Driver automatically.
        :param Sequence['RuntimeSoftwareConfigKernelArgs'] kernels: Use a list of container images to use as Kernels in the notebook instance.
               Structure is documented below.
        :param builtins.str notebook_upgrade_schedule: Cron expression in UTC timezone for schedule instance auto upgrade.
               Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
        :param builtins.str post_startup_script: Path to a Bash script that automatically runs after a notebook instance
               fully boots up. The path must be a URL or
               Cloud Storage path (gs://path-to-file/file-name).
        :param builtins.str post_startup_script_behavior: Behavior for the post startup script.
               Possible values are: `POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED`, `RUN_EVERY_START`, `DOWNLOAD_AND_RUN_EVERY_START`.
        :param builtins.bool upgradeable: (Output)
               Bool indicating whether an newer image is available in an image family.
        """
        if custom_gpu_driver_path is not None:
            pulumi.set(__self__, "custom_gpu_driver_path", custom_gpu_driver_path)
        if enable_health_monitoring is not None:
            pulumi.set(__self__, "enable_health_monitoring", enable_health_monitoring)
        if idle_shutdown is not None:
            pulumi.set(__self__, "idle_shutdown", idle_shutdown)
        if idle_shutdown_timeout is not None:
            pulumi.set(__self__, "idle_shutdown_timeout", idle_shutdown_timeout)
        if install_gpu_driver is not None:
            pulumi.set(__self__, "install_gpu_driver", install_gpu_driver)
        if kernels is not None:
            pulumi.set(__self__, "kernels", kernels)
        if notebook_upgrade_schedule is not None:
            pulumi.set(__self__, "notebook_upgrade_schedule", notebook_upgrade_schedule)
        if post_startup_script is not None:
            pulumi.set(__self__, "post_startup_script", post_startup_script)
        if post_startup_script_behavior is not None:
            pulumi.set(__self__, "post_startup_script_behavior", post_startup_script_behavior)
        if upgradeable is not None:
            pulumi.set(__self__, "upgradeable", upgradeable)

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> Optional[builtins.str]:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored.
        If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @property
    @pulumi.getter(name="enableHealthMonitoring")
    def enable_health_monitoring(self) -> Optional[builtins.bool]:
        """
        Verifies core internal services are running. Default: True.
        """
        return pulumi.get(self, "enable_health_monitoring")

    @property
    @pulumi.getter(name="idleShutdown")
    def idle_shutdown(self) -> Optional[builtins.bool]:
        """
        Runtime will automatically shutdown after idle_shutdown_time.
        Default: True
        """
        return pulumi.get(self, "idle_shutdown")

    @property
    @pulumi.getter(name="idleShutdownTimeout")
    def idle_shutdown_timeout(self) -> Optional[builtins.int]:
        """
        Time in minutes to wait before shuting down runtime.
        Default: 180 minutes
        """
        return pulumi.get(self, "idle_shutdown_timeout")

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> Optional[builtins.bool]:
        """
        Install Nvidia Driver automatically.
        """
        return pulumi.get(self, "install_gpu_driver")

    @property
    @pulumi.getter
    def kernels(self) -> Optional[Sequence['outputs.RuntimeSoftwareConfigKernel']]:
        """
        Use a list of container images to use as Kernels in the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "kernels")

    @property
    @pulumi.getter(name="notebookUpgradeSchedule")
    def notebook_upgrade_schedule(self) -> Optional[builtins.str]:
        """
        Cron expression in UTC timezone for schedule instance auto upgrade.
        Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "notebook_upgrade_schedule")

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> Optional[builtins.str]:
        """
        Path to a Bash script that automatically runs after a notebook instance
        fully boots up. The path must be a URL or
        Cloud Storage path (gs://path-to-file/file-name).
        """
        return pulumi.get(self, "post_startup_script")

    @property
    @pulumi.getter(name="postStartupScriptBehavior")
    def post_startup_script_behavior(self) -> Optional[builtins.str]:
        """
        Behavior for the post startup script.
        Possible values are: `POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED`, `RUN_EVERY_START`, `DOWNLOAD_AND_RUN_EVERY_START`.
        """
        return pulumi.get(self, "post_startup_script_behavior")

    @property
    @pulumi.getter
    def upgradeable(self) -> Optional[builtins.bool]:
        """
        (Output)
        Bool indicating whether an newer image is available in an image family.
        """
        return pulumi.get(self, "upgradeable")


@pulumi.output_type
class RuntimeSoftwareConfigKernel(dict):
    def __init__(__self__, *,
                 repository: builtins.str,
                 tag: Optional[builtins.str] = None):
        """
        :param builtins.str repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param builtins.str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class RuntimeVirtualMachine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "virtualMachineConfig":
            suggest = "virtual_machine_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: Optional[builtins.str] = None,
                 instance_name: Optional[builtins.str] = None,
                 virtual_machine_config: Optional['outputs.RuntimeVirtualMachineVirtualMachineConfig'] = None):
        """
        :param builtins.str instance_id: (Output)
               The unique identifier of the Managed Compute Engine instance.
        :param builtins.str instance_name: (Output)
               The user-friendly name of the Managed Compute Engine instance.
        :param 'RuntimeVirtualMachineVirtualMachineConfigArgs' virtual_machine_config: Virtual Machine configuration settings.
               Structure is documented below.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if virtual_machine_config is not None:
            pulumi.set(__self__, "virtual_machine_config", virtual_machine_config)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        (Output)
        The unique identifier of the Managed Compute Engine instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[builtins.str]:
        """
        (Output)
        The user-friendly name of the Managed Compute Engine instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="virtualMachineConfig")
    def virtual_machine_config(self) -> Optional['outputs.RuntimeVirtualMachineVirtualMachineConfig']:
        """
        Virtual Machine configuration settings.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine_config")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisk":
            suggest = "data_disk"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "acceleratorConfig":
            suggest = "accelerator_config"
        elif key == "containerImages":
            suggest = "container_images"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "guestAttributes":
            suggest = "guest_attributes"
        elif key == "internalIpOnly":
            suggest = "internal_ip_only"
        elif key == "nicType":
            suggest = "nic_type"
        elif key == "reservedIpRange":
            suggest = "reserved_ip_range"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk: 'outputs.RuntimeVirtualMachineVirtualMachineConfigDataDisk',
                 machine_type: builtins.str,
                 accelerator_config: Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig'] = None,
                 container_images: Optional[Sequence['outputs.RuntimeVirtualMachineVirtualMachineConfigContainerImage']] = None,
                 encryption_config: Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig'] = None,
                 guest_attributes: Optional[Mapping[str, builtins.str]] = None,
                 internal_ip_only: Optional[builtins.bool] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 network: Optional[builtins.str] = None,
                 nic_type: Optional[builtins.str] = None,
                 reserved_ip_range: Optional[builtins.str] = None,
                 shielded_instance_config: Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig'] = None,
                 subnet: Optional[builtins.str] = None,
                 tags: Optional[Sequence[builtins.str]] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param 'RuntimeVirtualMachineVirtualMachineConfigDataDiskArgs' data_disk: Data disk option configuration settings.
               Structure is documented below.
        :param builtins.str machine_type: The Compute Engine machine type used for runtimes.
        :param 'RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigArgs' accelerator_config: The Compute Engine accelerator configuration for this runtime.
               Structure is documented below.
        :param Sequence['RuntimeVirtualMachineVirtualMachineConfigContainerImageArgs'] container_images: Use a list of container images to start the notebook instance.
               Structure is documented below.
        :param 'RuntimeVirtualMachineVirtualMachineConfigEncryptionConfigArgs' encryption_config: Encryption settings for virtual machine data disk.
               Structure is documented below.
        :param Mapping[str, builtins.str] guest_attributes: (Output)
               The Compute Engine guest attributes. (see [Project and instance
               guest attributes](https://cloud.google.com/compute/docs/
               storing-retrieving-metadata#guest_attributes)).
        :param builtins.bool internal_ip_only: If true, runtime will only have internal IP addresses. By default,
               runtimes are not restricted to internal IP addresses, and will
               have ephemeral external IP addresses assigned to each vm. This
               `internal_ip_only` restriction can only be enabled for subnetwork
               enabled networks, and all dependencies must be configured to be
               accessible without external IP addresses.
        :param Mapping[str, builtins.str] labels: The labels to associate with this runtime. Label **keys** must
               contain 1 to 63 characters, and must conform to [RFC 1035]
               (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
               empty, but, if present, must contain 1 to 63 characters, and must
               conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
               more than 32 labels can be associated with a cluster.
        :param Mapping[str, builtins.str] metadata: The Compute Engine metadata entries to add to virtual machine.
               (see [Project and instance metadata](https://cloud.google.com
               /compute/docs/storing-retrieving-metadata#project_and_instance
               _metadata)).
        :param builtins.str network: The Compute Engine network to be used for machine communications.
               Cannot be specified with subnetwork. If neither `network` nor
               `subnet` is specified, the "default" network of the project is
               used, if it exists. A full URL or partial URI. Examples:
               * `https://www.googleapis.com/compute/v1/projects/[project_id]/
               regions/global/default`
               * `projects/[project_id]/regions/global/default`
               Runtimes are managed resources inside Google Infrastructure.
               Runtimes support the following network configurations:
               * Google Managed Network (Network & subnet are empty)
               * Consumer Project VPC (network & subnet are required). Requires
               configuring Private Service Access.
               * Shared VPC (network & subnet are required). Requires
               configuring Private Service Access.
        :param builtins.str nic_type: The type of vNIC to be used on this interface. This may be gVNIC
               or VirtioNet.
               Possible values are: `UNSPECIFIED_NIC_TYPE`, `VIRTIO_NET`, `GVNIC`.
        :param builtins.str reserved_ip_range: Reserved IP Range name is used for VPC Peering. The
               subnetwork allocation will use the range *name* if it's assigned.
        :param 'RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigArgs' shielded_instance_config: Shielded VM Instance configuration settings.
               Structure is documented below.
        :param builtins.str subnet: The Compute Engine subnetwork to be used for machine
               communications. Cannot be specified with network. A full URL or
               partial URI are valid. Examples:
               * `https://www.googleapis.com/compute/v1/projects/[project_id]/
               regions/us-east1/subnetworks/sub0`
               * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
        :param Sequence[builtins.str] tags: The Compute Engine tags to add to runtime (see [Tagging instances]
               (https://cloud.google.com/compute/docs/
               label-or-tag-resources#tags)).
        :param builtins.str zone: (Output)
               The zone where the virtual machine is located.
        """
        pulumi.set(__self__, "data_disk", data_disk)
        pulumi.set(__self__, "machine_type", machine_type)
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if container_images is not None:
            pulumi.set(__self__, "container_images", container_images)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if guest_attributes is not None:
            pulumi.set(__self__, "guest_attributes", guest_attributes)
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if nic_type is not None:
            pulumi.set(__self__, "nic_type", nic_type)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="dataDisk")
    def data_disk(self) -> 'outputs.RuntimeVirtualMachineVirtualMachineConfigDataDisk':
        """
        Data disk option configuration settings.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disk")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> builtins.str:
        """
        The Compute Engine machine type used for runtimes.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig']:
        """
        The Compute Engine accelerator configuration for this runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="containerImages")
    def container_images(self) -> Optional[Sequence['outputs.RuntimeVirtualMachineVirtualMachineConfigContainerImage']]:
        """
        Use a list of container images to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_images")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig']:
        """
        Encryption settings for virtual machine data disk.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="guestAttributes")
    def guest_attributes(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Output)
        The Compute Engine guest attributes. (see [Project and instance
        guest attributes](https://cloud.google.com/compute/docs/
        storing-retrieving-metadata#guest_attributes)).
        """
        return pulumi.get(self, "guest_attributes")

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[builtins.bool]:
        """
        If true, runtime will only have internal IP addresses. By default,
        runtimes are not restricted to internal IP addresses, and will
        have ephemeral external IP addresses assigned to each vm. This
        `internal_ip_only` restriction can only be enabled for subnetwork
        enabled networks, and all dependencies must be configured to be
        accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The labels to associate with this runtime. Label **keys** must
        contain 1 to 63 characters, and must conform to [RFC 1035]
        (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
        empty, but, if present, must contain 1 to 63 characters, and must
        conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
        more than 32 labels can be associated with a cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The Compute Engine metadata entries to add to virtual machine.
        (see [Project and instance metadata](https://cloud.google.com
        /compute/docs/storing-retrieving-metadata#project_and_instance
        _metadata)).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        The Compute Engine network to be used for machine communications.
        Cannot be specified with subnetwork. If neither `network` nor
        `subnet` is specified, the "default" network of the project is
        used, if it exists. A full URL or partial URI. Examples:
        * `https://www.googleapis.com/compute/v1/projects/[project_id]/
        regions/global/default`
        * `projects/[project_id]/regions/global/default`
        Runtimes are managed resources inside Google Infrastructure.
        Runtimes support the following network configurations:
        * Google Managed Network (Network & subnet are empty)
        * Consumer Project VPC (network & subnet are required). Requires
        configuring Private Service Access.
        * Shared VPC (network & subnet are required). Requires
        configuring Private Service Access.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> Optional[builtins.str]:
        """
        The type of vNIC to be used on this interface. This may be gVNIC
        or VirtioNet.
        Possible values are: `UNSPECIFIED_NIC_TYPE`, `VIRTIO_NET`, `GVNIC`.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[builtins.str]:
        """
        Reserved IP Range name is used for VPC Peering. The
        subnetwork allocation will use the range *name* if it's assigned.
        """
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig']:
        """
        Shielded VM Instance configuration settings.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[builtins.str]:
        """
        The Compute Engine subnetwork to be used for machine
        communications. Cannot be specified with network. A full URL or
        partial URI are valid. Examples:
        * `https://www.googleapis.com/compute/v1/projects/[project_id]/
        regions/us-east1/subnetworks/sub0`
        * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        """
        The Compute Engine tags to add to runtime (see [Tagging instances]
        (https://cloud.google.com/compute/docs/
        label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        (Output)
        The zone where the virtual machine is located.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: Optional[builtins.int] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.int core_count: Count of cores of this accelerator.
        :param builtins.str type: Accelerator model. For valid values, see
               `https://cloud.google.com/vertex-ai/docs/workbench/reference/
               rest/v1/projects.locations.runtimes#AcceleratorType`
        """
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[builtins.int]:
        """
        Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Accelerator model. For valid values, see
        `https://cloud.google.com/vertex-ai/docs/workbench/reference/
        rest/v1/projects.locations.runtimes#AcceleratorType`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigContainerImage(dict):
    def __init__(__self__, *,
                 repository: builtins.str,
                 tag: Optional[builtins.str] = None):
        """
        :param builtins.str repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param builtins.str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"
        elif key == "initializeParams":
            suggest = "initialize_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfigDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: Optional[builtins.bool] = None,
                 boot: Optional[builtins.bool] = None,
                 device_name: Optional[builtins.str] = None,
                 guest_os_features: Optional[Sequence[builtins.str]] = None,
                 index: Optional[builtins.int] = None,
                 initialize_params: Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams'] = None,
                 interface: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 licenses: Optional[Sequence[builtins.str]] = None,
                 mode: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.bool auto_delete: (Output)
               Optional. Specifies whether the disk will be auto-deleted
               when the instance is deleted (but not when the disk is
               detached from the instance).
        :param builtins.bool boot: (Output)
               Optional. Indicates that this is a boot disk. The virtual
               machine will use the first partition of the disk for its
               root filesystem.
        :param builtins.str device_name: (Output)
               Optional. Specifies a unique device name of your choice
               that is reflected into the /dev/disk/by-id/google-* tree
               of a Linux operating system running within the instance.
               This name can be used to reference the device for mounting,
               resizing, and so on, from within the instance.
               If not specified, the server chooses a default device name
               to apply to this disk, in the form persistent-disk-x, where
               x is a number assigned by Google Compute Engine. This field
               is only applicable for persistent disks.
        :param Sequence[builtins.str] guest_os_features: (Output)
               Indicates a list of features to enable on the guest operating
               system. Applicable only for bootable images. To see a list of
               available features, read `https://cloud.google.com/compute/docs/
               images/create-delete-deprecate-private-images#guest-os-features`
               options. ``
        :param builtins.int index: (Output)
               Output only. A zero-based index to this disk, where 0 is
               reserved for the boot disk. If you have many disks attached
               to an instance, each disk would have a unique index number.
        :param 'RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsArgs' initialize_params: Input only. Specifies the parameters for a new disk that will
               be created alongside the new instance. Use initialization
               parameters to create boot disks or local SSDs attached to the
               new instance. This property is mutually exclusive with the
               source property; you can only define one or the other, but not
               both.
               Structure is documented below.
        :param builtins.str interface: "Specifies the disk interface to use for attaching this disk,
               which is either SCSI or NVME. The default is SCSI. Persistent
               disks must always use SCSI and the request will fail if you attempt
               to attach a persistent disk in any other format than SCSI. Local SSDs
               can use either NVME or SCSI. For performance characteristics of SCSI
               over NVMe, see Local SSD performance. Valid values: * NVME * SCSI".
        :param builtins.str kind: (Output)
               Type of the resource. Always compute#attachedDisk for attached
               disks.
        :param Sequence[builtins.str] licenses: (Output)
               Output only. Any valid publicly visible licenses.
        :param builtins.str mode: The mode in which to attach this disk, either READ_WRITE
               or READ_ONLY. If not specified, the default is to attach
               the disk in READ_WRITE mode.
        :param builtins.str source: Specifies a valid partial or full URL to an existing
               Persistent Disk resource.
        :param builtins.str type: Specifies the type of the disk, either SCRATCH or PERSISTENT.
               If not specified, the default is PERSISTENT.
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if initialize_params is not None:
            pulumi.set(__self__, "initialize_params", initialize_params)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[builtins.bool]:
        """
        (Output)
        Optional. Specifies whether the disk will be auto-deleted
        when the instance is deleted (but not when the disk is
        detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> Optional[builtins.bool]:
        """
        (Output)
        Optional. Indicates that this is a boot disk. The virtual
        machine will use the first partition of the disk for its
        root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Specifies a unique device name of your choice
        that is reflected into the /dev/disk/by-id/google-* tree
        of a Linux operating system running within the instance.
        This name can be used to reference the device for mounting,
        resizing, and so on, from within the instance.
        If not specified, the server chooses a default device name
        to apply to this disk, in the form persistent-disk-x, where
        x is a number assigned by Google Compute Engine. This field
        is only applicable for persistent disks.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        Indicates a list of features to enable on the guest operating
        system. Applicable only for bootable images. To see a list of
        available features, read `https://cloud.google.com/compute/docs/
        images/create-delete-deprecate-private-images#guest-os-features`
        options. ``
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def index(self) -> Optional[builtins.int]:
        """
        (Output)
        Output only. A zero-based index to this disk, where 0 is
        reserved for the boot disk. If you have many disks attached
        to an instance, each disk would have a unique index number.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> Optional['outputs.RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams']:
        """
        Input only. Specifies the parameters for a new disk that will
        be created alongside the new instance. Use initialization
        parameters to create boot disks or local SSDs attached to the
        new instance. This property is mutually exclusive with the
        source property; you can only define one or the other, but not
        both.
        Structure is documented below.
        """
        return pulumi.get(self, "initialize_params")

    @property
    @pulumi.getter
    def interface(self) -> Optional[builtins.str]:
        """
        "Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. Persistent
        disks must always use SCSI and the request will fail if you attempt
        to attach a persistent disk in any other format than SCSI. Local SSDs
        can use either NVME or SCSI. For performance characteristics of SCSI
        over NVMe, see Local SSD performance. Valid values: * NVME * SCSI".
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        (Output)
        Type of the resource. Always compute#attachedDisk for attached
        disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def licenses(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        Output only. Any valid publicly visible licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        The mode in which to attach this disk, either READ_WRITE
        or READ_ONLY. If not specified, the default is to attach
        the disk in READ_WRITE mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Specifies a valid partial or full URL to an existing
        Persistent Disk resource.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Specifies the type of the disk, either SCRATCH or PERSISTENT.
        If not specified, the default is PERSISTENT.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 disk_name: Optional[builtins.str] = None,
                 disk_size_gb: Optional[builtins.int] = None,
                 disk_type: Optional[builtins.str] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str description: Provide this property when creating the disk.
        :param builtins.str disk_name: Specifies the disk name. If not specified, the default is
               to use the name of the instance. If the disk with the
               instance name exists already in the given zone/region, a
               new name will be automatically generated.
        :param builtins.int disk_size_gb: Specifies the size of the disk in base-2 GB. If not
               specified, the disk will be the same size as the image
               (usually 10GB). If specified, the size must be equal to
               or larger than 10GB. Default 100 GB.
        :param builtins.str disk_type: The type of the boot disk attached to this runtime,
               defaults to standard persistent disk. For valid values,
               see `https://cloud.google.com/vertex-ai/docs/workbench/
               reference/rest/v1/projects.locations.runtimes#disktype`
        :param Mapping[str, builtins.str] labels: Labels to apply to this disk. These can be later modified
               by the disks.setLabels method. This field is only
               applicable for persistent disks.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Provide this property when creating the disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[builtins.str]:
        """
        Specifies the disk name. If not specified, the default is
        to use the name of the instance. If the disk with the
        instance name exists already in the given zone/region, a
        new name will be automatically generated.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[builtins.int]:
        """
        Specifies the size of the disk in base-2 GB. If not
        specified, the disk will be the same size as the image
        (usually 10GB). If specified, the size must be equal to
        or larger than 10GB. Default 100 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[builtins.str]:
        """
        The type of the boot disk attached to this runtime,
        defaults to standard persistent disk. For valid values,
        see `https://cloud.google.com/vertex-ai/docs/workbench/
        reference/rest/v1/projects.locations.runtimes#disktype`
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to apply to this disk. These can be later modified
        by the disks.setLabels method. This field is only
        applicable for persistent disks.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key: The Cloud KMS resource identifier of the customer-managed
               encryption key used to protect a resource, such as a disks.
               It has the following format:
               `projects/{PROJECT_ID}/locations/{REGION}/keyRings/
               {KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        The Cloud KMS resource identifier of the customer-managed
        encryption key used to protect a resource, such as a disks.
        It has the following format:
        `projects/{PROJECT_ID}/locations/{REGION}/keyRings/
        {KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[builtins.bool] = None,
                 enable_secure_boot: Optional[builtins.bool] = None,
                 enable_vtpm: Optional[builtins.bool] = None):
        """
        :param builtins.bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled.
               Enables monitoring and attestation of the boot integrity of
               the instance. The attestation is performed against the
               integrity policy baseline. This baseline is initially derived
               from the implicitly trusted boot image when the instance is
               created. Enabled by default.
        :param builtins.bool enable_secure_boot: Defines whether the instance has Secure Boot enabled.Secure
               Boot helps ensure that the system only runs authentic software
               by verifying the digital signature of all boot components, and
               halting the boot process if signature verification fails.
               Disabled by default.
        :param builtins.bool enable_vtpm: Defines whether the instance has the vTPM enabled. Enabled by
               default.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has integrity monitoring enabled.
        Enables monitoring and attestation of the boot integrity of
        the instance. The attestation is performed against the
        integrity policy baseline. This baseline is initially derived
        from the implicitly trusted boot image when the instance is
        created. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has Secure Boot enabled.Secure
        Boot helps ensure that the system only runs authentic software
        by verifying the digital signature of all boot components, and
        halting the boot process if signature verification fails.
        Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[builtins.bool]:
        """
        Defines whether the instance has the vTPM enabled. Enabled by
        default.
        """
        return pulumi.get(self, "enable_vtpm")


