# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbNodesResult',
    'AwaitableGetDbNodesResult',
    'get_db_nodes',
    'get_db_nodes_output',
]

@pulumi.output_type
class GetDbNodesResult:
    """
    A collection of values returned by getDbNodes.
    """
    def __init__(__self__, cloud_vm_cluster=None, db_nodes=None, id=None, location=None, project=None):
        if cloud_vm_cluster and not isinstance(cloud_vm_cluster, str):
            raise TypeError("Expected argument 'cloud_vm_cluster' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster", cloud_vm_cluster)
        if db_nodes and not isinstance(db_nodes, list):
            raise TypeError("Expected argument 'db_nodes' to be a list")
        pulumi.set(__self__, "db_nodes", db_nodes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="cloudVmCluster")
    def cloud_vm_cluster(self) -> builtins.str:
        return pulumi.get(self, "cloud_vm_cluster")

    @property
    @pulumi.getter(name="dbNodes")
    def db_nodes(self) -> Sequence['outputs.GetDbNodesDbNodeResult']:
        return pulumi.get(self, "db_nodes")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetDbNodesResult(GetDbNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodesResult(
            cloud_vm_cluster=self.cloud_vm_cluster,
            db_nodes=self.db_nodes,
            id=self.id,
            location=self.location,
            project=self.project)


def get_db_nodes(cloud_vm_cluster: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodesResult:
    """
    List all DbNodes of a Cloud VmCluster.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters.dbNodes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_db_nodes = gcp.oracledatabase.get_db_nodes(location="us-east4",
        cloud_vm_cluster="vmcluster-id")
    ```

    ## Attributes reference

    The following attributes are exported:

    * `db_nodes` - List of dbNodes. Structure is documented below.

    <a name="nested_dbnodes"></a> The `db_nodes` block supports:

    * `name` - The name of the database node resource in the following format: projects/{project}/locations/{location}/cloudVmClusters/{cloudVmCluster}/dbNodes/{db_node}

    * `properties` - Various properties of the database node. Structure is documented below.

    <a name="nested_properties"></a> The `properties` block supports:

    * `ocid`- OCID of database node.

    * `ocpu_count` - OCPU count per database node.

    * `memory_size_gb` - The allocated memory in GBs on the database node.

    * `db_node_storage_size_gb` - The allocated local node storage in GBs on the database node.

    * `db_server_ocid` - The OCID of the Database server associated with the database node.

    * `hostname` - The host name for the database node.

    * `state` - State of the database node.
    <a name="nested_states"></a>Possible values for `state` are:<br>
    `PROVISIONING` - Indicates that the resource is being provisioned.<br>
    `AVAILABLE` - Indicates that the resource is available.<br>
    `UPDATING` - Indicates that the resource is being updated.<br>
    `STOPPING` - Indicates that the resource is being stopped.<br>
    `STOPPED` - Indicates that the resource is stopped.<br>
    `STARTING` - Indicates that the resource is being started.<br>
    `TERMINATING` - Indicates that the resource is being terminated.<br>
    `TERMINATED` - Indicates that the resource is terminated.<br>
    `FAILED` - Indicates that the resource has failed.<br>

    * `total_cpu_core_count` - The total number of CPU cores reserved on the database node.


    :param builtins.str cloud_vm_cluster: The ID of the VM Cluster.
    :param builtins.str location: The location of the resource.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['cloudVmCluster'] = cloud_vm_cluster
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:oracledatabase/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult).value

    return AwaitableGetDbNodesResult(
        cloud_vm_cluster=pulumi.get(__ret__, 'cloud_vm_cluster'),
        db_nodes=pulumi.get(__ret__, 'db_nodes'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'))
def get_db_nodes_output(cloud_vm_cluster: Optional[pulumi.Input[builtins.str]] = None,
                        location: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodesResult]:
    """
    List all DbNodes of a Cloud VmCluster.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters.dbNodes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_db_nodes = gcp.oracledatabase.get_db_nodes(location="us-east4",
        cloud_vm_cluster="vmcluster-id")
    ```

    ## Attributes reference

    The following attributes are exported:

    * `db_nodes` - List of dbNodes. Structure is documented below.

    <a name="nested_dbnodes"></a> The `db_nodes` block supports:

    * `name` - The name of the database node resource in the following format: projects/{project}/locations/{location}/cloudVmClusters/{cloudVmCluster}/dbNodes/{db_node}

    * `properties` - Various properties of the database node. Structure is documented below.

    <a name="nested_properties"></a> The `properties` block supports:

    * `ocid`- OCID of database node.

    * `ocpu_count` - OCPU count per database node.

    * `memory_size_gb` - The allocated memory in GBs on the database node.

    * `db_node_storage_size_gb` - The allocated local node storage in GBs on the database node.

    * `db_server_ocid` - The OCID of the Database server associated with the database node.

    * `hostname` - The host name for the database node.

    * `state` - State of the database node.
    <a name="nested_states"></a>Possible values for `state` are:<br>
    `PROVISIONING` - Indicates that the resource is being provisioned.<br>
    `AVAILABLE` - Indicates that the resource is available.<br>
    `UPDATING` - Indicates that the resource is being updated.<br>
    `STOPPING` - Indicates that the resource is being stopped.<br>
    `STOPPED` - Indicates that the resource is stopped.<br>
    `STARTING` - Indicates that the resource is being started.<br>
    `TERMINATING` - Indicates that the resource is being terminated.<br>
    `TERMINATED` - Indicates that the resource is terminated.<br>
    `FAILED` - Indicates that the resource has failed.<br>

    * `total_cpu_core_count` - The total number of CPU cores reserved on the database node.


    :param builtins.str cloud_vm_cluster: The ID of the VM Cluster.
    :param builtins.str location: The location of the resource.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['cloudVmCluster'] = cloud_vm_cluster
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:oracledatabase/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult)
    return __ret__.apply(lambda __response__: GetDbNodesResult(
        cloud_vm_cluster=pulumi.get(__response__, 'cloud_vm_cluster'),
        db_nodes=pulumi.get(__response__, 'db_nodes'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project')))
