# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetActiveFolderResult',
    'AwaitableGetActiveFolderResult',
    'get_active_folder',
    'get_active_folder_output',
]

@pulumi.output_type
class GetActiveFolderResult:
    """
    A collection of values returned by getActiveFolder.
    """
    def __init__(__self__, api_method=None, display_name=None, id=None, name=None, parent=None):
        if api_method and not isinstance(api_method, str):
            raise TypeError("Expected argument 'api_method' to be a str")
        pulumi.set(__self__, "api_method", api_method)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="apiMethod")
    def api_method(self) -> Optional[builtins.str]:
        return pulumi.get(self, "api_method")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name of the Folder. This uniquely identifies the folder.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        return pulumi.get(self, "parent")


class AwaitableGetActiveFolderResult(GetActiveFolderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActiveFolderResult(
            api_method=self.api_method,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            parent=self.parent)


def get_active_folder(api_method: Optional[builtins.str] = None,
                      display_name: Optional[builtins.str] = None,
                      parent: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActiveFolderResult:
    """
    Get an active folder within GCP by `display_name` and `parent`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    department1 = gcp.organizations.get_active_folder(display_name="Department 1",
        parent="organizations/1234567")
    ```


    :param builtins.str api_method: The API method to use to search for the folder. Valid values are `LIST` and `SEARCH`. Default Value is `LIST`. `LIST` is [strongly consistent](https://cloud.google.com/resource-manager/reference/rest/v3/folders/list#:~:text=list()%20provides%20a-,strongly%20consistent,-view%20of%20the) and requires `resourcemanager.folders.list` on the parent folder, while `SEARCH` is [eventually consistent](https://cloud.google.com/resource-manager/reference/rest/v3/folders/search#:~:text=eventually%20consistent) and only returns folders that the user has `resourcemanager.folders.get` permission on.
    :param builtins.str display_name: The folder's display name.
    :param builtins.str parent: The resource name of the parent Folder or Organization.
    """
    __args__ = dict()
    __args__['apiMethod'] = api_method
    __args__['displayName'] = display_name
    __args__['parent'] = parent
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getActiveFolder:getActiveFolder', __args__, opts=opts, typ=GetActiveFolderResult).value

    return AwaitableGetActiveFolderResult(
        api_method=pulumi.get(__ret__, 'api_method'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'))
def get_active_folder_output(api_method: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             display_name: Optional[pulumi.Input[builtins.str]] = None,
                             parent: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetActiveFolderResult]:
    """
    Get an active folder within GCP by `display_name` and `parent`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    department1 = gcp.organizations.get_active_folder(display_name="Department 1",
        parent="organizations/1234567")
    ```


    :param builtins.str api_method: The API method to use to search for the folder. Valid values are `LIST` and `SEARCH`. Default Value is `LIST`. `LIST` is [strongly consistent](https://cloud.google.com/resource-manager/reference/rest/v3/folders/list#:~:text=list()%20provides%20a-,strongly%20consistent,-view%20of%20the) and requires `resourcemanager.folders.list` on the parent folder, while `SEARCH` is [eventually consistent](https://cloud.google.com/resource-manager/reference/rest/v3/folders/search#:~:text=eventually%20consistent) and only returns folders that the user has `resourcemanager.folders.get` permission on.
    :param builtins.str display_name: The folder's display name.
    :param builtins.str parent: The resource name of the parent Folder or Organization.
    """
    __args__ = dict()
    __args__['apiMethod'] = api_method
    __args__['displayName'] = display_name
    __args__['parent'] = parent
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getActiveFolder:getActiveFolder', __args__, opts=opts, typ=GetActiveFolderResult)
    return __ret__.apply(lambda __response__: GetActiveFolderResult(
        api_method=pulumi.get(__response__, 'api_method'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent')))
