# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIamCustomRolesResult',
    'AwaitableGetIamCustomRolesResult',
    'get_iam_custom_roles',
    'get_iam_custom_roles_output',
]

@pulumi.output_type
class GetIamCustomRolesResult:
    """
    A collection of values returned by getIamCustomRoles.
    """
    def __init__(__self__, id=None, org_id=None, roles=None, show_deleted=None, view=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if show_deleted and not isinstance(show_deleted, bool):
            raise TypeError("Expected argument 'show_deleted' to be a bool")
        pulumi.set(__self__, "show_deleted", show_deleted)
        if view and not isinstance(view, str):
            raise TypeError("Expected argument 'view' to be a str")
        pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetIamCustomRolesRoleResult']:
        """
        A list of all retrieved custom roles roles. Structure is defined below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="showDeleted")
    def show_deleted(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "show_deleted")

    @property
    @pulumi.getter
    def view(self) -> Optional[builtins.str]:
        return pulumi.get(self, "view")


class AwaitableGetIamCustomRolesResult(GetIamCustomRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamCustomRolesResult(
            id=self.id,
            org_id=self.org_id,
            roles=self.roles,
            show_deleted=self.show_deleted,
            view=self.view)


def get_iam_custom_roles(org_id: Optional[builtins.str] = None,
                         show_deleted: Optional[builtins.bool] = None,
                         view: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamCustomRolesResult:
    """
    Get information about a Google Cloud Organization IAM Custom Roles.
    Note that you must have the `roles/iam.organizationRoleViewer`.
    See [the official documentation](https://cloud.google.com/iam/docs/creating-custom-roles)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/organizations.roles/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.organizations.get_iam_custom_roles(org_id="1234567890",
        show_deleted=True,
        view="FULL")
    ```


    :param builtins.str org_id: The numeric ID of the organization.
    :param builtins.bool show_deleted: Include Roles that have been deleted. Defaults to `false`.
    :param builtins.str view: When `"FULL"` is specified, the `permissions` field is returned, which includes a list of all permissions in the role. The default value is `"BASIC"`, which does not return the `permissions`.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    __args__['showDeleted'] = show_deleted
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getIamCustomRoles:getIamCustomRoles', __args__, opts=opts, typ=GetIamCustomRolesResult).value

    return AwaitableGetIamCustomRolesResult(
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        roles=pulumi.get(__ret__, 'roles'),
        show_deleted=pulumi.get(__ret__, 'show_deleted'),
        view=pulumi.get(__ret__, 'view'))
def get_iam_custom_roles_output(org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                show_deleted: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                view: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamCustomRolesResult]:
    """
    Get information about a Google Cloud Organization IAM Custom Roles.
    Note that you must have the `roles/iam.organizationRoleViewer`.
    See [the official documentation](https://cloud.google.com/iam/docs/creating-custom-roles)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/organizations.roles/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.organizations.get_iam_custom_roles(org_id="1234567890",
        show_deleted=True,
        view="FULL")
    ```


    :param builtins.str org_id: The numeric ID of the organization.
    :param builtins.bool show_deleted: Include Roles that have been deleted. Defaults to `false`.
    :param builtins.str view: When `"FULL"` is specified, the `permissions` field is returned, which includes a list of all permissions in the role. The default value is `"BASIC"`, which does not return the `permissions`.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    __args__['showDeleted'] = show_deleted
    __args__['view'] = view
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getIamCustomRoles:getIamCustomRoles', __args__, opts=opts, typ=GetIamCustomRolesResult)
    return __ret__.apply(lambda __response__: GetIamCustomRolesResult(
        id=pulumi.get(__response__, 'id'),
        org_id=pulumi.get(__response__, 'org_id'),
        roles=pulumi.get(__response__, 'roles'),
        show_deleted=pulumi.get(__response__, 'show_deleted'),
        view=pulumi.get(__response__, 'view')))
