# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, auto_create_network=None, billing_account=None, deletion_policy=None, effective_labels=None, folder_id=None, id=None, labels=None, name=None, number=None, org_id=None, project_id=None, pulumi_labels=None, tags=None):
        if auto_create_network and not isinstance(auto_create_network, bool):
            raise TypeError("Expected argument 'auto_create_network' to be a bool")
        pulumi.set(__self__, "auto_create_network", auto_create_network)
        if billing_account and not isinstance(billing_account, str):
            raise TypeError("Expected argument 'billing_account' to be a str")
        pulumi.set(__self__, "billing_account", billing_account)
        if deletion_policy and not isinstance(deletion_policy, str):
            raise TypeError("Expected argument 'deletion_policy' to be a str")
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if number and not isinstance(number, str):
            raise TypeError("Expected argument 'number' to be a str")
        pulumi.set(__self__, "number", number)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoCreateNetwork")
    def auto_create_network(self) -> builtins.bool:
        return pulumi.get(self, "auto_create_network")

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> builtins.str:
        return pulumi.get(self, "billing_account")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> builtins.str:
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> builtins.str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> builtins.str:
        """
        The numeric identifier of the project.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            auto_create_network=self.auto_create_network,
            billing_account=self.billing_account,
            deletion_policy=self.deletion_policy,
            effective_labels=self.effective_labels,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            number=self.number,
            org_id=self.org_id,
            project_id=self.project_id,
            pulumi_labels=self.pulumi_labels,
            tags=self.tags)


def get_project(project_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Use this data source to get project details.
    For more information see
    [API](https://cloud.google.com/resource-manager/reference/rest/v1/projects#Project)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    project = gcp.organizations.get_project()
    pulumi.export("projectNumber", project.number)
    ```


    :param builtins.str project_id: The project ID. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        auto_create_network=pulumi.get(__ret__, 'auto_create_network'),
        billing_account=pulumi.get(__ret__, 'billing_account'),
        deletion_policy=pulumi.get(__ret__, 'deletion_policy'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        number=pulumi.get(__ret__, 'number'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_output(project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Use this data source to get project details.
    For more information see
    [API](https://cloud.google.com/resource-manager/reference/rest/v1/projects#Project)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    project = gcp.organizations.get_project()
    pulumi.export("projectNumber", project.number)
    ```


    :param builtins.str project_id: The project ID. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        auto_create_network=pulumi.get(__response__, 'auto_create_network'),
        billing_account=pulumi.get(__response__, 'billing_account'),
        deletion_policy=pulumi.get(__response__, 'deletion_policy'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        number=pulumi.get(__response__, 'number'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        tags=pulumi.get(__response__, 'tags')))
