# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IAMMemberArgs', 'IAMMember']

@pulumi.input_type
class IAMMemberArgs:
    def __init__(__self__, *,
                 member: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 role: pulumi.Input[builtins.str],
                 condition: Optional[pulumi.Input['IAMMemberConditionArgs']] = None):
        """
        The set of arguments for constructing a IAMMember resource.
        :param pulumi.Input[builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[builtins.str] org_id: The organization id of the target organization.
        :param pulumi.Input[builtins.str] role: The role that should be applied. Only one
               `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
               `organizations/{{org_id}}/roles/{{role_id}}`.
        :param pulumi.Input['IAMMemberConditionArgs'] condition: An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
               Structure is documented below.
        """
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def member(self) -> pulumi.Input[builtins.str]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The organization id of the target organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        The role that should be applied. Only one
        `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
        `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['IAMMemberConditionArgs']]:
        """
        An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['IAMMemberConditionArgs']]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class _IAMMemberState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['IAMMemberConditionArgs']] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 member: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IAMMember resources.
        :param pulumi.Input['IAMMemberConditionArgs'] condition: An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: (Computed) The etag of the organization's IAM policy.
        :param pulumi.Input[builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[builtins.str] org_id: The organization id of the target organization.
        :param pulumi.Input[builtins.str] role: The role that should be applied. Only one
               `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
               `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['IAMMemberConditionArgs']]:
        """
        An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['IAMMemberConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Computed) The etag of the organization's IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def member(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization id of the target organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role that should be applied. Only one
        `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
        `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("gcp:organizations/iAMMember:IAMMember")
class IAMMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['IAMMemberConditionArgs', 'IAMMemberConditionArgsDict']]] = None,
                 member: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Four different resources help you manage your IAM policy for a organization. Each of these resources serves a different use case:

        * `organizations.IAMPolicy`: Authoritative. Sets the IAM policy for the organization and replaces any existing policy already attached.
        * `organizations.IAMBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organization are preserved.
        * `organizations.IAMMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organization are preserved.
        * `organizations.IamAuditConfig`: Authoritative for a given service. Updates the IAM policy to enable audit logging for the given service.

        > **Note:** `organizations.IAMPolicy` **cannot** be used in conjunction with `organizations.IAMBinding`, `organizations.IAMMember`, or `organizations.IamAuditConfig` or they will fight over what your policy should be.

        > **Note:** `organizations.IAMBinding` resources **can be** used in conjunction with `organizations.IAMMember` resources **only if** they do not grant privilege to the same role.

        ## organizations.IAMPolicy

        !> **Warning:** New organizations have several default policies which will,
           without extreme caution, be **overwritten** by use of this resource.
           The safest alternative is to use multiple `organizations.IAMBinding`
           resources. This resource makes it easy to remove your own access to
           an organization, which will require a call to Google Support to have
           fixed, and can take multiple days to resolve.

           In general, this resource should only be used with organizations
           fully managed by this provider.I f you do use this resource,
           the best way to be sure that you are not making dangerous changes is to start
           by **importing** your existing policy, and examining the diff very closely.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/editor",
            "members": ["user:jane@example.com"],
        }])
        organization = gcp.organizations.IAMPolicy("organization",
            org_id="1234567890",
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/editor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        organization = gcp.organizations.IAMPolicy("organization",
            org_id="1234567890",
            policy_data=admin.policy_data)
        ```

        ## organizations.IAMBinding

        > **Note:** If `role` is set to `roles/owner` and you don't specify a user or service account you have access to in `members`, you can lock yourself out of your organization.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IAMMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IamAuditConfig

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IamAuditConfig("organization",
            org_id="1234567890",
            service="allServices",
            audit_log_configs=[
                {
                    "log_type": "ADMIN_READ",
                },
                {
                    "log_type": "DATA_READ",
                    "exempted_members": ["user:joebloggs@example.com"],
                },
            ])
        ```

        ## organizations.IAMBinding

        > **Note:** If `role` is set to `roles/owner` and you don't specify a user or service account you have access to in `members`, you can lock yourself out of your organization.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IAMMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IamAuditConfig

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IamAuditConfig("organization",
            org_id="1234567890",
            service="allServices",
            audit_log_configs=[
                {
                    "log_type": "ADMIN_READ",
                },
                {
                    "log_type": "DATA_READ",
                    "exempted_members": ["user:joebloggs@example.com"],
                },
            ])
        ```

        ## Import

        ### Importing Audit Configs

        An audit config can be imported into a `google_organization_iam_audit_config` resource using the resource's `org_id` and the `service`, e.g:

        * `"{{org_id}} foo.googleapis.com"`

        An `import` block (Terraform v1.5.0 and later) can be used to import audit configs:

        tf

        import {

          id = "{{org_id}} foo.googleapis.com"

          to = google_organization_iam_audit_config.default

        }

        The `pulumi import` command can also be used:

        ```sh
        $ pulumi import gcp:organizations/iAMMember:IAMMember default "{{org_id}} foo.googleapis.com"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IAMMemberConditionArgs', 'IAMMemberConditionArgsDict']] condition: An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
               Structure is documented below.
        :param pulumi.Input[builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[builtins.str] org_id: The organization id of the target organization.
        :param pulumi.Input[builtins.str] role: The role that should be applied. Only one
               `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
               `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IAMMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Four different resources help you manage your IAM policy for a organization. Each of these resources serves a different use case:

        * `organizations.IAMPolicy`: Authoritative. Sets the IAM policy for the organization and replaces any existing policy already attached.
        * `organizations.IAMBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organization are preserved.
        * `organizations.IAMMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organization are preserved.
        * `organizations.IamAuditConfig`: Authoritative for a given service. Updates the IAM policy to enable audit logging for the given service.

        > **Note:** `organizations.IAMPolicy` **cannot** be used in conjunction with `organizations.IAMBinding`, `organizations.IAMMember`, or `organizations.IamAuditConfig` or they will fight over what your policy should be.

        > **Note:** `organizations.IAMBinding` resources **can be** used in conjunction with `organizations.IAMMember` resources **only if** they do not grant privilege to the same role.

        ## organizations.IAMPolicy

        !> **Warning:** New organizations have several default policies which will,
           without extreme caution, be **overwritten** by use of this resource.
           The safest alternative is to use multiple `organizations.IAMBinding`
           resources. This resource makes it easy to remove your own access to
           an organization, which will require a call to Google Support to have
           fixed, and can take multiple days to resolve.

           In general, this resource should only be used with organizations
           fully managed by this provider.I f you do use this resource,
           the best way to be sure that you are not making dangerous changes is to start
           by **importing** your existing policy, and examining the diff very closely.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/editor",
            "members": ["user:jane@example.com"],
        }])
        organization = gcp.organizations.IAMPolicy("organization",
            org_id="1234567890",
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/editor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        organization = gcp.organizations.IAMPolicy("organization",
            org_id="1234567890",
            policy_data=admin.policy_data)
        ```

        ## organizations.IAMBinding

        > **Note:** If `role` is set to `roles/owner` and you don't specify a user or service account you have access to in `members`, you can lock yourself out of your organization.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IAMMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IamAuditConfig

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IamAuditConfig("organization",
            org_id="1234567890",
            service="allServices",
            audit_log_configs=[
                {
                    "log_type": "ADMIN_READ",
                },
                {
                    "log_type": "DATA_READ",
                    "exempted_members": ["user:joebloggs@example.com"],
                },
            ])
        ```

        ## organizations.IAMBinding

        > **Note:** If `role` is set to `roles/owner` and you don't specify a user or service account you have access to in `members`, you can lock yourself out of your organization.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMBinding("organization",
            org_id="1234567890",
            role="roles/editor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IAMMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IAMMember("organization",
            org_id="1234567890",
            role="roles/editor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## organizations.IamAuditConfig

        ```python
        import pulumi
        import pulumi_gcp as gcp

        organization = gcp.organizations.IamAuditConfig("organization",
            org_id="1234567890",
            service="allServices",
            audit_log_configs=[
                {
                    "log_type": "ADMIN_READ",
                },
                {
                    "log_type": "DATA_READ",
                    "exempted_members": ["user:joebloggs@example.com"],
                },
            ])
        ```

        ## Import

        ### Importing Audit Configs

        An audit config can be imported into a `google_organization_iam_audit_config` resource using the resource's `org_id` and the `service`, e.g:

        * `"{{org_id}} foo.googleapis.com"`

        An `import` block (Terraform v1.5.0 and later) can be used to import audit configs:

        tf

        import {

          id = "{{org_id}} foo.googleapis.com"

          to = google_organization_iam_audit_config.default

        }

        The `pulumi import` command can also be used:

        ```sh
        $ pulumi import gcp:organizations/iAMMember:IAMMember default "{{org_id}} foo.googleapis.com"
        ```

        :param str resource_name: The name of the resource.
        :param IAMMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IAMMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['IAMMemberConditionArgs', 'IAMMemberConditionArgsDict']]] = None,
                 member: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IAMMemberArgs.__new__(IAMMemberArgs)

            __props__.__dict__["condition"] = condition
            if member is None and not opts.urn:
                raise TypeError("Missing required property 'member'")
            __props__.__dict__["member"] = member
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["etag"] = None
        super(IAMMember, __self__).__init__(
            'gcp:organizations/iAMMember:IAMMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[Union['IAMMemberConditionArgs', 'IAMMemberConditionArgsDict']]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            member: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None) -> 'IAMMember':
        """
        Get an existing IAMMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IAMMemberConditionArgs', 'IAMMemberConditionArgsDict']] condition: An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: (Computed) The etag of the organization's IAM policy.
        :param pulumi.Input[builtins.str] member: Identities that will be granted the privilege in `role`.
               Each entry can have one of the following values:
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[builtins.str] org_id: The organization id of the target organization.
        :param pulumi.Input[builtins.str] role: The role that should be applied. Only one
               `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
               `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IAMMemberState.__new__(_IAMMemberState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["etag"] = etag
        __props__.__dict__["member"] = member
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["role"] = role
        return IAMMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.IAMMemberCondition']]:
        """
        An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        (Computed) The etag of the organization's IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[builtins.str]:
        """
        Identities that will be granted the privilege in `role`.
        Each entry can have one of the following values:
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization id of the target organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The role that should be applied. Only one
        `organizations.IAMBinding` can be used per role. Note that custom roles must be of the format
        `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        return pulumi.get(self, "role")

