# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 capacity_gib: pulumi.Input[builtins.str],
                 instance_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] capacity_gib: Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        :param pulumi.Input[builtins.str] instance_id: The logical name of the Parallelstore instance in the user project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the customer project/ location
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] deployment_type: Parallelstore Instance deployment type.
               Possible values:
               DEPLOYMENT_TYPE_UNSPECIFIED
               SCRATCH
               PERSISTENT
        :param pulumi.Input[builtins.str] description: The description of the instance. 2048 characters or less.
        :param pulumi.Input[builtins.str] directory_stripe_level: Stripe level for directories.
               MIN when directory has a small number of files.
               MAX when directory has a large number of files.
               Possible values:
               DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
               DIRECTORY_STRIPE_LEVEL_MIN
               DIRECTORY_STRIPE_LEVEL_BALANCED
               DIRECTORY_STRIPE_LEVEL_MAX
        :param pulumi.Input[builtins.str] file_stripe_level: Stripe level for files.
               MIN better suited for small size files.
               MAX higher throughput performance for larger files.
               Possible values:
               FILE_STRIPE_LEVEL_UNSPECIFIED
               FILE_STRIPE_LEVEL_MIN
               FILE_STRIPE_LEVEL_BALANCED
               FILE_STRIPE_LEVEL_MAX
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Cloud Labels are a flexible and lightweight mechanism for
               organizing cloud resources into groups that reflect a customer's organizational
               needs and deployment strategies. Cloud Labels can be used to filter collections
               of resources. They can be used to control how resource metrics are aggregated.
               And they can be used as arguments to policy management rules (e.g. route, firewall,
               load balancing, etc.).
               * Label keys must be between 1 and 63 characters long and must conform to
               the following regular expression: `a-z{0,62}`.
               * Label values must be between 0 and 63 characters long and must conform
               to the regular expression `[a-z0-9_-]{0,63}`.
               * No more than 64 labels can be associated with a given resource.
               See https://goo.gl/xmQnxf for more information on and examples of labels.
               If you plan to use labels in your own code, please note that additional
               characters may be allowed in the future. Therefore, you are advised to use
               an internal label representation, such as JSON, which doesn't rely upon
               specific characters being disallowed.  For example, representing labels
               as the string:  `name + "_" + value` would prove problematic if we were to
               allow `"_"` in a future release. "
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] network: Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
               to which the instance is connected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] reserved_ip_range: Immutable. Contains the id of the allocated IP address range
               associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
               be considered.
        """
        pulumi.set(__self__, "capacity_gib", capacity_gib)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_stripe_level is not None:
            pulumi.set(__self__, "directory_stripe_level", directory_stripe_level)
        if file_stripe_level is not None:
            pulumi.set(__self__, "file_stripe_level", file_stripe_level)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The logical name of the Parallelstore instance in the user project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the customer project/ location
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Parallelstore Instance deployment type.
        Possible values:
        DEPLOYMENT_TYPE_UNSPECIFIED
        SCRATCH
        PERSISTENT
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the instance. 2048 characters or less.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directoryStripeLevel")
    def directory_stripe_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stripe level for directories.
        MIN when directory has a small number of files.
        MAX when directory has a large number of files.
        Possible values:
        DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
        DIRECTORY_STRIPE_LEVEL_MIN
        DIRECTORY_STRIPE_LEVEL_BALANCED
        DIRECTORY_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "directory_stripe_level")

    @directory_stripe_level.setter
    def directory_stripe_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_stripe_level", value)

    @property
    @pulumi.getter(name="fileStripeLevel")
    def file_stripe_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stripe level for files.
        MIN better suited for small size files.
        MAX higher throughput performance for larger files.
        Possible values:
        FILE_STRIPE_LEVEL_UNSPECIFIED
        FILE_STRIPE_LEVEL_MIN
        FILE_STRIPE_LEVEL_BALANCED
        FILE_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "file_stripe_level")

    @file_stripe_level.setter
    def file_stripe_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_stripe_level", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Cloud Labels are a flexible and lightweight mechanism for
        organizing cloud resources into groups that reflect a customer's organizational
        needs and deployment strategies. Cloud Labels can be used to filter collections
        of resources. They can be used to control how resource metrics are aggregated.
        And they can be used as arguments to policy management rules (e.g. route, firewall,
        load balancing, etc.).
        * Label keys must be between 1 and 63 characters long and must conform to
        the following regular expression: `a-z{0,62}`.
        * Label values must be between 0 and 63 characters long and must conform
        to the regular expression `[a-z0-9_-]{0,63}`.
        * No more than 64 labels can be associated with a given resource.
        See https://goo.gl/xmQnxf for more information on and examples of labels.
        If you plan to use labels in your own code, please note that additional
        characters may be allowed in the future. Therefore, you are advised to use
        an internal label representation, such as JSON, which doesn't rely upon
        specific characters being disallowed.  For example, representing labels
        as the string:  `name + "_" + value` would prove problematic if we were to
        allow `"_"` in a future release. "

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
        to which the instance is connected.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Contains the id of the allocated IP address range
        associated with the private service access connection for example, \\"test-default\\"
        associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
        be considered.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reserved_ip_range", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_points: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 daos_version: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 file_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] access_points: Output only. List of access_points.
               Contains a list of IPv4 addresses used for client side configuration.
        :param pulumi.Input[builtins.str] capacity_gib: Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        :param pulumi.Input[builtins.str] create_time: The time when the instance was created.
        :param pulumi.Input[builtins.str] daos_version: The version of DAOS software running in the instance.
        :param pulumi.Input[builtins.str] deployment_type: Parallelstore Instance deployment type.
               Possible values:
               DEPLOYMENT_TYPE_UNSPECIFIED
               SCRATCH
               PERSISTENT
        :param pulumi.Input[builtins.str] description: The description of the instance. 2048 characters or less.
        :param pulumi.Input[builtins.str] directory_stripe_level: Stripe level for directories.
               MIN when directory has a small number of files.
               MAX when directory has a large number of files.
               Possible values:
               DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
               DIRECTORY_STRIPE_LEVEL_MIN
               DIRECTORY_STRIPE_LEVEL_BALANCED
               DIRECTORY_STRIPE_LEVEL_MAX
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] effective_reserved_ip_range: Immutable. Contains the id of the allocated IP address
               range associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. This field is populated by the service
               and contains the value currently used by the service.
        :param pulumi.Input[builtins.str] file_stripe_level: Stripe level for files.
               MIN better suited for small size files.
               MAX higher throughput performance for larger files.
               Possible values:
               FILE_STRIPE_LEVEL_UNSPECIFIED
               FILE_STRIPE_LEVEL_MIN
               FILE_STRIPE_LEVEL_BALANCED
               FILE_STRIPE_LEVEL_MAX
        :param pulumi.Input[builtins.str] instance_id: The logical name of the Parallelstore instance in the user project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the customer project/ location
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Cloud Labels are a flexible and lightweight mechanism for
               organizing cloud resources into groups that reflect a customer's organizational
               needs and deployment strategies. Cloud Labels can be used to filter collections
               of resources. They can be used to control how resource metrics are aggregated.
               And they can be used as arguments to policy management rules (e.g. route, firewall,
               load balancing, etc.).
               * Label keys must be between 1 and 63 characters long and must conform to
               the following regular expression: `a-z{0,62}`.
               * Label values must be between 0 and 63 characters long and must conform
               to the regular expression `[a-z0-9_-]{0,63}`.
               * No more than 64 labels can be associated with a given resource.
               See https://goo.gl/xmQnxf for more information on and examples of labels.
               If you plan to use labels in your own code, please note that additional
               characters may be allowed in the future. Therefore, you are advised to use
               an internal label representation, such as JSON, which doesn't rely upon
               specific characters being disallowed.  For example, representing labels
               as the string:  `name + "_" + value` would prove problematic if we were to
               allow `"_"` in a future release. "
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the instance, in the format
               `projects/{project}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[builtins.str] network: Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
               to which the instance is connected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] reserved_ip_range: Immutable. Contains the id of the allocated IP address range
               associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
               be considered.
        :param pulumi.Input[builtins.str] state: The instance state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
               FAILED
               UPGRADING
        :param pulumi.Input[builtins.str] update_time: The time when the instance was updated.
        """
        if access_points is not None:
            pulumi.set(__self__, "access_points", access_points)
        if capacity_gib is not None:
            pulumi.set(__self__, "capacity_gib", capacity_gib)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if daos_version is not None:
            pulumi.set(__self__, "daos_version", daos_version)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_stripe_level is not None:
            pulumi.set(__self__, "directory_stripe_level", directory_stripe_level)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_reserved_ip_range is not None:
            pulumi.set(__self__, "effective_reserved_ip_range", effective_reserved_ip_range)
        if file_stripe_level is not None:
            pulumi.set(__self__, "file_stripe_level", file_stripe_level)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accessPoints")
    def access_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. List of access_points.
        Contains a list of IPv4 addresses used for client side configuration.
        """
        return pulumi.get(self, "access_points")

    @access_points.setter
    def access_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "access_points", value)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="daosVersion")
    def daos_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of DAOS software running in the instance.
        """
        return pulumi.get(self, "daos_version")

    @daos_version.setter
    def daos_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "daos_version", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Parallelstore Instance deployment type.
        Possible values:
        DEPLOYMENT_TYPE_UNSPECIFIED
        SCRATCH
        PERSISTENT
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the instance. 2048 characters or less.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directoryStripeLevel")
    def directory_stripe_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stripe level for directories.
        MIN when directory has a small number of files.
        MAX when directory has a large number of files.
        Possible values:
        DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
        DIRECTORY_STRIPE_LEVEL_MIN
        DIRECTORY_STRIPE_LEVEL_BALANCED
        DIRECTORY_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "directory_stripe_level")

    @directory_stripe_level.setter
    def directory_stripe_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_stripe_level", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="effectiveReservedIpRange")
    def effective_reserved_ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Contains the id of the allocated IP address
        range associated with the private service access connection for example, \\"test-default\\"
        associated with IP range 10.0.0.0/29. This field is populated by the service
        and contains the value currently used by the service.
        """
        return pulumi.get(self, "effective_reserved_ip_range")

    @effective_reserved_ip_range.setter
    def effective_reserved_ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effective_reserved_ip_range", value)

    @property
    @pulumi.getter(name="fileStripeLevel")
    def file_stripe_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stripe level for files.
        MIN better suited for small size files.
        MAX higher throughput performance for larger files.
        Possible values:
        FILE_STRIPE_LEVEL_UNSPECIFIED
        FILE_STRIPE_LEVEL_MIN
        FILE_STRIPE_LEVEL_BALANCED
        FILE_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "file_stripe_level")

    @file_stripe_level.setter
    def file_stripe_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_stripe_level", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The logical name of the Parallelstore instance in the user project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the customer project/ location
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Cloud Labels are a flexible and lightweight mechanism for
        organizing cloud resources into groups that reflect a customer's organizational
        needs and deployment strategies. Cloud Labels can be used to filter collections
        of resources. They can be used to control how resource metrics are aggregated.
        And they can be used as arguments to policy management rules (e.g. route, firewall,
        load balancing, etc.).
        * Label keys must be between 1 and 63 characters long and must conform to
        the following regular expression: `a-z{0,62}`.
        * Label values must be between 0 and 63 characters long and must conform
        to the regular expression `[a-z0-9_-]{0,63}`.
        * No more than 64 labels can be associated with a given resource.
        See https://goo.gl/xmQnxf for more information on and examples of labels.
        If you plan to use labels in your own code, please note that additional
        characters may be allowed in the future. Therefore, you are advised to use
        an internal label representation, such as JSON, which doesn't rely upon
        specific characters being disallowed.  For example, representing labels
        as the string:  `name + "_" + value` would prove problematic if we were to
        allow `"_"` in a future release. "

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the instance, in the format
        `projects/{project}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
        to which the instance is connected.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Contains the id of the allocated IP address range
        associated with the private service access connection for example, \\"test-default\\"
        associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
        be considered.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        FAILED
        UPGRADING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:parallelstore/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Parallelstore Instance.

        ## Example Usage

        ### Parallelstore Instance Basic Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=True,
            mtu=8896)
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=24,
            network=network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        instance = gcp.parallelstore.Instance("instance",
            instance_id="instance",
            location="us-central1-a",
            description="test instance",
            capacity_gib="12000",
            network=network.name,
            file_stripe_level="FILE_STRIPE_LEVEL_MIN",
            directory_stripe_level="DIRECTORY_STRIPE_LEVEL_MIN",
            deployment_type="SCRATCH",
            labels={
                "test": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Parallelstore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=True,
            mtu=8896)
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=24,
            network=network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        instance = gcp.parallelstore.Instance("instance",
            instance_id="instance",
            location="us-central1-a",
            description="test instance",
            capacity_gib="12000",
            network=network.name,
            file_stripe_level="FILE_STRIPE_LEVEL_MIN",
            directory_stripe_level="DIRECTORY_STRIPE_LEVEL_MIN",
            deployment_type="SCRATCH",
            labels={
                "test": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity_gib: Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        :param pulumi.Input[builtins.str] deployment_type: Parallelstore Instance deployment type.
               Possible values:
               DEPLOYMENT_TYPE_UNSPECIFIED
               SCRATCH
               PERSISTENT
        :param pulumi.Input[builtins.str] description: The description of the instance. 2048 characters or less.
        :param pulumi.Input[builtins.str] directory_stripe_level: Stripe level for directories.
               MIN when directory has a small number of files.
               MAX when directory has a large number of files.
               Possible values:
               DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
               DIRECTORY_STRIPE_LEVEL_MIN
               DIRECTORY_STRIPE_LEVEL_BALANCED
               DIRECTORY_STRIPE_LEVEL_MAX
        :param pulumi.Input[builtins.str] file_stripe_level: Stripe level for files.
               MIN better suited for small size files.
               MAX higher throughput performance for larger files.
               Possible values:
               FILE_STRIPE_LEVEL_UNSPECIFIED
               FILE_STRIPE_LEVEL_MIN
               FILE_STRIPE_LEVEL_BALANCED
               FILE_STRIPE_LEVEL_MAX
        :param pulumi.Input[builtins.str] instance_id: The logical name of the Parallelstore instance in the user project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the customer project/ location
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Cloud Labels are a flexible and lightweight mechanism for
               organizing cloud resources into groups that reflect a customer's organizational
               needs and deployment strategies. Cloud Labels can be used to filter collections
               of resources. They can be used to control how resource metrics are aggregated.
               And they can be used as arguments to policy management rules (e.g. route, firewall,
               load balancing, etc.).
               * Label keys must be between 1 and 63 characters long and must conform to
               the following regular expression: `a-z{0,62}`.
               * Label values must be between 0 and 63 characters long and must conform
               to the regular expression `[a-z0-9_-]{0,63}`.
               * No more than 64 labels can be associated with a given resource.
               See https://goo.gl/xmQnxf for more information on and examples of labels.
               If you plan to use labels in your own code, please note that additional
               characters may be allowed in the future. Therefore, you are advised to use
               an internal label representation, such as JSON, which doesn't rely upon
               specific characters being disallowed.  For example, representing labels
               as the string:  `name + "_" + value` would prove problematic if we were to
               allow `"_"` in a future release. "
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] network: Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
               to which the instance is connected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] reserved_ip_range: Immutable. Contains the id of the allocated IP address range
               associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
               be considered.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Parallelstore Instance.

        ## Example Usage

        ### Parallelstore Instance Basic Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=True,
            mtu=8896)
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=24,
            network=network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        instance = gcp.parallelstore.Instance("instance",
            instance_id="instance",
            location="us-central1-a",
            description="test instance",
            capacity_gib="12000",
            network=network.name,
            file_stripe_level="FILE_STRIPE_LEVEL_MIN",
            directory_stripe_level="DIRECTORY_STRIPE_LEVEL_MIN",
            deployment_type="SCRATCH",
            labels={
                "test": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Parallelstore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=True,
            mtu=8896)
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=24,
            network=network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        instance = gcp.parallelstore.Instance("instance",
            instance_id="instance",
            location="us-central1-a",
            description="test instance",
            capacity_gib="12000",
            network=network.name,
            file_stripe_level="FILE_STRIPE_LEVEL_MIN",
            directory_stripe_level="DIRECTORY_STRIPE_LEVEL_MIN",
            deployment_type="SCRATCH",
            labels={
                "test": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:parallelstore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if capacity_gib is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_gib'")
            __props__.__dict__["capacity_gib"] = capacity_gib
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["description"] = description
            __props__.__dict__["directory_stripe_level"] = directory_stripe_level
            __props__.__dict__["file_stripe_level"] = file_stripe_level
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["reserved_ip_range"] = reserved_ip_range
            __props__.__dict__["access_points"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["daos_version"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["effective_reserved_ip_range"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:parallelstore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_points: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            daos_version: Optional[pulumi.Input[builtins.str]] = None,
            deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            directory_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
            file_stripe_level: Optional[pulumi.Input[builtins.str]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] access_points: Output only. List of access_points.
               Contains a list of IPv4 addresses used for client side configuration.
        :param pulumi.Input[builtins.str] capacity_gib: Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        :param pulumi.Input[builtins.str] create_time: The time when the instance was created.
        :param pulumi.Input[builtins.str] daos_version: The version of DAOS software running in the instance.
        :param pulumi.Input[builtins.str] deployment_type: Parallelstore Instance deployment type.
               Possible values:
               DEPLOYMENT_TYPE_UNSPECIFIED
               SCRATCH
               PERSISTENT
        :param pulumi.Input[builtins.str] description: The description of the instance. 2048 characters or less.
        :param pulumi.Input[builtins.str] directory_stripe_level: Stripe level for directories.
               MIN when directory has a small number of files.
               MAX when directory has a large number of files.
               Possible values:
               DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
               DIRECTORY_STRIPE_LEVEL_MIN
               DIRECTORY_STRIPE_LEVEL_BALANCED
               DIRECTORY_STRIPE_LEVEL_MAX
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] effective_reserved_ip_range: Immutable. Contains the id of the allocated IP address
               range associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. This field is populated by the service
               and contains the value currently used by the service.
        :param pulumi.Input[builtins.str] file_stripe_level: Stripe level for files.
               MIN better suited for small size files.
               MAX higher throughput performance for larger files.
               Possible values:
               FILE_STRIPE_LEVEL_UNSPECIFIED
               FILE_STRIPE_LEVEL_MIN
               FILE_STRIPE_LEVEL_BALANCED
               FILE_STRIPE_LEVEL_MAX
        :param pulumi.Input[builtins.str] instance_id: The logical name of the Parallelstore instance in the user project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the customer project/ location
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Cloud Labels are a flexible and lightweight mechanism for
               organizing cloud resources into groups that reflect a customer's organizational
               needs and deployment strategies. Cloud Labels can be used to filter collections
               of resources. They can be used to control how resource metrics are aggregated.
               And they can be used as arguments to policy management rules (e.g. route, firewall,
               load balancing, etc.).
               * Label keys must be between 1 and 63 characters long and must conform to
               the following regular expression: `a-z{0,62}`.
               * Label values must be between 0 and 63 characters long and must conform
               to the regular expression `[a-z0-9_-]{0,63}`.
               * No more than 64 labels can be associated with a given resource.
               See https://goo.gl/xmQnxf for more information on and examples of labels.
               If you plan to use labels in your own code, please note that additional
               characters may be allowed in the future. Therefore, you are advised to use
               an internal label representation, such as JSON, which doesn't rely upon
               specific characters being disallowed.  For example, representing labels
               as the string:  `name + "_" + value` would prove problematic if we were to
               allow `"_"` in a future release. "
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the instance, in the format
               `projects/{project}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[builtins.str] network: Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
               to which the instance is connected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] reserved_ip_range: Immutable. Contains the id of the allocated IP address range
               associated with the private service access connection for example, \\"test-default\\"
               associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
               be considered.
        :param pulumi.Input[builtins.str] state: The instance state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
               FAILED
               UPGRADING
        :param pulumi.Input[builtins.str] update_time: The time when the instance was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_points"] = access_points
        __props__.__dict__["capacity_gib"] = capacity_gib
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["daos_version"] = daos_version
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["description"] = description
        __props__.__dict__["directory_stripe_level"] = directory_stripe_level
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_reserved_ip_range"] = effective_reserved_ip_range
        __props__.__dict__["file_stripe_level"] = file_stripe_level
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reserved_ip_range"] = reserved_ip_range
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPoints")
    def access_points(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. List of access_points.
        Contains a list of IPv4 addresses used for client side configuration.
        """
        return pulumi.get(self, "access_points")

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Output[builtins.str]:
        """
        Required. Immutable. Storage capacity of Parallelstore instance in Gibibytes (GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="daosVersion")
    def daos_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of DAOS software running in the instance.
        """
        return pulumi.get(self, "daos_version")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Parallelstore Instance deployment type.
        Possible values:
        DEPLOYMENT_TYPE_UNSPECIFIED
        SCRATCH
        PERSISTENT
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the instance. 2048 characters or less.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryStripeLevel")
    def directory_stripe_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Stripe level for directories.
        MIN when directory has a small number of files.
        MAX when directory has a large number of files.
        Possible values:
        DIRECTORY_STRIPE_LEVEL_UNSPECIFIED
        DIRECTORY_STRIPE_LEVEL_MIN
        DIRECTORY_STRIPE_LEVEL_BALANCED
        DIRECTORY_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "directory_stripe_level")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="effectiveReservedIpRange")
    def effective_reserved_ip_range(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. Contains the id of the allocated IP address
        range associated with the private service access connection for example, \\"test-default\\"
        associated with IP range 10.0.0.0/29. This field is populated by the service
        and contains the value currently used by the service.
        """
        return pulumi.get(self, "effective_reserved_ip_range")

    @property
    @pulumi.getter(name="fileStripeLevel")
    def file_stripe_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Stripe level for files.
        MIN better suited for small size files.
        MAX higher throughput performance for larger files.
        Possible values:
        FILE_STRIPE_LEVEL_UNSPECIFIED
        FILE_STRIPE_LEVEL_MIN
        FILE_STRIPE_LEVEL_BALANCED
        FILE_STRIPE_LEVEL_MAX
        """
        return pulumi.get(self, "file_stripe_level")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The logical name of the Parallelstore instance in the user project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the customer project/ location
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Cloud Labels are a flexible and lightweight mechanism for
        organizing cloud resources into groups that reflect a customer's organizational
        needs and deployment strategies. Cloud Labels can be used to filter collections
        of resources. They can be used to control how resource metrics are aggregated.
        And they can be used as arguments to policy management rules (e.g. route, firewall,
        load balancing, etc.).
        * Label keys must be between 1 and 63 characters long and must conform to
        the following regular expression: `a-z{0,62}`.
        * Label values must be between 0 and 63 characters long and must conform
        to the regular expression `[a-z0-9_-]{0,63}`.
        * No more than 64 labels can be associated with a given resource.
        See https://goo.gl/xmQnxf for more information on and examples of labels.
        If you plan to use labels in your own code, please note that additional
        characters may be allowed in the future. Therefore, you are advised to use
        an internal label representation, such as JSON, which doesn't rely upon
        specific characters being disallowed.  For example, representing labels
        as the string:  `name + "_" + value` would prove problematic if we were to
        allow `"_"` in a future release. "

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the instance, in the format
        `projects/{project}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. The name of the Google Compute Engine [VPC network](https://cloud.google.com/vpc/docs/vpc)
        to which the instance is connected.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. Contains the id of the allocated IP address range
        associated with the private service access connection for example, \\"test-default\\"
        associated with IP range 10.0.0.0/29. If no range id is provided all ranges will
        be considered.
        """
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The instance state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        FAILED
        UPGRADING
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

