# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegionalParameterResult',
    'AwaitableGetRegionalParameterResult',
    'get_regional_parameter',
    'get_regional_parameter_output',
]

@pulumi.output_type
class GetRegionalParameterResult:
    """
    A collection of values returned by getRegionalParameter.
    """
    def __init__(__self__, create_time=None, effective_labels=None, format=None, id=None, kms_key=None, labels=None, location=None, name=None, parameter_id=None, policy_members=None, project=None, pulumi_labels=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key and not isinstance(kms_key, str):
            raise TypeError("Expected argument 'kms_key' to be a str")
        pulumi.set(__self__, "kms_key", kms_key)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameter_id and not isinstance(parameter_id, str):
            raise TypeError("Expected argument 'parameter_id' to be a str")
        pulumi.set(__self__, "parameter_id", parameter_id)
        if policy_members and not isinstance(policy_members, list):
            raise TypeError("Expected argument 'policy_members' to be a list")
        pulumi.set(__self__, "policy_members", policy_members)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> builtins.str:
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> builtins.str:
        return pulumi.get(self, "parameter_id")

    @property
    @pulumi.getter(name="policyMembers")
    def policy_members(self) -> Sequence['outputs.GetRegionalParameterPolicyMemberResult']:
        return pulumi.get(self, "policy_members")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetRegionalParameterResult(GetRegionalParameterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalParameterResult(
            create_time=self.create_time,
            effective_labels=self.effective_labels,
            format=self.format,
            id=self.id,
            kms_key=self.kms_key,
            labels=self.labels,
            location=self.location,
            name=self.name,
            parameter_id=self.parameter_id,
            policy_members=self.policy_members,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            update_time=self.update_time)


def get_regional_parameter(location: Optional[builtins.str] = None,
                           parameter_id: Optional[builtins.str] = None,
                           project: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalParameterResult:
    """
    Use this data source to get information about a Parameter Manager Regional Parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    reg_parameter_datasource = gcp.parametermanager.get_regional_parameter(parameter_id="foobar",
        location="us-central1")
    ```


    :param builtins.str location: The location of the regional parameter. eg us-central1
    :param builtins.str parameter_id: The name of the regional parameter.
    :param builtins.str project: The ID of the project in which the resource belongs.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameterId'] = parameter_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:parametermanager/getRegionalParameter:getRegionalParameter', __args__, opts=opts, typ=GetRegionalParameterResult).value

    return AwaitableGetRegionalParameterResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        format=pulumi.get(__ret__, 'format'),
        id=pulumi.get(__ret__, 'id'),
        kms_key=pulumi.get(__ret__, 'kms_key'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        parameter_id=pulumi.get(__ret__, 'parameter_id'),
        policy_members=pulumi.get(__ret__, 'policy_members'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_regional_parameter_output(location: Optional[pulumi.Input[builtins.str]] = None,
                                  parameter_id: Optional[pulumi.Input[builtins.str]] = None,
                                  project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalParameterResult]:
    """
    Use this data source to get information about a Parameter Manager Regional Parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    reg_parameter_datasource = gcp.parametermanager.get_regional_parameter(parameter_id="foobar",
        location="us-central1")
    ```


    :param builtins.str location: The location of the regional parameter. eg us-central1
    :param builtins.str parameter_id: The name of the regional parameter.
    :param builtins.str project: The ID of the project in which the resource belongs.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameterId'] = parameter_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:parametermanager/getRegionalParameter:getRegionalParameter', __args__, opts=opts, typ=GetRegionalParameterResult)
    return __ret__.apply(lambda __response__: GetRegionalParameterResult(
        create_time=pulumi.get(__response__, 'create_time'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        format=pulumi.get(__response__, 'format'),
        id=pulumi.get(__response__, 'id'),
        kms_key=pulumi.get(__response__, 'kms_key'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        parameter_id=pulumi.get(__response__, 'parameter_id'),
        policy_members=pulumi.get(__response__, 'policy_members'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        update_time=pulumi.get(__response__, 'update_time')))
