# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ParameterArgs', 'Parameter']

@pulumi.input_type
class ParameterArgs:
    def __init__(__self__, *,
                 parameter_id: pulumi.Input[builtins.str],
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Parameter resource.
        :param pulumi.Input[builtins.str] parameter_id: This must be unique within the project.
        :param pulumi.Input[builtins.str] format: The format type of the parameter resource.
               Default value is `UNFORMATTED`.
               Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        :param pulumi.Input[builtins.str] kms_key: The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
               `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this Parameter.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "parameter_id", parameter_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> pulumi.Input[builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "parameter_id")

    @parameter_id.setter
    def parameter_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format type of the parameter resource.
        Default value is `UNFORMATTED`.
        Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
        `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels assigned to this Parameter.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ParameterState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_members: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterPolicyMemberArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Parameter resources.
        :param pulumi.Input[builtins.str] create_time: The time at which the Parameter was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] format: The format type of the parameter resource.
               Default value is `UNFORMATTED`.
               Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        :param pulumi.Input[builtins.str] kms_key: The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
               `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this Parameter.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Parameter. Format:
               `projects/{{project}}/locations/global/parameters/{{parameter_id}}`
        :param pulumi.Input[builtins.str] parameter_id: This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterPolicyMemberArgs']]] policy_members: Policy member strings of a Google Cloud resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: The time at which the Parameter was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_id is not None:
            pulumi.set(__self__, "parameter_id", parameter_id)
        if policy_members is not None:
            pulumi.set(__self__, "policy_members", policy_members)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Parameter was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format type of the parameter resource.
        Default value is `UNFORMATTED`.
        Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
        `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels assigned to this Parameter.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Parameter. Format:
        `projects/{{project}}/locations/global/parameters/{{parameter_id}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "parameter_id")

    @parameter_id.setter
    def parameter_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_id", value)

    @property
    @pulumi.getter(name="policyMembers")
    def policy_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterPolicyMemberArgs']]]]:
        """
        Policy member strings of a Google Cloud resource.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_members")

    @policy_members.setter
    def policy_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterPolicyMemberArgs']]]]):
        pulumi.set(self, "policy_members", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Parameter was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:parametermanager/parameter:Parameter")
class Parameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 parameter_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Parameter resource is a logical parameter.

        To get more information about Parameter, see:

        * [API documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters)

        ## Example Usage

        ### Parameter Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_basic = gcp.parametermanager.Parameter("parameter-basic", parameter_id="parameter")
        ```
        ### Parameter With Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_with_format = gcp.parametermanager.Parameter("parameter-with-format",
            parameter_id="parameter",
            format="JSON")
        ```
        ### Parameter With Labels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_with_labels = gcp.parametermanager.Parameter("parameter-with-labels",
            parameter_id="parameter",
            labels={
                "key1": "val1",
                "key2": "val2",
                "key3": "val3",
                "key4": "val4",
                "key5": "val5",
            })
        ```
        ### Parameter With Kms Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        parameter_with_kms_key = gcp.parametermanager.Parameter("parameter-with-kms-key",
            parameter_id="parameter",
            kms_key="kms-key")
        ```

        ## Import

        Parameter can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/parameters/{{parameter_id}}`

        * `{{project}}/{{parameter_id}}`

        * `{{parameter_id}}`

        When using the `pulumi import` command, Parameter can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default projects/{{project}}/locations/global/parameters/{{parameter_id}}
        ```

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default {{project}}/{{parameter_id}}
        ```

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default {{parameter_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] format: The format type of the parameter resource.
               Default value is `UNFORMATTED`.
               Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        :param pulumi.Input[builtins.str] kms_key: The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
               `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this Parameter.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] parameter_id: This must be unique within the project.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Parameter resource is a logical parameter.

        To get more information about Parameter, see:

        * [API documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters)

        ## Example Usage

        ### Parameter Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_basic = gcp.parametermanager.Parameter("parameter-basic", parameter_id="parameter")
        ```
        ### Parameter With Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_with_format = gcp.parametermanager.Parameter("parameter-with-format",
            parameter_id="parameter",
            format="JSON")
        ```
        ### Parameter With Labels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parameter_with_labels = gcp.parametermanager.Parameter("parameter-with-labels",
            parameter_id="parameter",
            labels={
                "key1": "val1",
                "key2": "val2",
                "key3": "val3",
                "key4": "val4",
                "key5": "val5",
            })
        ```
        ### Parameter With Kms Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        parameter_with_kms_key = gcp.parametermanager.Parameter("parameter-with-kms-key",
            parameter_id="parameter",
            kms_key="kms-key")
        ```

        ## Import

        Parameter can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/parameters/{{parameter_id}}`

        * `{{project}}/{{parameter_id}}`

        * `{{parameter_id}}`

        When using the `pulumi import` command, Parameter can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default projects/{{project}}/locations/global/parameters/{{parameter_id}}
        ```

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default {{project}}/{{parameter_id}}
        ```

        ```sh
        $ pulumi import gcp:parametermanager/parameter:Parameter default {{parameter_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 parameter_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ParameterArgs.__new__(ParameterArgs)

            __props__.__dict__["format"] = format
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["labels"] = labels
            if parameter_id is None and not opts.urn:
                raise TypeError("Missing required property 'parameter_id'")
            __props__.__dict__["parameter_id"] = parameter_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["policy_members"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Parameter, __self__).__init__(
            'gcp:parametermanager/parameter:Parameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            format: Optional[pulumi.Input[builtins.str]] = None,
            kms_key: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parameter_id: Optional[pulumi.Input[builtins.str]] = None,
            policy_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ParameterPolicyMemberArgs', 'ParameterPolicyMemberArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Parameter':
        """
        Get an existing Parameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time at which the Parameter was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] format: The format type of the parameter resource.
               Default value is `UNFORMATTED`.
               Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        :param pulumi.Input[builtins.str] kms_key: The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
               `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this Parameter.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Parameter. Format:
               `projects/{{project}}/locations/global/parameters/{{parameter_id}}`
        :param pulumi.Input[builtins.str] parameter_id: This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ParameterPolicyMemberArgs', 'ParameterPolicyMemberArgsDict']]]] policy_members: Policy member strings of a Google Cloud resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: The time at which the Parameter was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ParameterState.__new__(_ParameterState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["format"] = format
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter_id"] = parameter_id
        __props__.__dict__["policy_members"] = policy_members
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return Parameter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Parameter was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The format type of the parameter resource.
        Default value is `UNFORMATTED`.
        Possible values are: `UNFORMATTED`, `YAML`, `JSON`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt parameter version payload. Format
        `projects/{{project}}/locations/global/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}`
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels assigned to this Parameter.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the Parameter. Format:
        `projects/{{project}}/locations/global/parameters/{{parameter_id}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> pulumi.Output[builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "parameter_id")

    @property
    @pulumi.getter(name="policyMembers")
    def policy_members(self) -> pulumi.Output[Sequence['outputs.ParameterPolicyMember']]:
        """
        Policy member strings of a Google Cloud resource.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_members")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Parameter was updated.
        """
        return pulumi.get(self, "update_time")

