# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EntitlementAdditionalNotificationTargets',
    'EntitlementApprovalWorkflow',
    'EntitlementApprovalWorkflowManualApprovals',
    'EntitlementApprovalWorkflowManualApprovalsStep',
    'EntitlementApprovalWorkflowManualApprovalsStepApprovers',
    'EntitlementEligibleUser',
    'EntitlementPrivilegedAccess',
    'EntitlementPrivilegedAccessGcpIamAccess',
    'EntitlementPrivilegedAccessGcpIamAccessRoleBinding',
    'EntitlementRequesterJustificationConfig',
    'EntitlementRequesterJustificationConfigNotMandatory',
    'EntitlementRequesterJustificationConfigUnstructured',
    'GetEntitlementAdditionalNotificationTargetResult',
    'GetEntitlementApprovalWorkflowResult',
    'GetEntitlementApprovalWorkflowManualApprovalResult',
    'GetEntitlementApprovalWorkflowManualApprovalStepResult',
    'GetEntitlementApprovalWorkflowManualApprovalStepApproverResult',
    'GetEntitlementEligibleUserResult',
    'GetEntitlementPrivilegedAccessResult',
    'GetEntitlementPrivilegedAccessGcpIamAccessResult',
    'GetEntitlementPrivilegedAccessGcpIamAccessRoleBindingResult',
    'GetEntitlementRequesterJustificationConfigResult',
    'GetEntitlementRequesterJustificationConfigNotMandatoryResult',
    'GetEntitlementRequesterJustificationConfigUnstructuredResult',
]

@pulumi.output_type
class EntitlementAdditionalNotificationTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminEmailRecipients":
            suggest = "admin_email_recipients"
        elif key == "requesterEmailRecipients":
            suggest = "requester_email_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementAdditionalNotificationTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementAdditionalNotificationTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementAdditionalNotificationTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_email_recipients: Optional[Sequence[builtins.str]] = None,
                 requester_email_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] admin_email_recipients: Optional. Additional email addresses to be notified when a principal(requester) is granted access.
        :param Sequence[builtins.str] requester_email_recipients: Optional. Additional email address to be notified about an eligible entitlement.
        """
        if admin_email_recipients is not None:
            pulumi.set(__self__, "admin_email_recipients", admin_email_recipients)
        if requester_email_recipients is not None:
            pulumi.set(__self__, "requester_email_recipients", requester_email_recipients)

    @property
    @pulumi.getter(name="adminEmailRecipients")
    def admin_email_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        Optional. Additional email addresses to be notified when a principal(requester) is granted access.
        """
        return pulumi.get(self, "admin_email_recipients")

    @property
    @pulumi.getter(name="requesterEmailRecipients")
    def requester_email_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        Optional. Additional email address to be notified about an eligible entitlement.
        """
        return pulumi.get(self, "requester_email_recipients")


@pulumi.output_type
class EntitlementApprovalWorkflow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manualApprovals":
            suggest = "manual_approvals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementApprovalWorkflow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementApprovalWorkflow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementApprovalWorkflow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manual_approvals: 'outputs.EntitlementApprovalWorkflowManualApprovals'):
        """
        :param 'EntitlementApprovalWorkflowManualApprovalsArgs' manual_approvals: A manual approval workflow where users who are designated as approvers need to call the ApproveGrant/DenyGrant APIs for an Grant.
               The workflow can consist of multiple serial steps where each step defines who can act as Approver in that step and how many of those users should approve before the workflow moves to the next step.
               This can be used to create approval workflows such as
               * Require an approval from any user in a group G.
               * Require an approval from any k number of users from a Group G.
               * Require an approval from any user in a group G and then from a user U. etc.
               A single user might be part of `approvers` ACL for multiple steps in this workflow but they can only approve once and that approval will only be considered to satisfy the approval step at which it was granted.
               Structure is documented below.
        """
        pulumi.set(__self__, "manual_approvals", manual_approvals)

    @property
    @pulumi.getter(name="manualApprovals")
    def manual_approvals(self) -> 'outputs.EntitlementApprovalWorkflowManualApprovals':
        """
        A manual approval workflow where users who are designated as approvers need to call the ApproveGrant/DenyGrant APIs for an Grant.
        The workflow can consist of multiple serial steps where each step defines who can act as Approver in that step and how many of those users should approve before the workflow moves to the next step.
        This can be used to create approval workflows such as
        * Require an approval from any user in a group G.
        * Require an approval from any k number of users from a Group G.
        * Require an approval from any user in a group G and then from a user U. etc.
        A single user might be part of `approvers` ACL for multiple steps in this workflow but they can only approve once and that approval will only be considered to satisfy the approval step at which it was granted.
        Structure is documented below.
        """
        return pulumi.get(self, "manual_approvals")


@pulumi.output_type
class EntitlementApprovalWorkflowManualApprovals(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requireApproverJustification":
            suggest = "require_approver_justification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementApprovalWorkflowManualApprovals. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementApprovalWorkflowManualApprovals.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementApprovalWorkflowManualApprovals.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 steps: Sequence['outputs.EntitlementApprovalWorkflowManualApprovalsStep'],
                 require_approver_justification: Optional[builtins.bool] = None):
        """
        :param Sequence['EntitlementApprovalWorkflowManualApprovalsStepArgs'] steps: List of approval steps in this workflow. These steps would be followed in the specified order sequentially.  1 step is supported for now.
               Structure is documented below.
        :param builtins.bool require_approver_justification: Optional. Do the approvers need to provide a justification for their actions?
        """
        pulumi.set(__self__, "steps", steps)
        if require_approver_justification is not None:
            pulumi.set(__self__, "require_approver_justification", require_approver_justification)

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.EntitlementApprovalWorkflowManualApprovalsStep']:
        """
        List of approval steps in this workflow. These steps would be followed in the specified order sequentially.  1 step is supported for now.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="requireApproverJustification")
    def require_approver_justification(self) -> Optional[builtins.bool]:
        """
        Optional. Do the approvers need to provide a justification for their actions?
        """
        return pulumi.get(self, "require_approver_justification")


@pulumi.output_type
class EntitlementApprovalWorkflowManualApprovalsStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalsNeeded":
            suggest = "approvals_needed"
        elif key == "approverEmailRecipients":
            suggest = "approver_email_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementApprovalWorkflowManualApprovalsStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementApprovalWorkflowManualApprovalsStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementApprovalWorkflowManualApprovalsStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approvers: 'outputs.EntitlementApprovalWorkflowManualApprovalsStepApprovers',
                 approvals_needed: Optional[builtins.int] = None,
                 approver_email_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param 'EntitlementApprovalWorkflowManualApprovalsStepApproversArgs' approvers: The potential set of approvers in this step. This list should contain at only one entry.
               Structure is documented below.
        :param builtins.int approvals_needed: How many users from the above list need to approve.
               If there are not enough distinct users in the list above then the workflow
               will indefinitely block. Should always be greater than 0. Currently 1 is the only
               supported value.
        :param Sequence[builtins.str] approver_email_recipients: Optional. Additional email addresses to be notified when a grant is pending approval.
        """
        pulumi.set(__self__, "approvers", approvers)
        if approvals_needed is not None:
            pulumi.set(__self__, "approvals_needed", approvals_needed)
        if approver_email_recipients is not None:
            pulumi.set(__self__, "approver_email_recipients", approver_email_recipients)

    @property
    @pulumi.getter
    def approvers(self) -> 'outputs.EntitlementApprovalWorkflowManualApprovalsStepApprovers':
        """
        The potential set of approvers in this step. This list should contain at only one entry.
        Structure is documented below.
        """
        return pulumi.get(self, "approvers")

    @property
    @pulumi.getter(name="approvalsNeeded")
    def approvals_needed(self) -> Optional[builtins.int]:
        """
        How many users from the above list need to approve.
        If there are not enough distinct users in the list above then the workflow
        will indefinitely block. Should always be greater than 0. Currently 1 is the only
        supported value.
        """
        return pulumi.get(self, "approvals_needed")

    @property
    @pulumi.getter(name="approverEmailRecipients")
    def approver_email_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        Optional. Additional email addresses to be notified when a grant is pending approval.
        """
        return pulumi.get(self, "approver_email_recipients")


@pulumi.output_type
class EntitlementApprovalWorkflowManualApprovalsStepApprovers(dict):
    def __init__(__self__, *,
                 principals: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] principals: Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at: https://cloud.google.com/iam/docs/principal-identifiers#v1
        """
        pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter
    def principals(self) -> Sequence[builtins.str]:
        """
        Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at: https://cloud.google.com/iam/docs/principal-identifiers#v1
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class EntitlementEligibleUser(dict):
    def __init__(__self__, *,
                 principals: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] principals: Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at "https://cloud.google.com/iam/docs/principal-identifiers#v1"
        """
        pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter
    def principals(self) -> Sequence[builtins.str]:
        """
        Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at "https://cloud.google.com/iam/docs/principal-identifiers#v1"
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class EntitlementPrivilegedAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpIamAccess":
            suggest = "gcp_iam_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementPrivilegedAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementPrivilegedAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementPrivilegedAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_iam_access: 'outputs.EntitlementPrivilegedAccessGcpIamAccess'):
        """
        :param 'EntitlementPrivilegedAccessGcpIamAccessArgs' gcp_iam_access: GcpIamAccess represents IAM based access control on a GCP resource. Refer to https://cloud.google.com/iam/docs to understand more about IAM.
               Structure is documented below.
        """
        pulumi.set(__self__, "gcp_iam_access", gcp_iam_access)

    @property
    @pulumi.getter(name="gcpIamAccess")
    def gcp_iam_access(self) -> 'outputs.EntitlementPrivilegedAccessGcpIamAccess':
        """
        GcpIamAccess represents IAM based access control on a GCP resource. Refer to https://cloud.google.com/iam/docs to understand more about IAM.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_iam_access")


@pulumi.output_type
class EntitlementPrivilegedAccessGcpIamAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "roleBindings":
            suggest = "role_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementPrivilegedAccessGcpIamAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementPrivilegedAccessGcpIamAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementPrivilegedAccessGcpIamAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource: builtins.str,
                 resource_type: builtins.str,
                 role_bindings: Sequence['outputs.EntitlementPrivilegedAccessGcpIamAccessRoleBinding']):
        """
        :param builtins.str resource: Name of the resource.
        :param builtins.str resource_type: The type of this resource.
        :param Sequence['EntitlementPrivilegedAccessGcpIamAccessRoleBindingArgs'] role_bindings: Role bindings to be created on successful grant.
               Structure is documented below.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "role_bindings", role_bindings)

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The type of this resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="roleBindings")
    def role_bindings(self) -> Sequence['outputs.EntitlementPrivilegedAccessGcpIamAccessRoleBinding']:
        """
        Role bindings to be created on successful grant.
        Structure is documented below.
        """
        return pulumi.get(self, "role_bindings")


@pulumi.output_type
class EntitlementPrivilegedAccessGcpIamAccessRoleBinding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionExpression":
            suggest = "condition_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementPrivilegedAccessGcpIamAccessRoleBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementPrivilegedAccessGcpIamAccessRoleBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementPrivilegedAccessGcpIamAccessRoleBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: builtins.str,
                 condition_expression: Optional[builtins.str] = None):
        """
        :param builtins.str role: IAM role to be granted. https://cloud.google.com/iam/docs/roles-overview.
        :param builtins.str condition_expression: The expression field of the IAM condition to be associated with the role. If specified, a user with an active grant for this entitlement would be able to access the resource only if this condition evaluates to true for their request.
               https://cloud.google.com/iam/docs/conditions-overview#attributes.
        """
        pulumi.set(__self__, "role", role)
        if condition_expression is not None:
            pulumi.set(__self__, "condition_expression", condition_expression)

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        IAM role to be granted. https://cloud.google.com/iam/docs/roles-overview.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> Optional[builtins.str]:
        """
        The expression field of the IAM condition to be associated with the role. If specified, a user with an active grant for this entitlement would be able to access the resource only if this condition evaluates to true for their request.
        https://cloud.google.com/iam/docs/conditions-overview#attributes.
        """
        return pulumi.get(self, "condition_expression")


@pulumi.output_type
class EntitlementRequesterJustificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notMandatory":
            suggest = "not_mandatory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntitlementRequesterJustificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntitlementRequesterJustificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntitlementRequesterJustificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_mandatory: Optional['outputs.EntitlementRequesterJustificationConfigNotMandatory'] = None,
                 unstructured: Optional['outputs.EntitlementRequesterJustificationConfigUnstructured'] = None):
        """
        :param 'EntitlementRequesterJustificationConfigNotMandatoryArgs' not_mandatory: The justification is not mandatory but can be provided in any of the supported formats.
        :param 'EntitlementRequesterJustificationConfigUnstructuredArgs' unstructured: The requester has to provide a justification in the form of free flowing text.
        """
        if not_mandatory is not None:
            pulumi.set(__self__, "not_mandatory", not_mandatory)
        if unstructured is not None:
            pulumi.set(__self__, "unstructured", unstructured)

    @property
    @pulumi.getter(name="notMandatory")
    def not_mandatory(self) -> Optional['outputs.EntitlementRequesterJustificationConfigNotMandatory']:
        """
        The justification is not mandatory but can be provided in any of the supported formats.
        """
        return pulumi.get(self, "not_mandatory")

    @property
    @pulumi.getter
    def unstructured(self) -> Optional['outputs.EntitlementRequesterJustificationConfigUnstructured']:
        """
        The requester has to provide a justification in the form of free flowing text.
        """
        return pulumi.get(self, "unstructured")


@pulumi.output_type
class EntitlementRequesterJustificationConfigNotMandatory(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class EntitlementRequesterJustificationConfigUnstructured(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetEntitlementAdditionalNotificationTargetResult(dict):
    def __init__(__self__, *,
                 admin_email_recipients: Sequence[builtins.str],
                 requester_email_recipients: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] admin_email_recipients: Optional. Additional email addresses to be notified when a principal(requester) is granted access.
        :param Sequence[builtins.str] requester_email_recipients: Optional. Additional email address to be notified about an eligible entitlement.
        """
        pulumi.set(__self__, "admin_email_recipients", admin_email_recipients)
        pulumi.set(__self__, "requester_email_recipients", requester_email_recipients)

    @property
    @pulumi.getter(name="adminEmailRecipients")
    def admin_email_recipients(self) -> Sequence[builtins.str]:
        """
        Optional. Additional email addresses to be notified when a principal(requester) is granted access.
        """
        return pulumi.get(self, "admin_email_recipients")

    @property
    @pulumi.getter(name="requesterEmailRecipients")
    def requester_email_recipients(self) -> Sequence[builtins.str]:
        """
        Optional. Additional email address to be notified about an eligible entitlement.
        """
        return pulumi.get(self, "requester_email_recipients")


@pulumi.output_type
class GetEntitlementApprovalWorkflowResult(dict):
    def __init__(__self__, *,
                 manual_approvals: Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalResult']):
        """
        :param Sequence['GetEntitlementApprovalWorkflowManualApprovalArgs'] manual_approvals: A manual approval workflow where users who are designated as approvers need to call the ApproveGrant/DenyGrant APIs for an Grant.
               The workflow can consist of multiple serial steps where each step defines who can act as Approver in that step and how many of those users should approve before the workflow moves to the next step.
               This can be used to create approval workflows such as
               * Require an approval from any user in a group G.
               * Require an approval from any k number of users from a Group G.
               * Require an approval from any user in a group G and then from a user U. etc.
               A single user might be part of 'approvers' ACL for multiple steps in this workflow but they can only approve once and that approval will only be considered to satisfy the approval step at which it was granted.
        """
        pulumi.set(__self__, "manual_approvals", manual_approvals)

    @property
    @pulumi.getter(name="manualApprovals")
    def manual_approvals(self) -> Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalResult']:
        """
        A manual approval workflow where users who are designated as approvers need to call the ApproveGrant/DenyGrant APIs for an Grant.
        The workflow can consist of multiple serial steps where each step defines who can act as Approver in that step and how many of those users should approve before the workflow moves to the next step.
        This can be used to create approval workflows such as
        * Require an approval from any user in a group G.
        * Require an approval from any k number of users from a Group G.
        * Require an approval from any user in a group G and then from a user U. etc.
        A single user might be part of 'approvers' ACL for multiple steps in this workflow but they can only approve once and that approval will only be considered to satisfy the approval step at which it was granted.
        """
        return pulumi.get(self, "manual_approvals")


@pulumi.output_type
class GetEntitlementApprovalWorkflowManualApprovalResult(dict):
    def __init__(__self__, *,
                 require_approver_justification: builtins.bool,
                 steps: Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalStepResult']):
        """
        :param builtins.bool require_approver_justification: Optional. Do the approvers need to provide a justification for their actions?
        :param Sequence['GetEntitlementApprovalWorkflowManualApprovalStepArgs'] steps: List of approval steps in this workflow. These steps would be followed in the specified order sequentially.  1 step is supported for now.
        """
        pulumi.set(__self__, "require_approver_justification", require_approver_justification)
        pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter(name="requireApproverJustification")
    def require_approver_justification(self) -> builtins.bool:
        """
        Optional. Do the approvers need to provide a justification for their actions?
        """
        return pulumi.get(self, "require_approver_justification")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalStepResult']:
        """
        List of approval steps in this workflow. These steps would be followed in the specified order sequentially.  1 step is supported for now.
        """
        return pulumi.get(self, "steps")


@pulumi.output_type
class GetEntitlementApprovalWorkflowManualApprovalStepResult(dict):
    def __init__(__self__, *,
                 approvals_needed: builtins.int,
                 approver_email_recipients: Sequence[builtins.str],
                 approvers: Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalStepApproverResult']):
        """
        :param builtins.int approvals_needed: How many users from the above list need to approve.
               If there are not enough distinct users in the list above then the workflow
               will indefinitely block. Should always be greater than 0. Currently 1 is the only
               supported value.
        :param Sequence[builtins.str] approver_email_recipients: Optional. Additional email addresses to be notified when a grant is pending approval.
        :param Sequence['GetEntitlementApprovalWorkflowManualApprovalStepApproverArgs'] approvers: The potential set of approvers in this step. This list should contain at only one entry.
        """
        pulumi.set(__self__, "approvals_needed", approvals_needed)
        pulumi.set(__self__, "approver_email_recipients", approver_email_recipients)
        pulumi.set(__self__, "approvers", approvers)

    @property
    @pulumi.getter(name="approvalsNeeded")
    def approvals_needed(self) -> builtins.int:
        """
        How many users from the above list need to approve.
        If there are not enough distinct users in the list above then the workflow
        will indefinitely block. Should always be greater than 0. Currently 1 is the only
        supported value.
        """
        return pulumi.get(self, "approvals_needed")

    @property
    @pulumi.getter(name="approverEmailRecipients")
    def approver_email_recipients(self) -> Sequence[builtins.str]:
        """
        Optional. Additional email addresses to be notified when a grant is pending approval.
        """
        return pulumi.get(self, "approver_email_recipients")

    @property
    @pulumi.getter
    def approvers(self) -> Sequence['outputs.GetEntitlementApprovalWorkflowManualApprovalStepApproverResult']:
        """
        The potential set of approvers in this step. This list should contain at only one entry.
        """
        return pulumi.get(self, "approvers")


@pulumi.output_type
class GetEntitlementApprovalWorkflowManualApprovalStepApproverResult(dict):
    def __init__(__self__, *,
                 principals: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] principals: Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at: https://cloud.google.com/iam/docs/principal-identifiers#v1
        """
        pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter
    def principals(self) -> Sequence[builtins.str]:
        """
        Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at: https://cloud.google.com/iam/docs/principal-identifiers#v1
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class GetEntitlementEligibleUserResult(dict):
    def __init__(__self__, *,
                 principals: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] principals: Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at "https://cloud.google.com/iam/docs/principal-identifiers#v1"
        """
        pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter
    def principals(self) -> Sequence[builtins.str]:
        """
        Users who are being allowed for the operation. Each entry should be a valid v1 IAM Principal Identifier. Format for these is documented at "https://cloud.google.com/iam/docs/principal-identifiers#v1"
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class GetEntitlementPrivilegedAccessResult(dict):
    def __init__(__self__, *,
                 gcp_iam_accesses: Sequence['outputs.GetEntitlementPrivilegedAccessGcpIamAccessResult']):
        """
        :param Sequence['GetEntitlementPrivilegedAccessGcpIamAccessArgs'] gcp_iam_accesses: GcpIamAccess represents IAM based access control on a GCP resource. Refer to https://cloud.google.com/iam/docs to understand more about IAM.
        """
        pulumi.set(__self__, "gcp_iam_accesses", gcp_iam_accesses)

    @property
    @pulumi.getter(name="gcpIamAccesses")
    def gcp_iam_accesses(self) -> Sequence['outputs.GetEntitlementPrivilegedAccessGcpIamAccessResult']:
        """
        GcpIamAccess represents IAM based access control on a GCP resource. Refer to https://cloud.google.com/iam/docs to understand more about IAM.
        """
        return pulumi.get(self, "gcp_iam_accesses")


@pulumi.output_type
class GetEntitlementPrivilegedAccessGcpIamAccessResult(dict):
    def __init__(__self__, *,
                 resource: builtins.str,
                 resource_type: builtins.str,
                 role_bindings: Sequence['outputs.GetEntitlementPrivilegedAccessGcpIamAccessRoleBindingResult']):
        """
        :param builtins.str resource: Name of the resource.
        :param builtins.str resource_type: The type of this resource.
        :param Sequence['GetEntitlementPrivilegedAccessGcpIamAccessRoleBindingArgs'] role_bindings: Role bindings to be created on successful grant.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "role_bindings", role_bindings)

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The type of this resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="roleBindings")
    def role_bindings(self) -> Sequence['outputs.GetEntitlementPrivilegedAccessGcpIamAccessRoleBindingResult']:
        """
        Role bindings to be created on successful grant.
        """
        return pulumi.get(self, "role_bindings")


@pulumi.output_type
class GetEntitlementPrivilegedAccessGcpIamAccessRoleBindingResult(dict):
    def __init__(__self__, *,
                 condition_expression: builtins.str,
                 role: builtins.str):
        """
        :param builtins.str condition_expression: The expression field of the IAM condition to be associated with the role. If specified, a user with an active grant for this entitlement would be able to access the resource only if this condition evaluates to true for their request.
               https://cloud.google.com/iam/docs/conditions-overview#attributes.
        :param builtins.str role: IAM role to be granted. https://cloud.google.com/iam/docs/roles-overview.
        """
        pulumi.set(__self__, "condition_expression", condition_expression)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> builtins.str:
        """
        The expression field of the IAM condition to be associated with the role. If specified, a user with an active grant for this entitlement would be able to access the resource only if this condition evaluates to true for their request.
        https://cloud.google.com/iam/docs/conditions-overview#attributes.
        """
        return pulumi.get(self, "condition_expression")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        IAM role to be granted. https://cloud.google.com/iam/docs/roles-overview.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetEntitlementRequesterJustificationConfigResult(dict):
    def __init__(__self__, *,
                 not_mandatories: Sequence['outputs.GetEntitlementRequesterJustificationConfigNotMandatoryResult'],
                 unstructureds: Sequence['outputs.GetEntitlementRequesterJustificationConfigUnstructuredResult']):
        """
        :param Sequence['GetEntitlementRequesterJustificationConfigNotMandatoryArgs'] not_mandatories: The justification is not mandatory but can be provided in any of the supported formats.
        :param Sequence['GetEntitlementRequesterJustificationConfigUnstructuredArgs'] unstructureds: The requester has to provide a justification in the form of free flowing text.
        """
        pulumi.set(__self__, "not_mandatories", not_mandatories)
        pulumi.set(__self__, "unstructureds", unstructureds)

    @property
    @pulumi.getter(name="notMandatories")
    def not_mandatories(self) -> Sequence['outputs.GetEntitlementRequesterJustificationConfigNotMandatoryResult']:
        """
        The justification is not mandatory but can be provided in any of the supported formats.
        """
        return pulumi.get(self, "not_mandatories")

    @property
    @pulumi.getter
    def unstructureds(self) -> Sequence['outputs.GetEntitlementRequesterJustificationConfigUnstructuredResult']:
        """
        The requester has to provide a justification in the form of free flowing text.
        """
        return pulumi.get(self, "unstructureds")


@pulumi.output_type
class GetEntitlementRequesterJustificationConfigNotMandatoryResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetEntitlementRequesterJustificationConfigUnstructuredResult(dict):
    def __init__(__self__):
        pass


