# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessApprovalSettingsEnrolledService',
    'ApiKeyRestrictions',
    'ApiKeyRestrictionsAndroidKeyRestrictions',
    'ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication',
    'ApiKeyRestrictionsApiTarget',
    'ApiKeyRestrictionsBrowserKeyRestrictions',
    'ApiKeyRestrictionsIosKeyRestrictions',
    'ApiKeyRestrictionsServerKeyRestrictions',
    'IAMAuditConfigAuditLogConfig',
    'IAMBindingCondition',
    'IAMMemberCondition',
    'OrganizationPolicyBooleanPolicy',
    'OrganizationPolicyListPolicy',
    'OrganizationPolicyListPolicyAllow',
    'OrganizationPolicyListPolicyDeny',
    'OrganizationPolicyRestorePolicy',
    'GetAncestryAncestorResult',
    'GetIamCustomRolesRoleResult',
    'GetOrganizationPolicyBooleanPolicyResult',
    'GetOrganizationPolicyListPolicyResult',
    'GetOrganizationPolicyListPolicyAllowResult',
    'GetOrganizationPolicyListPolicyDenyResult',
    'GetOrganizationPolicyRestorePolicyResult',
    'GetProjectProjectResult',
]

@pulumi.output_type
class AccessApprovalSettingsEnrolledService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProduct":
            suggest = "cloud_product"
        elif key == "enrollmentLevel":
            suggest = "enrollment_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessApprovalSettingsEnrolledService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessApprovalSettingsEnrolledService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessApprovalSettingsEnrolledService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_product: builtins.str,
                 enrollment_level: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_product: The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
               all
               appengine.googleapis.com
               bigquery.googleapis.com
               bigtable.googleapis.com
               cloudkms.googleapis.com
               compute.googleapis.com
               dataflow.googleapis.com
               iam.googleapis.com
               pubsub.googleapis.com
               storage.googleapis.com
        :param builtins.str enrollment_level: The enrollment level of the service.
               Default value is `BLOCK_ALL`.
               Possible values are: `BLOCK_ALL`.
        """
        pulumi.set(__self__, "cloud_product", cloud_product)
        if enrollment_level is not None:
            pulumi.set(__self__, "enrollment_level", enrollment_level)

    @property
    @pulumi.getter(name="cloudProduct")
    def cloud_product(self) -> builtins.str:
        """
        The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
        all
        appengine.googleapis.com
        bigquery.googleapis.com
        bigtable.googleapis.com
        cloudkms.googleapis.com
        compute.googleapis.com
        dataflow.googleapis.com
        iam.googleapis.com
        pubsub.googleapis.com
        storage.googleapis.com
        """
        return pulumi.get(self, "cloud_product")

    @property
    @pulumi.getter(name="enrollmentLevel")
    def enrollment_level(self) -> Optional[builtins.str]:
        """
        The enrollment level of the service.
        Default value is `BLOCK_ALL`.
        Possible values are: `BLOCK_ALL`.
        """
        return pulumi.get(self, "enrollment_level")


@pulumi.output_type
class ApiKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidKeyRestrictions":
            suggest = "android_key_restrictions"
        elif key == "apiTargets":
            suggest = "api_targets"
        elif key == "browserKeyRestrictions":
            suggest = "browser_key_restrictions"
        elif key == "iosKeyRestrictions":
            suggest = "ios_key_restrictions"
        elif key == "serverKeyRestrictions":
            suggest = "server_key_restrictions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_key_restrictions: Optional['outputs.ApiKeyRestrictionsAndroidKeyRestrictions'] = None,
                 api_targets: Optional[Sequence['outputs.ApiKeyRestrictionsApiTarget']] = None,
                 browser_key_restrictions: Optional['outputs.ApiKeyRestrictionsBrowserKeyRestrictions'] = None,
                 ios_key_restrictions: Optional['outputs.ApiKeyRestrictionsIosKeyRestrictions'] = None,
                 server_key_restrictions: Optional['outputs.ApiKeyRestrictionsServerKeyRestrictions'] = None):
        """
        :param 'ApiKeyRestrictionsAndroidKeyRestrictionsArgs' android_key_restrictions: The Android apps that are allowed to use the key.
        :param Sequence['ApiKeyRestrictionsApiTargetArgs'] api_targets: A restriction for a specific service and optionally one or more specific methods. Requests are allowed if they match any of these restrictions. If no restrictions are specified, all targets are allowed.
        :param 'ApiKeyRestrictionsBrowserKeyRestrictionsArgs' browser_key_restrictions: The HTTP referrers (websites) that are allowed to use the key.
        :param 'ApiKeyRestrictionsIosKeyRestrictionsArgs' ios_key_restrictions: The iOS apps that are allowed to use the key.
        :param 'ApiKeyRestrictionsServerKeyRestrictionsArgs' server_key_restrictions: The IP addresses of callers that are allowed to use the key.
        """
        if android_key_restrictions is not None:
            pulumi.set(__self__, "android_key_restrictions", android_key_restrictions)
        if api_targets is not None:
            pulumi.set(__self__, "api_targets", api_targets)
        if browser_key_restrictions is not None:
            pulumi.set(__self__, "browser_key_restrictions", browser_key_restrictions)
        if ios_key_restrictions is not None:
            pulumi.set(__self__, "ios_key_restrictions", ios_key_restrictions)
        if server_key_restrictions is not None:
            pulumi.set(__self__, "server_key_restrictions", server_key_restrictions)

    @property
    @pulumi.getter(name="androidKeyRestrictions")
    def android_key_restrictions(self) -> Optional['outputs.ApiKeyRestrictionsAndroidKeyRestrictions']:
        """
        The Android apps that are allowed to use the key.
        """
        return pulumi.get(self, "android_key_restrictions")

    @property
    @pulumi.getter(name="apiTargets")
    def api_targets(self) -> Optional[Sequence['outputs.ApiKeyRestrictionsApiTarget']]:
        """
        A restriction for a specific service and optionally one or more specific methods. Requests are allowed if they match any of these restrictions. If no restrictions are specified, all targets are allowed.
        """
        return pulumi.get(self, "api_targets")

    @property
    @pulumi.getter(name="browserKeyRestrictions")
    def browser_key_restrictions(self) -> Optional['outputs.ApiKeyRestrictionsBrowserKeyRestrictions']:
        """
        The HTTP referrers (websites) that are allowed to use the key.
        """
        return pulumi.get(self, "browser_key_restrictions")

    @property
    @pulumi.getter(name="iosKeyRestrictions")
    def ios_key_restrictions(self) -> Optional['outputs.ApiKeyRestrictionsIosKeyRestrictions']:
        """
        The iOS apps that are allowed to use the key.
        """
        return pulumi.get(self, "ios_key_restrictions")

    @property
    @pulumi.getter(name="serverKeyRestrictions")
    def server_key_restrictions(self) -> Optional['outputs.ApiKeyRestrictionsServerKeyRestrictions']:
        """
        The IP addresses of callers that are allowed to use the key.
        """
        return pulumi.get(self, "server_key_restrictions")


@pulumi.output_type
class ApiKeyRestrictionsAndroidKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedApplications":
            suggest = "allowed_applications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictionsAndroidKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictionsAndroidKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictionsAndroidKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_applications: Sequence['outputs.ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication']):
        """
        :param Sequence['ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationArgs'] allowed_applications: A list of Android applications that are allowed to make API calls with this key.
        """
        pulumi.set(__self__, "allowed_applications", allowed_applications)

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> Sequence['outputs.ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication']:
        """
        A list of Android applications that are allowed to make API calls with this key.
        """
        return pulumi.get(self, "allowed_applications")


@pulumi.output_type
class ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageName":
            suggest = "package_name"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictionsAndroidKeyRestrictionsAllowedApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_name: builtins.str,
                 sha1_fingerprint: builtins.str):
        """
        :param builtins.str package_name: The package name of the application.
        :param builtins.str sha1_fingerprint: The SHA1 fingerprint of the application. For example, both sha1 formats are acceptable : DA:39:A3:EE:5E:6B:4B:0D:32:55:BF:EF:95:60:18:90:AF:D8:07:09 or DA39A3EE5E6B4B0D3255BFEF95601890AFD80709. Output format is the latter.
        """
        pulumi.set(__self__, "package_name", package_name)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> builtins.str:
        """
        The package name of the application.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> builtins.str:
        """
        The SHA1 fingerprint of the application. For example, both sha1 formats are acceptable : DA:39:A3:EE:5E:6B:4B:0D:32:55:BF:EF:95:60:18:90:AF:D8:07:09 or DA39A3EE5E6B4B0D3255BFEF95601890AFD80709. Output format is the latter.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class ApiKeyRestrictionsApiTarget(dict):
    def __init__(__self__, *,
                 service: builtins.str,
                 methods: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str service: The service for this restriction. It should be the canonical service name, for example: `translate.googleapis.com`. You can use `gcloud services list` to get a list of services that are enabled in the project.
        :param Sequence[builtins.str] methods: Optional. List of one or more methods that can be called. If empty, all methods for the service are allowed. A wildcard (*) can be used as the last symbol. Valid examples: `google.cloud.translate.v2.TranslateService.GetSupportedLanguage` `TranslateText` `Get*` `translate.googleapis.com.Get*`
        """
        pulumi.set(__self__, "service", service)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        The service for this restriction. It should be the canonical service name, for example: `translate.googleapis.com`. You can use `gcloud services list` to get a list of services that are enabled in the project.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Optional. List of one or more methods that can be called. If empty, all methods for the service are allowed. A wildcard (*) can be used as the last symbol. Valid examples: `google.cloud.translate.v2.TranslateService.GetSupportedLanguage` `TranslateText` `Get*` `translate.googleapis.com.Get*`
        """
        return pulumi.get(self, "methods")


@pulumi.output_type
class ApiKeyRestrictionsBrowserKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedReferrers":
            suggest = "allowed_referrers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictionsBrowserKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictionsBrowserKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictionsBrowserKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_referrers: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_referrers: A list of regular expressions for the referrer URLs that are allowed to make API calls with this key.
        """
        pulumi.set(__self__, "allowed_referrers", allowed_referrers)

    @property
    @pulumi.getter(name="allowedReferrers")
    def allowed_referrers(self) -> Sequence[builtins.str]:
        """
        A list of regular expressions for the referrer URLs that are allowed to make API calls with this key.
        """
        return pulumi.get(self, "allowed_referrers")


@pulumi.output_type
class ApiKeyRestrictionsIosKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedBundleIds":
            suggest = "allowed_bundle_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictionsIosKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictionsIosKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictionsIosKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_bundle_ids: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_bundle_ids: A list of bundle IDs that are allowed when making API calls with this key.
        """
        pulumi.set(__self__, "allowed_bundle_ids", allowed_bundle_ids)

    @property
    @pulumi.getter(name="allowedBundleIds")
    def allowed_bundle_ids(self) -> Sequence[builtins.str]:
        """
        A list of bundle IDs that are allowed when making API calls with this key.
        """
        return pulumi.get(self, "allowed_bundle_ids")


@pulumi.output_type
class ApiKeyRestrictionsServerKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIps":
            suggest = "allowed_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictionsServerKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictionsServerKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictionsServerKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ips: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_ips: A list of the caller IP addresses that are allowed to make API calls with this key.
        """
        pulumi.set(__self__, "allowed_ips", allowed_ips)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Sequence[builtins.str]:
        """
        A list of the caller IP addresses that are allowed to make API calls with this key.
        """
        return pulumi.get(self, "allowed_ips")


@pulumi.output_type
class IAMAuditConfigAuditLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logType":
            suggest = "log_type"
        elif key == "exemptedMembers":
            suggest = "exempted_members"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IAMAuditConfigAuditLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IAMAuditConfigAuditLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IAMAuditConfigAuditLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_type: builtins.str,
                 exempted_members: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str log_type: Permission type for which logging is to be configured.  Must be one of `DATA_READ`, `DATA_WRITE`, or `ADMIN_READ`.
        :param Sequence[builtins.str] exempted_members: Identities that do not cause logging for this type of permission.  The format is the same as that for `members`.
        """
        pulumi.set(__self__, "log_type", log_type)
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Permission type for which logging is to be configured.  Must be one of `DATA_READ`, `DATA_WRITE`, or `ADMIN_READ`.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[Sequence[builtins.str]]:
        """
        Identities that do not cause logging for this type of permission.  The format is the same as that for `members`.
        """
        return pulumi.get(self, "exempted_members")


@pulumi.output_type
class IAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class IAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class OrganizationPolicyBooleanPolicy(dict):
    def __init__(__self__, *,
                 enforced: builtins.bool):
        """
        :param builtins.bool enforced: If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        pulumi.set(__self__, "enforced", enforced)

    @property
    @pulumi.getter
    def enforced(self) -> builtins.bool:
        """
        If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        return pulumi.get(self, "enforced")


@pulumi.output_type
class OrganizationPolicyListPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inheritFromParent":
            suggest = "inherit_from_parent"
        elif key == "suggestedValue":
            suggest = "suggested_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationPolicyListPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationPolicyListPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationPolicyListPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow: Optional['outputs.OrganizationPolicyListPolicyAllow'] = None,
                 deny: Optional['outputs.OrganizationPolicyListPolicyDeny'] = None,
                 inherit_from_parent: Optional[builtins.bool] = None,
                 suggested_value: Optional[builtins.str] = None):
        """
        :param 'OrganizationPolicyListPolicyAllowArgs' allow: or `deny` - (Optional) One or the other must be set.
        :param 'OrganizationPolicyListPolicyDenyArgs' deny: One or the other must be set.
        :param builtins.bool inherit_from_parent: If set to true, the values from the effective Policy of the parent resource
               are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
               
               The `allow` or `deny` blocks support:
        :param builtins.str suggested_value: The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if deny is not None:
            pulumi.set(__self__, "deny", deny)
        if inherit_from_parent is not None:
            pulumi.set(__self__, "inherit_from_parent", inherit_from_parent)
        if suggested_value is not None:
            pulumi.set(__self__, "suggested_value", suggested_value)

    @property
    @pulumi.getter
    def allow(self) -> Optional['outputs.OrganizationPolicyListPolicyAllow']:
        """
        or `deny` - (Optional) One or the other must be set.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def deny(self) -> Optional['outputs.OrganizationPolicyListPolicyDeny']:
        """
        One or the other must be set.
        """
        return pulumi.get(self, "deny")

    @property
    @pulumi.getter(name="inheritFromParent")
    def inherit_from_parent(self) -> Optional[builtins.bool]:
        """
        If set to true, the values from the effective Policy of the parent resource
        are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.

        The `allow` or `deny` blocks support:
        """
        return pulumi.get(self, "inherit_from_parent")

    @property
    @pulumi.getter(name="suggestedValue")
    def suggested_value(self) -> Optional[builtins.str]:
        """
        The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        return pulumi.get(self, "suggested_value")


@pulumi.output_type
class OrganizationPolicyListPolicyAllow(dict):
    def __init__(__self__, *,
                 all: Optional[builtins.bool] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> Optional[builtins.bool]:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class OrganizationPolicyListPolicyDeny(dict):
    def __init__(__self__, *,
                 all: Optional[builtins.bool] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> Optional[builtins.bool]:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class OrganizationPolicyRestorePolicy(dict):
    def __init__(__self__, *,
                 default: builtins.bool):
        """
        :param builtins.bool default: May only be set to true. If set, then the default Policy is restored.
        """
        pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> builtins.bool:
        """
        May only be set to true. If set, then the default Policy is restored.
        """
        return pulumi.get(self, "default")


@pulumi.output_type
class GetAncestryAncestorResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: If it's a project, the `project_id` is exported, else the numeric folder id or organization id.
        :param builtins.str type: One of `"project"`, `"folder"` or `"organization"`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        If it's a project, the `project_id` is exported, else the numeric folder id or organization id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        One of `"project"`, `"folder"` or `"organization"`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetIamCustomRolesRoleResult(dict):
    def __init__(__self__, *,
                 deleted: builtins.bool,
                 description: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 permissions: Sequence[builtins.str],
                 role_id: builtins.str,
                 stage: builtins.str,
                 title: builtins.str):
        """
        :param builtins.bool deleted: The current deleted state of the role.
        :param builtins.str description: A human-readable description for the role.
        :param builtins.str id: an identifier for the resource with the format `projects/{{project}}/roles/{{role_id}}`.
        :param builtins.str name: The name of the role in the format `projects/{{project}}/roles/{{role_id}}`. Like `id`, this field can be used as a reference in other resources such as IAM role bindings.
        :param Sequence[builtins.str] permissions: The names of the permissions this role grants when bound in an IAM policy.
        :param builtins.str role_id: The camel case role id used for this role.
        :param builtins.str stage: The current launch stage of the role. List of possible stages is [here](https://cloud.google.com/iam/reference/rest/v1/organizations.roles#Role.RoleLaunchStage).
        :param builtins.str title: A human-readable title for the role.
        """
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def deleted(self) -> builtins.bool:
        """
        The current deleted state of the role.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A human-readable description for the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        an identifier for the resource with the format `projects/{{project}}/roles/{{role_id}}`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the role in the format `projects/{{project}}/roles/{{role_id}}`. Like `id`, this field can be used as a reference in other resources such as IAM role bindings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[builtins.str]:
        """
        The names of the permissions this role grants when bound in an IAM policy.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> builtins.str:
        """
        The camel case role id used for this role.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter
    def stage(self) -> builtins.str:
        """
        The current launch stage of the role. List of possible stages is [here](https://cloud.google.com/iam/reference/rest/v1/organizations.roles#Role.RoleLaunchStage).
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A human-readable title for the role.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetOrganizationPolicyBooleanPolicyResult(dict):
    def __init__(__self__, *,
                 enforced: builtins.bool):
        """
        :param builtins.bool enforced: If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        pulumi.set(__self__, "enforced", enforced)

    @property
    @pulumi.getter
    def enforced(self) -> builtins.bool:
        """
        If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        return pulumi.get(self, "enforced")


@pulumi.output_type
class GetOrganizationPolicyListPolicyResult(dict):
    def __init__(__self__, *,
                 allows: Sequence['outputs.GetOrganizationPolicyListPolicyAllowResult'],
                 denies: Sequence['outputs.GetOrganizationPolicyListPolicyDenyResult'],
                 inherit_from_parent: builtins.bool,
                 suggested_value: builtins.str):
        """
        :param Sequence['GetOrganizationPolicyListPolicyAllowArgs'] allows: One or the other must be set.
        :param Sequence['GetOrganizationPolicyListPolicyDenyArgs'] denies: One or the other must be set.
        :param builtins.bool inherit_from_parent: If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
        :param builtins.str suggested_value: The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        pulumi.set(__self__, "allows", allows)
        pulumi.set(__self__, "denies", denies)
        pulumi.set(__self__, "inherit_from_parent", inherit_from_parent)
        pulumi.set(__self__, "suggested_value", suggested_value)

    @property
    @pulumi.getter
    def allows(self) -> Sequence['outputs.GetOrganizationPolicyListPolicyAllowResult']:
        """
        One or the other must be set.
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter
    def denies(self) -> Sequence['outputs.GetOrganizationPolicyListPolicyDenyResult']:
        """
        One or the other must be set.
        """
        return pulumi.get(self, "denies")

    @property
    @pulumi.getter(name="inheritFromParent")
    def inherit_from_parent(self) -> builtins.bool:
        """
        If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
        """
        return pulumi.get(self, "inherit_from_parent")

    @property
    @pulumi.getter(name="suggestedValue")
    def suggested_value(self) -> builtins.str:
        """
        The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        return pulumi.get(self, "suggested_value")


@pulumi.output_type
class GetOrganizationPolicyListPolicyAllowResult(dict):
    def __init__(__self__, *,
                 all: builtins.bool,
                 values: Sequence[builtins.str]):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> builtins.bool:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetOrganizationPolicyListPolicyDenyResult(dict):
    def __init__(__self__, *,
                 all: builtins.bool,
                 values: Sequence[builtins.str]):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> builtins.bool:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetOrganizationPolicyRestorePolicyResult(dict):
    def __init__(__self__, *,
                 default: builtins.bool):
        """
        :param builtins.bool default: May only be set to true. If set, then the default Policy is restored.
        """
        pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> builtins.bool:
        """
        May only be set to true. If set, then the default Policy is restored.
        """
        return pulumi.get(self, "default")


@pulumi.output_type
class GetProjectProjectResult(dict):
    def __init__(__self__, *,
                 create_time: builtins.str,
                 labels: Mapping[str, builtins.str],
                 lifecycle_state: builtins.str,
                 name: builtins.str,
                 number: builtins.str,
                 parent: Mapping[str, builtins.str],
                 project_id: builtins.str):
        """
        :param builtins.str create_time: Creation time in RFC3339 UTC "Zulu" format.
        :param Mapping[str, builtins.str] labels: A set of key/value label pairs assigned on a project.
        :param builtins.str lifecycle_state: The Project lifecycle state.
        :param builtins.str name: The optional user-assigned display name of the project.
        :param builtins.str number: The numeric identifier of the project.
        :param Mapping[str, builtins.str] parent: An optional reference to a parent resource.
        :param builtins.str project_id: The project id of the project.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Creation time in RFC3339 UTC "Zulu" format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        A set of key/value label pairs assigned on a project.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        """
        The Project lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The optional user-assigned display name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> builtins.str:
        """
        The numeric identifier of the project.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def parent(self) -> Mapping[str, builtins.str]:
        """
        An optional reference to a parent resource.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The project id of the project.
        """
        return pulumi.get(self, "project_id")


