# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopicResult',
    'AwaitableGetTopicResult',
    'get_topic',
    'get_topic_output',
]

@pulumi.output_type
class GetTopicResult:
    """
    A collection of values returned by getTopic.
    """
    def __init__(__self__, effective_labels=None, id=None, ingestion_data_source_settings=None, kms_key_name=None, labels=None, message_retention_duration=None, message_storage_policies=None, message_transforms=None, name=None, project=None, pulumi_labels=None, schema_settings=None):
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingestion_data_source_settings and not isinstance(ingestion_data_source_settings, list):
            raise TypeError("Expected argument 'ingestion_data_source_settings' to be a list")
        pulumi.set(__self__, "ingestion_data_source_settings", ingestion_data_source_settings)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if message_retention_duration and not isinstance(message_retention_duration, str):
            raise TypeError("Expected argument 'message_retention_duration' to be a str")
        pulumi.set(__self__, "message_retention_duration", message_retention_duration)
        if message_storage_policies and not isinstance(message_storage_policies, list):
            raise TypeError("Expected argument 'message_storage_policies' to be a list")
        pulumi.set(__self__, "message_storage_policies", message_storage_policies)
        if message_transforms and not isinstance(message_transforms, list):
            raise TypeError("Expected argument 'message_transforms' to be a list")
        pulumi.set(__self__, "message_transforms", message_transforms)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if schema_settings and not isinstance(schema_settings, list):
            raise TypeError("Expected argument 'schema_settings' to be a list")
        pulumi.set(__self__, "schema_settings", schema_settings)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingestionDataSourceSettings")
    def ingestion_data_source_settings(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingResult']:
        return pulumi.get(self, "ingestion_data_source_settings")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> builtins.str:
        return pulumi.get(self, "message_retention_duration")

    @property
    @pulumi.getter(name="messageStoragePolicies")
    def message_storage_policies(self) -> Sequence['outputs.GetTopicMessageStoragePolicyResult']:
        return pulumi.get(self, "message_storage_policies")

    @property
    @pulumi.getter(name="messageTransforms")
    def message_transforms(self) -> Sequence['outputs.GetTopicMessageTransformResult']:
        return pulumi.get(self, "message_transforms")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="schemaSettings")
    def schema_settings(self) -> Sequence['outputs.GetTopicSchemaSettingResult']:
        return pulumi.get(self, "schema_settings")


class AwaitableGetTopicResult(GetTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicResult(
            effective_labels=self.effective_labels,
            id=self.id,
            ingestion_data_source_settings=self.ingestion_data_source_settings,
            kms_key_name=self.kms_key_name,
            labels=self.labels,
            message_retention_duration=self.message_retention_duration,
            message_storage_policies=self.message_storage_policies,
            message_transforms=self.message_transforms,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            schema_settings=self.schema_settings)


def get_topic(name: Optional[builtins.str] = None,
              project: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicResult:
    """
    Get information about a Google Cloud Pub/Sub Topic. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_topic = gcp.pubsub.get_topic(name="my-pubsub-topic")
    ```


    :param builtins.str name: The name of the Cloud Pub/Sub Topic.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:pubsub/getTopic:getTopic', __args__, opts=opts, typ=GetTopicResult).value

    return AwaitableGetTopicResult(
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        id=pulumi.get(__ret__, 'id'),
        ingestion_data_source_settings=pulumi.get(__ret__, 'ingestion_data_source_settings'),
        kms_key_name=pulumi.get(__ret__, 'kms_key_name'),
        labels=pulumi.get(__ret__, 'labels'),
        message_retention_duration=pulumi.get(__ret__, 'message_retention_duration'),
        message_storage_policies=pulumi.get(__ret__, 'message_storage_policies'),
        message_transforms=pulumi.get(__ret__, 'message_transforms'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        schema_settings=pulumi.get(__ret__, 'schema_settings'))
def get_topic_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTopicResult]:
    """
    Get information about a Google Cloud Pub/Sub Topic. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_topic = gcp.pubsub.get_topic(name="my-pubsub-topic")
    ```


    :param builtins.str name: The name of the Cloud Pub/Sub Topic.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:pubsub/getTopic:getTopic', __args__, opts=opts, typ=GetTopicResult)
    return __ret__.apply(lambda __response__: GetTopicResult(
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        id=pulumi.get(__response__, 'id'),
        ingestion_data_source_settings=pulumi.get(__response__, 'ingestion_data_source_settings'),
        kms_key_name=pulumi.get(__response__, 'kms_key_name'),
        labels=pulumi.get(__response__, 'labels'),
        message_retention_duration=pulumi.get(__response__, 'message_retention_duration'),
        message_storage_policies=pulumi.get(__response__, 'message_storage_policies'),
        message_transforms=pulumi.get(__response__, 'message_transforms'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        schema_settings=pulumi.get(__response__, 'schema_settings')))
