# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionalSecretArgs', 'RegionalSecret']

@pulumi.input_type
class RegionalSecretArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 secret_id: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_encryption: Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rotation: Optional[pulumi.Input['RegionalSecretRotationArgs']] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 version_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_destroy_ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RegionalSecret resource.
        :param pulumi.Input[builtins.str] location: The location of the regional secret. eg us-central1
        :param pulumi.Input[builtins.str] secret_id: This must be unique within the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Custom metadata about the regional secret.
               Annotations are distinct from various forms of labels. Annotations exist to allow
               client tools to store their own state information without requiring a database.
               Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
               may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
               symbols.
               The total size of annotation keys and values must be less than 16KiB.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs'] customer_managed_encryption: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[builtins.str] expire_time: Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
               output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this regional secret.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RegionalSecretRotationArgs'] rotation: The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
               will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
               set to configure rotation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane
               operations are called on the regional secret or its versions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ttl: The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] version_aliases: Mapping from version alias to version name.
               A version alias is a string with a maximum length of 63 characters and can contain
               uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
               characters. An alias string must start with a letter and cannot be the string
               'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] version_destroy_ttl: Secret Version TTL after destruction request.
               This is a part of the delayed delete feature on Secret Version.
               For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
               on calling destroy instead the version goes to a disabled state and
               the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "secret_id", secret_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if customer_managed_encryption is not None:
            pulumi.set(__self__, "customer_managed_encryption", customer_managed_encryption)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if version_aliases is not None:
            pulumi.set(__self__, "version_aliases", version_aliases)
        if version_destroy_ttl is not None:
            pulumi.set(__self__, "version_destroy_ttl", version_destroy_ttl)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the regional secret. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom metadata about the regional secret.
        Annotations are distinct from various forms of labels. Annotations exist to allow
        client tools to store their own state information without requiring a database.
        Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
        may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
        symbols.
        The total size of annotation keys and values must be less than 16KiB.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="customerManagedEncryption")
    def customer_managed_encryption(self) -> Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']]:
        """
        The customer-managed encryption configuration of the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryption")

    @customer_managed_encryption.setter
    def customer_managed_encryption(self, value: Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']]):
        pulumi.set(self, "customer_managed_encryption", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
        output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
        nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels assigned to this regional secret.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def rotation(self) -> Optional[pulumi.Input['RegionalSecretRotationArgs']]:
        """
        The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
        will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
        set to configure rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "rotation")

    @rotation.setter
    def rotation(self, value: Optional[pulumi.Input['RegionalSecretRotationArgs']]):
        pulumi.set(self, "rotation", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]]:
        """
        A list of up to 10 Pub/Sub topics to which messages are published when control plane
        operations are called on the regional secret or its versions.
        Structure is documented below.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Mapping from version alias to version name.
        A version alias is a string with a maximum length of 63 characters and can contain
        uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
        characters. An alias string must start with a letter and cannot be the string
        'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "version_aliases")

    @version_aliases.setter
    def version_aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "version_aliases", value)

    @property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret Version TTL after destruction request.
        This is a part of the delayed delete feature on Secret Version.
        For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
        on calling destroy instead the version goes to a disabled state and
        the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        return pulumi.get(self, "version_destroy_ttl")

    @version_destroy_ttl.setter
    def version_destroy_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_destroy_ttl", value)


@pulumi.input_type
class _RegionalSecretState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_encryption: Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 rotation: Optional[pulumi.Input['RegionalSecretRotationArgs']] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 version_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_destroy_ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionalSecret resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Custom metadata about the regional secret.
               Annotations are distinct from various forms of labels. Annotations exist to allow
               client tools to store their own state information without requiring a database.
               Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
               may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
               symbols.
               The total size of annotation keys and values must be less than 16KiB.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: The time at which the regional secret was created.
        :param pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs'] customer_managed_encryption: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] expire_time: Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
               output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this regional secret.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the regional secret. eg us-central1
        :param pulumi.Input[builtins.str] name: The resource name of the regional secret. Format:
               `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['RegionalSecretRotationArgs'] rotation: The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
               will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
               set to configure rotation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] secret_id: This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane
               operations are called on the regional secret or its versions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ttl: The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] version_aliases: Mapping from version alias to version name.
               A version alias is a string with a maximum length of 63 characters and can contain
               uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
               characters. An alias string must start with a letter and cannot be the string
               'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] version_destroy_ttl: Secret Version TTL after destruction request.
               This is a part of the delayed delete feature on Secret Version.
               For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
               on calling destroy instead the version goes to a disabled state and
               the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if customer_managed_encryption is not None:
            pulumi.set(__self__, "customer_managed_encryption", customer_managed_encryption)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if version_aliases is not None:
            pulumi.set(__self__, "version_aliases", version_aliases)
        if version_destroy_ttl is not None:
            pulumi.set(__self__, "version_destroy_ttl", version_destroy_ttl)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom metadata about the regional secret.
        Annotations are distinct from various forms of labels. Annotations exist to allow
        client tools to store their own state information without requiring a database.
        Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
        may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
        symbols.
        The total size of annotation keys and values must be less than 16KiB.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the regional secret was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customerManagedEncryption")
    def customer_managed_encryption(self) -> Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']]:
        """
        The customer-managed encryption configuration of the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryption")

    @customer_managed_encryption.setter
    def customer_managed_encryption(self, value: Optional[pulumi.Input['RegionalSecretCustomerManagedEncryptionArgs']]):
        pulumi.set(self, "customer_managed_encryption", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
        output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
        nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels assigned to this regional secret.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the regional secret. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the regional secret. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def rotation(self) -> Optional[pulumi.Input['RegionalSecretRotationArgs']]:
        """
        The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
        will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
        set to configure rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "rotation")

    @rotation.setter
    def rotation(self, value: Optional[pulumi.Input['RegionalSecretRotationArgs']]):
        pulumi.set(self, "rotation", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]]:
        """
        A list of up to 10 Pub/Sub topics to which messages are published when control plane
        operations are called on the regional secret or its versions.
        Structure is documented below.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretTopicArgs']]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Mapping from version alias to version name.
        A version alias is a string with a maximum length of 63 characters and can contain
        uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
        characters. An alias string must start with a letter and cannot be the string
        'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "version_aliases")

    @version_aliases.setter
    def version_aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "version_aliases", value)

    @property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret Version TTL after destruction request.
        This is a part of the delayed delete feature on Secret Version.
        For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
        on calling destroy instead the version goes to a disabled state and
        the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        return pulumi.get(self, "version_destroy_ttl")

    @version_destroy_ttl.setter
    def version_destroy_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_destroy_ttl", value)


@pulumi.type_token("gcp:secretmanager/regionalSecret:RegionalSecret")
class RegionalSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_encryption: Optional[pulumi.Input[Union['RegionalSecretCustomerManagedEncryptionArgs', 'RegionalSecretCustomerManagedEncryptionArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rotation: Optional[pulumi.Input[Union['RegionalSecretRotationArgs', 'RegionalSecretRotationArgsDict']]] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretTopicArgs', 'RegionalSecretTopicArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 version_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_destroy_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Regional Secret is a logical secret whose value and versions can be created and accessed within a region only.

        To get more information about RegionalSecret, see:

        * [API documentation](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.locations.secrets)
        * How-to Guides
            * [Create and deploy a Regional Secret](https://cloud.google.com/secret-manager/regional-secrets/create-regional-secret)

        ## Example Usage

        ### Regional Secret Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_basic = gcp.secretmanager.RegionalSecret("regional-secret-basic",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            deletion_protection=False)
        ```
        ### Regional Secret With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        kms_secret_binding = gcp.kms.CryptoKeyIAMMember("kms-secret-binding",
            crypto_key_id="kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-secretmanager.iam.gserviceaccount.com")
        regional_secret_with_cmek = gcp.secretmanager.RegionalSecret("regional-secret-with-cmek",
            secret_id="tf-reg-secret",
            location="us-central1",
            customer_managed_encryption={
                "kms_key_name": "kms-key",
            },
            opts = pulumi.ResourceOptions(depends_on=[kms_secret_binding]))
        ```
        ### Regional Secret With Rotation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        topic = gcp.pubsub.Topic("topic", name="tf-topic")
        secrets_manager_access = gcp.pubsub.TopicIAMMember("secrets_manager_access",
            topic=topic.name,
            role="roles/pubsub.publisher",
            member=f"serviceAccount:service-{project.number}@gcp-sa-secretmanager.iam.gserviceaccount.com")
        regional_secret_with_rotation = gcp.secretmanager.RegionalSecret("regional-secret-with-rotation",
            secret_id="tf-reg-secret",
            location="us-central1",
            topics=[{
                "name": topic.id,
            }],
            rotation={
                "rotation_period": "3600s",
                "next_rotation_time": "2045-11-30T00:00:00Z",
            },
            opts = pulumi.ResourceOptions(depends_on=[secrets_manager_access]))
        ```
        ### Regional Secret With Ttl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_ttl = gcp.secretmanager.RegionalSecret("regional-secret-with-ttl",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            ttl="36000s")
        ```
        ### Regional Secret With Expire Time

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_expire_time = gcp.secretmanager.RegionalSecret("regional-secret-with-expire-time",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            expire_time="2055-11-30T00:00:00Z")
        ```
        ### Regional Secret With Version Destroy Ttl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_version_destroy_ttl = gcp.secretmanager.RegionalSecret("regional-secret-with-version-destroy-ttl",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            version_destroy_ttl="86400s")
        ```

        ## Import

        RegionalSecret can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`

        * `{{project}}/{{location}}/{{secret_id}}`

        * `{{location}}/{{secret_id}}`

        When using the `pulumi import` command, RegionalSecret can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}
        ```

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default {{project}}/{{location}}/{{secret_id}}
        ```

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default {{location}}/{{secret_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Custom metadata about the regional secret.
               Annotations are distinct from various forms of labels. Annotations exist to allow
               client tools to store their own state information without requiring a database.
               Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
               may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
               symbols.
               The total size of annotation keys and values must be less than 16KiB.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['RegionalSecretCustomerManagedEncryptionArgs', 'RegionalSecretCustomerManagedEncryptionArgsDict']] customer_managed_encryption: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[builtins.str] expire_time: Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
               output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this regional secret.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the regional secret. eg us-central1
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RegionalSecretRotationArgs', 'RegionalSecretRotationArgsDict']] rotation: The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
               will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
               set to configure rotation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] secret_id: This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretTopicArgs', 'RegionalSecretTopicArgsDict']]]] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane
               operations are called on the regional secret or its versions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ttl: The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] version_aliases: Mapping from version alias to version name.
               A version alias is a string with a maximum length of 63 characters and can contain
               uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
               characters. An alias string must start with a letter and cannot be the string
               'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] version_destroy_ttl: Secret Version TTL after destruction request.
               This is a part of the delayed delete feature on Secret Version.
               For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
               on calling destroy instead the version goes to a disabled state and
               the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionalSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Regional Secret is a logical secret whose value and versions can be created and accessed within a region only.

        To get more information about RegionalSecret, see:

        * [API documentation](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.locations.secrets)
        * How-to Guides
            * [Create and deploy a Regional Secret](https://cloud.google.com/secret-manager/regional-secrets/create-regional-secret)

        ## Example Usage

        ### Regional Secret Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_basic = gcp.secretmanager.RegionalSecret("regional-secret-basic",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            deletion_protection=False)
        ```
        ### Regional Secret With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        kms_secret_binding = gcp.kms.CryptoKeyIAMMember("kms-secret-binding",
            crypto_key_id="kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-secretmanager.iam.gserviceaccount.com")
        regional_secret_with_cmek = gcp.secretmanager.RegionalSecret("regional-secret-with-cmek",
            secret_id="tf-reg-secret",
            location="us-central1",
            customer_managed_encryption={
                "kms_key_name": "kms-key",
            },
            opts = pulumi.ResourceOptions(depends_on=[kms_secret_binding]))
        ```
        ### Regional Secret With Rotation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        topic = gcp.pubsub.Topic("topic", name="tf-topic")
        secrets_manager_access = gcp.pubsub.TopicIAMMember("secrets_manager_access",
            topic=topic.name,
            role="roles/pubsub.publisher",
            member=f"serviceAccount:service-{project.number}@gcp-sa-secretmanager.iam.gserviceaccount.com")
        regional_secret_with_rotation = gcp.secretmanager.RegionalSecret("regional-secret-with-rotation",
            secret_id="tf-reg-secret",
            location="us-central1",
            topics=[{
                "name": topic.id,
            }],
            rotation={
                "rotation_period": "3600s",
                "next_rotation_time": "2045-11-30T00:00:00Z",
            },
            opts = pulumi.ResourceOptions(depends_on=[secrets_manager_access]))
        ```
        ### Regional Secret With Ttl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_ttl = gcp.secretmanager.RegionalSecret("regional-secret-with-ttl",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            ttl="36000s")
        ```
        ### Regional Secret With Expire Time

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_expire_time = gcp.secretmanager.RegionalSecret("regional-secret-with-expire-time",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            expire_time="2055-11-30T00:00:00Z")
        ```
        ### Regional Secret With Version Destroy Ttl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_secret_with_version_destroy_ttl = gcp.secretmanager.RegionalSecret("regional-secret-with-version-destroy-ttl",
            secret_id="tf-reg-secret",
            location="us-central1",
            labels={
                "label": "my-label",
            },
            annotations={
                "key1": "value1",
                "key2": "value2",
                "key3": "value3",
            },
            version_destroy_ttl="86400s")
        ```

        ## Import

        RegionalSecret can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`

        * `{{project}}/{{location}}/{{secret_id}}`

        * `{{location}}/{{secret_id}}`

        When using the `pulumi import` command, RegionalSecret can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}
        ```

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default {{project}}/{{location}}/{{secret_id}}
        ```

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecret:RegionalSecret default {{location}}/{{secret_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionalSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionalSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_encryption: Optional[pulumi.Input[Union['RegionalSecretCustomerManagedEncryptionArgs', 'RegionalSecretCustomerManagedEncryptionArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rotation: Optional[pulumi.Input[Union['RegionalSecretRotationArgs', 'RegionalSecretRotationArgsDict']]] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretTopicArgs', 'RegionalSecretTopicArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 version_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_destroy_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionalSecretArgs.__new__(RegionalSecretArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["customer_managed_encryption"] = customer_managed_encryption
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["rotation"] = rotation
            if secret_id is None and not opts.urn:
                raise TypeError("Missing required property 'secret_id'")
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["topics"] = topics
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["version_aliases"] = version_aliases
            __props__.__dict__["version_destroy_ttl"] = version_destroy_ttl
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionalSecret, __self__).__init__(
            'gcp:secretmanager/regionalSecret:RegionalSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_encryption: Optional[pulumi.Input[Union['RegionalSecretCustomerManagedEncryptionArgs', 'RegionalSecretCustomerManagedEncryptionArgsDict']]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            expire_time: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            rotation: Optional[pulumi.Input[Union['RegionalSecretRotationArgs', 'RegionalSecretRotationArgsDict']]] = None,
            secret_id: Optional[pulumi.Input[builtins.str]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretTopicArgs', 'RegionalSecretTopicArgsDict']]]]] = None,
            ttl: Optional[pulumi.Input[builtins.str]] = None,
            version_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            version_destroy_ttl: Optional[pulumi.Input[builtins.str]] = None) -> 'RegionalSecret':
        """
        Get an existing RegionalSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Custom metadata about the regional secret.
               Annotations are distinct from various forms of labels. Annotations exist to allow
               client tools to store their own state information without requiring a database.
               Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
               may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
               symbols.
               The total size of annotation keys and values must be less than 16KiB.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: The time at which the regional secret was created.
        :param pulumi.Input[Union['RegionalSecretCustomerManagedEncryptionArgs', 'RegionalSecretCustomerManagedEncryptionArgsDict']] customer_managed_encryption: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] expire_time: Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
               output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels assigned to this regional secret.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
               and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be assigned to a given resource.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the regional secret. eg us-central1
        :param pulumi.Input[builtins.str] name: The resource name of the regional secret. Format:
               `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['RegionalSecretRotationArgs', 'RegionalSecretRotationArgsDict']] rotation: The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
               will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
               set to configure rotation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] secret_id: This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretTopicArgs', 'RegionalSecretTopicArgsDict']]]] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane
               operations are called on the regional secret or its versions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ttl: The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] version_aliases: Mapping from version alias to version name.
               A version alias is a string with a maximum length of 63 characters and can contain
               uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
               characters. An alias string must start with a letter and cannot be the string
               'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
               An object containing a list of "key": value pairs. Example:
               { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] version_destroy_ttl: Secret Version TTL after destruction request.
               This is a part of the delayed delete feature on Secret Version.
               For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
               on calling destroy instead the version goes to a disabled state and
               the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionalSecretState.__new__(_RegionalSecretState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["customer_managed_encryption"] = customer_managed_encryption
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rotation"] = rotation
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["topics"] = topics
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["version_aliases"] = version_aliases
        __props__.__dict__["version_destroy_ttl"] = version_destroy_ttl
        return RegionalSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Custom metadata about the regional secret.
        Annotations are distinct from various forms of labels. Annotations exist to allow
        client tools to store their own state information without requiring a database.
        Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
        may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
        symbols.
        The total size of annotation keys and values must be less than 16KiB.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the regional secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerManagedEncryption")
    def customer_managed_encryption(self) -> pulumi.Output[Optional['outputs.RegionalSecretCustomerManagedEncryption']]:
        """
        The customer-managed encryption configuration of the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryption")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp in UTC when the regional secret is scheduled to expire. This is always provided on
        output, regardless of what was sent on input. A timestamp in RFC3339 UTC "Zulu" format, with
        nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z". Only one of `expire_time` or `ttl` can be provided.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels assigned to this regional secret.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
        and must conform to the following PCRE regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be assigned to a given resource.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the regional secret. eg us-central1
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the regional secret. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def rotation(self) -> pulumi.Output[Optional['outputs.RegionalSecretRotation']]:
        """
        The rotation time and period for a regional secret. At `next_rotation_time`, Secret Manager
        will send a Pub/Sub notification to the topics configured on the Secret. `topics` must be
        set to configure rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "rotation")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence['outputs.RegionalSecretTopic']]]:
        """
        A list of up to 10 Pub/Sub topics to which messages are published when control plane
        operations are called on the regional secret or its versions.
        Structure is documented below.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Only one of `ttl` or `expire_time` can be provided.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Mapping from version alias to version name.
        A version alias is a string with a maximum length of 63 characters and can contain
        uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
        characters. An alias string must start with a letter and cannot be the string
        'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
        An object containing a list of "key": value pairs. Example:
        { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "version_aliases")

    @property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Secret Version TTL after destruction request.
        This is a part of the delayed delete feature on Secret Version.
        For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
        on calling destroy instead the version goes to a disabled state and
        the actual destruction happens after this TTL expires. It must be atleast 24h.
        """
        return pulumi.get(self, "version_destroy_ttl")

