# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 repository_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 initial_config: Optional[pulumi.Input['RepositoryInitialConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the repository is hosted.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[builtins.str] description: Description of the repository, which cannot exceed 500 characters.
        :param pulumi.Input['RepositoryInitialConfigArgs'] initial_config: Initial configurations for the repository.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "repository_id", repository_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if initial_config is not None:
            pulumi.set(__self__, "initial_config", initial_config)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The name of the instance in which the repository is hosted.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the repository, which cannot exceed 500 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="initialConfig")
    def initial_config(self) -> Optional[pulumi.Input['RepositoryInitialConfigArgs']]:
        """
        Initial configurations for the repository.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_config")

    @initial_config.setter
    def initial_config(self, value: Optional[pulumi.Input['RepositoryInitialConfigArgs']]):
        pulumi.set(self, "initial_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 initial_config: Optional[pulumi.Input['RepositoryInitialConfigArgs']] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 uris: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryUriArgs']]]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[builtins.str] create_time: Time the repository was created in UTC.
        :param pulumi.Input[builtins.str] description: Description of the repository, which cannot exceed 500 characters.
        :param pulumi.Input['RepositoryInitialConfigArgs'] initial_config: Initial configurations for the repository.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the repository is hosted.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.str] name: The resource name for the Repository.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[builtins.str] uid: Unique identifier of the repository.
        :param pulumi.Input[builtins.str] update_time: Time the repository was updated in UTC.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryUriArgs']]] uris: URIs for the repository.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if initial_config is not None:
            pulumi.set(__self__, "initial_config", initial_config)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the repository was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the repository, which cannot exceed 500 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="initialConfig")
    def initial_config(self) -> Optional[pulumi.Input['RepositoryInitialConfigArgs']]:
        """
        Initial configurations for the repository.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_config")

    @initial_config.setter
    def initial_config(self, value: Optional[pulumi.Input['RepositoryInitialConfigArgs']]):
        pulumi.set(self, "initial_config", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance in which the repository is hosted.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the Repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the repository.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the repository was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryUriArgs']]]]:
        """
        URIs for the repository.
        Structure is documented below.
        """
        return pulumi.get(self, "uris")

    @uris.setter
    def uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryUriArgs']]]]):
        pulumi.set(self, "uris", value)


@pulumi.type_token("gcp:securesourcemanager/repository:Repository")
class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 initial_config: Optional[pulumi.Input[Union['RepositoryInitialConfigArgs', 'RepositoryInitialConfigArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Repositories store source code. It supports all Git SCM client commands and has built-in pull requests and issue tracking. Both HTTPS and SSH authentication are supported.

        To get more information about Repository, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.repositories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ### Secure Source Manager Repository Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-instance")
        default = gcp.securesourcemanager.Repository("default",
            location="us-central1",
            repository_id="my-repository",
            instance=instance.name)
        ```
        ### Secure Source Manager Repository Initial Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-instance")
        default = gcp.securesourcemanager.Repository("default",
            location="us-central1",
            repository_id="my-repository",
            instance=instance.name,
            description="This is a test repository",
            initial_config={
                "default_branch": "main",
                "gitignores": ["python"],
                "license": "mit",
                "readme": "default",
            })
        ```

        ## Import

        Repository can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`

        * `{{project}}/{{location}}/{{repository_id}}`

        * `{{location}}/{{repository_id}}`

        * `{{repository_id}}`

        When using the `pulumi import` command, Repository can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{project}}/{{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{repository_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the repository, which cannot exceed 500 characters.
        :param pulumi.Input[Union['RepositoryInitialConfigArgs', 'RepositoryInitialConfigArgsDict']] initial_config: Initial configurations for the repository.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the repository is hosted.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Repositories store source code. It supports all Git SCM client commands and has built-in pull requests and issue tracking. Both HTTPS and SSH authentication are supported.

        To get more information about Repository, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.repositories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ### Secure Source Manager Repository Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-instance")
        default = gcp.securesourcemanager.Repository("default",
            location="us-central1",
            repository_id="my-repository",
            instance=instance.name)
        ```
        ### Secure Source Manager Repository Initial Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-instance")
        default = gcp.securesourcemanager.Repository("default",
            location="us-central1",
            repository_id="my-repository",
            instance=instance.name,
            description="This is a test repository",
            initial_config={
                "default_branch": "main",
                "gitignores": ["python"],
                "license": "mit",
                "readme": "default",
            })
        ```

        ## Import

        Repository can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`

        * `{{project}}/{{location}}/{{repository_id}}`

        * `{{location}}/{{repository_id}}`

        * `{{repository_id}}`

        When using the `pulumi import` command, Repository can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{project}}/{{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/repository:Repository default {{repository_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 initial_config: Optional[pulumi.Input[Union['RepositoryInitialConfigArgs', 'RepositoryInitialConfigArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["initial_config"] = initial_config
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["uris"] = None
        super(Repository, __self__).__init__(
            'gcp:securesourcemanager/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            initial_config: Optional[pulumi.Input[Union['RepositoryInitialConfigArgs', 'RepositoryInitialConfigArgsDict']]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            repository_id: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            uris: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryUriArgs', 'RepositoryUriArgsDict']]]]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Time the repository was created in UTC.
        :param pulumi.Input[builtins.str] description: Description of the repository, which cannot exceed 500 characters.
        :param pulumi.Input[Union['RepositoryInitialConfigArgs', 'RepositoryInitialConfigArgsDict']] initial_config: Initial configurations for the repository.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the repository is hosted.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.str] name: The resource name for the Repository.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[builtins.str] uid: Unique identifier of the repository.
        :param pulumi.Input[builtins.str] update_time: Time the repository was updated in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryUriArgs', 'RepositoryUriArgsDict']]]] uris: URIs for the repository.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["initial_config"] = initial_config
        __props__.__dict__["instance"] = instance
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["uris"] = uris
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the repository was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the repository, which cannot exceed 500 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="initialConfig")
    def initial_config(self) -> pulumi.Output[Optional['outputs.RepositoryInitialConfig']]:
        """
        Initial configurations for the repository.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_config")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The name of the instance in which the repository is hosted.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the Repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the repository.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the repository was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uris(self) -> pulumi.Output[Sequence['outputs.RepositoryUri']]:
        """
        URIs for the repository.
        Structure is documented below.
        """
        return pulumi.get(self, "uris")

