# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModule']

@pulumi.input_type
class ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[builtins.str],
                 custom_config: Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagementOrganizationSecurityHealthAnalyticsCustomModule resource.
        :param pulumi.Input[builtins.str] organization: Numerical ID of the parent organization.
        :param pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs'] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] location: Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        """
        pulumi.set(__self__, "organization", organization)
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enablement_state is not None:
            pulumi.set(__self__, "enablement_state", enablement_state)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[builtins.str]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']]:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']]):
        pulumi.set(self, "custom_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @enablement_state.setter
    def enablement_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enablement_state", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _ManagementOrganizationSecurityHealthAnalyticsCustomModuleState:
    def __init__(__self__, *,
                 ancestor_module: Optional[pulumi.Input[builtins.str]] = None,
                 custom_config: Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[builtins.str]] = None,
                 last_editor: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagementOrganizationSecurityHealthAnalyticsCustomModule resources.
        :param pulumi.Input[builtins.str] ancestor_module: If empty, indicates that the custom module was created in the organization, folder,
               or project in which you are viewing the custom module. Otherwise, ancestor_module
               specifies the organization or folder from which the custom module is inherited.
        :param pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs'] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] last_editor: The editor that last updated the custom module.
        :param pulumi.Input[builtins.str] location: Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        :param pulumi.Input[builtins.str] name: The resource name of the custom module. Its format is "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{securityHealthAnalyticsCustomModule}".
               The id {securityHealthAnalyticsCustomModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        :param pulumi.Input[builtins.str] organization: Numerical ID of the parent organization.
        :param pulumi.Input[builtins.str] update_time: The time at which the custom module was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if ancestor_module is not None:
            pulumi.set(__self__, "ancestor_module", ancestor_module)
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enablement_state is not None:
            pulumi.set(__self__, "enablement_state", enablement_state)
        if last_editor is not None:
            pulumi.set(__self__, "last_editor", last_editor)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="ancestorModule")
    def ancestor_module(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If empty, indicates that the custom module was created in the organization, folder,
        or project in which you are viewing the custom module. Otherwise, ancestor_module
        specifies the organization or folder from which the custom module is inherited.
        """
        return pulumi.get(self, "ancestor_module")

    @ancestor_module.setter
    def ancestor_module(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ancestor_module", value)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']]:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[pulumi.Input['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs']]):
        pulumi.set(self, "custom_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @enablement_state.setter
    def enablement_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enablement_state", value)

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The editor that last updated the custom module.
        """
        return pulumi.get(self, "last_editor")

    @last_editor.setter
    def last_editor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_editor", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the custom module. Its format is "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{securityHealthAnalyticsCustomModule}".
        The id {securityHealthAnalyticsCustomModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the custom module was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule")
class ManagementOrganizationSecurityHealthAnalyticsCustomModule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Union['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents an instance of a Security Health Analytics custom module, including
        its full module name, display name, enablement state, and last updated time.
        You can create a custom module at the organization, folder, or project level.
        Custom modules that you create at the organization or folder level are inherited
        by the child folders and projects.

        To get more information about OrganizationSecurityHealthAnalyticsCustomModule, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/security-center-management/rest/v1/organizations.locations.securityHealthAnalyticsCustomModules)
        * How-to Guides
            * [Overview of custom modules for Security Health Analytics](https://cloud.google.com/security-command-center/docs/custom-modules-sha-overview)

        ## Example Usage

        ### Scc Management Organization Security Health Analytics Custom Module Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.ManagementOrganizationSecurityHealthAnalyticsCustomModule("example",
            organization="123456789",
            display_name="basic_custom_module",
            location="global",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "description": "The rotation period of the identified cryptokey resource exceeds 30 days.",
                "recommendation": "Set the rotation period to at most 30 days.",
                "severity": "MEDIUM",
            })
        ```
        ### Scc Management Organization Security Health Analytics Custom Module Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.ManagementOrganizationSecurityHealthAnalyticsCustomModule("example",
            organization="123456789",
            display_name="full_custom_module",
            location="global",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                    "title": "Purpose of the expression",
                    "description": "description of the expression",
                    "location": "location of the expression",
                },
                "custom_output": {
                    "properties": [{
                        "name": "duration",
                        "value_expression": {
                            "expression": "resource.rotationPeriod",
                            "title": "Purpose of the expression",
                            "description": "description of the expression",
                            "location": "location of the expression",
                        },
                    }],
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "severity": "LOW",
                "description": "Description of the custom module",
                "recommendation": "Steps to resolve violation",
            })
        ```

        ## Import

        OrganizationSecurityHealthAnalyticsCustomModule can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/securityHealthAnalyticsCustomModules/{{name}}`

        * `{{organization}}/{{location}}/{{name}}`

        When using the `pulumi import` command, OrganizationSecurityHealthAnalyticsCustomModule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule default organizations/{{organization}}/locations/{{location}}/securityHealthAnalyticsCustomModules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule default {{organization}}/{{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgsDict']] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] location: Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        :param pulumi.Input[builtins.str] organization: Numerical ID of the parent organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an instance of a Security Health Analytics custom module, including
        its full module name, display name, enablement state, and last updated time.
        You can create a custom module at the organization, folder, or project level.
        Custom modules that you create at the organization or folder level are inherited
        by the child folders and projects.

        To get more information about OrganizationSecurityHealthAnalyticsCustomModule, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/security-center-management/rest/v1/organizations.locations.securityHealthAnalyticsCustomModules)
        * How-to Guides
            * [Overview of custom modules for Security Health Analytics](https://cloud.google.com/security-command-center/docs/custom-modules-sha-overview)

        ## Example Usage

        ### Scc Management Organization Security Health Analytics Custom Module Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.ManagementOrganizationSecurityHealthAnalyticsCustomModule("example",
            organization="123456789",
            display_name="basic_custom_module",
            location="global",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "description": "The rotation period of the identified cryptokey resource exceeds 30 days.",
                "recommendation": "Set the rotation period to at most 30 days.",
                "severity": "MEDIUM",
            })
        ```
        ### Scc Management Organization Security Health Analytics Custom Module Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.ManagementOrganizationSecurityHealthAnalyticsCustomModule("example",
            organization="123456789",
            display_name="full_custom_module",
            location="global",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                    "title": "Purpose of the expression",
                    "description": "description of the expression",
                    "location": "location of the expression",
                },
                "custom_output": {
                    "properties": [{
                        "name": "duration",
                        "value_expression": {
                            "expression": "resource.rotationPeriod",
                            "title": "Purpose of the expression",
                            "description": "description of the expression",
                            "location": "location of the expression",
                        },
                    }],
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "severity": "LOW",
                "description": "Description of the custom module",
                "recommendation": "Steps to resolve violation",
            })
        ```

        ## Import

        OrganizationSecurityHealthAnalyticsCustomModule can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/securityHealthAnalyticsCustomModules/{{name}}`

        * `{{organization}}/{{location}}/{{name}}`

        When using the `pulumi import` command, OrganizationSecurityHealthAnalyticsCustomModule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule default organizations/{{organization}}/locations/{{location}}/securityHealthAnalyticsCustomModules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule default {{organization}}/{{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Union['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs.__new__(ManagementOrganizationSecurityHealthAnalyticsCustomModuleArgs)

            __props__.__dict__["custom_config"] = custom_config
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enablement_state"] = enablement_state
            __props__.__dict__["location"] = location
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["ancestor_module"] = None
            __props__.__dict__["last_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(ManagementOrganizationSecurityHealthAnalyticsCustomModule, __self__).__init__(
            'gcp:securitycenter/managementOrganizationSecurityHealthAnalyticsCustomModule:ManagementOrganizationSecurityHealthAnalyticsCustomModule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ancestor_module: Optional[pulumi.Input[builtins.str]] = None,
            custom_config: Optional[pulumi.Input[Union['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            enablement_state: Optional[pulumi.Input[builtins.str]] = None,
            last_editor: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagementOrganizationSecurityHealthAnalyticsCustomModule':
        """
        Get an existing ManagementOrganizationSecurityHealthAnalyticsCustomModule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ancestor_module: If empty, indicates that the custom module was created in the organization, folder,
               or project in which you are viewing the custom module. Otherwise, ancestor_module
               specifies the organization or folder from which the custom module is inherited.
        :param pulumi.Input[Union['ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgs', 'ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfigArgsDict']] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] last_editor: The editor that last updated the custom module.
        :param pulumi.Input[builtins.str] location: Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        :param pulumi.Input[builtins.str] name: The resource name of the custom module. Its format is "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{securityHealthAnalyticsCustomModule}".
               The id {securityHealthAnalyticsCustomModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        :param pulumi.Input[builtins.str] organization: Numerical ID of the parent organization.
        :param pulumi.Input[builtins.str] update_time: The time at which the custom module was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementOrganizationSecurityHealthAnalyticsCustomModuleState.__new__(_ManagementOrganizationSecurityHealthAnalyticsCustomModuleState)

        __props__.__dict__["ancestor_module"] = ancestor_module
        __props__.__dict__["custom_config"] = custom_config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enablement_state"] = enablement_state
        __props__.__dict__["last_editor"] = last_editor
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["update_time"] = update_time
        return ManagementOrganizationSecurityHealthAnalyticsCustomModule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ancestorModule")
    def ancestor_module(self) -> pulumi.Output[builtins.str]:
        """
        If empty, indicates that the custom module was created in the organization, folder,
        or project in which you are viewing the custom module. Otherwise, ancestor_module
        specifies the organization or folder from which the custom module is inherited.
        """
        return pulumi.get(self, "ancestor_module")

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> pulumi.Output[Optional['outputs.ManagementOrganizationSecurityHealthAnalyticsCustomModuleCustomConfig']]:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> pulumi.Output[builtins.str]:
        """
        The editor that last updated the custom module.
        """
        return pulumi.get(self, "last_editor")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location ID of the parent organization. If not provided, 'global' will be used as the default location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the custom module. Its format is "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{securityHealthAnalyticsCustomModule}".
        The id {securityHealthAnalyticsCustomModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[builtins.str]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the custom module was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

