# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['V2FolderSccBigQueryExportArgs', 'V2FolderSccBigQueryExport']

@pulumi.input_type
class V2FolderSccBigQueryExportArgs:
    def __init__(__self__, *,
                 big_query_export_id: pulumi.Input[builtins.str],
                 folder: pulumi.Input[builtins.str],
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a V2FolderSccBigQueryExport resource.
        :param pulumi.Input[builtins.str] big_query_export_id: This must be unique within the organization.  It must consist of only lowercase letters,
               numbers, and hyphens, must start with a letter, must end with either a letter or a number,
               and must be 63 characters or less.
        :param pulumi.Input[builtins.str] folder: The folder where Cloud Security Command Center Big Query Export
               Config lives in.
        :param pulumi.Input[builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * >, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[builtins.str] location: The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        """
        pulumi.set(__self__, "big_query_export_id", big_query_export_id)
        pulumi.set(__self__, "folder", folder)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> pulumi.Input[builtins.str]:
        """
        This must be unique within the organization.  It must consist of only lowercase letters,
        numbers, and hyphens, must start with a letter, must end with either a letter or a number,
        and must be 63 characters or less.
        """
        return pulumi.get(self, "big_query_export_id")

    @big_query_export_id.setter
    def big_query_export_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "big_query_export_id", value)

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Input[builtins.str]:
        """
        The folder where Cloud Security Command Center Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * >, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _V2FolderSccBigQueryExportState:
    def __init__(__self__, *,
                 big_query_export_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 most_recent_editor: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering V2FolderSccBigQueryExport resources.
        :param pulumi.Input[builtins.str] big_query_export_id: This must be unique within the organization.  It must consist of only lowercase letters,
               numbers, and hyphens, must start with a letter, must end with either a letter or a number,
               and must be 63 characters or less.
        :param pulumi.Input[builtins.str] create_time: The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * >, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[builtins.str] folder: The folder where Cloud Security Command Center Big Query Export
               Config lives in.
        :param pulumi.Input[builtins.str] location: The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        :param pulumi.Input[builtins.str] most_recent_editor: Email address of the user who last edited the BigQuery export.
               This field is set by the server and will be ignored if provided on export creation or update.
        :param pulumi.Input[builtins.str] name: The resource name of this export, in the format
               `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`.
               This field is provided in responses, and is ignored when provided in create requests.
        :param pulumi.Input[builtins.str] principal: The service account that needs permission to create table and upload data to the BigQuery dataset.
        :param pulumi.Input[builtins.str] update_time: The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if big_query_export_id is not None:
            pulumi.set(__self__, "big_query_export_id", big_query_export_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if most_recent_editor is not None:
            pulumi.set(__self__, "most_recent_editor", most_recent_editor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This must be unique within the organization.  It must consist of only lowercase letters,
        numbers, and hyphens, must start with a letter, must end with either a letter or a number,
        and must be 63 characters or less.
        """
        return pulumi.get(self, "big_query_export_id")

    @big_query_export_id.setter
    def big_query_export_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "big_query_export_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * >, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The folder where Cloud Security Command Center Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the user who last edited the BigQuery export.
        This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @most_recent_editor.setter
    def most_recent_editor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "most_recent_editor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of this export, in the format
        `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`.
        This field is provided in responses, and is ignored when provided in create requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service account that needs permission to create table and upload data to the BigQuery dataset.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport")
class V2FolderSccBigQueryExport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_export_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Security Command Center (Cloud SCC) Big Query Export Config.
        It represents exporting Security Command Center data, including assets, findings, and security marks
        using gcloud scc bqexports
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about FolderSccBigQueryExport, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/folders.locations.bigQueryExports)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs/how-to-analyze-findings-in-big-query)

        ## Example Usage

        ### Scc V2 Folder Big Query Export Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name",
            deletion_protection=False)
        default = gcp.bigquery.Dataset("default",
            dataset_id="my_dataset_id",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_partition_expiration_ms=None,
            labels={
                "env": "default",
            })
        custom_big_query_export_config = gcp.securitycenter.V2FolderSccBigQueryExport("custom_big_query_export_config",
            big_query_export_id="my-export",
            folder=folder.folder_id,
            dataset=default.id,
            location="global",
            description="Cloud Security Command Center Findings Big Query Export Config",
            filter="state=\\"ACTIVE\\" AND NOT mute=\\"MUTED\\"")
        ```

        ## Import

        FolderSccBigQueryExport can be imported using any of these accepted formats:

        * `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`

        * `{{folder}}/{{location}}/{{big_query_export_id}}`

        When using the `pulumi import` command, FolderSccBigQueryExport can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport default folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport default {{folder}}/{{location}}/{{big_query_export_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] big_query_export_id: This must be unique within the organization.  It must consist of only lowercase letters,
               numbers, and hyphens, must start with a letter, must end with either a letter or a number,
               and must be 63 characters or less.
        :param pulumi.Input[builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * >, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[builtins.str] folder: The folder where Cloud Security Command Center Big Query Export
               Config lives in.
        :param pulumi.Input[builtins.str] location: The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2FolderSccBigQueryExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Security Command Center (Cloud SCC) Big Query Export Config.
        It represents exporting Security Command Center data, including assets, findings, and security marks
        using gcloud scc bqexports
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about FolderSccBigQueryExport, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/folders.locations.bigQueryExports)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs/how-to-analyze-findings-in-big-query)

        ## Example Usage

        ### Scc V2 Folder Big Query Export Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name",
            deletion_protection=False)
        default = gcp.bigquery.Dataset("default",
            dataset_id="my_dataset_id",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_partition_expiration_ms=None,
            labels={
                "env": "default",
            })
        custom_big_query_export_config = gcp.securitycenter.V2FolderSccBigQueryExport("custom_big_query_export_config",
            big_query_export_id="my-export",
            folder=folder.folder_id,
            dataset=default.id,
            location="global",
            description="Cloud Security Command Center Findings Big Query Export Config",
            filter="state=\\"ACTIVE\\" AND NOT mute=\\"MUTED\\"")
        ```

        ## Import

        FolderSccBigQueryExport can be imported using any of these accepted formats:

        * `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`

        * `{{folder}}/{{location}}/{{big_query_export_id}}`

        When using the `pulumi import` command, FolderSccBigQueryExport can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport default folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport default {{folder}}/{{location}}/{{big_query_export_id}}
        ```

        :param str resource_name: The name of the resource.
        :param V2FolderSccBigQueryExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2FolderSccBigQueryExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_export_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2FolderSccBigQueryExportArgs.__new__(V2FolderSccBigQueryExportArgs)

            if big_query_export_id is None and not opts.urn:
                raise TypeError("Missing required property 'big_query_export_id'")
            __props__.__dict__["big_query_export_id"] = big_query_export_id
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            __props__.__dict__["filter"] = filter
            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            __props__.__dict__["location"] = location
            __props__.__dict__["create_time"] = None
            __props__.__dict__["most_recent_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["principal"] = None
            __props__.__dict__["update_time"] = None
        super(V2FolderSccBigQueryExport, __self__).__init__(
            'gcp:securitycenter/v2FolderSccBigQueryExport:V2FolderSccBigQueryExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            big_query_export_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            dataset: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            folder: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            most_recent_editor: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            principal: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'V2FolderSccBigQueryExport':
        """
        Get an existing V2FolderSccBigQueryExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] big_query_export_id: This must be unique within the organization.  It must consist of only lowercase letters,
               numbers, and hyphens, must start with a letter, must end with either a letter or a number,
               and must be 63 characters or less.
        :param pulumi.Input[builtins.str] create_time: The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * >, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[builtins.str] folder: The folder where Cloud Security Command Center Big Query Export
               Config lives in.
        :param pulumi.Input[builtins.str] location: The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        :param pulumi.Input[builtins.str] most_recent_editor: Email address of the user who last edited the BigQuery export.
               This field is set by the server and will be ignored if provided on export creation or update.
        :param pulumi.Input[builtins.str] name: The resource name of this export, in the format
               `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`.
               This field is provided in responses, and is ignored when provided in create requests.
        :param pulumi.Input[builtins.str] principal: The service account that needs permission to create table and upload data to the BigQuery dataset.
        :param pulumi.Input[builtins.str] update_time: The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2FolderSccBigQueryExportState.__new__(_V2FolderSccBigQueryExportState)

        __props__.__dict__["big_query_export_id"] = big_query_export_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["folder"] = folder
        __props__.__dict__["location"] = location
        __props__.__dict__["most_recent_editor"] = most_recent_editor
        __props__.__dict__["name"] = name
        __props__.__dict__["principal"] = principal
        __props__.__dict__["update_time"] = update_time
        return V2FolderSccBigQueryExport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> pulumi.Output[builtins.str]:
        """
        This must be unique within the organization.  It must consist of only lowercase letters,
        numbers, and hyphens, must start with a letter, must end with either a letter or a number,
        and must be 63 characters or less.
        """
        return pulumi.get(self, "big_query_export_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * >, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[builtins.str]:
        """
        The folder where Cloud Security Command Center Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The BigQuery export configuration is stored in this location. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the user who last edited the BigQuery export.
        This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of this export, in the format
        `folders/{{folder}}/locations/{{location}}/bigQueryExports/{{big_query_export_id}}`.
        This field is provided in responses, and is ignored when provided in create requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[builtins.str]:
        """
        The service account that needs permission to create table and upload data to the BigQuery dataset.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

