# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcServiceControlsArgs', 'VpcServiceControls']

@pulumi.input_type
class VpcServiceControlsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 network: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcServiceControls resource.
        :param pulumi.Input[builtins.bool] enabled: Desired VPC Service Controls state service producer VPC network, as
               described at the top of this page.
        :param pulumi.Input[builtins.str] network: The network that the consumer is using to connect with services.
        :param pulumi.Input[builtins.str] service: The service that is managing peering connectivity for a service
               producer's organization. For Google services that support this
               functionality, this value is `servicenetworking.googleapis.com`.
        :param pulumi.Input[builtins.str] project: The id of the Google Cloud project containing the consumer network.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "service", service)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Desired VPC Service Controls state service producer VPC network, as
        described at the top of this page.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The network that the consumer is using to connect with services.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        The service that is managing peering connectivity for a service
        producer's organization. For Google services that support this
        functionality, this value is `servicenetworking.googleapis.com`.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the Google Cloud project containing the consumer network.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _VpcServiceControlsState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcServiceControls resources.
        :param pulumi.Input[builtins.bool] enabled: Desired VPC Service Controls state service producer VPC network, as
               described at the top of this page.
        :param pulumi.Input[builtins.str] network: The network that the consumer is using to connect with services.
        :param pulumi.Input[builtins.str] project: The id of the Google Cloud project containing the consumer network.
        :param pulumi.Input[builtins.str] service: The service that is managing peering connectivity for a service
               producer's organization. For Google services that support this
               functionality, this value is `servicenetworking.googleapis.com`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Desired VPC Service Controls state service producer VPC network, as
        described at the top of this page.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network that the consumer is using to connect with services.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the Google Cloud project containing the consumer network.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service that is managing peering connectivity for a service
        producer's organization. For Google services that support this
        functionality, this value is `servicenetworking.googleapis.com`.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)


@pulumi.type_token("gcp:servicenetworking/vpcServiceControls:VpcServiceControls")
class VpcServiceControls(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the VPC Service Controls configuration for a service
        networking connection

        When enabled, Google Cloud makes the following
        route configuration changes in the service producer VPC network:
        - Removes the IPv4 default route (destination 0.0.0.0/0,
          next hop default internet gateway), Google Cloud then creates an
          IPv4 route for destination 199.36.153.4/30 using the default
          internet gateway next hop.
        - Creates Cloud DNS managed private zones and authorizes those zones
          for the service producer VPC network. The zones include
          googleapis.com, gcr.io, pkg.dev, notebooks.cloud.google.com,
          kernels.googleusercontent.com, backupdr.cloud.google.com, and
          backupdr.googleusercontent.com as necessary domains or host names
          for Google APIs and services that are compatible with VPC Service
          Controls. Record data in the zones resolves all host names to
          199.36.153.4, 199.36.153.5, 199.36.153.6, and 199.36.153.7.

        When disabled, Google Cloud makes the following route configuration
        changes in the service producer VPC network:
        - Restores a default route (destination 0.0.0.0/0, next hop default
          internet gateway)
        - Deletes the Cloud DNS managed private zones that provided the host
          name overrides.

        To get more information about VPCServiceControls, see:

        * [API documentation](https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/v1/services)
        * How-to Guides
            * [Enable VPC Service Controls for service networking](https://cloud.google.com/sdk/gcloud/reference/services/vpc-peerings/enable-vpc-service-controls)
            * [Private Google Access with VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/private-connectivity)
            * [Set up private connectivity to Google APIs and services](https://cloud.google.com/vpc-service-controls/docs/set-up-private-connectivity)

        > **Note:** Destroying a `servicenetworking.VpcServiceControls`
        resource will remove it from state, but will not change the
        underlying VPC Service Controls configuration for the service
        producer network.

        ## Example Usage

        ### Service Networking Vpc Service Controls Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a VPC
        default = gcp.compute.Network("default", name="example-network")
        # Create an IP address
        default_global_address = gcp.compute.GlobalAddress("default",
            name="psa-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=default.id)
        # Create a private connection
        default_connection = gcp.servicenetworking.Connection("default",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[default_global_address.name])
        # Enable VPC-SC on the producer network
        default_vpc_service_controls = gcp.servicenetworking.VpcServiceControls("default",
            network=default.name,
            service="servicenetworking.googleapis.com",
            enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default_connection]))
        ```

        ## Import

        VPCServiceControls can be imported using any of these accepted formats:

        * `services/{{service}}/projects/{{project}}/networks/{{network}}`

        * `{{service}}/{{project}}/{{network}}`

        * `{{service}}/{{network}}`

        When using the `pulumi import` command, VPCServiceControls can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default services/{{service}}/projects/{{project}}/networks/{{network}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default {{service}}/{{project}}/{{network}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default {{service}}/{{network}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Desired VPC Service Controls state service producer VPC network, as
               described at the top of this page.
        :param pulumi.Input[builtins.str] network: The network that the consumer is using to connect with services.
        :param pulumi.Input[builtins.str] project: The id of the Google Cloud project containing the consumer network.
        :param pulumi.Input[builtins.str] service: The service that is managing peering connectivity for a service
               producer's organization. For Google services that support this
               functionality, this value is `servicenetworking.googleapis.com`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcServiceControlsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the VPC Service Controls configuration for a service
        networking connection

        When enabled, Google Cloud makes the following
        route configuration changes in the service producer VPC network:
        - Removes the IPv4 default route (destination 0.0.0.0/0,
          next hop default internet gateway), Google Cloud then creates an
          IPv4 route for destination 199.36.153.4/30 using the default
          internet gateway next hop.
        - Creates Cloud DNS managed private zones and authorizes those zones
          for the service producer VPC network. The zones include
          googleapis.com, gcr.io, pkg.dev, notebooks.cloud.google.com,
          kernels.googleusercontent.com, backupdr.cloud.google.com, and
          backupdr.googleusercontent.com as necessary domains or host names
          for Google APIs and services that are compatible with VPC Service
          Controls. Record data in the zones resolves all host names to
          199.36.153.4, 199.36.153.5, 199.36.153.6, and 199.36.153.7.

        When disabled, Google Cloud makes the following route configuration
        changes in the service producer VPC network:
        - Restores a default route (destination 0.0.0.0/0, next hop default
          internet gateway)
        - Deletes the Cloud DNS managed private zones that provided the host
          name overrides.

        To get more information about VPCServiceControls, see:

        * [API documentation](https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/v1/services)
        * How-to Guides
            * [Enable VPC Service Controls for service networking](https://cloud.google.com/sdk/gcloud/reference/services/vpc-peerings/enable-vpc-service-controls)
            * [Private Google Access with VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/private-connectivity)
            * [Set up private connectivity to Google APIs and services](https://cloud.google.com/vpc-service-controls/docs/set-up-private-connectivity)

        > **Note:** Destroying a `servicenetworking.VpcServiceControls`
        resource will remove it from state, but will not change the
        underlying VPC Service Controls configuration for the service
        producer network.

        ## Example Usage

        ### Service Networking Vpc Service Controls Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a VPC
        default = gcp.compute.Network("default", name="example-network")
        # Create an IP address
        default_global_address = gcp.compute.GlobalAddress("default",
            name="psa-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=default.id)
        # Create a private connection
        default_connection = gcp.servicenetworking.Connection("default",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[default_global_address.name])
        # Enable VPC-SC on the producer network
        default_vpc_service_controls = gcp.servicenetworking.VpcServiceControls("default",
            network=default.name,
            service="servicenetworking.googleapis.com",
            enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default_connection]))
        ```

        ## Import

        VPCServiceControls can be imported using any of these accepted formats:

        * `services/{{service}}/projects/{{project}}/networks/{{network}}`

        * `{{service}}/{{project}}/{{network}}`

        * `{{service}}/{{network}}`

        When using the `pulumi import` command, VPCServiceControls can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default services/{{service}}/projects/{{project}}/networks/{{network}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default {{service}}/{{project}}/{{network}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/vpcServiceControls:VpcServiceControls default {{service}}/{{network}}
        ```

        :param str resource_name: The name of the resource.
        :param VpcServiceControlsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcServiceControlsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcServiceControlsArgs.__new__(VpcServiceControlsArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
        super(VpcServiceControls, __self__).__init__(
            'gcp:servicenetworking/vpcServiceControls:VpcServiceControls',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None) -> 'VpcServiceControls':
        """
        Get an existing VpcServiceControls resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Desired VPC Service Controls state service producer VPC network, as
               described at the top of this page.
        :param pulumi.Input[builtins.str] network: The network that the consumer is using to connect with services.
        :param pulumi.Input[builtins.str] project: The id of the Google Cloud project containing the consumer network.
        :param pulumi.Input[builtins.str] service: The service that is managing peering connectivity for a service
               producer's organization. For Google services that support this
               functionality, this value is `servicenetworking.googleapis.com`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcServiceControlsState.__new__(_VpcServiceControlsState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["service"] = service
        return VpcServiceControls(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Desired VPC Service Controls state service producer VPC network, as
        described at the top of this page.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The network that the consumer is using to connect with services.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The id of the Google Cloud project containing the consumer network.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        The service that is managing peering connectivity for a service
        producer's organization. For Google services that support this
        functionality, this value is `servicenetworking.googleapis.com`.
        """
        return pulumi.get(self, "service")

