# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTokenResult',
    'AwaitableGetTokenResult',
    'get_token',
    'get_token_output',
]

@pulumi.output_type
class GetTokenResult:
    """
    A collection of values returned by getToken.
    """
    def __init__(__self__, id=None, identifier=None, token=None, type=None, verification_method=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if verification_method and not isinstance(verification_method, str):
            raise TypeError("Expected argument 'verification_method' to be a str")
        pulumi.set(__self__, "verification_method", verification_method)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The generated token for use in subsequent verification steps.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="verificationMethod")
    def verification_method(self) -> builtins.str:
        return pulumi.get(self, "verification_method")


class AwaitableGetTokenResult(GetTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTokenResult(
            id=self.id,
            identifier=self.identifier,
            token=self.token,
            type=self.type,
            verification_method=self.verification_method)


def get_token(identifier: Optional[builtins.str] = None,
              type: Optional[builtins.str] = None,
              verification_method: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTokenResult:
    """
    A verification token is used to demonstrate ownership of a website or domain.

    To get more information about Token, see:

    * [API documentation](https://developers.google.com/site-verification/v1)
    * How-to Guides
        * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

    ## Example Usage

    ### Site Verification Via Site META Tag

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.siteverification.get_token(type="SITE",
        identifier="https://www.example.com",
        verification_method="META")
    ```

    ### Site Verification Via DNS TXT Record

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.siteverification.get_token(type="INET_DOMAIN",
        identifier="www.example.com",
        verification_method="DNS_TXT")
    ```


    :param builtins.str identifier: The site identifier. If the type is set to SITE, the identifier is a URL. If the type is
           set to INET_DOMAIN, the identifier is a domain name.
    :param builtins.str type: The type of resource to be verified, either a domain or a web site.
           Possible values are: `INET_DOMAIN`, `SITE`.
    :param builtins.str verification_method: The verification method for the Site Verification system to use to verify
           this site or domain.
           Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
           
           
           - - -
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['type'] = type
    __args__['verificationMethod'] = verification_method
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:siteverification/getToken:getToken', __args__, opts=opts, typ=GetTokenResult).value

    return AwaitableGetTokenResult(
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        token=pulumi.get(__ret__, 'token'),
        type=pulumi.get(__ret__, 'type'),
        verification_method=pulumi.get(__ret__, 'verification_method'))
def get_token_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                     type: Optional[pulumi.Input[builtins.str]] = None,
                     verification_method: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTokenResult]:
    """
    A verification token is used to demonstrate ownership of a website or domain.

    To get more information about Token, see:

    * [API documentation](https://developers.google.com/site-verification/v1)
    * How-to Guides
        * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

    ## Example Usage

    ### Site Verification Via Site META Tag

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.siteverification.get_token(type="SITE",
        identifier="https://www.example.com",
        verification_method="META")
    ```

    ### Site Verification Via DNS TXT Record

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.siteverification.get_token(type="INET_DOMAIN",
        identifier="www.example.com",
        verification_method="DNS_TXT")
    ```


    :param builtins.str identifier: The site identifier. If the type is set to SITE, the identifier is a URL. If the type is
           set to INET_DOMAIN, the identifier is a domain name.
    :param builtins.str type: The type of resource to be verified, either a domain or a web site.
           Possible values are: `INET_DOMAIN`, `SITE`.
    :param builtins.str verification_method: The verification method for the Site Verification system to use to verify
           this site or domain.
           Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
           
           
           - - -
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['type'] = type
    __args__['verificationMethod'] = verification_method
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:siteverification/getToken:getToken', __args__, opts=opts, typ=GetTokenResult)
    return __ret__.apply(lambda __response__: GetTokenResult(
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        token=pulumi.get(__response__, 'token'),
        type=pulumi.get(__response__, 'type'),
        verification_method=pulumi.get(__response__, 'verification_method')))
