# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupScheduleEncryptionConfigArgs',
    'BackupScheduleEncryptionConfigArgsDict',
    'BackupScheduleFullBackupSpecArgs',
    'BackupScheduleFullBackupSpecArgsDict',
    'BackupScheduleIncrementalBackupSpecArgs',
    'BackupScheduleIncrementalBackupSpecArgsDict',
    'BackupScheduleSpecArgs',
    'BackupScheduleSpecArgsDict',
    'BackupScheduleSpecCronSpecArgs',
    'BackupScheduleSpecCronSpecArgsDict',
    'DatabaseEncryptionConfigArgs',
    'DatabaseEncryptionConfigArgsDict',
    'DatabaseIAMBindingConditionArgs',
    'DatabaseIAMBindingConditionArgsDict',
    'DatabaseIAMMemberConditionArgs',
    'DatabaseIAMMemberConditionArgsDict',
    'InstanceAutoscalingConfigArgs',
    'InstanceAutoscalingConfigArgsDict',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgsDict',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgsDict',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgsDict',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgsDict',
    'InstanceAutoscalingConfigAutoscalingLimitsArgs',
    'InstanceAutoscalingConfigAutoscalingLimitsArgsDict',
    'InstanceAutoscalingConfigAutoscalingTargetsArgs',
    'InstanceAutoscalingConfigAutoscalingTargetsArgsDict',
    'InstanceConfigReplicaArgs',
    'InstanceConfigReplicaArgsDict',
    'InstanceIAMBindingConditionArgs',
    'InstanceIAMBindingConditionArgsDict',
    'InstanceIAMMemberConditionArgs',
    'InstanceIAMMemberConditionArgsDict',
]

MYPY = False

if not MYPY:
    class BackupScheduleEncryptionConfigArgsDict(TypedDict):
        encryption_type: pulumi.Input[builtins.str]
        """
        The encryption type of backups created by the backup schedule.
        Possible values are USE_DATABASE_ENCRYPTION, GOOGLE_DEFAULT_ENCRYPTION, or CUSTOMER_MANAGED_ENCRYPTION.
        If you use CUSTOMER_MANAGED_ENCRYPTION, you must specify a kmsKeyName.
        If your backup type is incremental-backup, the encryption type must be GOOGLE_DEFAULT_ENCRYPTION.
        Possible values are: `USE_DATABASE_ENCRYPTION`, `GOOGLE_DEFAULT_ENCRYPTION`, `CUSTOMER_MANAGED_ENCRYPTION`.
        """
        kms_key_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Cloud KMS key to use for encryption.
        Format: 'projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}'
        """
        kms_key_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
elif False:
    BackupScheduleEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupScheduleEncryptionConfigArgs:
    def __init__(__self__, *,
                 encryption_type: pulumi.Input[builtins.str],
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] encryption_type: The encryption type of backups created by the backup schedule.
               Possible values are USE_DATABASE_ENCRYPTION, GOOGLE_DEFAULT_ENCRYPTION, or CUSTOMER_MANAGED_ENCRYPTION.
               If you use CUSTOMER_MANAGED_ENCRYPTION, you must specify a kmsKeyName.
               If your backup type is incremental-backup, the encryption type must be GOOGLE_DEFAULT_ENCRYPTION.
               Possible values are: `USE_DATABASE_ENCRYPTION`, `GOOGLE_DEFAULT_ENCRYPTION`, `CUSTOMER_MANAGED_ENCRYPTION`.
        :param pulumi.Input[builtins.str] kms_key_name: The resource name of the Cloud KMS key to use for encryption.
               Format: 'projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}'
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] kms_key_names: Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
               in the same locations as the Spanner Database.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_names is not None:
            pulumi.set(__self__, "kms_key_names", kms_key_names)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input[builtins.str]:
        """
        The encryption type of backups created by the backup schedule.
        Possible values are USE_DATABASE_ENCRYPTION, GOOGLE_DEFAULT_ENCRYPTION, or CUSTOMER_MANAGED_ENCRYPTION.
        If you use CUSTOMER_MANAGED_ENCRYPTION, you must specify a kmsKeyName.
        If your backup type is incremental-backup, the encryption type must be GOOGLE_DEFAULT_ENCRYPTION.
        Possible values are: `USE_DATABASE_ENCRYPTION`, `GOOGLE_DEFAULT_ENCRYPTION`, `CUSTOMER_MANAGED_ENCRYPTION`.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Cloud KMS key to use for encryption.
        Format: 'projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}'
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="kmsKeyNames")
    def kms_key_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_names")

    @kms_key_names.setter
    def kms_key_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "kms_key_names", value)


if not MYPY:
    class BackupScheduleFullBackupSpecArgsDict(TypedDict):
        pass
elif False:
    BackupScheduleFullBackupSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupScheduleFullBackupSpecArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class BackupScheduleIncrementalBackupSpecArgsDict(TypedDict):
        pass
elif False:
    BackupScheduleIncrementalBackupSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupScheduleIncrementalBackupSpecArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class BackupScheduleSpecArgsDict(TypedDict):
        cron_spec: NotRequired[pulumi.Input['BackupScheduleSpecCronSpecArgsDict']]
        """
        Cron style schedule specification..
        Structure is documented below.
        """
elif False:
    BackupScheduleSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupScheduleSpecArgs:
    def __init__(__self__, *,
                 cron_spec: Optional[pulumi.Input['BackupScheduleSpecCronSpecArgs']] = None):
        """
        :param pulumi.Input['BackupScheduleSpecCronSpecArgs'] cron_spec: Cron style schedule specification..
               Structure is documented below.
        """
        if cron_spec is not None:
            pulumi.set(__self__, "cron_spec", cron_spec)

    @property
    @pulumi.getter(name="cronSpec")
    def cron_spec(self) -> Optional[pulumi.Input['BackupScheduleSpecCronSpecArgs']]:
        """
        Cron style schedule specification..
        Structure is documented below.
        """
        return pulumi.get(self, "cron_spec")

    @cron_spec.setter
    def cron_spec(self, value: Optional[pulumi.Input['BackupScheduleSpecCronSpecArgs']]):
        pulumi.set(self, "cron_spec", value)


if not MYPY:
    class BackupScheduleSpecCronSpecArgsDict(TypedDict):
        text: NotRequired[pulumi.Input[builtins.str]]
        """
        Textual representation of the crontab. User can customize the
        backup frequency and the backup version time using the cron
        expression. The version time must be in UTC timzeone.
        The backup will contain an externally consistent copy of the
        database at the version time. Allowed frequencies are 12 hour, 1 day,
        1 week and 1 month. Examples of valid cron specifications:
        0 2/12 * * * : every 12 hours at (2, 14) hours past midnight in UTC.
        0 2,14 * * * : every 12 hours at (2,14) hours past midnight in UTC.
        0 2 * * *    : once a day at 2 past midnight in UTC.
        0 2 * * 0    : once a week every Sunday at 2 past midnight in UTC.
        0 2 8 * *    : once a month on 8th day at 2 past midnight in UTC.
        """
elif False:
    BackupScheduleSpecCronSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupScheduleSpecCronSpecArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] text: Textual representation of the crontab. User can customize the
               backup frequency and the backup version time using the cron
               expression. The version time must be in UTC timzeone.
               The backup will contain an externally consistent copy of the
               database at the version time. Allowed frequencies are 12 hour, 1 day,
               1 week and 1 month. Examples of valid cron specifications:
               0 2/12 * * * : every 12 hours at (2, 14) hours past midnight in UTC.
               0 2,14 * * * : every 12 hours at (2,14) hours past midnight in UTC.
               0 2 * * *    : once a day at 2 past midnight in UTC.
               0 2 * * 0    : once a week every Sunday at 2 past midnight in UTC.
               0 2 8 * *    : once a month on 8th day at 2 past midnight in UTC.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Textual representation of the crontab. User can customize the
        backup frequency and the backup version time using the cron
        expression. The version time must be in UTC timzeone.
        The backup will contain an externally consistent copy of the
        database at the version time. Allowed frequencies are 12 hour, 1 day,
        1 week and 1 month. Examples of valid cron specifications:
        0 2/12 * * * : every 12 hours at (2, 14) hours past midnight in UTC.
        0 2,14 * * * : every 12 hours at (2,14) hours past midnight in UTC.
        0 2 * * *    : once a day at 2 past midnight in UTC.
        0 2 * * 0    : once a week every Sunday at 2 past midnight in UTC.
        0 2 8 * *    : once a month on 8th day at 2 past midnight in UTC.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "text", value)


if not MYPY:
    class DatabaseEncryptionConfigArgsDict(TypedDict):
        kms_key_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified name of the KMS key to use to encrypt this database. This key must exist
        in the same location as the Spanner Database.
        """
        kms_key_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
elif False:
    DatabaseEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_name: Fully qualified name of the KMS key to use to encrypt this database. This key must exist
               in the same location as the Spanner Database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] kms_key_names: Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
               in the same locations as the Spanner Database.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_names is not None:
            pulumi.set(__self__, "kms_key_names", kms_key_names)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified name of the KMS key to use to encrypt this database. This key must exist
        in the same location as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="kmsKeyNames")
    def kms_key_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_names")

    @kms_key_names.setter
    def kms_key_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "kms_key_names", value)


if not MYPY:
    class DatabaseIAMBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DatabaseIAMBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class DatabaseIAMMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DatabaseIAMMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class InstanceAutoscalingConfigArgsDict(TypedDict):
        asymmetric_autoscaling_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgsDict']]]]
        """
        Asymmetric autoscaling options for specific replicas.
        Structure is documented below.
        """
        autoscaling_limits: NotRequired[pulumi.Input['InstanceAutoscalingConfigAutoscalingLimitsArgsDict']]
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events. Users can define the minimum and
        maximum compute capacity allocated to the instance, and the autoscaler will
        only scale within that range. Users can either use nodes or processing
        units to specify the limits, but should use the same unit to set both the
        min_limit and max_limit.
        Structure is documented below.
        """
        autoscaling_targets: NotRequired[pulumi.Input['InstanceAutoscalingConfigAutoscalingTargetsArgsDict']]
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events
        Structure is documented below.
        """
elif False:
    InstanceAutoscalingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigArgs:
    def __init__(__self__, *,
                 asymmetric_autoscaling_options: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs']]]] = None,
                 autoscaling_limits: Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingLimitsArgs']] = None,
                 autoscaling_targets: Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingTargetsArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs']]] asymmetric_autoscaling_options: Asymmetric autoscaling options for specific replicas.
               Structure is documented below.
        :param pulumi.Input['InstanceAutoscalingConfigAutoscalingLimitsArgs'] autoscaling_limits: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events. Users can define the minimum and
               maximum compute capacity allocated to the instance, and the autoscaler will
               only scale within that range. Users can either use nodes or processing
               units to specify the limits, but should use the same unit to set both the
               min_limit and max_limit.
               Structure is documented below.
        :param pulumi.Input['InstanceAutoscalingConfigAutoscalingTargetsArgs'] autoscaling_targets: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events
               Structure is documented below.
        """
        if asymmetric_autoscaling_options is not None:
            pulumi.set(__self__, "asymmetric_autoscaling_options", asymmetric_autoscaling_options)
        if autoscaling_limits is not None:
            pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)
        if autoscaling_targets is not None:
            pulumi.set(__self__, "autoscaling_targets", autoscaling_targets)

    @property
    @pulumi.getter(name="asymmetricAutoscalingOptions")
    def asymmetric_autoscaling_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs']]]]:
        """
        Asymmetric autoscaling options for specific replicas.
        Structure is documented below.
        """
        return pulumi.get(self, "asymmetric_autoscaling_options")

    @asymmetric_autoscaling_options.setter
    def asymmetric_autoscaling_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs']]]]):
        pulumi.set(self, "asymmetric_autoscaling_options", value)

    @property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingLimitsArgs']]:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events. Users can define the minimum and
        maximum compute capacity allocated to the instance, and the autoscaler will
        only scale within that range. Users can either use nodes or processing
        units to specify the limits, but should use the same unit to set both the
        min_limit and max_limit.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_limits")

    @autoscaling_limits.setter
    def autoscaling_limits(self, value: Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingLimitsArgs']]):
        pulumi.set(self, "autoscaling_limits", value)

    @property
    @pulumi.getter(name="autoscalingTargets")
    def autoscaling_targets(self) -> Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingTargetsArgs']]:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_targets")

    @autoscaling_targets.setter
    def autoscaling_targets(self, value: Optional[pulumi.Input['InstanceAutoscalingConfigAutoscalingTargetsArgs']]):
        pulumi.set(self, "autoscaling_targets", value)


if not MYPY:
    class InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgsDict(TypedDict):
        overrides: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgsDict']
        """
        A nested object resource.
        Structure is documented below.
        """
        replica_selection: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgsDict']
        """
        A nested object resource.
        Structure is documented below.
        """
elif False:
    InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs:
    def __init__(__self__, *,
                 overrides: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs'],
                 replica_selection: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs']):
        """
        :param pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs'] overrides: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs'] replica_selection: A nested object resource.
               Structure is documented below.
        """
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "replica_selection", replica_selection)

    @property
    @pulumi.getter
    def overrides(self) -> pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs']):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="replicaSelection")
    def replica_selection(self) -> pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "replica_selection")

    @replica_selection.setter
    def replica_selection(self, value: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs']):
        pulumi.set(self, "replica_selection", value)


if not MYPY:
    class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgsDict(TypedDict):
        autoscaling_limits: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgsDict']
        """
        A nested object resource.
        Structure is documented below.
        """
elif False:
    InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs:
    def __init__(__self__, *,
                 autoscaling_limits: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs']):
        """
        :param pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs'] autoscaling_limits: A nested object resource.
               Structure is documented below.
        """
        pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)

    @property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_limits")

    @autoscaling_limits.setter
    def autoscaling_limits(self, value: pulumi.Input['InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs']):
        pulumi.set(self, "autoscaling_limits", value)


if not MYPY:
    class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgsDict(TypedDict):
        max_nodes: pulumi.Input[builtins.int]
        """
        The maximum number of nodes for this specific replica.
        """
        min_nodes: pulumi.Input[builtins.int]
        """
        The minimum number of nodes for this specific replica.
        """
elif False:
    InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs:
    def __init__(__self__, *,
                 max_nodes: pulumi.Input[builtins.int],
                 min_nodes: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] max_nodes: The maximum number of nodes for this specific replica.
        :param pulumi.Input[builtins.int] min_nodes: The minimum number of nodes for this specific replica.
        """
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of nodes for this specific replica.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Input[builtins.int]:
        """
        The minimum number of nodes for this specific replica.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_nodes", value)


if not MYPY:
    class InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgsDict(TypedDict):
        location: pulumi.Input[builtins.str]
        """
        The location of the replica to apply asymmetric autoscaling options.
        """
elif False:
    InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] location: The location of the replica to apply asymmetric autoscaling options.
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the replica to apply asymmetric autoscaling options.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)


if not MYPY:
    class InstanceAutoscalingConfigAutoscalingLimitsArgsDict(TypedDict):
        max_nodes: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of nodes for this specific replica.
        """
        max_processing_units: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies maximum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000 and be greater than or equal to
        min_processing_units.
        """
        min_nodes: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of nodes for this specific replica.
        """
        min_processing_units: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies minimum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000.
        """
elif False:
    InstanceAutoscalingConfigAutoscalingLimitsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAutoscalingLimitsArgs:
    def __init__(__self__, *,
                 max_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 max_processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 min_processing_units: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_nodes: The maximum number of nodes for this specific replica.
        :param pulumi.Input[builtins.int] max_processing_units: Specifies maximum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000 and be greater than or equal to
               min_processing_units.
        :param pulumi.Input[builtins.int] min_nodes: The minimum number of nodes for this specific replica.
        :param pulumi.Input[builtins.int] min_processing_units: Specifies minimum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000.
        """
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if max_processing_units is not None:
            pulumi.set(__self__, "max_processing_units", max_processing_units)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if min_processing_units is not None:
            pulumi.set(__self__, "min_processing_units", min_processing_units)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of nodes for this specific replica.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="maxProcessingUnits")
    def max_processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies maximum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000 and be greater than or equal to
        min_processing_units.
        """
        return pulumi.get(self, "max_processing_units")

    @max_processing_units.setter
    def max_processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_processing_units", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of nodes for this specific replica.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter(name="minProcessingUnits")
    def min_processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies minimum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000.
        """
        return pulumi.get(self, "min_processing_units")

    @min_processing_units.setter
    def min_processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_processing_units", value)


if not MYPY:
    class InstanceAutoscalingConfigAutoscalingTargetsArgsDict(TypedDict):
        high_priority_cpu_utilization_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the target high priority cpu utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        """
        storage_utilization_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the target storage utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
elif False:
    InstanceAutoscalingConfigAutoscalingTargetsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAutoscalingConfigAutoscalingTargetsArgs:
    def __init__(__self__, *,
                 high_priority_cpu_utilization_percent: Optional[pulumi.Input[builtins.int]] = None,
                 storage_utilization_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] high_priority_cpu_utilization_percent: Specifies the target high priority cpu utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        :param pulumi.Input[builtins.int] storage_utilization_percent: Specifies the target storage utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        if high_priority_cpu_utilization_percent is not None:
            pulumi.set(__self__, "high_priority_cpu_utilization_percent", high_priority_cpu_utilization_percent)
        if storage_utilization_percent is not None:
            pulumi.set(__self__, "storage_utilization_percent", storage_utilization_percent)

    @property
    @pulumi.getter(name="highPriorityCpuUtilizationPercent")
    def high_priority_cpu_utilization_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the target high priority cpu utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        """
        return pulumi.get(self, "high_priority_cpu_utilization_percent")

    @high_priority_cpu_utilization_percent.setter
    def high_priority_cpu_utilization_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "high_priority_cpu_utilization_percent", value)

    @property
    @pulumi.getter(name="storageUtilizationPercent")
    def storage_utilization_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the target storage utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        return pulumi.get(self, "storage_utilization_percent")

    @storage_utilization_percent.setter
    def storage_utilization_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_utilization_percent", value)


if not MYPY:
    class InstanceConfigReplicaArgsDict(TypedDict):
        default_leader_location: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, this location is designated as the default leader location where
        leader replicas are placed.
        """
        location: NotRequired[pulumi.Input[builtins.str]]
        """
        The location of the serving resources, e.g. "us-central1".
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates the type of replica.  See the [replica types
        documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
        for more details.
        Possible values are: `READ_WRITE`, `READ_ONLY`, `WITNESS`.
        """
elif False:
    InstanceConfigReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceConfigReplicaArgs:
    def __init__(__self__, *,
                 default_leader_location: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] default_leader_location: If true, this location is designated as the default leader location where
               leader replicas are placed.
        :param pulumi.Input[builtins.str] location: The location of the serving resources, e.g. "us-central1".
        :param pulumi.Input[builtins.str] type: Indicates the type of replica.  See the [replica types
               documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
               for more details.
               Possible values are: `READ_WRITE`, `READ_ONLY`, `WITNESS`.
        """
        if default_leader_location is not None:
            pulumi.set(__self__, "default_leader_location", default_leader_location)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultLeaderLocation")
    def default_leader_location(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, this location is designated as the default leader location where
        leader replicas are placed.
        """
        return pulumi.get(self, "default_leader_location")

    @default_leader_location.setter
    def default_leader_location(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_leader_location", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the serving resources, e.g. "us-central1".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the type of replica.  See the [replica types
        documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
        for more details.
        Possible values are: `READ_WRITE`, `READ_ONLY`, `WITNESS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class InstanceIAMBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        title: pulumi.Input[builtins.str]
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    InstanceIAMBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class InstanceIAMMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        title: pulumi.Input[builtins.str]
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    InstanceIAMMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


