# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupScheduleArgs', 'BackupSchedule']

@pulumi.input_type
class BackupScheduleArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 instance: pulumi.Input[builtins.str],
                 retention_duration: pulumi.Input[builtins.str],
                 encryption_config: Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']] = None,
                 full_backup_spec: Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']] = None,
                 incremental_backup_spec: Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spec: Optional[pulumi.Input['BackupScheduleSpecArgs']] = None):
        """
        The set of arguments for constructing a BackupSchedule resource.
        :param pulumi.Input[builtins.str] database: The database to create the backup schedule on.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] retention_duration: At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
               You can set this to a value up to 366 days.
        :param pulumi.Input['BackupScheduleEncryptionConfigArgs'] encryption_config: Configuration for the encryption of the backup schedule.
               Structure is documented below.
        :param pulumi.Input['BackupScheduleFullBackupSpecArgs'] full_backup_spec: The schedule creates only full backups..
        :param pulumi.Input['BackupScheduleIncrementalBackupSpecArgs'] incremental_backup_spec: The schedule creates incremental backup chains.
        :param pulumi.Input[builtins.str] name: A unique identifier for the backup schedule, which cannot be changed after
               the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BackupScheduleSpecArgs'] spec: Defines specifications of the backup schedule.
               Structure is documented below.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "retention_duration", retention_duration)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if full_backup_spec is not None:
            pulumi.set(__self__, "full_backup_spec", full_backup_spec)
        if incremental_backup_spec is not None:
            pulumi.set(__self__, "incremental_backup_spec", incremental_backup_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The database to create the backup schedule on.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> pulumi.Input[builtins.str]:
        """
        At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
        You can set this to a value up to 366 days.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']]:
        """
        Configuration for the encryption of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="fullBackupSpec")
    def full_backup_spec(self) -> Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']]:
        """
        The schedule creates only full backups..
        """
        return pulumi.get(self, "full_backup_spec")

    @full_backup_spec.setter
    def full_backup_spec(self, value: Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']]):
        pulumi.set(self, "full_backup_spec", value)

    @property
    @pulumi.getter(name="incrementalBackupSpec")
    def incremental_backup_spec(self) -> Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']]:
        """
        The schedule creates incremental backup chains.
        """
        return pulumi.get(self, "incremental_backup_spec")

    @incremental_backup_spec.setter
    def incremental_backup_spec(self, value: Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']]):
        pulumi.set(self, "incremental_backup_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the backup schedule, which cannot be changed after
        the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['BackupScheduleSpecArgs']]:
        """
        Defines specifications of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['BackupScheduleSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class _BackupScheduleState:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']] = None,
                 full_backup_spec: Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']] = None,
                 incremental_backup_spec: Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_duration: Optional[pulumi.Input[builtins.str]] = None,
                 spec: Optional[pulumi.Input['BackupScheduleSpecArgs']] = None):
        """
        Input properties used for looking up and filtering BackupSchedule resources.
        :param pulumi.Input[builtins.str] database: The database to create the backup schedule on.
        :param pulumi.Input['BackupScheduleEncryptionConfigArgs'] encryption_config: Configuration for the encryption of the backup schedule.
               Structure is documented below.
        :param pulumi.Input['BackupScheduleFullBackupSpecArgs'] full_backup_spec: The schedule creates only full backups..
        :param pulumi.Input['BackupScheduleIncrementalBackupSpecArgs'] incremental_backup_spec: The schedule creates incremental backup chains.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the backup schedule, which cannot be changed after
               the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] retention_duration: At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
               You can set this to a value up to 366 days.
        :param pulumi.Input['BackupScheduleSpecArgs'] spec: Defines specifications of the backup schedule.
               Structure is documented below.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if full_backup_spec is not None:
            pulumi.set(__self__, "full_backup_spec", full_backup_spec)
        if incremental_backup_spec is not None:
            pulumi.set(__self__, "incremental_backup_spec", incremental_backup_spec)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database to create the backup schedule on.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']]:
        """
        Configuration for the encryption of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['BackupScheduleEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="fullBackupSpec")
    def full_backup_spec(self) -> Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']]:
        """
        The schedule creates only full backups..
        """
        return pulumi.get(self, "full_backup_spec")

    @full_backup_spec.setter
    def full_backup_spec(self, value: Optional[pulumi.Input['BackupScheduleFullBackupSpecArgs']]):
        pulumi.set(self, "full_backup_spec", value)

    @property
    @pulumi.getter(name="incrementalBackupSpec")
    def incremental_backup_spec(self) -> Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']]:
        """
        The schedule creates incremental backup chains.
        """
        return pulumi.get(self, "incremental_backup_spec")

    @incremental_backup_spec.setter
    def incremental_backup_spec(self, value: Optional[pulumi.Input['BackupScheduleIncrementalBackupSpecArgs']]):
        pulumi.set(self, "incremental_backup_spec", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the backup schedule, which cannot be changed after
        the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
        You can set this to a value up to 366 days.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['BackupScheduleSpecArgs']]:
        """
        Defines specifications of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['BackupScheduleSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.type_token("gcp:spanner/backupSchedule:BackupSchedule")
class BackupSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input[Union['BackupScheduleEncryptionConfigArgs', 'BackupScheduleEncryptionConfigArgsDict']]] = None,
                 full_backup_spec: Optional[pulumi.Input[Union['BackupScheduleFullBackupSpecArgs', 'BackupScheduleFullBackupSpecArgsDict']]] = None,
                 incremental_backup_spec: Optional[pulumi.Input[Union['BackupScheduleIncrementalBackupSpecArgs', 'BackupScheduleIncrementalBackupSpecArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_duration: Optional[pulumi.Input[builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['BackupScheduleSpecArgs', 'BackupScheduleSpecArgsDict']]] = None,
                 __props__=None):
        """
        A backup schedule for a Cloud Spanner Database.
        This resource is owned by the database it is backing up, and is deleted along with the database.
        The actual backups are not though.

        To get more information about BackupSchedule, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.databases.backupSchedules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/docs/backup)

        > **Warning:** This resource creates a Spanner Backup Schedule on a project that already has
        a Spanner database.
        This resource is owned by the database it is backing up, and is deleted along
        with the database. The actual backups are not though.

        ## Example Usage

        ### Spanner Backup Schedule Daily Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="instance-id",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1)
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="database-id",
            version_retention_period="3d",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=True)
        full_backup = gcp.spanner.BackupSchedule("full-backup",
            instance=main.name,
            database=database.name,
            name="backup-schedule-id",
            retention_duration="31620000s",
            spec={
                "cron_spec": {
                    "text": "0 12 * * *",
                },
            },
            full_backup_spec={},
            encryption_config={
                "encryption_type": "USE_DATABASE_ENCRYPTION",
            })
        ```
        ### Spanner Backup Schedule Daily Incremental

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="instance-id",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1,
            edition="ENTERPRISE")
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="database-id",
            version_retention_period="3d",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=True)
        incremental_backup = gcp.spanner.BackupSchedule("incremental-backup",
            instance=main.name,
            database=database.name,
            name="backup-schedule-id",
            retention_duration="31620000s",
            spec={
                "cron_spec": {
                    "text": "0 12 * * *",
                },
            },
            incremental_backup_spec={},
            encryption_config={
                "encryption_type": "GOOGLE_DEFAULT_ENCRYPTION",
            })
        ```

        ## Import

        BackupSchedule can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/databases/{{database}}/backupSchedules/{{name}}`

        * `{{project}}/{{instance}}/{{database}}/{{name}}`

        * `{{instance}}/{{database}}/{{name}}`

        When using the `pulumi import` command, BackupSchedule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default projects/{{project}}/instances/{{instance}}/databases/{{database}}/backupSchedules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default {{project}}/{{instance}}/{{database}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default {{instance}}/{{database}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: The database to create the backup schedule on.
        :param pulumi.Input[Union['BackupScheduleEncryptionConfigArgs', 'BackupScheduleEncryptionConfigArgsDict']] encryption_config: Configuration for the encryption of the backup schedule.
               Structure is documented below.
        :param pulumi.Input[Union['BackupScheduleFullBackupSpecArgs', 'BackupScheduleFullBackupSpecArgsDict']] full_backup_spec: The schedule creates only full backups..
        :param pulumi.Input[Union['BackupScheduleIncrementalBackupSpecArgs', 'BackupScheduleIncrementalBackupSpecArgsDict']] incremental_backup_spec: The schedule creates incremental backup chains.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the backup schedule, which cannot be changed after
               the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] retention_duration: At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
               You can set this to a value up to 366 days.
        :param pulumi.Input[Union['BackupScheduleSpecArgs', 'BackupScheduleSpecArgsDict']] spec: Defines specifications of the backup schedule.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A backup schedule for a Cloud Spanner Database.
        This resource is owned by the database it is backing up, and is deleted along with the database.
        The actual backups are not though.

        To get more information about BackupSchedule, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.databases.backupSchedules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/docs/backup)

        > **Warning:** This resource creates a Spanner Backup Schedule on a project that already has
        a Spanner database.
        This resource is owned by the database it is backing up, and is deleted along
        with the database. The actual backups are not though.

        ## Example Usage

        ### Spanner Backup Schedule Daily Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="instance-id",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1)
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="database-id",
            version_retention_period="3d",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=True)
        full_backup = gcp.spanner.BackupSchedule("full-backup",
            instance=main.name,
            database=database.name,
            name="backup-schedule-id",
            retention_duration="31620000s",
            spec={
                "cron_spec": {
                    "text": "0 12 * * *",
                },
            },
            full_backup_spec={},
            encryption_config={
                "encryption_type": "USE_DATABASE_ENCRYPTION",
            })
        ```
        ### Spanner Backup Schedule Daily Incremental

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="instance-id",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1,
            edition="ENTERPRISE")
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="database-id",
            version_retention_period="3d",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=True)
        incremental_backup = gcp.spanner.BackupSchedule("incremental-backup",
            instance=main.name,
            database=database.name,
            name="backup-schedule-id",
            retention_duration="31620000s",
            spec={
                "cron_spec": {
                    "text": "0 12 * * *",
                },
            },
            incremental_backup_spec={},
            encryption_config={
                "encryption_type": "GOOGLE_DEFAULT_ENCRYPTION",
            })
        ```

        ## Import

        BackupSchedule can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/databases/{{database}}/backupSchedules/{{name}}`

        * `{{project}}/{{instance}}/{{database}}/{{name}}`

        * `{{instance}}/{{database}}/{{name}}`

        When using the `pulumi import` command, BackupSchedule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default projects/{{project}}/instances/{{instance}}/databases/{{database}}/backupSchedules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default {{project}}/{{instance}}/{{database}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/backupSchedule:BackupSchedule default {{instance}}/{{database}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input[Union['BackupScheduleEncryptionConfigArgs', 'BackupScheduleEncryptionConfigArgsDict']]] = None,
                 full_backup_spec: Optional[pulumi.Input[Union['BackupScheduleFullBackupSpecArgs', 'BackupScheduleFullBackupSpecArgsDict']]] = None,
                 incremental_backup_spec: Optional[pulumi.Input[Union['BackupScheduleIncrementalBackupSpecArgs', 'BackupScheduleIncrementalBackupSpecArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_duration: Optional[pulumi.Input[builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['BackupScheduleSpecArgs', 'BackupScheduleSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupScheduleArgs.__new__(BackupScheduleArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["full_backup_spec"] = full_backup_spec
            __props__.__dict__["incremental_backup_spec"] = incremental_backup_spec
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if retention_duration is None and not opts.urn:
                raise TypeError("Missing required property 'retention_duration'")
            __props__.__dict__["retention_duration"] = retention_duration
            __props__.__dict__["spec"] = spec
        super(BackupSchedule, __self__).__init__(
            'gcp:spanner/backupSchedule:BackupSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database: Optional[pulumi.Input[builtins.str]] = None,
            encryption_config: Optional[pulumi.Input[Union['BackupScheduleEncryptionConfigArgs', 'BackupScheduleEncryptionConfigArgsDict']]] = None,
            full_backup_spec: Optional[pulumi.Input[Union['BackupScheduleFullBackupSpecArgs', 'BackupScheduleFullBackupSpecArgsDict']]] = None,
            incremental_backup_spec: Optional[pulumi.Input[Union['BackupScheduleIncrementalBackupSpecArgs', 'BackupScheduleIncrementalBackupSpecArgsDict']]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            retention_duration: Optional[pulumi.Input[builtins.str]] = None,
            spec: Optional[pulumi.Input[Union['BackupScheduleSpecArgs', 'BackupScheduleSpecArgsDict']]] = None) -> 'BackupSchedule':
        """
        Get an existing BackupSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: The database to create the backup schedule on.
        :param pulumi.Input[Union['BackupScheduleEncryptionConfigArgs', 'BackupScheduleEncryptionConfigArgsDict']] encryption_config: Configuration for the encryption of the backup schedule.
               Structure is documented below.
        :param pulumi.Input[Union['BackupScheduleFullBackupSpecArgs', 'BackupScheduleFullBackupSpecArgsDict']] full_backup_spec: The schedule creates only full backups..
        :param pulumi.Input[Union['BackupScheduleIncrementalBackupSpecArgs', 'BackupScheduleIncrementalBackupSpecArgsDict']] incremental_backup_spec: The schedule creates incremental backup chains.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the backup schedule, which cannot be changed after
               the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] retention_duration: At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
               You can set this to a value up to 366 days.
        :param pulumi.Input[Union['BackupScheduleSpecArgs', 'BackupScheduleSpecArgsDict']] spec: Defines specifications of the backup schedule.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupScheduleState.__new__(_BackupScheduleState)

        __props__.__dict__["database"] = database
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["full_backup_spec"] = full_backup_spec
        __props__.__dict__["incremental_backup_spec"] = incremental_backup_spec
        __props__.__dict__["instance"] = instance
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["retention_duration"] = retention_duration
        __props__.__dict__["spec"] = spec
        return BackupSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[builtins.str]:
        """
        The database to create the backup schedule on.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output['outputs.BackupScheduleEncryptionConfig']:
        """
        Configuration for the encryption of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="fullBackupSpec")
    def full_backup_spec(self) -> pulumi.Output[Optional['outputs.BackupScheduleFullBackupSpec']]:
        """
        The schedule creates only full backups..
        """
        return pulumi.get(self, "full_backup_spec")

    @property
    @pulumi.getter(name="incrementalBackupSpec")
    def incremental_backup_spec(self) -> pulumi.Output[Optional['outputs.BackupScheduleIncrementalBackupSpec']]:
        """
        The schedule creates incremental backup chains.
        """
        return pulumi.get(self, "incremental_backup_spec")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the backup schedule, which cannot be changed after
        the backup schedule is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> pulumi.Output[builtins.str]:
        """
        At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
        You can set this to a value up to 366 days.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.BackupScheduleSpec']]:
        """
        Defines specifications of the backup schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

