# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[builtins.str],
                 database_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 ddls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_drop_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input['DatabaseEncryptionConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 version_retention_period: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] database_dialect: The dialect of the Cloud Spanner Database.
               If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
               Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        :param pulumi.Input[builtins.str] default_time_zone: The default time zone for the database. The default time zone must be a valid name
               from the tz database. Default value is "America/Los_angeles".
        :param pulumi.Input[builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` that would delete the instance will fail.
        :param pulumi.Input['DatabaseEncryptionConfigArgs'] encryption_config: Encryption configuration for the database
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: A unique identifier for the database, which cannot be changed after the
               instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] version_retention_period: The retention period for the database. The retention period must be between 1 hour
               and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
               the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
               If this property is used, you must avoid adding new DDL statements to `ddl` that
               update the database's version_retention_period.
        """
        pulumi.set(__self__, "instance", instance)
        if database_dialect is not None:
            pulumi.set(__self__, "database_dialect", database_dialect)
        if ddls is not None:
            pulumi.set(__self__, "ddls", ddls)
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_drop_protection is not None:
            pulumi.set(__self__, "enable_drop_protection", enable_drop_protection)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if version_retention_period is not None:
            pulumi.set(__self__, "version_retention_period", version_retention_period)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="databaseDialect")
    def database_dialect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The dialect of the Cloud Spanner Database.
        If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
        Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        """
        return pulumi.get(self, "database_dialect")

    @database_dialect.setter
    def database_dialect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_dialect", value)

    @property
    @pulumi.getter
    def ddls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "ddls")

    @ddls.setter
    def ddls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ddls", value)

    @property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default time zone for the database. The default time zone must be a valid name
        from the tz database. Default value is "America/Los_angeles".
        """
        return pulumi.get(self, "default_time_zone")

    @default_time_zone.setter
    def default_time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_time_zone", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableDropProtection")
    def enable_drop_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "enable_drop_protection")

    @enable_drop_protection.setter
    def enable_drop_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_drop_protection", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['DatabaseEncryptionConfigArgs']]:
        """
        Encryption configuration for the database
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['DatabaseEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the database, which cannot be changed after the
        instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The retention period for the database. The retention period must be between 1 hour
        and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
        the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
        If this property is used, you must avoid adding new DDL statements to `ddl` that
        update the database's version_retention_period.
        """
        return pulumi.get(self, "version_retention_period")

    @version_retention_period.setter
    def version_retention_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_retention_period", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 database_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 ddls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_drop_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input['DatabaseEncryptionConfigArgs']] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 version_retention_period: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[builtins.str] database_dialect: The dialect of the Cloud Spanner Database.
               If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
               Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        :param pulumi.Input[builtins.str] default_time_zone: The default time zone for the database. The default time zone must be a valid name
               from the tz database. Default value is "America/Los_angeles".
        :param pulumi.Input[builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` that would delete the instance will fail.
        :param pulumi.Input['DatabaseEncryptionConfigArgs'] encryption_config: Encryption configuration for the database
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the database, which cannot be changed after the
               instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: An explanation of the status of the database.
        :param pulumi.Input[builtins.str] version_retention_period: The retention period for the database. The retention period must be between 1 hour
               and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
               the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
               If this property is used, you must avoid adding new DDL statements to `ddl` that
               update the database's version_retention_period.
        """
        if database_dialect is not None:
            pulumi.set(__self__, "database_dialect", database_dialect)
        if ddls is not None:
            pulumi.set(__self__, "ddls", ddls)
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_drop_protection is not None:
            pulumi.set(__self__, "enable_drop_protection", enable_drop_protection)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version_retention_period is not None:
            pulumi.set(__self__, "version_retention_period", version_retention_period)

    @property
    @pulumi.getter(name="databaseDialect")
    def database_dialect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The dialect of the Cloud Spanner Database.
        If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
        Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        """
        return pulumi.get(self, "database_dialect")

    @database_dialect.setter
    def database_dialect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_dialect", value)

    @property
    @pulumi.getter
    def ddls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "ddls")

    @ddls.setter
    def ddls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ddls", value)

    @property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default time zone for the database. The default time zone must be a valid name
        from the tz database. Default value is "America/Los_angeles".
        """
        return pulumi.get(self, "default_time_zone")

    @default_time_zone.setter
    def default_time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_time_zone", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableDropProtection")
    def enable_drop_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "enable_drop_protection")

    @enable_drop_protection.setter
    def enable_drop_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_drop_protection", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['DatabaseEncryptionConfigArgs']]:
        """
        Encryption configuration for the database
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['DatabaseEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the database, which cannot be changed after the
        instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An explanation of the status of the database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The retention period for the database. The retention period must be between 1 hour
        and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
        the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
        If this property is used, you must avoid adding new DDL statements to `ddl` that
        update the database's version_retention_period.
        """
        return pulumi.get(self, "version_retention_period")

    @version_retention_period.setter
    def version_retention_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_retention_period", value)


@pulumi.type_token("gcp:spanner/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 ddls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_drop_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['DatabaseEncryptionConfigArgs', 'DatabaseEncryptionConfigArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 version_retention_period: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Spanner Database which is hosted on a Spanner instance.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/)

        > **Warning:** On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi up` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.
        On older versions, it is strongly recommended to set `lifecycle { prevent_destroy = true }`
        on databases in order to prevent accidental data loss.

        ## Example Usage

        ### Spanner Database Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1)
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="my-database",
            version_retention_period="3d",
            default_time_zone="UTC",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=False)
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/databases/{{name}}`

        * `instances/{{instance}}/databases/{{name}}`

        * `{{project}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/database:Database default projects/{{project}}/instances/{{instance}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default instances/{{instance}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default {{project}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_dialect: The dialect of the Cloud Spanner Database.
               If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
               Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        :param pulumi.Input[builtins.str] default_time_zone: The default time zone for the database. The default time zone must be a valid name
               from the tz database. Default value is "America/Los_angeles".
        :param pulumi.Input[builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` that would delete the instance will fail.
        :param pulumi.Input[Union['DatabaseEncryptionConfigArgs', 'DatabaseEncryptionConfigArgsDict']] encryption_config: Encryption configuration for the database
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the database, which cannot be changed after the
               instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] version_retention_period: The retention period for the database. The retention period must be between 1 hour
               and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
               the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
               If this property is used, you must avoid adding new DDL statements to `ddl` that
               update the database's version_retention_period.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Spanner Database which is hosted on a Spanner instance.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/)

        > **Warning:** On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi up` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.
        On older versions, it is strongly recommended to set `lifecycle { prevent_destroy = true }`
        on databases in order to prevent accidental data loss.

        ## Example Usage

        ### Spanner Database Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            config="regional-europe-west1",
            display_name="main-instance",
            num_nodes=1)
        database = gcp.spanner.Database("database",
            instance=main.name,
            name="my-database",
            version_retention_period="3d",
            default_time_zone="UTC",
            ddls=[
                "CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)",
                "CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)",
            ],
            deletion_protection=False)
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/databases/{{name}}`

        * `instances/{{instance}}/databases/{{name}}`

        * `{{project}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/database:Database default projects/{{project}}/instances/{{instance}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default instances/{{instance}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default {{project}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/database:Database default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 ddls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_drop_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['DatabaseEncryptionConfigArgs', 'DatabaseEncryptionConfigArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 version_retention_period: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["database_dialect"] = database_dialect
            __props__.__dict__["ddls"] = ddls
            __props__.__dict__["default_time_zone"] = default_time_zone
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_drop_protection"] = enable_drop_protection
            __props__.__dict__["encryption_config"] = encryption_config
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["version_retention_period"] = version_retention_period
            __props__.__dict__["state"] = None
        super(Database, __self__).__init__(
            'gcp:spanner/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_dialect: Optional[pulumi.Input[builtins.str]] = None,
            ddls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            default_time_zone: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            enable_drop_protection: Optional[pulumi.Input[builtins.bool]] = None,
            encryption_config: Optional[pulumi.Input[Union['DatabaseEncryptionConfigArgs', 'DatabaseEncryptionConfigArgsDict']]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            version_retention_period: Optional[pulumi.Input[builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_dialect: The dialect of the Cloud Spanner Database.
               If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
               Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        :param pulumi.Input[builtins.str] default_time_zone: The default time zone for the database. The default time zone must be a valid name
               from the tz database. Default value is "America/Los_angeles".
        :param pulumi.Input[builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` that would delete the instance will fail.
        :param pulumi.Input[Union['DatabaseEncryptionConfigArgs', 'DatabaseEncryptionConfigArgsDict']] encryption_config: Encryption configuration for the database
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The instance to create the database on.
        :param pulumi.Input[builtins.str] name: A unique identifier for the database, which cannot be changed after the
               instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: An explanation of the status of the database.
        :param pulumi.Input[builtins.str] version_retention_period: The retention period for the database. The retention period must be between 1 hour
               and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
               the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
               If this property is used, you must avoid adding new DDL statements to `ddl` that
               update the database's version_retention_period.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["database_dialect"] = database_dialect
        __props__.__dict__["ddls"] = ddls
        __props__.__dict__["default_time_zone"] = default_time_zone
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_drop_protection"] = enable_drop_protection
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["instance"] = instance
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["version_retention_period"] = version_retention_period
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseDialect")
    def database_dialect(self) -> pulumi.Output[builtins.str]:
        """
        The dialect of the Cloud Spanner Database.
        If it is not provided, "GOOGLE_STANDARD_SQL" will be used.
        Possible values are: `GOOGLE_STANDARD_SQL`, `POSTGRESQL`.
        """
        return pulumi.get(self, "database_dialect")

    @property
    @pulumi.getter
    def ddls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "ddls")

    @property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default time zone for the database. The default time zone must be a valid name
        from the tz database. Default value is "America/Los_angeles".
        """
        return pulumi.get(self, "default_time_zone")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="enableDropProtection")
    def enable_drop_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "enable_drop_protection")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output[Optional['outputs.DatabaseEncryptionConfig']]:
        """
        Encryption configuration for the database
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The instance to create the database on.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the database, which cannot be changed after the
        instance is created. Values are of the form `[a-z][-_a-z0-9]*[a-z0-9]`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        An explanation of the status of the database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> pulumi.Output[builtins.str]:
        """
        The retention period for the database. The retention period must be between 1 hour
        and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
        the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
        If this property is used, you must avoid adding new DDL statements to `ddl` that
        update the database's version_retention_period.
        """
        return pulumi.get(self, "version_retention_period")

