# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    """
    A collection of values returned by getInstance.
    """
    def __init__(__self__, autoscaling_configs=None, config=None, default_backup_schedule_type=None, display_name=None, edition=None, effective_labels=None, force_destroy=None, id=None, instance_type=None, labels=None, name=None, num_nodes=None, processing_units=None, project=None, pulumi_labels=None, state=None):
        if autoscaling_configs and not isinstance(autoscaling_configs, list):
            raise TypeError("Expected argument 'autoscaling_configs' to be a list")
        pulumi.set(__self__, "autoscaling_configs", autoscaling_configs)
        if config and not isinstance(config, str):
            raise TypeError("Expected argument 'config' to be a str")
        pulumi.set(__self__, "config", config)
        if default_backup_schedule_type and not isinstance(default_backup_schedule_type, str):
            raise TypeError("Expected argument 'default_backup_schedule_type' to be a str")
        pulumi.set(__self__, "default_backup_schedule_type", default_backup_schedule_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if edition and not isinstance(edition, str):
            raise TypeError("Expected argument 'edition' to be a str")
        pulumi.set(__self__, "edition", edition)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if force_destroy and not isinstance(force_destroy, bool):
            raise TypeError("Expected argument 'force_destroy' to be a bool")
        pulumi.set(__self__, "force_destroy", force_destroy)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if num_nodes and not isinstance(num_nodes, int):
            raise TypeError("Expected argument 'num_nodes' to be a int")
        pulumi.set(__self__, "num_nodes", num_nodes)
        if processing_units and not isinstance(processing_units, int):
            raise TypeError("Expected argument 'processing_units' to be a int")
        pulumi.set(__self__, "processing_units", processing_units)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autoscalingConfigs")
    def autoscaling_configs(self) -> Sequence['outputs.GetInstanceAutoscalingConfigResult']:
        return pulumi.get(self, "autoscaling_configs")

    @property
    @pulumi.getter
    def config(self) -> Optional[builtins.str]:
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="defaultBackupScheduleType")
    def default_backup_schedule_type(self) -> builtins.str:
        return pulumi.get(self, "default_backup_schedule_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def edition(self) -> builtins.str:
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> builtins.bool:
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> builtins.int:
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> builtins.int:
        return pulumi.get(self, "processing_units")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            autoscaling_configs=self.autoscaling_configs,
            config=self.config,
            default_backup_schedule_type=self.default_backup_schedule_type,
            display_name=self.display_name,
            edition=self.edition,
            effective_labels=self.effective_labels,
            force_destroy=self.force_destroy,
            id=self.id,
            instance_type=self.instance_type,
            labels=self.labels,
            name=self.name,
            num_nodes=self.num_nodes,
            processing_units=self.processing_units,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            state=self.state)


def get_instance(config: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Get a spanner instance from Google Cloud by its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_instance(name="bar")
    ```


    :param builtins.str name: The name of the spanner instance.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['config'] = config
    __args__['displayName'] = display_name
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:spanner/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        autoscaling_configs=pulumi.get(__ret__, 'autoscaling_configs'),
        config=pulumi.get(__ret__, 'config'),
        default_backup_schedule_type=pulumi.get(__ret__, 'default_backup_schedule_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        edition=pulumi.get(__ret__, 'edition'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        force_destroy=pulumi.get(__ret__, 'force_destroy'),
        id=pulumi.get(__ret__, 'id'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        num_nodes=pulumi.get(__ret__, 'num_nodes'),
        processing_units=pulumi.get(__ret__, 'processing_units'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        state=pulumi.get(__ret__, 'state'))
def get_instance_output(config: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        name: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Get a spanner instance from Google Cloud by its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_instance(name="bar")
    ```


    :param builtins.str name: The name of the spanner instance.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['config'] = config
    __args__['displayName'] = display_name
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:spanner/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult)
    return __ret__.apply(lambda __response__: GetInstanceResult(
        autoscaling_configs=pulumi.get(__response__, 'autoscaling_configs'),
        config=pulumi.get(__response__, 'config'),
        default_backup_schedule_type=pulumi.get(__response__, 'default_backup_schedule_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        edition=pulumi.get(__response__, 'edition'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        force_destroy=pulumi.get(__response__, 'force_destroy'),
        id=pulumi.get(__response__, 'id'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        num_nodes=pulumi.get(__response__, 'num_nodes'),
        processing_units=pulumi.get(__response__, 'processing_units'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        state=pulumi.get(__response__, 'state')))
