# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstancePartitionArgs', 'InstancePartition']

@pulumi.input_type
class InstancePartitionArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 instance: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstancePartition resource.
        :param pulumi.Input[builtins.str] config: The name of the instance partition's configuration (similar to a region) which
               defines the geographic placement and replication of data in this instance partition.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance partition as it appears in UIs.
               Must be unique per project and between 4 and 30 characters in length.
        :param pulumi.Input[builtins.str] instance: The instance to create the instance partition in.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance partition, which cannot be changed after
               the instance partition is created. The name must be between 2 and 64 characters
               and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        :param pulumi.Input[builtins.int] node_count: The number of nodes allocated to this instance partition. One node equals
               1000 processing units. Exactly one of either node_count or processing_units
               must be present.
        :param pulumi.Input[builtins.int] processing_units: The number of processing units allocated to this instance partition.
               Exactly one of either node_count or processing_units must be present.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if processing_units is not None:
            pulumi.set(__self__, "processing_units", processing_units)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[builtins.str]:
        """
        The name of the instance partition's configuration (similar to a region) which
        defines the geographic placement and replication of data in this instance partition.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The descriptive name for this instance partition as it appears in UIs.
        Must be unique per project and between 4 and 30 characters in length.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The instance to create the instance partition in.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the instance partition, which cannot be changed after
        the instance partition is created. The name must be between 2 and 64 characters
        and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes allocated to this instance partition. One node equals
        1000 processing units. Exactly one of either node_count or processing_units
        must be present.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of processing units allocated to this instance partition.
        Exactly one of either node_count or processing_units must be present.
        """
        return pulumi.get(self, "processing_units")

    @processing_units.setter
    def processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "processing_units", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InstancePartitionState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstancePartition resources.
        :param pulumi.Input[builtins.str] config: The name of the instance partition's configuration (similar to a region) which
               defines the geographic placement and replication of data in this instance partition.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance partition as it appears in UIs.
               Must be unique per project and between 4 and 30 characters in length.
        :param pulumi.Input[builtins.str] instance: The instance to create the instance partition in.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance partition, which cannot be changed after
               the instance partition is created. The name must be between 2 and 64 characters
               and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        :param pulumi.Input[builtins.int] node_count: The number of nodes allocated to this instance partition. One node equals
               1000 processing units. Exactly one of either node_count or processing_units
               must be present.
        :param pulumi.Input[builtins.int] processing_units: The number of processing units allocated to this instance partition.
               Exactly one of either node_count or processing_units must be present.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current instance partition state. Possible values are:
               CREATING: The instance partition is being created. Resources are being
               allocated for the instance partition.
               READY: The instance partition has been allocated resources and is ready for use.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if processing_units is not None:
            pulumi.set(__self__, "processing_units", processing_units)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance partition's configuration (similar to a region) which
        defines the geographic placement and replication of data in this instance partition.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptive name for this instance partition as it appears in UIs.
        Must be unique per project and between 4 and 30 characters in length.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance to create the instance partition in.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the instance partition, which cannot be changed after
        the instance partition is created. The name must be between 2 and 64 characters
        and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes allocated to this instance partition. One node equals
        1000 processing units. Exactly one of either node_count or processing_units
        must be present.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of processing units allocated to this instance partition.
        Exactly one of either node_count or processing_units must be present.
        """
        return pulumi.get(self, "processing_units")

    @processing_units.setter
    def processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "processing_units", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current instance partition state. Possible values are:
        CREATING: The instance partition is being created. Resources are being
        allocated for the instance partition.
        READY: The instance partition has been allocated resources and is ready for use.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:spanner/instancePartition:InstancePartition")
class InstancePartition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Spanner instance partition is a unit of Cloud Spanner database capacity
        that can be used to partition data and processing capacity within an instance.

        To get more information about InstancePartition, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.instancePartitions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/docs/geo-partitioning)

        ## Example Usage

        ### Spanner Instance Partition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="test-instance",
            config="nam6",
            display_name="main-instance",
            num_nodes=1,
            edition="ENTERPRISE_PLUS")
        partition = gcp.spanner.InstancePartition("partition",
            name="test-partition",
            instance=main.name,
            config="nam8",
            display_name="test-spanner-partition",
            node_count=1)
        ```

        ## Import

        InstancePartition can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/instancePartitions/{{name}}`

        * `{{project}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, InstancePartition can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default projects/{{project}}/instances/{{instance}}/instancePartitions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default {{project}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config: The name of the instance partition's configuration (similar to a region) which
               defines the geographic placement and replication of data in this instance partition.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance partition as it appears in UIs.
               Must be unique per project and between 4 and 30 characters in length.
        :param pulumi.Input[builtins.str] instance: The instance to create the instance partition in.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance partition, which cannot be changed after
               the instance partition is created. The name must be between 2 and 64 characters
               and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        :param pulumi.Input[builtins.int] node_count: The number of nodes allocated to this instance partition. One node equals
               1000 processing units. Exactly one of either node_count or processing_units
               must be present.
        :param pulumi.Input[builtins.int] processing_units: The number of processing units allocated to this instance partition.
               Exactly one of either node_count or processing_units must be present.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePartitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Spanner instance partition is a unit of Cloud Spanner database capacity
        that can be used to partition data and processing capacity within an instance.

        To get more information about InstancePartition, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances.instancePartitions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/docs/geo-partitioning)

        ## Example Usage

        ### Spanner Instance Partition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.spanner.Instance("main",
            name="test-instance",
            config="nam6",
            display_name="main-instance",
            num_nodes=1,
            edition="ENTERPRISE_PLUS")
        partition = gcp.spanner.InstancePartition("partition",
            name="test-partition",
            instance=main.name,
            config="nam8",
            display_name="test-spanner-partition",
            node_count=1)
        ```

        ## Import

        InstancePartition can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/instancePartitions/{{name}}`

        * `{{project}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, InstancePartition can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default projects/{{project}}/instances/{{instance}}/instancePartitions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default {{project}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instancePartition:InstancePartition default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstancePartitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePartitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePartitionArgs.__new__(InstancePartitionArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["processing_units"] = processing_units
            __props__.__dict__["project"] = project
            __props__.__dict__["state"] = None
        super(InstancePartition, __self__).__init__(
            'gcp:spanner/instancePartition:InstancePartition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            processing_units: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'InstancePartition':
        """
        Get an existing InstancePartition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config: The name of the instance partition's configuration (similar to a region) which
               defines the geographic placement and replication of data in this instance partition.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance partition as it appears in UIs.
               Must be unique per project and between 4 and 30 characters in length.
        :param pulumi.Input[builtins.str] instance: The instance to create the instance partition in.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance partition, which cannot be changed after
               the instance partition is created. The name must be between 2 and 64 characters
               and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        :param pulumi.Input[builtins.int] node_count: The number of nodes allocated to this instance partition. One node equals
               1000 processing units. Exactly one of either node_count or processing_units
               must be present.
        :param pulumi.Input[builtins.int] processing_units: The number of processing units allocated to this instance partition.
               Exactly one of either node_count or processing_units must be present.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current instance partition state. Possible values are:
               CREATING: The instance partition is being created. Resources are being
               allocated for the instance partition.
               READY: The instance partition has been allocated resources and is ready for use.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePartitionState.__new__(_InstancePartitionState)

        __props__.__dict__["config"] = config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["instance"] = instance
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["processing_units"] = processing_units
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        return InstancePartition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[builtins.str]:
        """
        The name of the instance partition's configuration (similar to a region) which
        defines the geographic placement and replication of data in this instance partition.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The descriptive name for this instance partition as it appears in UIs.
        Must be unique per project and between 4 and 30 characters in length.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The instance to create the instance partition in.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the instance partition, which cannot be changed after
        the instance partition is created. The name must be between 2 and 64 characters
        and match the regular expression [a-z][a-z0-9\\\\-]{0,61}[a-z0-9].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of nodes allocated to this instance partition. One node equals
        1000 processing units. Exactly one of either node_count or processing_units
        must be present.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of processing units allocated to this instance partition.
        Exactly one of either node_count or processing_units must be present.
        """
        return pulumi.get(self, "processing_units")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current instance partition state. Possible values are:
        CREATING: The instance partition is being created. Resources are being
        allocated for the instance partition.
        READY: The instance partition has been allocated resources and is ready for use.
        """
        return pulumi.get(self, "state")

