# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AnywhereCacheArgs', 'AnywhereCache']

@pulumi.input_type
class AnywhereCacheArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 zone: pulumi.Input[builtins.str],
                 admission_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AnywhereCache resource.
        :param pulumi.Input[builtins.str] bucket: A reference to Bucket resource
        :param pulumi.Input[builtins.str] zone: The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        :param pulumi.Input[builtins.str] admission_policy: The cache admission policy dictates whether a block should be inserted upon a cache miss.
               Default value is `admit-on-first-miss`.
               Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        :param pulumi.Input[builtins.str] ttl: The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "zone", zone)
        if admission_policy is not None:
            pulumi.set(__self__, "admission_policy", admission_policy)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        A reference to Bucket resource
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[builtins.str]:
        """
        The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="admissionPolicy")
    def admission_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cache admission policy dictates whether a block should be inserted upon a cache miss.
        Default value is `admit-on-first-miss`.
        Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        """
        return pulumi.get(self, "admission_policy")

    @admission_policy.setter
    def admission_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admission_policy", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _AnywhereCacheState:
    def __init__(__self__, *,
                 admission_policy: Optional[pulumi.Input[builtins.str]] = None,
                 anywhere_cache_id: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 pending_update: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnywhereCache resources.
        :param pulumi.Input[builtins.str] admission_policy: The cache admission policy dictates whether a block should be inserted upon a cache miss.
               Default value is `admit-on-first-miss`.
               Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        :param pulumi.Input[builtins.str] anywhere_cache_id: The ID of the Anywhere cache instance.
        :param pulumi.Input[builtins.str] bucket: A reference to Bucket resource
        :param pulumi.Input[builtins.str] create_time: The creation time of the cache instance in RFC 3339 format.
        :param pulumi.Input[builtins.bool] pending_update: True if the cache instance has an active Update long-running operation.
        :param pulumi.Input[builtins.str] state: The current state of the cache instance.
        :param pulumi.Input[builtins.str] ttl: The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        :param pulumi.Input[builtins.str] update_time: The modification time of the cache instance metadata in RFC 3339 format.
        :param pulumi.Input[builtins.str] zone: The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        if admission_policy is not None:
            pulumi.set(__self__, "admission_policy", admission_policy)
        if anywhere_cache_id is not None:
            pulumi.set(__self__, "anywhere_cache_id", anywhere_cache_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if pending_update is not None:
            pulumi.set(__self__, "pending_update", pending_update)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="admissionPolicy")
    def admission_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cache admission policy dictates whether a block should be inserted upon a cache miss.
        Default value is `admit-on-first-miss`.
        Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        """
        return pulumi.get(self, "admission_policy")

    @admission_policy.setter
    def admission_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admission_policy", value)

    @property
    @pulumi.getter(name="anywhereCacheId")
    def anywhere_cache_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Anywhere cache instance.
        """
        return pulumi.get(self, "anywhere_cache_id")

    @anywhere_cache_id.setter
    def anywhere_cache_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anywhere_cache_id", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to Bucket resource
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation time of the cache instance in RFC 3339 format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="pendingUpdate")
    def pending_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if the cache instance has an active Update long-running operation.
        """
        return pulumi.get(self, "pending_update")

    @pending_update.setter
    def pending_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pending_update", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the cache instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The modification time of the cache instance metadata in RFC 3339 format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:storage/anywhereCache:AnywhereCache")
class AnywhereCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_policy: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The Google Cloud Storage (GCS) Anywhere Cache feature allows users to
        create SSD backed zonal read cache for their buckets. These zonal
        caches are co-located with the customers compute engines to provide
        cost efficiency.

        ## Example Usage

        ### Storage Anywhere Cache Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="US")
        destroy_wait5000_seconds = time.index.Sleep("destroy_wait_5000_seconds", destroy_duration=5000s,
        opts = pulumi.ResourceOptions(depends_on=[bucket]))
        cache = gcp.storage.AnywhereCache("cache",
            bucket=bucket.name,
            zone="us-central1-f",
            ttl="3601s",
            opts = pulumi.ResourceOptions(depends_on=[destroy_wait5000_seconds]))
        ```

        ## Import

        AnywhereCache can be imported using any of these accepted formats:

        * `b/{{bucket}}/anywhereCaches/{{anywhere_cache_id}}`

        * `{{bucket}}/{{anywhere_cache_id}}`

        When using the `pulumi import` command, AnywhereCache can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/anywhereCache:AnywhereCache default b/{{bucket}}/anywhereCaches/{{anywhere_cache_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/anywhereCache:AnywhereCache default {{bucket}}/{{anywhere_cache_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admission_policy: The cache admission policy dictates whether a block should be inserted upon a cache miss.
               Default value is `admit-on-first-miss`.
               Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        :param pulumi.Input[builtins.str] bucket: A reference to Bucket resource
        :param pulumi.Input[builtins.str] ttl: The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        :param pulumi.Input[builtins.str] zone: The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnywhereCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Google Cloud Storage (GCS) Anywhere Cache feature allows users to
        create SSD backed zonal read cache for their buckets. These zonal
        caches are co-located with the customers compute engines to provide
        cost efficiency.

        ## Example Usage

        ### Storage Anywhere Cache Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="US")
        destroy_wait5000_seconds = time.index.Sleep("destroy_wait_5000_seconds", destroy_duration=5000s,
        opts = pulumi.ResourceOptions(depends_on=[bucket]))
        cache = gcp.storage.AnywhereCache("cache",
            bucket=bucket.name,
            zone="us-central1-f",
            ttl="3601s",
            opts = pulumi.ResourceOptions(depends_on=[destroy_wait5000_seconds]))
        ```

        ## Import

        AnywhereCache can be imported using any of these accepted formats:

        * `b/{{bucket}}/anywhereCaches/{{anywhere_cache_id}}`

        * `{{bucket}}/{{anywhere_cache_id}}`

        When using the `pulumi import` command, AnywhereCache can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/anywhereCache:AnywhereCache default b/{{bucket}}/anywhereCaches/{{anywhere_cache_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/anywhereCache:AnywhereCache default {{bucket}}/{{anywhere_cache_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AnywhereCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnywhereCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_policy: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnywhereCacheArgs.__new__(AnywhereCacheArgs)

            __props__.__dict__["admission_policy"] = admission_policy
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["ttl"] = ttl
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["anywhere_cache_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["pending_update"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(AnywhereCache, __self__).__init__(
            'gcp:storage/anywhereCache:AnywhereCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admission_policy: Optional[pulumi.Input[builtins.str]] = None,
            anywhere_cache_id: Optional[pulumi.Input[builtins.str]] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            pending_update: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            ttl: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'AnywhereCache':
        """
        Get an existing AnywhereCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admission_policy: The cache admission policy dictates whether a block should be inserted upon a cache miss.
               Default value is `admit-on-first-miss`.
               Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        :param pulumi.Input[builtins.str] anywhere_cache_id: The ID of the Anywhere cache instance.
        :param pulumi.Input[builtins.str] bucket: A reference to Bucket resource
        :param pulumi.Input[builtins.str] create_time: The creation time of the cache instance in RFC 3339 format.
        :param pulumi.Input[builtins.bool] pending_update: True if the cache instance has an active Update long-running operation.
        :param pulumi.Input[builtins.str] state: The current state of the cache instance.
        :param pulumi.Input[builtins.str] ttl: The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        :param pulumi.Input[builtins.str] update_time: The modification time of the cache instance metadata in RFC 3339 format.
        :param pulumi.Input[builtins.str] zone: The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnywhereCacheState.__new__(_AnywhereCacheState)

        __props__.__dict__["admission_policy"] = admission_policy
        __props__.__dict__["anywhere_cache_id"] = anywhere_cache_id
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["pending_update"] = pending_update
        __props__.__dict__["state"] = state
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zone"] = zone
        return AnywhereCache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="admissionPolicy")
    def admission_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The cache admission policy dictates whether a block should be inserted upon a cache miss.
        Default value is `admit-on-first-miss`.
        Possible values are: `admit-on-first-miss`, `admit-on-second-miss`.
        """
        return pulumi.get(self, "admission_policy")

    @property
    @pulumi.getter(name="anywhereCacheId")
    def anywhere_cache_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Anywhere cache instance.
        """
        return pulumi.get(self, "anywhere_cache_id")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        A reference to Bucket resource
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation time of the cache instance in RFC 3339 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="pendingUpdate")
    def pending_update(self) -> pulumi.Output[builtins.bool]:
        """
        True if the cache instance has an active Update long-running operation.
        """
        return pulumi.get(self, "pending_update")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the cache instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The TTL of all cache entries in whole seconds. e.g., "7200s". It defaults to `86400s`
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The modification time of the cache instance metadata in RFC 3339 format.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The zone in which the cache instance needs to be created. For example, `us-central1-a.`
        """
        return pulumi.get(self, "zone")

