# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BatchOperationsJobArgs', 'BatchOperationsJob']

@pulumi.input_type
class BatchOperationsJobArgs:
    def __init__(__self__, *,
                 bucket_list: Optional[pulumi.Input['BatchOperationsJobBucketListArgs']] = None,
                 delete_object: Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 put_metadata: Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']] = None,
                 put_object_hold: Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']] = None,
                 rewrite_object: Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']] = None):
        """
        The set of arguments for constructing a BatchOperationsJob resource.
        :param pulumi.Input['BatchOperationsJobBucketListArgs'] bucket_list: List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
               Structure is documented below.
        :param pulumi.Input['BatchOperationsJobDeleteObjectArgs'] delete_object: allows batch operations to delete objects in bucket
               Structure is documented below.
        :param pulumi.Input[builtins.bool] delete_protection: If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        :param pulumi.Input[builtins.str] job_id: The ID of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BatchOperationsJobPutMetadataArgs'] put_metadata: allows batch operations to update metadata for objects in bucket
               Structure is documented below.
        :param pulumi.Input['BatchOperationsJobPutObjectHoldArgs'] put_object_hold: allows to update temporary hold or eventBased hold for objects in bucket.
               Structure is documented below.
        :param pulumi.Input['BatchOperationsJobRewriteObjectArgs'] rewrite_object: allows to update encryption key for objects in bucket.
               Structure is documented below.
        """
        if bucket_list is not None:
            pulumi.set(__self__, "bucket_list", bucket_list)
        if delete_object is not None:
            pulumi.set(__self__, "delete_object", delete_object)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if put_metadata is not None:
            pulumi.set(__self__, "put_metadata", put_metadata)
        if put_object_hold is not None:
            pulumi.set(__self__, "put_object_hold", put_object_hold)
        if rewrite_object is not None:
            pulumi.set(__self__, "rewrite_object", rewrite_object)

    @property
    @pulumi.getter(name="bucketList")
    def bucket_list(self) -> Optional[pulumi.Input['BatchOperationsJobBucketListArgs']]:
        """
        List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
        Structure is documented below.
        """
        return pulumi.get(self, "bucket_list")

    @bucket_list.setter
    def bucket_list(self, value: Optional[pulumi.Input['BatchOperationsJobBucketListArgs']]):
        pulumi.set(self, "bucket_list", value)

    @property
    @pulumi.getter(name="deleteObject")
    def delete_object(self) -> Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']]:
        """
        allows batch operations to delete objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "delete_object")

    @delete_object.setter
    def delete_object(self, value: Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']]):
        pulumi.set(self, "delete_object", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="putMetadata")
    def put_metadata(self) -> Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']]:
        """
        allows batch operations to update metadata for objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "put_metadata")

    @put_metadata.setter
    def put_metadata(self, value: Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']]):
        pulumi.set(self, "put_metadata", value)

    @property
    @pulumi.getter(name="putObjectHold")
    def put_object_hold(self) -> Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']]:
        """
        allows to update temporary hold or eventBased hold for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "put_object_hold")

    @put_object_hold.setter
    def put_object_hold(self, value: Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']]):
        pulumi.set(self, "put_object_hold", value)

    @property
    @pulumi.getter(name="rewriteObject")
    def rewrite_object(self) -> Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']]:
        """
        allows to update encryption key for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "rewrite_object")

    @rewrite_object.setter
    def rewrite_object(self, value: Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']]):
        pulumi.set(self, "rewrite_object", value)


@pulumi.input_type
class _BatchOperationsJobState:
    def __init__(__self__, *,
                 bucket_list: Optional[pulumi.Input['BatchOperationsJobBucketListArgs']] = None,
                 complete_time: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delete_object: Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 put_metadata: Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']] = None,
                 put_object_hold: Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']] = None,
                 rewrite_object: Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']] = None,
                 schedule_time: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BatchOperationsJob resources.
        :param pulumi.Input['BatchOperationsJobBucketListArgs'] bucket_list: List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
               Structure is documented below.
        :param pulumi.Input[builtins.str] complete_time: The time that the job was completed.
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this storage batch operation was created.
        :param pulumi.Input['BatchOperationsJobDeleteObjectArgs'] delete_object: allows batch operations to delete objects in bucket
               Structure is documented below.
        :param pulumi.Input[builtins.bool] delete_protection: If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        :param pulumi.Input[builtins.str] job_id: The ID of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BatchOperationsJobPutMetadataArgs'] put_metadata: allows batch operations to update metadata for objects in bucket
               Structure is documented below.
        :param pulumi.Input['BatchOperationsJobPutObjectHoldArgs'] put_object_hold: allows to update temporary hold or eventBased hold for objects in bucket.
               Structure is documented below.
        :param pulumi.Input['BatchOperationsJobRewriteObjectArgs'] rewrite_object: allows to update encryption key for objects in bucket.
               Structure is documented below.
        :param pulumi.Input[builtins.str] schedule_time: The time that the job was scheduled.
        :param pulumi.Input[builtins.str] state: State of the job.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this storage batch operation was most recently updated.
        """
        if bucket_list is not None:
            pulumi.set(__self__, "bucket_list", bucket_list)
        if complete_time is not None:
            pulumi.set(__self__, "complete_time", complete_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_object is not None:
            pulumi.set(__self__, "delete_object", delete_object)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if put_metadata is not None:
            pulumi.set(__self__, "put_metadata", put_metadata)
        if put_object_hold is not None:
            pulumi.set(__self__, "put_object_hold", put_object_hold)
        if rewrite_object is not None:
            pulumi.set(__self__, "rewrite_object", rewrite_object)
        if schedule_time is not None:
            pulumi.set(__self__, "schedule_time", schedule_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="bucketList")
    def bucket_list(self) -> Optional[pulumi.Input['BatchOperationsJobBucketListArgs']]:
        """
        List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
        Structure is documented below.
        """
        return pulumi.get(self, "bucket_list")

    @bucket_list.setter
    def bucket_list(self, value: Optional[pulumi.Input['BatchOperationsJobBucketListArgs']]):
        pulumi.set(self, "bucket_list", value)

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time that the job was completed.
        """
        return pulumi.get(self, "complete_time")

    @complete_time.setter
    def complete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "complete_time", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this storage batch operation was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteObject")
    def delete_object(self) -> Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']]:
        """
        allows batch operations to delete objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "delete_object")

    @delete_object.setter
    def delete_object(self, value: Optional[pulumi.Input['BatchOperationsJobDeleteObjectArgs']]):
        pulumi.set(self, "delete_object", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="putMetadata")
    def put_metadata(self) -> Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']]:
        """
        allows batch operations to update metadata for objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "put_metadata")

    @put_metadata.setter
    def put_metadata(self, value: Optional[pulumi.Input['BatchOperationsJobPutMetadataArgs']]):
        pulumi.set(self, "put_metadata", value)

    @property
    @pulumi.getter(name="putObjectHold")
    def put_object_hold(self) -> Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']]:
        """
        allows to update temporary hold or eventBased hold for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "put_object_hold")

    @put_object_hold.setter
    def put_object_hold(self, value: Optional[pulumi.Input['BatchOperationsJobPutObjectHoldArgs']]):
        pulumi.set(self, "put_object_hold", value)

    @property
    @pulumi.getter(name="rewriteObject")
    def rewrite_object(self) -> Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']]:
        """
        allows to update encryption key for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "rewrite_object")

    @rewrite_object.setter
    def rewrite_object(self, value: Optional[pulumi.Input['BatchOperationsJobRewriteObjectArgs']]):
        pulumi.set(self, "rewrite_object", value)

    @property
    @pulumi.getter(name="scheduleTime")
    def schedule_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time that the job was scheduled.
        """
        return pulumi.get(self, "schedule_time")

    @schedule_time.setter
    def schedule_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this storage batch operation was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:storage/batchOperationsJob:BatchOperationsJob")
class BatchOperationsJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_list: Optional[pulumi.Input[Union['BatchOperationsJobBucketListArgs', 'BatchOperationsJobBucketListArgsDict']]] = None,
                 delete_object: Optional[pulumi.Input[Union['BatchOperationsJobDeleteObjectArgs', 'BatchOperationsJobDeleteObjectArgsDict']]] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 put_metadata: Optional[pulumi.Input[Union['BatchOperationsJobPutMetadataArgs', 'BatchOperationsJobPutMetadataArgsDict']]] = None,
                 put_object_hold: Optional[pulumi.Input[Union['BatchOperationsJobPutObjectHoldArgs', 'BatchOperationsJobPutObjectHoldArgsDict']]] = None,
                 rewrite_object: Optional[pulumi.Input[Union['BatchOperationsJobRewriteObjectArgs', 'BatchOperationsJobRewriteObjectArgsDict']]] = None,
                 __props__=None):
        """
        Storage Batch Operations (SBO) is a Cloud Storage management feature that offers a
        seamless experience to perform single batch operations on millions of GCS objects in a
        serverless manner.

        ## Example Usage

        ### Storage Batch Operations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="tf-sample-bucket",
            location="us-central1",
            force_destroy=True)
        tf_job = gcp.storage.BatchOperationsJob("tf-job",
            job_id="tf-job",
            bucket_list={
                "buckets": {
                    "bucket": bucket.name,
                    "prefix_list": {
                        "included_object_prefixes": ["bkt"],
                    },
                },
            },
            put_metadata={
                "custom_metadata": {
                    "key": "value",
                },
            },
            delete_protection=False)
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/jobs/{{job_id}}`

        * `{{project}}/{{job_id}}`

        * `{{job_id}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default projects/{{project}}/locations/global/jobs/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default {{project}}/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default {{job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BatchOperationsJobBucketListArgs', 'BatchOperationsJobBucketListArgsDict']] bucket_list: List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
               Structure is documented below.
        :param pulumi.Input[Union['BatchOperationsJobDeleteObjectArgs', 'BatchOperationsJobDeleteObjectArgsDict']] delete_object: allows batch operations to delete objects in bucket
               Structure is documented below.
        :param pulumi.Input[builtins.bool] delete_protection: If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        :param pulumi.Input[builtins.str] job_id: The ID of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BatchOperationsJobPutMetadataArgs', 'BatchOperationsJobPutMetadataArgsDict']] put_metadata: allows batch operations to update metadata for objects in bucket
               Structure is documented below.
        :param pulumi.Input[Union['BatchOperationsJobPutObjectHoldArgs', 'BatchOperationsJobPutObjectHoldArgsDict']] put_object_hold: allows to update temporary hold or eventBased hold for objects in bucket.
               Structure is documented below.
        :param pulumi.Input[Union['BatchOperationsJobRewriteObjectArgs', 'BatchOperationsJobRewriteObjectArgsDict']] rewrite_object: allows to update encryption key for objects in bucket.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BatchOperationsJobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Storage Batch Operations (SBO) is a Cloud Storage management feature that offers a
        seamless experience to perform single batch operations on millions of GCS objects in a
        serverless manner.

        ## Example Usage

        ### Storage Batch Operations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="tf-sample-bucket",
            location="us-central1",
            force_destroy=True)
        tf_job = gcp.storage.BatchOperationsJob("tf-job",
            job_id="tf-job",
            bucket_list={
                "buckets": {
                    "bucket": bucket.name,
                    "prefix_list": {
                        "included_object_prefixes": ["bkt"],
                    },
                },
            },
            put_metadata={
                "custom_metadata": {
                    "key": "value",
                },
            },
            delete_protection=False)
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/jobs/{{job_id}}`

        * `{{project}}/{{job_id}}`

        * `{{job_id}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default projects/{{project}}/locations/global/jobs/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default {{project}}/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/batchOperationsJob:BatchOperationsJob default {{job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BatchOperationsJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BatchOperationsJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_list: Optional[pulumi.Input[Union['BatchOperationsJobBucketListArgs', 'BatchOperationsJobBucketListArgsDict']]] = None,
                 delete_object: Optional[pulumi.Input[Union['BatchOperationsJobDeleteObjectArgs', 'BatchOperationsJobDeleteObjectArgsDict']]] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 put_metadata: Optional[pulumi.Input[Union['BatchOperationsJobPutMetadataArgs', 'BatchOperationsJobPutMetadataArgsDict']]] = None,
                 put_object_hold: Optional[pulumi.Input[Union['BatchOperationsJobPutObjectHoldArgs', 'BatchOperationsJobPutObjectHoldArgsDict']]] = None,
                 rewrite_object: Optional[pulumi.Input[Union['BatchOperationsJobRewriteObjectArgs', 'BatchOperationsJobRewriteObjectArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BatchOperationsJobArgs.__new__(BatchOperationsJobArgs)

            __props__.__dict__["bucket_list"] = bucket_list
            __props__.__dict__["delete_object"] = delete_object
            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["project"] = project
            __props__.__dict__["put_metadata"] = put_metadata
            __props__.__dict__["put_object_hold"] = put_object_hold
            __props__.__dict__["rewrite_object"] = rewrite_object
            __props__.__dict__["complete_time"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["schedule_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(BatchOperationsJob, __self__).__init__(
            'gcp:storage/batchOperationsJob:BatchOperationsJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_list: Optional[pulumi.Input[Union['BatchOperationsJobBucketListArgs', 'BatchOperationsJobBucketListArgsDict']]] = None,
            complete_time: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delete_object: Optional[pulumi.Input[Union['BatchOperationsJobDeleteObjectArgs', 'BatchOperationsJobDeleteObjectArgsDict']]] = None,
            delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
            job_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            put_metadata: Optional[pulumi.Input[Union['BatchOperationsJobPutMetadataArgs', 'BatchOperationsJobPutMetadataArgsDict']]] = None,
            put_object_hold: Optional[pulumi.Input[Union['BatchOperationsJobPutObjectHoldArgs', 'BatchOperationsJobPutObjectHoldArgsDict']]] = None,
            rewrite_object: Optional[pulumi.Input[Union['BatchOperationsJobRewriteObjectArgs', 'BatchOperationsJobRewriteObjectArgsDict']]] = None,
            schedule_time: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'BatchOperationsJob':
        """
        Get an existing BatchOperationsJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BatchOperationsJobBucketListArgs', 'BatchOperationsJobBucketListArgsDict']] bucket_list: List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
               Structure is documented below.
        :param pulumi.Input[builtins.str] complete_time: The time that the job was completed.
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this storage batch operation was created.
        :param pulumi.Input[Union['BatchOperationsJobDeleteObjectArgs', 'BatchOperationsJobDeleteObjectArgsDict']] delete_object: allows batch operations to delete objects in bucket
               Structure is documented below.
        :param pulumi.Input[builtins.bool] delete_protection: If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        :param pulumi.Input[builtins.str] job_id: The ID of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BatchOperationsJobPutMetadataArgs', 'BatchOperationsJobPutMetadataArgsDict']] put_metadata: allows batch operations to update metadata for objects in bucket
               Structure is documented below.
        :param pulumi.Input[Union['BatchOperationsJobPutObjectHoldArgs', 'BatchOperationsJobPutObjectHoldArgsDict']] put_object_hold: allows to update temporary hold or eventBased hold for objects in bucket.
               Structure is documented below.
        :param pulumi.Input[Union['BatchOperationsJobRewriteObjectArgs', 'BatchOperationsJobRewriteObjectArgsDict']] rewrite_object: allows to update encryption key for objects in bucket.
               Structure is documented below.
        :param pulumi.Input[builtins.str] schedule_time: The time that the job was scheduled.
        :param pulumi.Input[builtins.str] state: State of the job.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this storage batch operation was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BatchOperationsJobState.__new__(_BatchOperationsJobState)

        __props__.__dict__["bucket_list"] = bucket_list
        __props__.__dict__["complete_time"] = complete_time
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_object"] = delete_object
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["project"] = project
        __props__.__dict__["put_metadata"] = put_metadata
        __props__.__dict__["put_object_hold"] = put_object_hold
        __props__.__dict__["rewrite_object"] = rewrite_object
        __props__.__dict__["schedule_time"] = schedule_time
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return BatchOperationsJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketList")
    def bucket_list(self) -> pulumi.Output[Optional['outputs.BatchOperationsJobBucketList']]:
        """
        List of buckets and their objects to be transformed. Currently, only one bucket configuration is supported. If multiple buckets are specified, an error will be returned
        Structure is documented below.
        """
        return pulumi.get(self, "bucket_list")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> pulumi.Output[builtins.str]:
        """
        The time that the job was completed.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this storage batch operation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteObject")
    def delete_object(self) -> pulumi.Output[Optional['outputs.BatchOperationsJobDeleteObject']]:
        """
        allows batch operations to delete objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "delete_object")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to `true`, the storage batch operation job will not be deleted and new job will be created.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="putMetadata")
    def put_metadata(self) -> pulumi.Output[Optional['outputs.BatchOperationsJobPutMetadata']]:
        """
        allows batch operations to update metadata for objects in bucket
        Structure is documented below.
        """
        return pulumi.get(self, "put_metadata")

    @property
    @pulumi.getter(name="putObjectHold")
    def put_object_hold(self) -> pulumi.Output[Optional['outputs.BatchOperationsJobPutObjectHold']]:
        """
        allows to update temporary hold or eventBased hold for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "put_object_hold")

    @property
    @pulumi.getter(name="rewriteObject")
    def rewrite_object(self) -> pulumi.Output[Optional['outputs.BatchOperationsJobRewriteObject']]:
        """
        allows to update encryption key for objects in bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "rewrite_object")

    @property
    @pulumi.getter(name="scheduleTime")
    def schedule_time(self) -> pulumi.Output[builtins.str]:
        """
        The time that the job was scheduled.
        """
        return pulumi.get(self, "schedule_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this storage batch operation was most recently updated.
        """
        return pulumi.get(self, "update_time")

