# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketObjectResult',
    'AwaitableGetBucketObjectResult',
    'get_bucket_object',
    'get_bucket_object_output',
]

@pulumi.output_type
class GetBucketObjectResult:
    """
    A collection of values returned by getBucketObject.
    """
    def __init__(__self__, bucket=None, cache_control=None, content=None, content_disposition=None, content_encoding=None, content_language=None, content_type=None, crc32c=None, customer_encryptions=None, detect_md5hash=None, event_based_hold=None, force_empty_content_type=None, generation=None, id=None, kms_key_name=None, md5hash=None, md5hexhash=None, media_link=None, metadata=None, name=None, output_name=None, retentions=None, self_link=None, source=None, source_md5hash=None, storage_class=None, temporary_hold=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if cache_control and not isinstance(cache_control, str):
            raise TypeError("Expected argument 'cache_control' to be a str")
        pulumi.set(__self__, "cache_control", cache_control)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if content_disposition and not isinstance(content_disposition, str):
            raise TypeError("Expected argument 'content_disposition' to be a str")
        pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding and not isinstance(content_encoding, str):
            raise TypeError("Expected argument 'content_encoding' to be a str")
        pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language and not isinstance(content_language, str):
            raise TypeError("Expected argument 'content_language' to be a str")
        pulumi.set(__self__, "content_language", content_language)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if crc32c and not isinstance(crc32c, str):
            raise TypeError("Expected argument 'crc32c' to be a str")
        pulumi.set(__self__, "crc32c", crc32c)
        if customer_encryptions and not isinstance(customer_encryptions, list):
            raise TypeError("Expected argument 'customer_encryptions' to be a list")
        pulumi.set(__self__, "customer_encryptions", customer_encryptions)
        if detect_md5hash and not isinstance(detect_md5hash, str):
            raise TypeError("Expected argument 'detect_md5hash' to be a str")
        pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if event_based_hold and not isinstance(event_based_hold, bool):
            raise TypeError("Expected argument 'event_based_hold' to be a bool")
        pulumi.set(__self__, "event_based_hold", event_based_hold)
        if force_empty_content_type and not isinstance(force_empty_content_type, bool):
            raise TypeError("Expected argument 'force_empty_content_type' to be a bool")
        pulumi.set(__self__, "force_empty_content_type", force_empty_content_type)
        if generation and not isinstance(generation, int):
            raise TypeError("Expected argument 'generation' to be a int")
        pulumi.set(__self__, "generation", generation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if md5hash and not isinstance(md5hash, str):
            raise TypeError("Expected argument 'md5hash' to be a str")
        pulumi.set(__self__, "md5hash", md5hash)
        if md5hexhash and not isinstance(md5hexhash, str):
            raise TypeError("Expected argument 'md5hexhash' to be a str")
        pulumi.set(__self__, "md5hexhash", md5hexhash)
        if media_link and not isinstance(media_link, str):
            raise TypeError("Expected argument 'media_link' to be a str")
        pulumi.set(__self__, "media_link", media_link)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_name and not isinstance(output_name, str):
            raise TypeError("Expected argument 'output_name' to be a str")
        pulumi.set(__self__, "output_name", output_name)
        if retentions and not isinstance(retentions, list):
            raise TypeError("Expected argument 'retentions' to be a list")
        pulumi.set(__self__, "retentions", retentions)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if source_md5hash and not isinstance(source_md5hash, str):
            raise TypeError("Expected argument 'source_md5hash' to be a str")
        pulumi.set(__self__, "source_md5hash", source_md5hash)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)
        if temporary_hold and not isinstance(temporary_hold, bool):
            raise TypeError("Expected argument 'temporary_hold' to be a bool")
        pulumi.set(__self__, "temporary_hold", temporary_hold)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> builtins.str:
        """
        (Computed) [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
        directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> builtins.str:
        """
        (Computed) [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> builtins.str:
        """
        (Computed) [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> builtins.str:
        """
        (Computed) [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        (Computed) [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def crc32c(self) -> builtins.str:
        """
        (Computed) Base 64 CRC32 hash of the uploaded data.
        """
        return pulumi.get(self, "crc32c")

    @property
    @pulumi.getter(name="customerEncryptions")
    def customer_encryptions(self) -> Sequence['outputs.GetBucketObjectCustomerEncryptionResult']:
        return pulumi.get(self, "customer_encryptions")

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> builtins.str:
        return pulumi.get(self, "detect_md5hash")

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> builtins.bool:
        """
        (Computed) Whether an object is under [event-based hold](https://cloud.google.com/storage/docs/object-holds#hold-types). Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
        """
        return pulumi.get(self, "event_based_hold")

    @property
    @pulumi.getter(name="forceEmptyContentType")
    def force_empty_content_type(self) -> builtins.bool:
        return pulumi.get(self, "force_empty_content_type")

    @property
    @pulumi.getter
    def generation(self) -> builtins.int:
        """
        (Computed) The content generation of this object. Used for object [versioning](https://cloud.google.com/storage/docs/object-versioning) and [soft delete](https://cloud.google.com/storage/docs/soft-delete).
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def md5hash(self) -> builtins.str:
        """
        (Computed) Base 64 MD5 hash of the uploaded data.
        """
        return pulumi.get(self, "md5hash")

    @property
    @pulumi.getter
    def md5hexhash(self) -> builtins.str:
        return pulumi.get(self, "md5hexhash")

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> builtins.str:
        """
        (Computed) A url reference to download this object.
        """
        return pulumi.get(self, "media_link")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputName")
    def output_name(self) -> builtins.str:
        return pulumi.get(self, "output_name")

    @property
    @pulumi.getter
    def retentions(self) -> Sequence['outputs.GetBucketObjectRetentionResult']:
        return pulumi.get(self, "retentions")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        (Computed) A url reference to this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceMd5hash")
    def source_md5hash(self) -> builtins.str:
        return pulumi.get(self, "source_md5hash")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> builtins.str:
        """
        (Computed) The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
        Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
        storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> builtins.bool:
        """
        (Computed) Whether an object is under [temporary hold](https://cloud.google.com/storage/docs/object-holds#hold-types). While this flag is set to true, the object is protected against deletion and overwrites.
        """
        return pulumi.get(self, "temporary_hold")


class AwaitableGetBucketObjectResult(GetBucketObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketObjectResult(
            bucket=self.bucket,
            cache_control=self.cache_control,
            content=self.content,
            content_disposition=self.content_disposition,
            content_encoding=self.content_encoding,
            content_language=self.content_language,
            content_type=self.content_type,
            crc32c=self.crc32c,
            customer_encryptions=self.customer_encryptions,
            detect_md5hash=self.detect_md5hash,
            event_based_hold=self.event_based_hold,
            force_empty_content_type=self.force_empty_content_type,
            generation=self.generation,
            id=self.id,
            kms_key_name=self.kms_key_name,
            md5hash=self.md5hash,
            md5hexhash=self.md5hexhash,
            media_link=self.media_link,
            metadata=self.metadata,
            name=self.name,
            output_name=self.output_name,
            retentions=self.retentions,
            self_link=self.self_link,
            source=self.source,
            source_md5hash=self.source_md5hash,
            storage_class=self.storage_class,
            temporary_hold=self.temporary_hold)


def get_bucket_object(bucket: Optional[builtins.str] = None,
                      name: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketObjectResult:
    """
    Gets an existing object inside an existing bucket in Google Cloud Storage service (GCS).
    See [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
    and
    [API](https://cloud.google.com/storage/docs/json_api/v1/objects).

    ## Example Usage

    Example picture stored within a folder.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    picture = gcp.storage.get_bucket_object(name="folder/butterfly01.jpg",
        bucket="image-store")
    ```


    :param builtins.str bucket: The name of the containing bucket.
    :param builtins.str name: The name of the object.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:storage/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult).value

    return AwaitableGetBucketObjectResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        cache_control=pulumi.get(__ret__, 'cache_control'),
        content=pulumi.get(__ret__, 'content'),
        content_disposition=pulumi.get(__ret__, 'content_disposition'),
        content_encoding=pulumi.get(__ret__, 'content_encoding'),
        content_language=pulumi.get(__ret__, 'content_language'),
        content_type=pulumi.get(__ret__, 'content_type'),
        crc32c=pulumi.get(__ret__, 'crc32c'),
        customer_encryptions=pulumi.get(__ret__, 'customer_encryptions'),
        detect_md5hash=pulumi.get(__ret__, 'detect_md5hash'),
        event_based_hold=pulumi.get(__ret__, 'event_based_hold'),
        force_empty_content_type=pulumi.get(__ret__, 'force_empty_content_type'),
        generation=pulumi.get(__ret__, 'generation'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_name=pulumi.get(__ret__, 'kms_key_name'),
        md5hash=pulumi.get(__ret__, 'md5hash'),
        md5hexhash=pulumi.get(__ret__, 'md5hexhash'),
        media_link=pulumi.get(__ret__, 'media_link'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        output_name=pulumi.get(__ret__, 'output_name'),
        retentions=pulumi.get(__ret__, 'retentions'),
        self_link=pulumi.get(__ret__, 'self_link'),
        source=pulumi.get(__ret__, 'source'),
        source_md5hash=pulumi.get(__ret__, 'source_md5hash'),
        storage_class=pulumi.get(__ret__, 'storage_class'),
        temporary_hold=pulumi.get(__ret__, 'temporary_hold'))
def get_bucket_object_output(bucket: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketObjectResult]:
    """
    Gets an existing object inside an existing bucket in Google Cloud Storage service (GCS).
    See [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
    and
    [API](https://cloud.google.com/storage/docs/json_api/v1/objects).

    ## Example Usage

    Example picture stored within a folder.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    picture = gcp.storage.get_bucket_object(name="folder/butterfly01.jpg",
        bucket="image-store")
    ```


    :param builtins.str bucket: The name of the containing bucket.
    :param builtins.str name: The name of the object.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:storage/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult)
    return __ret__.apply(lambda __response__: GetBucketObjectResult(
        bucket=pulumi.get(__response__, 'bucket'),
        cache_control=pulumi.get(__response__, 'cache_control'),
        content=pulumi.get(__response__, 'content'),
        content_disposition=pulumi.get(__response__, 'content_disposition'),
        content_encoding=pulumi.get(__response__, 'content_encoding'),
        content_language=pulumi.get(__response__, 'content_language'),
        content_type=pulumi.get(__response__, 'content_type'),
        crc32c=pulumi.get(__response__, 'crc32c'),
        customer_encryptions=pulumi.get(__response__, 'customer_encryptions'),
        detect_md5hash=pulumi.get(__response__, 'detect_md5hash'),
        event_based_hold=pulumi.get(__response__, 'event_based_hold'),
        force_empty_content_type=pulumi.get(__response__, 'force_empty_content_type'),
        generation=pulumi.get(__response__, 'generation'),
        id=pulumi.get(__response__, 'id'),
        kms_key_name=pulumi.get(__response__, 'kms_key_name'),
        md5hash=pulumi.get(__response__, 'md5hash'),
        md5hexhash=pulumi.get(__response__, 'md5hexhash'),
        media_link=pulumi.get(__response__, 'media_link'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        output_name=pulumi.get(__response__, 'output_name'),
        retentions=pulumi.get(__response__, 'retentions'),
        self_link=pulumi.get(__response__, 'self_link'),
        source=pulumi.get(__response__, 'source'),
        source_md5hash=pulumi.get(__response__, 'source_md5hash'),
        storage_class=pulumi.get(__response__, 'storage_class'),
        temporary_hold=pulumi.get(__response__, 'temporary_hold')))
