# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTagValuesResult',
    'AwaitableGetTagValuesResult',
    'get_tag_values',
    'get_tag_values_output',
]

@pulumi.output_type
class GetTagValuesResult:
    """
    A collection of values returned by getTagValues.
    """
    def __init__(__self__, id=None, parent=None, values=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        """
        The resource name of the new TagValue's parent TagKey. Must be of the form tagKeys/{tag_key_id}.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetTagValuesValueResult']:
        return pulumi.get(self, "values")


class AwaitableGetTagValuesResult(GetTagValuesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagValuesResult(
            id=self.id,
            parent=self.parent,
            values=self.values)


def get_tag_values(parent: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagValuesResult:
    """
    Get tag values from a `parent` key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_values = gcp.tags.get_tag_values(parent="tagKeys/56789")
    ```


    :param builtins.str parent: The resource name of the parent tagKey in format `tagKey/{name}`.
    """
    __args__ = dict()
    __args__['parent'] = parent
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:tags/getTagValues:getTagValues', __args__, opts=opts, typ=GetTagValuesResult).value

    return AwaitableGetTagValuesResult(
        id=pulumi.get(__ret__, 'id'),
        parent=pulumi.get(__ret__, 'parent'),
        values=pulumi.get(__ret__, 'values'))
def get_tag_values_output(parent: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagValuesResult]:
    """
    Get tag values from a `parent` key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_values = gcp.tags.get_tag_values(parent="tagKeys/56789")
    ```


    :param builtins.str parent: The resource name of the parent tagKey in format `tagKey/{name}`.
    """
    __args__ = dict()
    __args__['parent'] = parent
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:tags/getTagValues:getTagValues', __args__, opts=opts, typ=GetTagValuesResult)
    return __ret__.apply(lambda __response__: GetTagValuesResult(
        id=pulumi.get(__response__, 'id'),
        parent=pulumi.get(__response__, 'parent'),
        values=pulumi.get(__response__, 'values')))
