# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2QueuedResourceArgs', 'V2QueuedResource']

@pulumi.input_type
class V2QueuedResourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tpu: Optional[pulumi.Input['V2QueuedResourceTpuArgs']] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a V2QueuedResource resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the Queued Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['V2QueuedResourceTpuArgs'] tpu: Defines a TPU resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tpu is not None:
            pulumi.set(__self__, "tpu", tpu)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the Queued Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tpu(self) -> Optional[pulumi.Input['V2QueuedResourceTpuArgs']]:
        """
        Defines a TPU resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tpu")

    @tpu.setter
    def tpu(self, value: Optional[pulumi.Input['V2QueuedResourceTpuArgs']]):
        pulumi.set(self, "tpu", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _V2QueuedResourceState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tpu: Optional[pulumi.Input['V2QueuedResourceTpuArgs']] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering V2QueuedResource resources.
        :param pulumi.Input[builtins.str] name: The immutable name of the Queued Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['V2QueuedResourceTpuArgs'] tpu: Defines a TPU resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tpu is not None:
            pulumi.set(__self__, "tpu", tpu)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the Queued Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tpu(self) -> Optional[pulumi.Input['V2QueuedResourceTpuArgs']]:
        """
        Defines a TPU resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tpu")

    @tpu.setter
    def tpu(self, value: Optional[pulumi.Input['V2QueuedResourceTpuArgs']]):
        pulumi.set(self, "tpu", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:tpu/v2QueuedResource:V2QueuedResource")
class V2QueuedResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tpu: Optional[pulumi.Input[Union['V2QueuedResourceTpuArgs', 'V2QueuedResourceTpuArgsDict']]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Tpu V2 Queued Resource Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        qr = gcp.tpu.V2QueuedResource("qr",
            name="test-qr",
            zone="us-central1-c",
            project="my-project-name",
            tpu={
                "node_specs": [{
                    "parent": "projects/my-project-name/locations/us-central1-c",
                    "node_id": "test-tpu",
                    "node": {
                        "runtime_version": "tpu-vm-tf-2.13.0",
                        "accelerator_type": "v2-8",
                        "description": "Text description of the TPU.",
                    },
                }],
            })
        ```
        ### Tpu V2 Queued Resource Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="tpu-net",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="tpu-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=network.id)
        qr = gcp.tpu.V2QueuedResource("qr",
            name="test-qr",
            zone="us-central1-c",
            project="my-project-name",
            tpu={
                "node_specs": [{
                    "parent": "projects/my-project-name/locations/us-central1-c",
                    "node_id": "test-tpu",
                    "node": {
                        "runtime_version": "tpu-vm-tf-2.13.0",
                        "accelerator_type": "v2-8",
                        "description": "Text description of the TPU.",
                        "network_config": {
                            "can_ip_forward": True,
                            "enable_external_ips": True,
                            "network": network.id,
                            "subnetwork": subnet.id,
                            "queue_count": 32,
                        },
                    },
                }],
            })
        ```

        ## Import

        QueuedResource can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/queuedResources/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, QueuedResource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default projects/{{project}}/locations/{{zone}}/queuedResources/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the Queued Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['V2QueuedResourceTpuArgs', 'V2QueuedResourceTpuArgsDict']] tpu: Defines a TPU resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[V2QueuedResourceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Tpu V2 Queued Resource Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        qr = gcp.tpu.V2QueuedResource("qr",
            name="test-qr",
            zone="us-central1-c",
            project="my-project-name",
            tpu={
                "node_specs": [{
                    "parent": "projects/my-project-name/locations/us-central1-c",
                    "node_id": "test-tpu",
                    "node": {
                        "runtime_version": "tpu-vm-tf-2.13.0",
                        "accelerator_type": "v2-8",
                        "description": "Text description of the TPU.",
                    },
                }],
            })
        ```
        ### Tpu V2 Queued Resource Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="tpu-net",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="tpu-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=network.id)
        qr = gcp.tpu.V2QueuedResource("qr",
            name="test-qr",
            zone="us-central1-c",
            project="my-project-name",
            tpu={
                "node_specs": [{
                    "parent": "projects/my-project-name/locations/us-central1-c",
                    "node_id": "test-tpu",
                    "node": {
                        "runtime_version": "tpu-vm-tf-2.13.0",
                        "accelerator_type": "v2-8",
                        "description": "Text description of the TPU.",
                        "network_config": {
                            "can_ip_forward": True,
                            "enable_external_ips": True,
                            "network": network.id,
                            "subnetwork": subnet.id,
                            "queue_count": 32,
                        },
                    },
                }],
            })
        ```

        ## Import

        QueuedResource can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/queuedResources/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, QueuedResource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default projects/{{project}}/locations/{{zone}}/queuedResources/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2QueuedResource:V2QueuedResource default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param V2QueuedResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2QueuedResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tpu: Optional[pulumi.Input[Union['V2QueuedResourceTpuArgs', 'V2QueuedResourceTpuArgsDict']]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2QueuedResourceArgs.__new__(V2QueuedResourceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["tpu"] = tpu
            __props__.__dict__["zone"] = zone
        super(V2QueuedResource, __self__).__init__(
            'gcp:tpu/v2QueuedResource:V2QueuedResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            tpu: Optional[pulumi.Input[Union['V2QueuedResourceTpuArgs', 'V2QueuedResourceTpuArgsDict']]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'V2QueuedResource':
        """
        Get an existing V2QueuedResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the Queued Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['V2QueuedResourceTpuArgs', 'V2QueuedResourceTpuArgsDict']] tpu: Defines a TPU resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2QueuedResourceState.__new__(_V2QueuedResourceState)

        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tpu"] = tpu
        __props__.__dict__["zone"] = zone
        return V2QueuedResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The immutable name of the Queued Resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tpu(self) -> pulumi.Output[Optional['outputs.V2QueuedResourceTpu']]:
        """
        Defines a TPU resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tpu")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The GCP location for the Queued Resource. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

