# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiDeploymentResourcePoolArgs', 'AiDeploymentResourcePool']

@pulumi.input_type
class AiDeploymentResourcePoolArgs:
    def __init__(__self__, *,
                 dedicated_resources: Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AiDeploymentResourcePool resource.
        :param pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs'] dedicated_resources: The underlying dedicated resources that the deployment resource pool uses.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of deployment resource pool. eg us-central1
        """
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']]:
        """
        The underlying dedicated resources that the deployment resource pool uses.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @dedicated_resources.setter
    def dedicated_resources(self, value: Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']]):
        pulumi.set(self, "dedicated_resources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of deployment resource pool. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AiDeploymentResourcePoolState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_resources: Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiDeploymentResourcePool resources.
        :param pulumi.Input[builtins.str] create_time: A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs'] dedicated_resources: The underlying dedicated resources that the deployment resource pool uses.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of deployment resource pool. eg us-central1
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']]:
        """
        The underlying dedicated resources that the deployment resource pool uses.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @dedicated_resources.setter
    def dedicated_resources(self, value: Optional[pulumi.Input['AiDeploymentResourcePoolDedicatedResourcesArgs']]):
        pulumi.set(self, "dedicated_resources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of deployment resource pool. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool")
class AiDeploymentResourcePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_resources: Optional[pulumi.Input[Union['AiDeploymentResourcePoolDedicatedResourcesArgs', 'AiDeploymentResourcePoolDedicatedResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        'DeploymentResourcePool can be shared by multiple deployed models,
        whose underlying specification consists of dedicated resources.'

        To get more information about DeploymentResourcePool, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.deploymentResourcePools)

        ## Example Usage

        ### Vertex Ai Deployment Resource Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deployment_resource_pool = gcp.vertex.AiDeploymentResourcePool("deployment_resource_pool",
            region="us-central1",
            name="example-deployment-resource-pool",
            dedicated_resources={
                "machine_spec": {
                    "machine_type": "n1-standard-4",
                    "accelerator_type": "NVIDIA_TESLA_P4",
                    "accelerator_count": 1,
                },
                "min_replica_count": 1,
                "max_replica_count": 2,
                "autoscaling_metric_specs": [{
                    "metric_name": "aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle",
                    "target": 60,
                }],
            })
        ```

        ## Import

        DeploymentResourcePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/deploymentResourcePools/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, DeploymentResourcePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default projects/{{project}}/locations/{{region}}/deploymentResourcePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiDeploymentResourcePoolDedicatedResourcesArgs', 'AiDeploymentResourcePoolDedicatedResourcesArgsDict']] dedicated_resources: The underlying dedicated resources that the deployment resource pool uses.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of deployment resource pool. eg us-central1
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AiDeploymentResourcePoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        'DeploymentResourcePool can be shared by multiple deployed models,
        whose underlying specification consists of dedicated resources.'

        To get more information about DeploymentResourcePool, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.deploymentResourcePools)

        ## Example Usage

        ### Vertex Ai Deployment Resource Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deployment_resource_pool = gcp.vertex.AiDeploymentResourcePool("deployment_resource_pool",
            region="us-central1",
            name="example-deployment-resource-pool",
            dedicated_resources={
                "machine_spec": {
                    "machine_type": "n1-standard-4",
                    "accelerator_type": "NVIDIA_TESLA_P4",
                    "accelerator_count": 1,
                },
                "min_replica_count": 1,
                "max_replica_count": 2,
                "autoscaling_metric_specs": [{
                    "metric_name": "aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle",
                    "target": 60,
                }],
            })
        ```

        ## Import

        DeploymentResourcePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/deploymentResourcePools/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, DeploymentResourcePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default projects/{{project}}/locations/{{region}}/deploymentResourcePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiDeploymentResourcePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiDeploymentResourcePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_resources: Optional[pulumi.Input[Union['AiDeploymentResourcePoolDedicatedResourcesArgs', 'AiDeploymentResourcePoolDedicatedResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiDeploymentResourcePoolArgs.__new__(AiDeploymentResourcePoolArgs)

            __props__.__dict__["dedicated_resources"] = dedicated_resources
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["create_time"] = None
        super(AiDeploymentResourcePool, __self__).__init__(
            'gcp:vertex/aiDeploymentResourcePool:AiDeploymentResourcePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            dedicated_resources: Optional[pulumi.Input[Union['AiDeploymentResourcePoolDedicatedResourcesArgs', 'AiDeploymentResourcePoolDedicatedResourcesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'AiDeploymentResourcePool':
        """
        Get an existing AiDeploymentResourcePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Union['AiDeploymentResourcePoolDedicatedResourcesArgs', 'AiDeploymentResourcePoolDedicatedResourcesArgsDict']] dedicated_resources: The underlying dedicated resources that the deployment resource pool uses.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of deployment resource pool. eg us-central1
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiDeploymentResourcePoolState.__new__(_AiDeploymentResourcePoolState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dedicated_resources"] = dedicated_resources
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return AiDeploymentResourcePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> pulumi.Output[Optional['outputs.AiDeploymentResourcePoolDedicatedResources']]:
        """
        The underlying dedicated resources that the deployment resource pool uses.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of deployment resource pool. The maximum length is 63 characters, and valid characters are `/^a-z?$/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The region of deployment resource pool. eg us-central1
        """
        return pulumi.get(self, "region")

