# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AiDatasetEncryptionSpec',
    'AiDeploymentResourcePoolDedicatedResources',
    'AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec',
    'AiDeploymentResourcePoolDedicatedResourcesMachineSpec',
    'AiEndpointDeployedModel',
    'AiEndpointDeployedModelAutomaticResource',
    'AiEndpointDeployedModelDedicatedResource',
    'AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec',
    'AiEndpointDeployedModelDedicatedResourceMachineSpec',
    'AiEndpointDeployedModelPrivateEndpoint',
    'AiEndpointEncryptionSpec',
    'AiEndpointIamBindingCondition',
    'AiEndpointIamMemberCondition',
    'AiEndpointPredictRequestResponseLoggingConfig',
    'AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination',
    'AiEndpointPrivateServiceConnectConfig',
    'AiFeatureGroupBigQuery',
    'AiFeatureGroupBigQueryBigQuerySource',
    'AiFeatureGroupIamBindingCondition',
    'AiFeatureGroupIamMemberCondition',
    'AiFeatureOnlineStoreBigtable',
    'AiFeatureOnlineStoreBigtableAutoScaling',
    'AiFeatureOnlineStoreDedicatedServingEndpoint',
    'AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig',
    'AiFeatureOnlineStoreEmbeddingManagement',
    'AiFeatureOnlineStoreFeatureviewBigQuerySource',
    'AiFeatureOnlineStoreFeatureviewFeatureRegistrySource',
    'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup',
    'AiFeatureOnlineStoreFeatureviewIamBindingCondition',
    'AiFeatureOnlineStoreFeatureviewIamMemberCondition',
    'AiFeatureOnlineStoreFeatureviewSyncConfig',
    'AiFeatureOnlineStoreFeatureviewVectorSearchConfig',
    'AiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig',
    'AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig',
    'AiFeatureOnlineStoreIamBindingCondition',
    'AiFeatureOnlineStoreIamMemberCondition',
    'AiFeatureOnlineStoreOptimized',
    'AiFeatureStoreEncryptionSpec',
    'AiFeatureStoreEntityTypeIamBindingCondition',
    'AiFeatureStoreEntityTypeIamMemberCondition',
    'AiFeatureStoreEntityTypeMonitoringConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis',
    'AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis',
    'AiFeatureStoreIamBindingCondition',
    'AiFeatureStoreIamMemberCondition',
    'AiFeatureStoreOnlineServingConfig',
    'AiFeatureStoreOnlineServingConfigScaling',
    'AiIndexDeployedIndex',
    'AiIndexEndpointDeployedIndexAutomaticResources',
    'AiIndexEndpointDeployedIndexDedicatedResources',
    'AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec',
    'AiIndexEndpointDeployedIndexDeployedIndexAuthConfig',
    'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider',
    'AiIndexEndpointDeployedIndexPrivateEndpoint',
    'AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint',
    'AiIndexEndpointPrivateServiceConnectConfig',
    'AiIndexIndexStat',
    'AiIndexMetadata',
    'AiIndexMetadataConfig',
    'AiIndexMetadataConfigAlgorithmConfig',
    'AiIndexMetadataConfigAlgorithmConfigBruteForceConfig',
    'AiIndexMetadataConfigAlgorithmConfigTreeAhConfig',
    'AiMetadataStoreEncryptionSpec',
    'AiMetadataStoreState',
    'AiTensorboardEncryptionSpec',
    'GetAiIndexDeployedIndexResult',
    'GetAiIndexIndexStatResult',
    'GetAiIndexMetadataResult',
    'GetAiIndexMetadataConfigResult',
    'GetAiIndexMetadataConfigAlgorithmConfigResult',
    'GetAiIndexMetadataConfigAlgorithmConfigBruteForceConfigResult',
    'GetAiIndexMetadataConfigAlgorithmConfigTreeAhConfigResult',
]

@pulumi.output_type
class AiDatasetEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiDatasetEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiDatasetEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiDatasetEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[builtins.str]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiDeploymentResourcePoolDedicatedResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineSpec":
            suggest = "machine_spec"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"
        elif key == "autoscalingMetricSpecs":
            suggest = "autoscaling_metric_specs"
        elif key == "maxReplicaCount":
            suggest = "max_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiDeploymentResourcePoolDedicatedResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiDeploymentResourcePoolDedicatedResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiDeploymentResourcePoolDedicatedResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_spec: 'outputs.AiDeploymentResourcePoolDedicatedResourcesMachineSpec',
                 min_replica_count: builtins.int,
                 autoscaling_metric_specs: Optional[Sequence['outputs.AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec']] = None,
                 max_replica_count: Optional[builtins.int] = None):
        """
        :param 'AiDeploymentResourcePoolDedicatedResourcesMachineSpecArgs' machine_spec: The specification of a single machine used by the prediction
               Structure is documented below.
        :param builtins.int min_replica_count: The minimum number of machine replicas this DeployedModel will be always deployed on. This value must be greater than or equal to 1. If traffic against the DeployedModel increases, it may dynamically be deployed onto more replicas, and as traffic decreases, some of these extra replicas may be freed.
        :param Sequence['AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpecArgs'] autoscaling_metric_specs: A list of the metric specifications that overrides a resource utilization metric.
               Structure is documented below.
        :param builtins.int max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, will use min_replica_count as the default value. The value of this field impacts the charge against Vertex CPU and GPU quotas. Specifically, you will be charged for max_replica_count * number of cores in the selected machine type) and (max_replica_count * number of GPUs per replica in the selected machine type).
        """
        pulumi.set(__self__, "machine_spec", machine_spec)
        pulumi.set(__self__, "min_replica_count", min_replica_count)
        if autoscaling_metric_specs is not None:
            pulumi.set(__self__, "autoscaling_metric_specs", autoscaling_metric_specs)
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)

    @property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> 'outputs.AiDeploymentResourcePoolDedicatedResourcesMachineSpec':
        """
        The specification of a single machine used by the prediction
        Structure is documented below.
        """
        return pulumi.get(self, "machine_spec")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> builtins.int:
        """
        The minimum number of machine replicas this DeployedModel will be always deployed on. This value must be greater than or equal to 1. If traffic against the DeployedModel increases, it may dynamically be deployed onto more replicas, and as traffic decreases, some of these extra replicas may be freed.
        """
        return pulumi.get(self, "min_replica_count")

    @property
    @pulumi.getter(name="autoscalingMetricSpecs")
    def autoscaling_metric_specs(self) -> Optional[Sequence['outputs.AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec']]:
        """
        A list of the metric specifications that overrides a resource utilization metric.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_metric_specs")

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[builtins.int]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, will use min_replica_count as the default value. The value of this field impacts the charge against Vertex CPU and GPU quotas. Specifically, you will be charged for max_replica_count * number of cores in the selected machine type) and (max_replica_count * number of GPUs per replica in the selected machine type).
        """
        return pulumi.get(self, "max_replica_count")


@pulumi.output_type
class AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiDeploymentResourcePoolDedicatedResourcesAutoscalingMetricSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: builtins.str,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.str metric_name: The resource metric name. Supported metrics: For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        :param builtins.int target: The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        The resource metric name. Supported metrics: For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AiDeploymentResourcePoolDedicatedResourcesMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiDeploymentResourcePoolDedicatedResourcesMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiDeploymentResourcePoolDedicatedResourcesMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiDeploymentResourcePoolDedicatedResourcesMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[builtins.int] = None,
                 accelerator_type: Optional[builtins.str] = None,
                 machine_type: Optional[builtins.str] = None):
        """
        :param builtins.int accelerator_count: The number of accelerators to attach to the machine.
        :param builtins.str accelerator_type: The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        :param builtins.str machine_type: The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types).
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[builtins.int]:
        """
        The number of accelerators to attach to the machine.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[builtins.str]:
        """
        The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[builtins.str]:
        """
        The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types).
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class AiEndpointDeployedModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticResources":
            suggest = "automatic_resources"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "dedicatedResources":
            suggest = "dedicated_resources"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "enableAccessLogging":
            suggest = "enable_access_logging"
        elif key == "enableContainerLogging":
            suggest = "enable_container_logging"
        elif key == "modelVersionId":
            suggest = "model_version_id"
        elif key == "privateEndpoints":
            suggest = "private_endpoints"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sharedResources":
            suggest = "shared_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_resources: Optional[Sequence['outputs.AiEndpointDeployedModelAutomaticResource']] = None,
                 create_time: Optional[builtins.str] = None,
                 dedicated_resources: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResource']] = None,
                 display_name: Optional[builtins.str] = None,
                 enable_access_logging: Optional[builtins.bool] = None,
                 enable_container_logging: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None,
                 model: Optional[builtins.str] = None,
                 model_version_id: Optional[builtins.str] = None,
                 private_endpoints: Optional[Sequence['outputs.AiEndpointDeployedModelPrivateEndpoint']] = None,
                 service_account: Optional[builtins.str] = None,
                 shared_resources: Optional[builtins.str] = None):
        """
        :param Sequence['AiEndpointDeployedModelAutomaticResourceArgs'] automatic_resources: (Output)
               A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
               Structure is documented below.
        :param builtins.str create_time: (Output)
               Output only. Timestamp when the DeployedModel was created.
        :param Sequence['AiEndpointDeployedModelDedicatedResourceArgs'] dedicated_resources: (Output)
               A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
               Structure is documented below.
        :param builtins.str display_name: Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param builtins.bool enable_access_logging: (Output)
               These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        :param builtins.bool enable_container_logging: (Output)
               If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        :param builtins.str id: (Output)
               The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        :param builtins.str model: (Output)
               The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        :param builtins.str model_version_id: (Output)
               Output only. The version ID of the model that is deployed.
        :param Sequence['AiEndpointDeployedModelPrivateEndpointArgs'] private_endpoints: (Output)
               Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
               Structure is documented below.
        :param builtins.str service_account: (Output)
               The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        :param builtins.str shared_resources: (Output)
               The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        if automatic_resources is not None:
            pulumi.set(__self__, "automatic_resources", automatic_resources)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_access_logging is not None:
            pulumi.set(__self__, "enable_access_logging", enable_access_logging)
        if enable_container_logging is not None:
            pulumi.set(__self__, "enable_container_logging", enable_container_logging)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_version_id is not None:
            pulumi.set(__self__, "model_version_id", model_version_id)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shared_resources is not None:
            pulumi.set(__self__, "shared_resources", shared_resources)

    @property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelAutomaticResource']]:
        """
        (Output)
        A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Timestamp when the DeployedModel was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResource']]:
        """
        (Output)
        A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> Optional[builtins.bool]:
        """
        (Output)
        These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        """
        return pulumi.get(self, "enable_access_logging")

    @property
    @pulumi.getter(name="enableContainerLogging")
    def enable_container_logging(self) -> Optional[builtins.bool]:
        """
        (Output)
        If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        """
        return pulumi.get(self, "enable_container_logging")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        (Output)
        The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def model(self) -> Optional[builtins.str]:
        """
        (Output)
        The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="modelVersionId")
    def model_version_id(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The version ID of the model that is deployed.
        """
        return pulumi.get(self, "model_version_id")

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelPrivateEndpoint']]:
        """
        (Output)
        Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
        Structure is documented below.
        """
        return pulumi.get(self, "private_endpoints")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[builtins.str]:
        """
        (Output)
        The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="sharedResources")
    def shared_resources(self) -> Optional[builtins.str]:
        """
        (Output)
        The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        return pulumi.get(self, "shared_resources")


@pulumi.output_type
class AiEndpointDeployedModelAutomaticResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicaCount":
            suggest = "max_replica_count"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelAutomaticResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelAutomaticResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelAutomaticResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replica_count: Optional[builtins.int] = None,
                 min_replica_count: Optional[builtins.int] = None):
        """
        :param builtins.int max_replica_count: (Output)
               The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param builtins.int min_replica_count: (Output)
               The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingMetricSpecs":
            suggest = "autoscaling_metric_specs"
        elif key == "machineSpecs":
            suggest = "machine_specs"
        elif key == "maxReplicaCount":
            suggest = "max_replica_count"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_metric_specs: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec']] = None,
                 machine_specs: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceMachineSpec']] = None,
                 max_replica_count: Optional[builtins.int] = None,
                 min_replica_count: Optional[builtins.int] = None):
        """
        :param Sequence['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs'] autoscaling_metric_specs: (Output)
               The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
               Structure is documented below.
        :param Sequence['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs'] machine_specs: (Output)
               The specification of a single machine used by the prediction.
               Structure is documented below.
        :param builtins.int max_replica_count: (Output)
               The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param builtins.int min_replica_count: (Output)
               The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if autoscaling_metric_specs is not None:
            pulumi.set(__self__, "autoscaling_metric_specs", autoscaling_metric_specs)
        if machine_specs is not None:
            pulumi.set(__self__, "machine_specs", machine_specs)
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="autoscalingMetricSpecs")
    def autoscaling_metric_specs(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec']]:
        """
        (Output)
        The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_metric_specs")

    @property
    @pulumi.getter(name="machineSpecs")
    def machine_specs(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceMachineSpec']]:
        """
        (Output)
        The specification of a single machine used by the prediction.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_specs")

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: Optional[builtins.str] = None,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.str metric_name: (Output)
               The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        :param builtins.int target: (Output)
               The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[builtins.str]:
        """
        (Output)
        The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        (Output)
        The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResourceMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResourceMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResourceMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResourceMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[builtins.int] = None,
                 accelerator_type: Optional[builtins.str] = None,
                 machine_type: Optional[builtins.str] = None):
        """
        :param builtins.int accelerator_count: (Output)
               The number of accelerators to attach to the machine.
        :param builtins.str accelerator_type: (Output)
               The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        :param builtins.str machine_type: (Output)
               The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The number of accelerators to attach to the machine.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[builtins.str]:
        """
        (Output)
        The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[builtins.str]:
        """
        (Output)
        The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class AiEndpointDeployedModelPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "explainHttpUri":
            suggest = "explain_http_uri"
        elif key == "healthHttpUri":
            suggest = "health_http_uri"
        elif key == "predictHttpUri":
            suggest = "predict_http_uri"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 explain_http_uri: Optional[builtins.str] = None,
                 health_http_uri: Optional[builtins.str] = None,
                 predict_http_uri: Optional[builtins.str] = None,
                 service_attachment: Optional[builtins.str] = None):
        """
        :param builtins.str explain_http_uri: (Output)
               Output only. Http(s) path to send explain requests.
        :param builtins.str health_http_uri: (Output)
               Output only. Http(s) path to send health check requests.
        :param builtins.str predict_http_uri: (Output)
               Output only. Http(s) path to send prediction requests.
        :param builtins.str service_attachment: (Output)
               Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        if explain_http_uri is not None:
            pulumi.set(__self__, "explain_http_uri", explain_http_uri)
        if health_http_uri is not None:
            pulumi.set(__self__, "health_http_uri", health_http_uri)
        if predict_http_uri is not None:
            pulumi.set(__self__, "predict_http_uri", predict_http_uri)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="explainHttpUri")
    def explain_http_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Http(s) path to send explain requests.
        """
        return pulumi.get(self, "explain_http_uri")

    @property
    @pulumi.getter(name="healthHttpUri")
    def health_http_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Http(s) path to send health check requests.
        """
        return pulumi.get(self, "health_http_uri")

    @property
    @pulumi.getter(name="predictHttpUri")
    def predict_http_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Http(s) path to send prediction requests.
        """
        return pulumi.get(self, "predict_http_uri")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class AiEndpointEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: builtins.str):
        """
        :param builtins.str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiEndpointIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiEndpointIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiEndpointPredictRequestResponseLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointPredictRequestResponseLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointPredictRequestResponseLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointPredictRequestResponseLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: Optional['outputs.AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination'] = None,
                 enabled: Optional[builtins.bool] = None,
                 sampling_rate: Optional[builtins.float] = None):
        """
        :param 'AiEndpointPredictRequestResponseLoggingConfigBigqueryDestinationArgs' bigquery_destination: BigQuery table for logging. If only given a project, a new dataset will be created with name `logging_<endpoint-display-name>_<endpoint-id>` where will be made BigQuery-dataset-name compatible (e.g. most special characters will become underscores). If no table name is given, a new table will be created with name `request_response_logging`
               Structure is documented below.
        :param builtins.bool enabled: If logging is enabled or not.
        :param builtins.float sampling_rate: Percentage of requests to be logged, expressed as a fraction in range(0,1]
        """
        if bigquery_destination is not None:
            pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> Optional['outputs.AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination']:
        """
        BigQuery table for logging. If only given a project, a new dataset will be created with name `logging_<endpoint-display-name>_<endpoint-id>` where will be made BigQuery-dataset-name compatible (e.g. most special characters will become underscores). If no table name is given, a new table will be created with name `request_response_logging`
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        If logging is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[builtins.float]:
        """
        Percentage of requests to be logged, expressed as a fraction in range(0,1]
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputUri":
            suggest = "output_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointPredictRequestResponseLoggingConfigBigqueryDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_uri: Optional[builtins.str] = None):
        """
        :param builtins.str output_uri: BigQuery URI to a project or table, up to 2000 characters long. When only the project is specified, the Dataset and Table is created. When the full table reference is specified, the Dataset must exist and table must not exist. Accepted forms: - BigQuery path. For example: `bq://projectId` or `bq://projectId.bqDatasetId` or `bq://projectId.bqDatasetId.bqTableId`.
        """
        if output_uri is not None:
            pulumi.set(__self__, "output_uri", output_uri)

    @property
    @pulumi.getter(name="outputUri")
    def output_uri(self) -> Optional[builtins.str]:
        """
        BigQuery URI to a project or table, up to 2000 characters long. When only the project is specified, the Dataset and Table is created. When the full table reference is specified, the Dataset must exist and table must not exist. Accepted forms: - BigQuery path. For example: `bq://projectId` or `bq://projectId.bqDatasetId` or `bq://projectId.bqDatasetId.bqTableId`.
        """
        return pulumi.get(self, "output_uri")


@pulumi.output_type
class AiEndpointPrivateServiceConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateServiceConnect":
            suggest = "enable_private_service_connect"
        elif key == "enableSecurePrivateServiceConnect":
            suggest = "enable_secure_private_service_connect"
        elif key == "projectAllowlists":
            suggest = "project_allowlists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointPrivateServiceConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_service_connect: builtins.bool,
                 enable_secure_private_service_connect: Optional[builtins.bool] = None,
                 project_allowlists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool enable_private_service_connect: Required. If true, expose the IndexEndpoint via private service connect.
        :param builtins.bool enable_secure_private_service_connect: If set to true, enable secure private service connect with IAM authorization. Otherwise, private service connect will be done without authorization. Note latency will be slightly increased if authorization is enabled.
        :param Sequence[builtins.str] project_allowlists: A list of Projects from which the forwarding rule will target the service attachment.
        """
        pulumi.set(__self__, "enable_private_service_connect", enable_private_service_connect)
        if enable_secure_private_service_connect is not None:
            pulumi.set(__self__, "enable_secure_private_service_connect", enable_secure_private_service_connect)
        if project_allowlists is not None:
            pulumi.set(__self__, "project_allowlists", project_allowlists)

    @property
    @pulumi.getter(name="enablePrivateServiceConnect")
    def enable_private_service_connect(self) -> builtins.bool:
        """
        Required. If true, expose the IndexEndpoint via private service connect.
        """
        return pulumi.get(self, "enable_private_service_connect")

    @property
    @pulumi.getter(name="enableSecurePrivateServiceConnect")
    def enable_secure_private_service_connect(self) -> Optional[builtins.bool]:
        """
        If set to true, enable secure private service connect with IAM authorization. Otherwise, private service connect will be done without authorization. Note latency will be slightly increased if authorization is enabled.
        """
        return pulumi.get(self, "enable_secure_private_service_connect")

    @property
    @pulumi.getter(name="projectAllowlists")
    def project_allowlists(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Projects from which the forwarding rule will target the service attachment.
        """
        return pulumi.get(self, "project_allowlists")


@pulumi.output_type
class AiFeatureGroupBigQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigQuerySource":
            suggest = "big_query_source"
        elif key == "entityIdColumns":
            suggest = "entity_id_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureGroupBigQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureGroupBigQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureGroupBigQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 big_query_source: 'outputs.AiFeatureGroupBigQueryBigQuerySource',
                 entity_id_columns: Optional[Sequence[builtins.str]] = None):
        """
        :param 'AiFeatureGroupBigQueryBigQuerySourceArgs' big_query_source: The BigQuery source URI that points to either a BigQuery Table or View.
               Structure is documented below.
        :param Sequence[builtins.str] entity_id_columns: Columns to construct entityId / row keys. If not provided defaults to entityId.
        """
        pulumi.set(__self__, "big_query_source", big_query_source)
        if entity_id_columns is not None:
            pulumi.set(__self__, "entity_id_columns", entity_id_columns)

    @property
    @pulumi.getter(name="bigQuerySource")
    def big_query_source(self) -> 'outputs.AiFeatureGroupBigQueryBigQuerySource':
        """
        The BigQuery source URI that points to either a BigQuery Table or View.
        Structure is documented below.
        """
        return pulumi.get(self, "big_query_source")

    @property
    @pulumi.getter(name="entityIdColumns")
    def entity_id_columns(self) -> Optional[Sequence[builtins.str]]:
        """
        Columns to construct entityId / row keys. If not provided defaults to entityId.
        """
        return pulumi.get(self, "entity_id_columns")


@pulumi.output_type
class AiFeatureGroupBigQueryBigQuerySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputUri":
            suggest = "input_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureGroupBigQueryBigQuerySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureGroupBigQueryBigQuerySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureGroupBigQueryBigQuerySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_uri: builtins.str):
        """
        :param builtins.str input_uri: BigQuery URI to a table, up to 2000 characters long. For example: `bq://projectId.bqDatasetId.bqTableId.`
        """
        pulumi.set(__self__, "input_uri", input_uri)

    @property
    @pulumi.getter(name="inputUri")
    def input_uri(self) -> builtins.str:
        """
        BigQuery URI to a table, up to 2000 characters long. For example: `bq://projectId.bqDatasetId.bqTableId.`
        """
        return pulumi.get(self, "input_uri")


@pulumi.output_type
class AiFeatureGroupIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureGroupIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureOnlineStoreBigtable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScaling":
            suggest = "auto_scaling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreBigtable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreBigtable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreBigtable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling: 'outputs.AiFeatureOnlineStoreBigtableAutoScaling'):
        """
        :param 'AiFeatureOnlineStoreBigtableAutoScalingArgs' auto_scaling: Autoscaling config applied to Bigtable Instance.
               Structure is documented below.
        """
        pulumi.set(__self__, "auto_scaling", auto_scaling)

    @property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> 'outputs.AiFeatureOnlineStoreBigtableAutoScaling':
        """
        Autoscaling config applied to Bigtable Instance.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_scaling")


@pulumi.output_type
class AiFeatureOnlineStoreBigtableAutoScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "cpuUtilizationTarget":
            suggest = "cpu_utilization_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreBigtableAutoScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreBigtableAutoScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreBigtableAutoScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: builtins.int,
                 min_node_count: builtins.int,
                 cpu_utilization_target: Optional[builtins.int] = None):
        """
        :param builtins.int max_node_count: The maximum number of nodes to scale up to. Must be greater than or equal to minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        :param builtins.int min_node_count: The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        :param builtins.int cpu_utilization_target: A percentage of the cluster's CPU capacity. Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target that you have set, Bigtable immediately adds nodes to the cluster. When CPU utilization is substantially lower than the target, Bigtable removes nodes. If not set will default to 50%.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)
        if cpu_utilization_target is not None:
            pulumi.set(__self__, "cpu_utilization_target", cpu_utilization_target)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> builtins.int:
        """
        The maximum number of nodes to scale up to. Must be greater than or equal to minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> builtins.int:
        """
        The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="cpuUtilizationTarget")
    def cpu_utilization_target(self) -> Optional[builtins.int]:
        """
        A percentage of the cluster's CPU capacity. Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target that you have set, Bigtable immediately adds nodes to the cluster. When CPU utilization is substantially lower than the target, Bigtable removes nodes. If not set will default to 50%.
        """
        return pulumi.get(self, "cpu_utilization_target")


@pulumi.output_type
class AiFeatureOnlineStoreDedicatedServingEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateServiceConnectConfig":
            suggest = "private_service_connect_config"
        elif key == "publicEndpointDomainName":
            suggest = "public_endpoint_domain_name"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreDedicatedServingEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreDedicatedServingEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreDedicatedServingEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_service_connect_config: Optional['outputs.AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig'] = None,
                 public_endpoint_domain_name: Optional[builtins.str] = None,
                 service_attachment: Optional[builtins.str] = None):
        """
        :param 'AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigArgs' private_service_connect_config: Private service connect config.
               Structure is documented below.
        :param builtins.str public_endpoint_domain_name: (Output)
               Domain name to use for this FeatureOnlineStore
        :param builtins.str service_attachment: (Output)
               Name of the service attachment resource. Applicable only if private service connect is enabled and after FeatureViewSync is created.
        """
        if private_service_connect_config is not None:
            pulumi.set(__self__, "private_service_connect_config", private_service_connect_config)
        if public_endpoint_domain_name is not None:
            pulumi.set(__self__, "public_endpoint_domain_name", public_endpoint_domain_name)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="privateServiceConnectConfig")
    def private_service_connect_config(self) -> Optional['outputs.AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig']:
        """
        Private service connect config.
        Structure is documented below.
        """
        return pulumi.get(self, "private_service_connect_config")

    @property
    @pulumi.getter(name="publicEndpointDomainName")
    def public_endpoint_domain_name(self) -> Optional[builtins.str]:
        """
        (Output)
        Domain name to use for this FeatureOnlineStore
        """
        return pulumi.get(self, "public_endpoint_domain_name")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[builtins.str]:
        """
        (Output)
        Name of the service attachment resource. Applicable only if private service connect is enabled and after FeatureViewSync is created.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateServiceConnect":
            suggest = "enable_private_service_connect"
        elif key == "projectAllowlists":
            suggest = "project_allowlists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_service_connect: builtins.bool,
                 project_allowlists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool enable_private_service_connect: If set to true, customers will use private service connection to send request. Otherwise, the connection will set to public endpoint.
        :param Sequence[builtins.str] project_allowlists: A list of Projects from which the forwarding rule will target the service attachment.
        """
        pulumi.set(__self__, "enable_private_service_connect", enable_private_service_connect)
        if project_allowlists is not None:
            pulumi.set(__self__, "project_allowlists", project_allowlists)

    @property
    @pulumi.getter(name="enablePrivateServiceConnect")
    def enable_private_service_connect(self) -> builtins.bool:
        """
        If set to true, customers will use private service connection to send request. Otherwise, the connection will set to public endpoint.
        """
        return pulumi.get(self, "enable_private_service_connect")

    @property
    @pulumi.getter(name="projectAllowlists")
    def project_allowlists(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Projects from which the forwarding rule will target the service attachment.
        """
        return pulumi.get(self, "project_allowlists")


@pulumi.output_type
class AiFeatureOnlineStoreEmbeddingManagement(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Enable embedding management.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable embedding management.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewBigQuerySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityIdColumns":
            suggest = "entity_id_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreFeatureviewBigQuerySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreFeatureviewBigQuerySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreFeatureviewBigQuerySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id_columns: Sequence[builtins.str],
                 uri: builtins.str):
        """
        :param Sequence[builtins.str] entity_id_columns: Columns to construct entityId / row keys. Start by supporting 1 only.
        :param builtins.str uri: The BigQuery view URI that will be materialized on each sync trigger based on FeatureView.SyncConfig.
        """
        pulumi.set(__self__, "entity_id_columns", entity_id_columns)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="entityIdColumns")
    def entity_id_columns(self) -> Sequence[builtins.str]:
        """
        Columns to construct entityId / row keys. Start by supporting 1 only.
        """
        return pulumi.get(self, "entity_id_columns")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The BigQuery view URI that will be materialized on each sync trigger based on FeatureView.SyncConfig.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewFeatureRegistrySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureGroups":
            suggest = "feature_groups"
        elif key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreFeatureviewFeatureRegistrySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreFeatureviewFeatureRegistrySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreFeatureviewFeatureRegistrySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_groups: Sequence['outputs.AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup'],
                 project_number: Optional[builtins.str] = None):
        """
        :param Sequence['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupArgs'] feature_groups: List of features that need to be synced to Online Store.
               Structure is documented below.
        :param builtins.str project_number: The project number of the parent project of the feature Groups.
        """
        pulumi.set(__self__, "feature_groups", feature_groups)
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)

    @property
    @pulumi.getter(name="featureGroups")
    def feature_groups(self) -> Sequence['outputs.AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup']:
        """
        List of features that need to be synced to Online Store.
        Structure is documented below.
        """
        return pulumi.get(self, "feature_groups")

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[builtins.str]:
        """
        The project number of the parent project of the feature Groups.
        """
        return pulumi.get(self, "project_number")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureGroupId":
            suggest = "feature_group_id"
        elif key == "featureIds":
            suggest = "feature_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_group_id: builtins.str,
                 feature_ids: Sequence[builtins.str]):
        """
        :param builtins.str feature_group_id: Identifier of the feature group.
        :param Sequence[builtins.str] feature_ids: Identifiers of features under the feature group.
        """
        pulumi.set(__self__, "feature_group_id", feature_group_id)
        pulumi.set(__self__, "feature_ids", feature_ids)

    @property
    @pulumi.getter(name="featureGroupId")
    def feature_group_id(self) -> builtins.str:
        """
        Identifier of the feature group.
        """
        return pulumi.get(self, "feature_group_id")

    @property
    @pulumi.getter(name="featureIds")
    def feature_ids(self) -> Sequence[builtins.str]:
        """
        Identifiers of features under the feature group.
        """
        return pulumi.get(self, "feature_ids")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewSyncConfig(dict):
    def __init__(__self__, *,
                 cron: Optional[builtins.str] = None):
        """
        :param builtins.str cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
               To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
        """
        if cron is not None:
            pulumi.set(__self__, "cron", cron)

    @property
    @pulumi.getter
    def cron(self) -> Optional[builtins.str]:
        """
        Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
        """
        return pulumi.get(self, "cron")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewVectorSearchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "embeddingColumn":
            suggest = "embedding_column"
        elif key == "bruteForceConfig":
            suggest = "brute_force_config"
        elif key == "crowdingColumn":
            suggest = "crowding_column"
        elif key == "distanceMeasureType":
            suggest = "distance_measure_type"
        elif key == "embeddingDimension":
            suggest = "embedding_dimension"
        elif key == "filterColumns":
            suggest = "filter_columns"
        elif key == "treeAhConfig":
            suggest = "tree_ah_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreFeatureviewVectorSearchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreFeatureviewVectorSearchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreFeatureviewVectorSearchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 embedding_column: builtins.str,
                 brute_force_config: Optional['outputs.AiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig'] = None,
                 crowding_column: Optional[builtins.str] = None,
                 distance_measure_type: Optional[builtins.str] = None,
                 embedding_dimension: Optional[builtins.int] = None,
                 filter_columns: Optional[Sequence[builtins.str]] = None,
                 tree_ah_config: Optional['outputs.AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig'] = None):
        """
        :param builtins.str embedding_column: Column of embedding. This column contains the source data to create index for vector search.
        :param 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigArgs' brute_force_config: Configuration options for using brute force search, which simply implements the standard linear search in the database for each query. It is primarily meant for benchmarking and to generate the ground truth for approximate search.
        :param builtins.str crowding_column: Column of crowding. This column contains crowding attribute which is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than some value k' of the k neighbors returned have the same value of crowdingAttribute.
        :param builtins.str distance_measure_type: The distance measure used in nearest neighbor search.
               For details on allowed values, see the [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.featureOnlineStores.featureViews#DistanceMeasureType).
               Possible values are: `SQUARED_L2_DISTANCE`, `COSINE_DISTANCE`, `DOT_PRODUCT_DISTANCE`.
        :param builtins.int embedding_dimension: The number of dimensions of the input embedding.
        :param Sequence[builtins.str] filter_columns: Columns of features that are used to filter vector search results.
        :param 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigArgs' tree_ah_config: Configuration options for the tree-AH algorithm (Shallow tree + Asymmetric Hashing). Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
               Structure is documented below.
        """
        pulumi.set(__self__, "embedding_column", embedding_column)
        if brute_force_config is not None:
            pulumi.set(__self__, "brute_force_config", brute_force_config)
        if crowding_column is not None:
            pulumi.set(__self__, "crowding_column", crowding_column)
        if distance_measure_type is not None:
            pulumi.set(__self__, "distance_measure_type", distance_measure_type)
        if embedding_dimension is not None:
            pulumi.set(__self__, "embedding_dimension", embedding_dimension)
        if filter_columns is not None:
            pulumi.set(__self__, "filter_columns", filter_columns)
        if tree_ah_config is not None:
            pulumi.set(__self__, "tree_ah_config", tree_ah_config)

    @property
    @pulumi.getter(name="embeddingColumn")
    def embedding_column(self) -> builtins.str:
        """
        Column of embedding. This column contains the source data to create index for vector search.
        """
        return pulumi.get(self, "embedding_column")

    @property
    @pulumi.getter(name="bruteForceConfig")
    def brute_force_config(self) -> Optional['outputs.AiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig']:
        """
        Configuration options for using brute force search, which simply implements the standard linear search in the database for each query. It is primarily meant for benchmarking and to generate the ground truth for approximate search.
        """
        return pulumi.get(self, "brute_force_config")

    @property
    @pulumi.getter(name="crowdingColumn")
    def crowding_column(self) -> Optional[builtins.str]:
        """
        Column of crowding. This column contains crowding attribute which is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than some value k' of the k neighbors returned have the same value of crowdingAttribute.
        """
        return pulumi.get(self, "crowding_column")

    @property
    @pulumi.getter(name="distanceMeasureType")
    def distance_measure_type(self) -> Optional[builtins.str]:
        """
        The distance measure used in nearest neighbor search.
        For details on allowed values, see the [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.featureOnlineStores.featureViews#DistanceMeasureType).
        Possible values are: `SQUARED_L2_DISTANCE`, `COSINE_DISTANCE`, `DOT_PRODUCT_DISTANCE`.
        """
        return pulumi.get(self, "distance_measure_type")

    @property
    @pulumi.getter(name="embeddingDimension")
    def embedding_dimension(self) -> Optional[builtins.int]:
        """
        The number of dimensions of the input embedding.
        """
        return pulumi.get(self, "embedding_dimension")

    @property
    @pulumi.getter(name="filterColumns")
    def filter_columns(self) -> Optional[Sequence[builtins.str]]:
        """
        Columns of features that are used to filter vector search results.
        """
        return pulumi.get(self, "filter_columns")

    @property
    @pulumi.getter(name="treeAhConfig")
    def tree_ah_config(self) -> Optional['outputs.AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig']:
        """
        Configuration options for the tree-AH algorithm (Shallow tree + Asymmetric Hashing). Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        Structure is documented below.
        """
        return pulumi.get(self, "tree_ah_config")


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafNodeEmbeddingCount":
            suggest = "leaf_node_embedding_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 leaf_node_embedding_count: Optional[builtins.str] = None):
        """
        :param builtins.str leaf_node_embedding_count: Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        if leaf_node_embedding_count is not None:
            pulumi.set(__self__, "leaf_node_embedding_count", leaf_node_embedding_count)

    @property
    @pulumi.getter(name="leafNodeEmbeddingCount")
    def leaf_node_embedding_count(self) -> Optional[builtins.str]:
        """
        Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        return pulumi.get(self, "leaf_node_embedding_count")


@pulumi.output_type
class AiFeatureOnlineStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureOnlineStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureOnlineStoreOptimized(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class AiFeatureStoreEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: builtins.str):
        """
        :param builtins.str kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiFeatureStoreEntityTypeIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreEntityTypeIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalThresholdConfig":
            suggest = "categorical_threshold_config"
        elif key == "importFeaturesAnalysis":
            suggest = "import_features_analysis"
        elif key == "numericalThresholdConfig":
            suggest = "numerical_threshold_config"
        elif key == "snapshotAnalysis":
            suggest = "snapshot_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_threshold_config: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig'] = None,
                 import_features_analysis: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis'] = None,
                 numerical_threshold_config: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig'] = None,
                 snapshot_analysis: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis'] = None):
        """
        :param 'AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs' categorical_threshold_config: Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs' import_features_analysis: The config for ImportFeatures Analysis Based Feature Monitoring.
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs' numerical_threshold_config: Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs' snapshot_analysis: The config for Snapshot Analysis Based Feature Monitoring.
               Structure is documented below.
        """
        if categorical_threshold_config is not None:
            pulumi.set(__self__, "categorical_threshold_config", categorical_threshold_config)
        if import_features_analysis is not None:
            pulumi.set(__self__, "import_features_analysis", import_features_analysis)
        if numerical_threshold_config is not None:
            pulumi.set(__self__, "numerical_threshold_config", numerical_threshold_config)
        if snapshot_analysis is not None:
            pulumi.set(__self__, "snapshot_analysis", snapshot_analysis)

    @property
    @pulumi.getter(name="categoricalThresholdConfig")
    def categorical_threshold_config(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig']:
        """
        Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
        Structure is documented below.
        """
        return pulumi.get(self, "categorical_threshold_config")

    @property
    @pulumi.getter(name="importFeaturesAnalysis")
    def import_features_analysis(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis']:
        """
        The config for ImportFeatures Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "import_features_analysis")

    @property
    @pulumi.getter(name="numericalThresholdConfig")
    def numerical_threshold_config(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig']:
        """
        Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
        Structure is documented below.
        """
        return pulumi.get(self, "numerical_threshold_config")

    @property
    @pulumi.getter(name="snapshotAnalysis")
    def snapshot_analysis(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis']:
        """
        The config for Snapshot Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_analysis")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig(dict):
    def __init__(__self__, *,
                 value: builtins.float):
        """
        :param builtins.float value: Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        """
        Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anomalyDetectionBaseline":
            suggest = "anomaly_detection_baseline"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anomaly_detection_baseline: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str anomaly_detection_baseline: Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
               * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
               * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
               * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        :param builtins.str state: Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
               * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
               * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
               * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        if anomaly_detection_baseline is not None:
            pulumi.set(__self__, "anomaly_detection_baseline", anomaly_detection_baseline)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="anomalyDetectionBaseline")
    def anomaly_detection_baseline(self) -> Optional[builtins.str]:
        """
        Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
        * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
        * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
        * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        """
        return pulumi.get(self, "anomaly_detection_baseline")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
        * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
        * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
        * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig(dict):
    def __init__(__self__, *,
                 value: builtins.float):
        """
        :param builtins.float value: Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        """
        Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringInterval":
            suggest = "monitoring_interval"
        elif key == "monitoringIntervalDays":
            suggest = "monitoring_interval_days"
        elif key == "stalenessDays":
            suggest = "staleness_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[builtins.bool] = None,
                 monitoring_interval: Optional[builtins.str] = None,
                 monitoring_interval_days: Optional[builtins.int] = None,
                 staleness_days: Optional[builtins.int] = None):
        """
        :param builtins.bool disabled: The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        :param builtins.str monitoring_interval: Configuration of the snapshot analysis based monitoring pipeline running interval. The value is rolled up to full day.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
               
               > **Warning:** `monitoring_interval` is deprecated and will be removed in a future release.
        :param builtins.int monitoring_interval_days: Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
               If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        :param builtins.int staleness_days: Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_interval_days is not None:
            pulumi.set(__self__, "monitoring_interval_days", monitoring_interval_days)
        if staleness_days is not None:
            pulumi.set(__self__, "staleness_days", staleness_days)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="monitoringInterval")
    @_utilities.deprecated("""`monitoring_interval` is deprecated and will be removed in a future release.""")
    def monitoring_interval(self) -> Optional[builtins.str]:
        """
        Configuration of the snapshot analysis based monitoring pipeline running interval. The value is rolled up to full day.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".

        > **Warning:** `monitoring_interval` is deprecated and will be removed in a future release.
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringIntervalDays")
    def monitoring_interval_days(self) -> Optional[builtins.int]:
        """
        Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
        If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        """
        return pulumi.get(self, "monitoring_interval_days")

    @property
    @pulumi.getter(name="stalenessDays")
    def staleness_days(self) -> Optional[builtins.int]:
        """
        Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        return pulumi.get(self, "staleness_days")


@pulumi.output_type
class AiFeatureStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreOnlineServingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedNodeCount":
            suggest = "fixed_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreOnlineServingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreOnlineServingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreOnlineServingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_node_count: Optional[builtins.int] = None,
                 scaling: Optional['outputs.AiFeatureStoreOnlineServingConfigScaling'] = None):
        """
        :param builtins.int fixed_node_count: The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        :param 'AiFeatureStoreOnlineServingConfigScalingArgs' scaling: Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
               Structure is documented below.
        """
        if fixed_node_count is not None:
            pulumi.set(__self__, "fixed_node_count", fixed_node_count)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)

    @property
    @pulumi.getter(name="fixedNodeCount")
    def fixed_node_count(self) -> Optional[builtins.int]:
        """
        The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        """
        return pulumi.get(self, "fixed_node_count")

    @property
    @pulumi.getter
    def scaling(self) -> Optional['outputs.AiFeatureStoreOnlineServingConfigScaling']:
        """
        Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")


@pulumi.output_type
class AiFeatureStoreOnlineServingConfigScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreOnlineServingConfigScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreOnlineServingConfigScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreOnlineServingConfigScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: builtins.int,
                 min_node_count: builtins.int):
        """
        :param builtins.int max_node_count: The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        :param builtins.int min_node_count: The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> builtins.int:
        """
        The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> builtins.int:
        """
        The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class AiIndexDeployedIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployedIndexId":
            suggest = "deployed_index_id"
        elif key == "indexEndpoint":
            suggest = "index_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexDeployedIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexDeployedIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexDeployedIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployed_index_id: Optional[builtins.str] = None,
                 index_endpoint: Optional[builtins.str] = None):
        """
        :param builtins.str deployed_index_id: (Output)
               The ID of the DeployedIndex in the above IndexEndpoint.
        :param builtins.str index_endpoint: (Output)
               A resource name of the IndexEndpoint.
        """
        if deployed_index_id is not None:
            pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        if index_endpoint is not None:
            pulumi.set(__self__, "index_endpoint", index_endpoint)

    @property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> Optional[builtins.str]:
        """
        (Output)
        The ID of the DeployedIndex in the above IndexEndpoint.
        """
        return pulumi.get(self, "deployed_index_id")

    @property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> Optional[builtins.str]:
        """
        (Output)
        A resource name of the IndexEndpoint.
        """
        return pulumi.get(self, "index_endpoint")


@pulumi.output_type
class AiIndexEndpointDeployedIndexAutomaticResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicaCount":
            suggest = "max_replica_count"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexAutomaticResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexAutomaticResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexAutomaticResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replica_count: Optional[builtins.int] = None,
                 min_replica_count: Optional[builtins.int] = None):
        """
        :param builtins.int max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
               The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param builtins.int min_replica_count: The minimum number of replicas this DeployedModel will be always deployed on. If minReplicaCount is not set, the default value is 2 (we don't provide SLA when minReplicaCount=1).
               If traffic against it increases, it may dynamically be deployed onto more replicas up to [maxReplicaCount](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/AutomaticResources#FIELDS.max_replica_count), and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[builtins.int]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[builtins.int]:
        """
        The minimum number of replicas this DeployedModel will be always deployed on. If minReplicaCount is not set, the default value is 2 (we don't provide SLA when minReplicaCount=1).
        If traffic against it increases, it may dynamically be deployed onto more replicas up to [maxReplicaCount](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/AutomaticResources#FIELDS.max_replica_count), and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")


@pulumi.output_type
class AiIndexEndpointDeployedIndexDedicatedResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineSpec":
            suggest = "machine_spec"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"
        elif key == "maxReplicaCount":
            suggest = "max_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexDedicatedResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexDedicatedResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexDedicatedResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_spec: 'outputs.AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec',
                 min_replica_count: builtins.int,
                 max_replica_count: Optional[builtins.int] = None):
        """
        :param 'AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpecArgs' machine_spec: The minimum number of replicas this DeployedModel will be always deployed on.
               Structure is documented below.
        :param builtins.int min_replica_count: The minimum number of machine replicas this DeployedModel will be always deployed on. This value must be greater than or equal to 1.
        :param builtins.int max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If maxReplicaCount is not set, the default value is minReplicaCount
        """
        pulumi.set(__self__, "machine_spec", machine_spec)
        pulumi.set(__self__, "min_replica_count", min_replica_count)
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)

    @property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> 'outputs.AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec':
        """
        The minimum number of replicas this DeployedModel will be always deployed on.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_spec")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> builtins.int:
        """
        The minimum number of machine replicas this DeployedModel will be always deployed on. This value must be greater than or equal to 1.
        """
        return pulumi.get(self, "min_replica_count")

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[builtins.int]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If maxReplicaCount is not set, the default value is minReplicaCount
        """
        return pulumi.get(self, "max_replica_count")


@pulumi.output_type
class AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexDedicatedResourcesMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_type: Optional[builtins.str] = None):
        """
        :param builtins.str machine_type: The type of the machine.
               See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types)
               See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types).
               For [DeployedModel](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints#DeployedModel) this field is optional, and the default value is n1-standard-2. For [BatchPredictionJob](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.batchPredictionJobs#BatchPredictionJob) or as part of [WorkerPoolSpec](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/CustomJobSpec#WorkerPoolSpec) this field is required.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[builtins.str]:
        """
        The type of the machine.
        See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types)
        See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types).
        For [DeployedModel](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints#DeployedModel) this field is optional, and the default value is n1-standard-2. For [BatchPredictionJob](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.batchPredictionJobs#BatchPredictionJob) or as part of [WorkerPoolSpec](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/CustomJobSpec#WorkerPoolSpec) this field is required.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class AiIndexEndpointDeployedIndexDeployedIndexAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authProvider":
            suggest = "auth_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexDeployedIndexAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexDeployedIndexAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexDeployedIndexAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_provider: Optional['outputs.AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider'] = None):
        """
        :param 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProviderArgs' auth_provider: Defines the authentication provider that the DeployedIndex uses.
               Structure is documented below.
        """
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)

    @property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional['outputs.AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider']:
        """
        Defines the authentication provider that the DeployedIndex uses.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_provider")


@pulumi.output_type
class AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIssuers":
            suggest = "allowed_issuers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexDeployedIndexAuthConfigAuthProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_issuers: Optional[Sequence[builtins.str]] = None,
                 audiences: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_issuers: A list of allowed JWT issuers. Each entry must be a valid Google service account, in the following format: service-account-name@project-id.iam.gserviceaccount.com
        :param Sequence[builtins.str] audiences: The list of JWT audiences. that are allowed to access. A JWT containing any of these audiences will be accepted.
        """
        if allowed_issuers is not None:
            pulumi.set(__self__, "allowed_issuers", allowed_issuers)
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)

    @property
    @pulumi.getter(name="allowedIssuers")
    def allowed_issuers(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of allowed JWT issuers. Each entry must be a valid Google service account, in the following format: service-account-name@project-id.iam.gserviceaccount.com
        """
        return pulumi.get(self, "allowed_issuers")

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of JWT audiences. that are allowed to access. A JWT containing any of these audiences will be accepted.
        """
        return pulumi.get(self, "audiences")


@pulumi.output_type
class AiIndexEndpointDeployedIndexPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchGrpcAddress":
            suggest = "match_grpc_address"
        elif key == "pscAutomatedEndpoints":
            suggest = "psc_automated_endpoints"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_grpc_address: Optional[builtins.str] = None,
                 psc_automated_endpoints: Optional[Sequence['outputs.AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint']] = None,
                 service_attachment: Optional[builtins.str] = None):
        """
        :param builtins.str match_grpc_address: (Output)
               The ip address used to send match gRPC requests.
        :param Sequence['AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpointArgs'] psc_automated_endpoints: (Output)
               PscAutomatedEndpoints is populated if private service connect is enabled if PscAutomatedConfig is set.
               Structure is documented below.
        :param builtins.str service_attachment: (Output)
               The name of the service attachment resource. Populated if private service connect is enabled.
        """
        if match_grpc_address is not None:
            pulumi.set(__self__, "match_grpc_address", match_grpc_address)
        if psc_automated_endpoints is not None:
            pulumi.set(__self__, "psc_automated_endpoints", psc_automated_endpoints)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="matchGrpcAddress")
    def match_grpc_address(self) -> Optional[builtins.str]:
        """
        (Output)
        The ip address used to send match gRPC requests.
        """
        return pulumi.get(self, "match_grpc_address")

    @property
    @pulumi.getter(name="pscAutomatedEndpoints")
    def psc_automated_endpoints(self) -> Optional[Sequence['outputs.AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint']]:
        """
        (Output)
        PscAutomatedEndpoints is populated if private service connect is enabled if PscAutomatedConfig is set.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_automated_endpoints")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[builtins.str]:
        """
        (Output)
        The name of the service attachment resource. Populated if private service connect is enabled.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAddress":
            suggest = "match_address"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointDeployedIndexPrivateEndpointPscAutomatedEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_address: Optional[builtins.str] = None,
                 network: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None):
        """
        :param builtins.str match_address: (Output)
               ip Address created by the automated forwarding rule.
        :param builtins.str network: (Output)
               Corresponding network in pscAutomationConfigs.
        :param builtins.str project_id: (Output)
               Corresponding projectId in pscAutomationConfigs
        """
        if match_address is not None:
            pulumi.set(__self__, "match_address", match_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="matchAddress")
    def match_address(self) -> Optional[builtins.str]:
        """
        (Output)
        ip Address created by the automated forwarding rule.
        """
        return pulumi.get(self, "match_address")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        (Output)
        Corresponding network in pscAutomationConfigs.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        (Output)
        Corresponding projectId in pscAutomationConfigs
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class AiIndexEndpointPrivateServiceConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateServiceConnect":
            suggest = "enable_private_service_connect"
        elif key == "projectAllowlists":
            suggest = "project_allowlists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexEndpointPrivateServiceConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexEndpointPrivateServiceConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_service_connect: builtins.bool,
                 project_allowlists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool enable_private_service_connect: If set to true, the IndexEndpoint is created without private service access.
        :param Sequence[builtins.str] project_allowlists: A list of Projects from which the forwarding rule will target the service attachment.
        """
        pulumi.set(__self__, "enable_private_service_connect", enable_private_service_connect)
        if project_allowlists is not None:
            pulumi.set(__self__, "project_allowlists", project_allowlists)

    @property
    @pulumi.getter(name="enablePrivateServiceConnect")
    def enable_private_service_connect(self) -> builtins.bool:
        """
        If set to true, the IndexEndpoint is created without private service access.
        """
        return pulumi.get(self, "enable_private_service_connect")

    @property
    @pulumi.getter(name="projectAllowlists")
    def project_allowlists(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Projects from which the forwarding rule will target the service attachment.
        """
        return pulumi.get(self, "project_allowlists")


@pulumi.output_type
class AiIndexIndexStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shardsCount":
            suggest = "shards_count"
        elif key == "vectorsCount":
            suggest = "vectors_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexIndexStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexIndexStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexIndexStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shards_count: Optional[builtins.int] = None,
                 vectors_count: Optional[builtins.str] = None):
        """
        :param builtins.int shards_count: (Output)
               The number of shards in the Index.
        :param builtins.str vectors_count: (Output)
               The number of vectors in the Index.
        """
        if shards_count is not None:
            pulumi.set(__self__, "shards_count", shards_count)
        if vectors_count is not None:
            pulumi.set(__self__, "vectors_count", vectors_count)

    @property
    @pulumi.getter(name="shardsCount")
    def shards_count(self) -> Optional[builtins.int]:
        """
        (Output)
        The number of shards in the Index.
        """
        return pulumi.get(self, "shards_count")

    @property
    @pulumi.getter(name="vectorsCount")
    def vectors_count(self) -> Optional[builtins.str]:
        """
        (Output)
        The number of vectors in the Index.
        """
        return pulumi.get(self, "vectors_count")


@pulumi.output_type
class AiIndexMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsDeltaUri":
            suggest = "contents_delta_uri"
        elif key == "isCompleteOverwrite":
            suggest = "is_complete_overwrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.AiIndexMetadataConfig'] = None,
                 contents_delta_uri: Optional[builtins.str] = None,
                 is_complete_overwrite: Optional[builtins.bool] = None):
        """
        :param 'AiIndexMetadataConfigArgs' config: The configuration of the Matching Engine Index.
               Structure is documented below.
        :param builtins.str contents_delta_uri: Allows inserting, updating  or deleting the contents of the Matching Engine Index.
               The string must be a valid Cloud Storage directory path. If this
               field is set when calling IndexService.UpdateIndex, then no other
               Index field can be also updated as part of the same call.
               The expected structure and format of the files this URI points to is
               described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        :param builtins.bool is_complete_overwrite: If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
               then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if contents_delta_uri is not None:
            pulumi.set(__self__, "contents_delta_uri", contents_delta_uri)
        if is_complete_overwrite is not None:
            pulumi.set(__self__, "is_complete_overwrite", is_complete_overwrite)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.AiIndexMetadataConfig']:
        """
        The configuration of the Matching Engine Index.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="contentsDeltaUri")
    def contents_delta_uri(self) -> Optional[builtins.str]:
        """
        Allows inserting, updating  or deleting the contents of the Matching Engine Index.
        The string must be a valid Cloud Storage directory path. If this
        field is set when calling IndexService.UpdateIndex, then no other
        Index field can be also updated as part of the same call.
        The expected structure and format of the files this URI points to is
        described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        """
        return pulumi.get(self, "contents_delta_uri")

    @property
    @pulumi.getter(name="isCompleteOverwrite")
    def is_complete_overwrite(self) -> Optional[builtins.bool]:
        """
        If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
        then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        return pulumi.get(self, "is_complete_overwrite")


@pulumi.output_type
class AiIndexMetadataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmConfig":
            suggest = "algorithm_config"
        elif key == "approximateNeighborsCount":
            suggest = "approximate_neighbors_count"
        elif key == "distanceMeasureType":
            suggest = "distance_measure_type"
        elif key == "featureNormType":
            suggest = "feature_norm_type"
        elif key == "shardSize":
            suggest = "shard_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: builtins.int,
                 algorithm_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfig'] = None,
                 approximate_neighbors_count: Optional[builtins.int] = None,
                 distance_measure_type: Optional[builtins.str] = None,
                 feature_norm_type: Optional[builtins.str] = None,
                 shard_size: Optional[builtins.str] = None):
        """
        :param builtins.int dimensions: The number of dimensions of the input vectors.
        :param 'AiIndexMetadataConfigAlgorithmConfigArgs' algorithm_config: The configuration with regard to the algorithms used for efficient search.
               Structure is documented below.
        :param builtins.int approximate_neighbors_count: The default number of neighbors to find via approximate search before exact reordering is
               performed. Exact reordering is a procedure where results returned by an
               approximate search algorithm are reordered via a more expensive distance computation.
               Required if tree-AH algorithm is used.
        :param builtins.str distance_measure_type: The distance measure used in nearest neighbor search. The value must be one of the followings:
               * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
               * L1_DISTANCE: Manhattan (L_1) Distance
               * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
               * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        :param builtins.str feature_norm_type: Type of normalization to be carried out on each vector. The value must be one of the followings:
               * UNIT_L2_NORM: Unit L2 normalization type
               * NONE: No normalization type is specified.
        :param builtins.str shard_size: Index data is split into equal parts to be processed. These are called "shards".
               The shard size must be specified when creating an index. The value must be one of the followings:
               * SHARD_SIZE_SMALL: Small (2GB)
               * SHARD_SIZE_MEDIUM: Medium (20GB)
               * SHARD_SIZE_LARGE: Large (50GB)
        """
        pulumi.set(__self__, "dimensions", dimensions)
        if algorithm_config is not None:
            pulumi.set(__self__, "algorithm_config", algorithm_config)
        if approximate_neighbors_count is not None:
            pulumi.set(__self__, "approximate_neighbors_count", approximate_neighbors_count)
        if distance_measure_type is not None:
            pulumi.set(__self__, "distance_measure_type", distance_measure_type)
        if feature_norm_type is not None:
            pulumi.set(__self__, "feature_norm_type", feature_norm_type)
        if shard_size is not None:
            pulumi.set(__self__, "shard_size", shard_size)

    @property
    @pulumi.getter
    def dimensions(self) -> builtins.int:
        """
        The number of dimensions of the input vectors.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="algorithmConfig")
    def algorithm_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfig']:
        """
        The configuration with regard to the algorithms used for efficient search.
        Structure is documented below.
        """
        return pulumi.get(self, "algorithm_config")

    @property
    @pulumi.getter(name="approximateNeighborsCount")
    def approximate_neighbors_count(self) -> Optional[builtins.int]:
        """
        The default number of neighbors to find via approximate search before exact reordering is
        performed. Exact reordering is a procedure where results returned by an
        approximate search algorithm are reordered via a more expensive distance computation.
        Required if tree-AH algorithm is used.
        """
        return pulumi.get(self, "approximate_neighbors_count")

    @property
    @pulumi.getter(name="distanceMeasureType")
    def distance_measure_type(self) -> Optional[builtins.str]:
        """
        The distance measure used in nearest neighbor search. The value must be one of the followings:
        * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
        * L1_DISTANCE: Manhattan (L_1) Distance
        * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
        * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        """
        return pulumi.get(self, "distance_measure_type")

    @property
    @pulumi.getter(name="featureNormType")
    def feature_norm_type(self) -> Optional[builtins.str]:
        """
        Type of normalization to be carried out on each vector. The value must be one of the followings:
        * UNIT_L2_NORM: Unit L2 normalization type
        * NONE: No normalization type is specified.
        """
        return pulumi.get(self, "feature_norm_type")

    @property
    @pulumi.getter(name="shardSize")
    def shard_size(self) -> Optional[builtins.str]:
        """
        Index data is split into equal parts to be processed. These are called "shards".
        The shard size must be specified when creating an index. The value must be one of the followings:
        * SHARD_SIZE_SMALL: Small (2GB)
        * SHARD_SIZE_MEDIUM: Medium (20GB)
        * SHARD_SIZE_LARGE: Large (50GB)
        """
        return pulumi.get(self, "shard_size")


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bruteForceConfig":
            suggest = "brute_force_config"
        elif key == "treeAhConfig":
            suggest = "tree_ah_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfigAlgorithmConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfigAlgorithmConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfigAlgorithmConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brute_force_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfigBruteForceConfig'] = None,
                 tree_ah_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfigTreeAhConfig'] = None):
        """
        :param 'AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs' brute_force_config: Configuration options for using brute force search, which simply implements the
               standard linear search in the database for each query.
        :param 'AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs' tree_ah_config: Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
               Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
               Structure is documented below.
        """
        if brute_force_config is not None:
            pulumi.set(__self__, "brute_force_config", brute_force_config)
        if tree_ah_config is not None:
            pulumi.set(__self__, "tree_ah_config", tree_ah_config)

    @property
    @pulumi.getter(name="bruteForceConfig")
    def brute_force_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfigBruteForceConfig']:
        """
        Configuration options for using brute force search, which simply implements the
        standard linear search in the database for each query.
        """
        return pulumi.get(self, "brute_force_config")

    @property
    @pulumi.getter(name="treeAhConfig")
    def tree_ah_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfigTreeAhConfig']:
        """
        Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
        Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        Structure is documented below.
        """
        return pulumi.get(self, "tree_ah_config")


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfigBruteForceConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfigTreeAhConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafNodeEmbeddingCount":
            suggest = "leaf_node_embedding_count"
        elif key == "leafNodesToSearchPercent":
            suggest = "leaf_nodes_to_search_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfigAlgorithmConfigTreeAhConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfigAlgorithmConfigTreeAhConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfigAlgorithmConfigTreeAhConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 leaf_node_embedding_count: Optional[builtins.int] = None,
                 leaf_nodes_to_search_percent: Optional[builtins.int] = None):
        """
        :param builtins.int leaf_node_embedding_count: Number of embeddings on each leaf node. The default value is 1000 if not set.
        :param builtins.int leaf_nodes_to_search_percent: The default percentage of leaf nodes that any query may be searched. Must be in
               range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        if leaf_node_embedding_count is not None:
            pulumi.set(__self__, "leaf_node_embedding_count", leaf_node_embedding_count)
        if leaf_nodes_to_search_percent is not None:
            pulumi.set(__self__, "leaf_nodes_to_search_percent", leaf_nodes_to_search_percent)

    @property
    @pulumi.getter(name="leafNodeEmbeddingCount")
    def leaf_node_embedding_count(self) -> Optional[builtins.int]:
        """
        Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        return pulumi.get(self, "leaf_node_embedding_count")

    @property
    @pulumi.getter(name="leafNodesToSearchPercent")
    def leaf_nodes_to_search_percent(self) -> Optional[builtins.int]:
        """
        The default percentage of leaf nodes that any query may be searched. Must be in
        range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        return pulumi.get(self, "leaf_nodes_to_search_percent")


@pulumi.output_type
class AiMetadataStoreEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiMetadataStoreEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiMetadataStoreEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiMetadataStoreEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[builtins.str]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiMetadataStoreState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskUtilizationBytes":
            suggest = "disk_utilization_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiMetadataStoreState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiMetadataStoreState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiMetadataStoreState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_utilization_bytes: Optional[builtins.str] = None):
        """
        :param builtins.str disk_utilization_bytes: (Output)
               The disk utilization of the MetadataStore in bytes.
        """
        if disk_utilization_bytes is not None:
            pulumi.set(__self__, "disk_utilization_bytes", disk_utilization_bytes)

    @property
    @pulumi.getter(name="diskUtilizationBytes")
    def disk_utilization_bytes(self) -> Optional[builtins.str]:
        """
        (Output)
        The disk utilization of the MetadataStore in bytes.
        """
        return pulumi.get(self, "disk_utilization_bytes")


@pulumi.output_type
class AiTensorboardEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiTensorboardEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiTensorboardEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiTensorboardEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: builtins.str):
        """
        :param builtins.str kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetAiIndexDeployedIndexResult(dict):
    def __init__(__self__, *,
                 deployed_index_id: builtins.str,
                 index_endpoint: builtins.str):
        """
        :param builtins.str deployed_index_id: The ID of the DeployedIndex in the above IndexEndpoint.
        :param builtins.str index_endpoint: A resource name of the IndexEndpoint.
        """
        pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        pulumi.set(__self__, "index_endpoint", index_endpoint)

    @property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> builtins.str:
        """
        The ID of the DeployedIndex in the above IndexEndpoint.
        """
        return pulumi.get(self, "deployed_index_id")

    @property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> builtins.str:
        """
        A resource name of the IndexEndpoint.
        """
        return pulumi.get(self, "index_endpoint")


@pulumi.output_type
class GetAiIndexIndexStatResult(dict):
    def __init__(__self__, *,
                 shards_count: builtins.int,
                 vectors_count: builtins.str):
        """
        :param builtins.int shards_count: The number of shards in the Index.
        :param builtins.str vectors_count: The number of vectors in the Index.
        """
        pulumi.set(__self__, "shards_count", shards_count)
        pulumi.set(__self__, "vectors_count", vectors_count)

    @property
    @pulumi.getter(name="shardsCount")
    def shards_count(self) -> builtins.int:
        """
        The number of shards in the Index.
        """
        return pulumi.get(self, "shards_count")

    @property
    @pulumi.getter(name="vectorsCount")
    def vectors_count(self) -> builtins.str:
        """
        The number of vectors in the Index.
        """
        return pulumi.get(self, "vectors_count")


@pulumi.output_type
class GetAiIndexMetadataResult(dict):
    def __init__(__self__, *,
                 configs: Sequence['outputs.GetAiIndexMetadataConfigResult'],
                 contents_delta_uri: builtins.str,
                 is_complete_overwrite: builtins.bool):
        """
        :param Sequence['GetAiIndexMetadataConfigArgs'] configs: The configuration of the Matching Engine Index.
        :param builtins.str contents_delta_uri: Allows inserting, updating  or deleting the contents of the Matching Engine Index.
               The string must be a valid Cloud Storage directory path. If this
               field is set when calling IndexService.UpdateIndex, then no other
               Index field can be also updated as part of the same call.
               The expected structure and format of the files this URI points to is
               described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        :param builtins.bool is_complete_overwrite: If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
               then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "contents_delta_uri", contents_delta_uri)
        pulumi.set(__self__, "is_complete_overwrite", is_complete_overwrite)

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetAiIndexMetadataConfigResult']:
        """
        The configuration of the Matching Engine Index.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="contentsDeltaUri")
    def contents_delta_uri(self) -> builtins.str:
        """
        Allows inserting, updating  or deleting the contents of the Matching Engine Index.
        The string must be a valid Cloud Storage directory path. If this
        field is set when calling IndexService.UpdateIndex, then no other
        Index field can be also updated as part of the same call.
        The expected structure and format of the files this URI points to is
        described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        """
        return pulumi.get(self, "contents_delta_uri")

    @property
    @pulumi.getter(name="isCompleteOverwrite")
    def is_complete_overwrite(self) -> builtins.bool:
        """
        If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
        then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        return pulumi.get(self, "is_complete_overwrite")


@pulumi.output_type
class GetAiIndexMetadataConfigResult(dict):
    def __init__(__self__, *,
                 algorithm_configs: Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigResult'],
                 approximate_neighbors_count: builtins.int,
                 dimensions: builtins.int,
                 distance_measure_type: builtins.str,
                 feature_norm_type: builtins.str,
                 shard_size: builtins.str):
        """
        :param Sequence['GetAiIndexMetadataConfigAlgorithmConfigArgs'] algorithm_configs: The configuration with regard to the algorithms used for efficient search.
        :param builtins.int approximate_neighbors_count: The default number of neighbors to find via approximate search before exact reordering is
               performed. Exact reordering is a procedure where results returned by an
               approximate search algorithm are reordered via a more expensive distance computation.
               Required if tree-AH algorithm is used.
        :param builtins.int dimensions: The number of dimensions of the input vectors.
        :param builtins.str distance_measure_type: The distance measure used in nearest neighbor search. The value must be one of the followings:
               * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
               * L1_DISTANCE: Manhattan (L_1) Distance
               * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
               * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        :param builtins.str feature_norm_type: Type of normalization to be carried out on each vector. The value must be one of the followings:
               * UNIT_L2_NORM: Unit L2 normalization type
               * NONE: No normalization type is specified.
        :param builtins.str shard_size: Index data is split into equal parts to be processed. These are called "shards".
               The shard size must be specified when creating an index. The value must be one of the followings:
               * SHARD_SIZE_SMALL: Small (2GB)
               * SHARD_SIZE_MEDIUM: Medium (20GB)
               * SHARD_SIZE_LARGE: Large (50GB)
        """
        pulumi.set(__self__, "algorithm_configs", algorithm_configs)
        pulumi.set(__self__, "approximate_neighbors_count", approximate_neighbors_count)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "distance_measure_type", distance_measure_type)
        pulumi.set(__self__, "feature_norm_type", feature_norm_type)
        pulumi.set(__self__, "shard_size", shard_size)

    @property
    @pulumi.getter(name="algorithmConfigs")
    def algorithm_configs(self) -> Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigResult']:
        """
        The configuration with regard to the algorithms used for efficient search.
        """
        return pulumi.get(self, "algorithm_configs")

    @property
    @pulumi.getter(name="approximateNeighborsCount")
    def approximate_neighbors_count(self) -> builtins.int:
        """
        The default number of neighbors to find via approximate search before exact reordering is
        performed. Exact reordering is a procedure where results returned by an
        approximate search algorithm are reordered via a more expensive distance computation.
        Required if tree-AH algorithm is used.
        """
        return pulumi.get(self, "approximate_neighbors_count")

    @property
    @pulumi.getter
    def dimensions(self) -> builtins.int:
        """
        The number of dimensions of the input vectors.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="distanceMeasureType")
    def distance_measure_type(self) -> builtins.str:
        """
        The distance measure used in nearest neighbor search. The value must be one of the followings:
        * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
        * L1_DISTANCE: Manhattan (L_1) Distance
        * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
        * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        """
        return pulumi.get(self, "distance_measure_type")

    @property
    @pulumi.getter(name="featureNormType")
    def feature_norm_type(self) -> builtins.str:
        """
        Type of normalization to be carried out on each vector. The value must be one of the followings:
        * UNIT_L2_NORM: Unit L2 normalization type
        * NONE: No normalization type is specified.
        """
        return pulumi.get(self, "feature_norm_type")

    @property
    @pulumi.getter(name="shardSize")
    def shard_size(self) -> builtins.str:
        """
        Index data is split into equal parts to be processed. These are called "shards".
        The shard size must be specified when creating an index. The value must be one of the followings:
        * SHARD_SIZE_SMALL: Small (2GB)
        * SHARD_SIZE_MEDIUM: Medium (20GB)
        * SHARD_SIZE_LARGE: Large (50GB)
        """
        return pulumi.get(self, "shard_size")


@pulumi.output_type
class GetAiIndexMetadataConfigAlgorithmConfigResult(dict):
    def __init__(__self__, *,
                 brute_force_configs: Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigBruteForceConfigResult'],
                 tree_ah_configs: Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigTreeAhConfigResult']):
        """
        :param Sequence['GetAiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs'] brute_force_configs: Configuration options for using brute force search, which simply implements the
               standard linear search in the database for each query.
        :param Sequence['GetAiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs'] tree_ah_configs: Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
               Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        """
        pulumi.set(__self__, "brute_force_configs", brute_force_configs)
        pulumi.set(__self__, "tree_ah_configs", tree_ah_configs)

    @property
    @pulumi.getter(name="bruteForceConfigs")
    def brute_force_configs(self) -> Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigBruteForceConfigResult']:
        """
        Configuration options for using brute force search, which simply implements the
        standard linear search in the database for each query.
        """
        return pulumi.get(self, "brute_force_configs")

    @property
    @pulumi.getter(name="treeAhConfigs")
    def tree_ah_configs(self) -> Sequence['outputs.GetAiIndexMetadataConfigAlgorithmConfigTreeAhConfigResult']:
        """
        Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
        Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        """
        return pulumi.get(self, "tree_ah_configs")


@pulumi.output_type
class GetAiIndexMetadataConfigAlgorithmConfigBruteForceConfigResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetAiIndexMetadataConfigAlgorithmConfigTreeAhConfigResult(dict):
    def __init__(__self__, *,
                 leaf_node_embedding_count: builtins.int,
                 leaf_nodes_to_search_percent: builtins.int):
        """
        :param builtins.int leaf_node_embedding_count: Number of embeddings on each leaf node. The default value is 1000 if not set.
        :param builtins.int leaf_nodes_to_search_percent: The default percentage of leaf nodes that any query may be searched. Must be in
               range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        pulumi.set(__self__, "leaf_node_embedding_count", leaf_node_embedding_count)
        pulumi.set(__self__, "leaf_nodes_to_search_percent", leaf_nodes_to_search_percent)

    @property
    @pulumi.getter(name="leafNodeEmbeddingCount")
    def leaf_node_embedding_count(self) -> builtins.int:
        """
        Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        return pulumi.get(self, "leaf_node_embedding_count")

    @property
    @pulumi.getter(name="leafNodesToSearchPercent")
    def leaf_nodes_to_search_percent(self) -> builtins.int:
        """
        The default percentage of leaf nodes that any query may be searched. Must be in
        range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        return pulumi.get(self, "leaf_nodes_to_search_percent")


