# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkstationConfigArgs', 'WorkstationConfig']

@pulumi.input_type
class WorkstationConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 workstation_cluster_id: pulumi.Input[builtins.str],
                 workstation_config_id: pulumi.Input[builtins.str],
                 allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 container: Optional[pulumi.Input['WorkstationConfigContainerArgs']] = None,
                 disable_tcp_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_audit_agent: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']] = None,
                 ephemeral_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]] = None,
                 host: Optional[pulumi.Input['WorkstationConfigHostArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 max_usable_workstations: Optional[pulumi.Input[builtins.int]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_checks: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 running_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkstationConfig resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster config should reside.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]] allowed_ports: A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['WorkstationConfigContainerArgs'] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] disable_tcp_connections: Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[builtins.bool] enable_audit_agent: Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        :param pulumi.Input['WorkstationConfigEncryptionKeyArgs'] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]] ephemeral_directories: Ephemeral directories which won't persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input['WorkstationConfigHostArgs'] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.int] max_usable_workstations: Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]] readiness_checks: Readiness checks to be performed on a workstation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replica_zones: Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
               If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        :param pulumi.Input[builtins.str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        if allowed_ports is not None:
            pulumi.set(__self__, "allowed_ports", allowed_ports)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if disable_tcp_connections is not None:
            pulumi.set(__self__, "disable_tcp_connections", disable_tcp_connections)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_audit_agent is not None:
            pulumi.set(__self__, "enable_audit_agent", enable_audit_agent)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if ephemeral_directories is not None:
            pulumi.set(__self__, "ephemeral_directories", ephemeral_directories)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_usable_workstations is not None:
            pulumi.set(__self__, "max_usable_workstations", max_usable_workstations)
        if persistent_directories is not None:
            pulumi.set(__self__, "persistent_directories", persistent_directories)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if readiness_checks is not None:
            pulumi.set(__self__, "readiness_checks", readiness_checks)
        if replica_zones is not None:
            pulumi.set(__self__, "replica_zones", replica_zones)
        if running_timeout is not None:
            pulumi.set(__self__, "running_timeout", running_timeout)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location where the workstation cluster config should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_config_id", value)

    @property
    @pulumi.getter(name="allowedPorts")
    def allowed_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]]:
        """
        A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_ports")

    @allowed_ports.setter
    def allowed_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]]):
        pulumi.set(self, "allowed_ports", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['WorkstationConfigContainerArgs']]:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['WorkstationConfigContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="disableTcpConnections")
    def disable_tcp_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        """
        return pulumi.get(self, "disable_tcp_connections")

    @disable_tcp_connections.setter
    def disable_tcp_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_tcp_connections", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableAuditAgent")
    def enable_audit_agent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        """
        return pulumi.get(self, "enable_audit_agent")

    @enable_audit_agent.setter
    def enable_audit_agent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_audit_agent", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="ephemeralDirectories")
    def ephemeral_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]]:
        """
        Ephemeral directories which won't persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "ephemeral_directories")

    @ephemeral_directories.setter
    def ephemeral_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]]):
        pulumi.set(self, "ephemeral_directories", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input['WorkstationConfigHostArgs']]:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input['WorkstationConfigHostArgs']]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxUsableWorkstations")
    def max_usable_workstations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        """
        return pulumi.get(self, "max_usable_workstations")

    @max_usable_workstations.setter
    def max_usable_workstations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_usable_workstations", value)

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @persistent_directories.setter
    def persistent_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]):
        pulumi.set(self, "persistent_directories", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="readinessChecks")
    def readiness_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]]:
        """
        Readiness checks to be performed on a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_checks")

    @readiness_checks.setter
    def readiness_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]]):
        pulumi.set(self, "readiness_checks", value)

    @property
    @pulumi.getter(name="replicaZones")
    def replica_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
        If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        """
        return pulumi.get(self, "replica_zones")

    @replica_zones.setter
    def replica_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "replica_zones", value)

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @running_timeout.setter
    def running_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "running_timeout", value)


@pulumi.input_type
class _WorkstationConfigState:
    def __init__(__self__, *,
                 allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]] = None,
                 container: Optional[pulumi.Input['WorkstationConfigContainerArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 degraded: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_tcp_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_audit_agent: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']] = None,
                 ephemeral_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 host: Optional[pulumi.Input['WorkstationConfigHostArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_usable_workstations: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 readiness_checks: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 running_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkstationConfig resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]] allowed_ports: A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input['WorkstationConfigContainerArgs'] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        :param pulumi.Input[builtins.bool] disable_tcp_connections: Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_audit_agent: Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        :param pulumi.Input['WorkstationConfigEncryptionKeyArgs'] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]] ephemeral_directories: Ephemeral directories which won't persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input['WorkstationConfigHostArgs'] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster config should reside.
        :param pulumi.Input[builtins.int] max_usable_workstations: Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        :param pulumi.Input[builtins.str] name: Full name of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]] readiness_checks: Readiness checks to be performed on a workstation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replica_zones: Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
               If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        :param pulumi.Input[builtins.str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        if allowed_ports is not None:
            pulumi.set(__self__, "allowed_ports", allowed_ports)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if degraded is not None:
            pulumi.set(__self__, "degraded", degraded)
        if disable_tcp_connections is not None:
            pulumi.set(__self__, "disable_tcp_connections", disable_tcp_connections)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_audit_agent is not None:
            pulumi.set(__self__, "enable_audit_agent", enable_audit_agent)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if ephemeral_directories is not None:
            pulumi.set(__self__, "ephemeral_directories", ephemeral_directories)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_usable_workstations is not None:
            pulumi.set(__self__, "max_usable_workstations", max_usable_workstations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistent_directories is not None:
            pulumi.set(__self__, "persistent_directories", persistent_directories)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if readiness_checks is not None:
            pulumi.set(__self__, "readiness_checks", readiness_checks)
        if replica_zones is not None:
            pulumi.set(__self__, "replica_zones", replica_zones)
        if running_timeout is not None:
            pulumi.set(__self__, "running_timeout", running_timeout)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if workstation_cluster_id is not None:
            pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        if workstation_config_id is not None:
            pulumi.set(__self__, "workstation_config_id", workstation_config_id)

    @property
    @pulumi.getter(name="allowedPorts")
    def allowed_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]]:
        """
        A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_ports")

    @allowed_ports.setter
    def allowed_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigAllowedPortArgs']]]]):
        pulumi.set(self, "allowed_ports", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['WorkstationConfigContainerArgs']]:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['WorkstationConfigContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def degraded(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @degraded.setter
    def degraded(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "degraded", value)

    @property
    @pulumi.getter(name="disableTcpConnections")
    def disable_tcp_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        """
        return pulumi.get(self, "disable_tcp_connections")

    @disable_tcp_connections.setter
    def disable_tcp_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_tcp_connections", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableAuditAgent")
    def enable_audit_agent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        """
        return pulumi.get(self, "enable_audit_agent")

    @enable_audit_agent.setter
    def enable_audit_agent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_audit_agent", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="ephemeralDirectories")
    def ephemeral_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]]:
        """
        Ephemeral directories which won't persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "ephemeral_directories")

    @ephemeral_directories.setter
    def ephemeral_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigEphemeralDirectoryArgs']]]]):
        pulumi.set(self, "ephemeral_directories", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input['WorkstationConfigHostArgs']]:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input['WorkstationConfigHostArgs']]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the workstation cluster config should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxUsableWorkstations")
    def max_usable_workstations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        """
        return pulumi.get(self, "max_usable_workstations")

    @max_usable_workstations.setter
    def max_usable_workstations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_usable_workstations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @persistent_directories.setter
    def persistent_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]):
        pulumi.set(self, "persistent_directories", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="readinessChecks")
    def readiness_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]]:
        """
        Readiness checks to be performed on a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_checks")

    @readiness_checks.setter
    def readiness_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigReadinessCheckArgs']]]]):
        pulumi.set(self, "readiness_checks", value)

    @property
    @pulumi.getter(name="replicaZones")
    def replica_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
        If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        """
        return pulumi.get(self, "replica_zones")

    @replica_zones.setter
    def replica_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "replica_zones", value)

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @running_timeout.setter
    def running_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "running_timeout", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_config_id", value)


@pulumi.type_token("gcp:workstations/workstationConfig:WorkstationConfig")
class WorkstationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigAllowedPortArgs', 'WorkstationConfigAllowedPortArgsDict']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 container: Optional[pulumi.Input[Union['WorkstationConfigContainerArgs', 'WorkstationConfigContainerArgsDict']]] = None,
                 disable_tcp_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_audit_agent: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[Union['WorkstationConfigEncryptionKeyArgs', 'WorkstationConfigEncryptionKeyArgsDict']]] = None,
                 ephemeral_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigEphemeralDirectoryArgs', 'WorkstationConfigEphemeralDirectoryArgsDict']]]]] = None,
                 host: Optional[pulumi.Input[Union['WorkstationConfigHostArgs', 'WorkstationConfigHostArgsDict']]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_usable_workstations: Optional[pulumi.Input[builtins.int]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigPersistentDirectoryArgs', 'WorkstationConfigPersistentDirectoryArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigReadinessCheckArgs', 'WorkstationConfigReadinessCheckArgsDict']]]]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 running_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Workstation Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tag_key1 = gcp.tags.TagKey("tag_key1",
            parent="organizations/123456789",
            short_name="keyname")
        tag_value1 = gcp.tags.TagValue("tag_value1",
            parent=tag_key1.id,
            short_name="valuename")
        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            idle_timeout="600s",
            running_timeout="21600s",
            replica_zones=[
                "us-central1-a",
                "us-central1-b",
            ],
            annotations={
                "label-one": "value-one",
            },
            labels={
                "label": "key",
            },
            max_usable_workstations=1,
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "disable_ssh": False,
                    "vm_tags": pulumi.Output.all(
                        tagKey1Id=tag_key1.id,
                        tagValue1Id=tag_value1.id
        ).apply(lambda resolved_outputs: {
                        resolved_outputs['tagKey1Id']: resolved_outputs['tagValue1Id'],
                    })
        ,
                },
            })
        ```
        ### Workstation Config Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "n1-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "enable_nested_virtualization": True,
                },
            },
            container={
                "image": "intellij",
                "env": {
                    "NAME": "FOO",
                    "BABE": "bar",
                },
            })
        ```
        ### Workstation Config Persistent Directories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            },
            persistent_directories=[{
                "mount_path": "/home",
                "gce_pd": {
                    "size_gb": 200,
                    "fs_type": "ext4",
                    "disk_type": "pd-standard",
                    "reclaim_policy": "DELETE",
                },
            }])
        ```
        ### Workstation Config Source Snapshot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        my_source_disk = gcp.compute.Disk("my_source_disk",
            name="workstation-config",
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        my_source_snapshot = gcp.compute.Snapshot("my_source_snapshot",
            name="workstation-config",
            source_disk=my_source_disk.name,
            zone="us-central1-a")
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1")
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location=default_workstation_cluster.location,
            persistent_directories=[{
                "mount_path": "/home",
                "gce_pd": {
                    "source_snapshot": my_source_snapshot.id,
                    "reclaim_policy": "DELETE",
                },
            }])
        ```
        ### Workstation Config Shielded Instance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            })
        ```
        ### Workstation Config Accelerators

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "n1-standard-2",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "accelerators": [{
                        "type": "nvidia-tesla-t4",
                        "count": 1,
                    }],
                },
            })
        ```
        ### Workstation Config Boost

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "boost_configs": [
                        {
                            "id": "boost-1",
                            "machine_type": "n1-standard-2",
                            "accelerators": [{
                                "type": "nvidia-tesla-t4",
                                "count": 1,
                            }],
                        },
                        {
                            "id": "boost-2",
                            "machine_type": "n1-standard-2",
                            "pool_size": 2,
                            "boot_disk_size_gb": 30,
                            "enable_nested_virtualization": True,
                        },
                    ],
                },
            })
        ```
        ### Workstation Config Encryption Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_key_ring = gcp.kms.KeyRing("default",
            name="workstation-cluster",
            location="us-central1")
        default_crypto_key = gcp.kms.CryptoKey("default",
            name="workstation-cluster",
            key_ring=default_key_ring.id)
        default_account = gcp.serviceaccount.Account("default",
            account_id="my-account",
            display_name="Service Account")
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            },
            encryption_key={
                "kms_key": default_crypto_key.id,
                "kms_key_service_account": default_account.email,
            })
        ```
        ### Workstation Config Allowed Ports

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                },
            },
            allowed_ports=[
                {
                    "first": 80,
                    "last": 80,
                },
                {
                    "first": 22,
                    "last": 22,
                },
                {
                    "first": 1024,
                    "last": 65535,
                },
            ])
        ```

        ## Import

        WorkstationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}`

        * `{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}`

        When using the `pulumi import` command, WorkstationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigAllowedPortArgs', 'WorkstationConfigAllowedPortArgsDict']]]] allowed_ports: A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['WorkstationConfigContainerArgs', 'WorkstationConfigContainerArgsDict']] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] disable_tcp_connections: Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[builtins.bool] enable_audit_agent: Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        :param pulumi.Input[Union['WorkstationConfigEncryptionKeyArgs', 'WorkstationConfigEncryptionKeyArgsDict']] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigEphemeralDirectoryArgs', 'WorkstationConfigEphemeralDirectoryArgsDict']]]] ephemeral_directories: Ephemeral directories which won't persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[Union['WorkstationConfigHostArgs', 'WorkstationConfigHostArgsDict']] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster config should reside.
        :param pulumi.Input[builtins.int] max_usable_workstations: Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigPersistentDirectoryArgs', 'WorkstationConfigPersistentDirectoryArgsDict']]]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigReadinessCheckArgs', 'WorkstationConfigReadinessCheckArgsDict']]]] readiness_checks: Readiness checks to be performed on a workstation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replica_zones: Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
               If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        :param pulumi.Input[builtins.str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkstationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Workstation Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tag_key1 = gcp.tags.TagKey("tag_key1",
            parent="organizations/123456789",
            short_name="keyname")
        tag_value1 = gcp.tags.TagValue("tag_value1",
            parent=tag_key1.id,
            short_name="valuename")
        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            idle_timeout="600s",
            running_timeout="21600s",
            replica_zones=[
                "us-central1-a",
                "us-central1-b",
            ],
            annotations={
                "label-one": "value-one",
            },
            labels={
                "label": "key",
            },
            max_usable_workstations=1,
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "disable_ssh": False,
                    "vm_tags": pulumi.Output.all(
                        tagKey1Id=tag_key1.id,
                        tagValue1Id=tag_value1.id
        ).apply(lambda resolved_outputs: {
                        resolved_outputs['tagKey1Id']: resolved_outputs['tagValue1Id'],
                    })
        ,
                },
            })
        ```
        ### Workstation Config Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "n1-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "enable_nested_virtualization": True,
                },
            },
            container={
                "image": "intellij",
                "env": {
                    "NAME": "FOO",
                    "BABE": "bar",
                },
            })
        ```
        ### Workstation Config Persistent Directories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            },
            persistent_directories=[{
                "mount_path": "/home",
                "gce_pd": {
                    "size_gb": 200,
                    "fs_type": "ext4",
                    "disk_type": "pd-standard",
                    "reclaim_policy": "DELETE",
                },
            }])
        ```
        ### Workstation Config Source Snapshot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        my_source_disk = gcp.compute.Disk("my_source_disk",
            name="workstation-config",
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        my_source_snapshot = gcp.compute.Snapshot("my_source_snapshot",
            name="workstation-config",
            source_disk=my_source_disk.name,
            zone="us-central1-a")
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1")
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location=default_workstation_cluster.location,
            persistent_directories=[{
                "mount_path": "/home",
                "gce_pd": {
                    "source_snapshot": my_source_snapshot.id,
                    "reclaim_policy": "DELETE",
                },
            }])
        ```
        ### Workstation Config Shielded Instance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            })
        ```
        ### Workstation Config Accelerators

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "n1-standard-2",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "accelerators": [{
                        "type": "nvidia-tesla-t4",
                        "count": 1,
                    }],
                },
            })
        ```
        ### Workstation Config Boost

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "boost_configs": [
                        {
                            "id": "boost-1",
                            "machine_type": "n1-standard-2",
                            "accelerators": [{
                                "type": "nvidia-tesla-t4",
                                "count": 1,
                            }],
                        },
                        {
                            "id": "boost-2",
                            "machine_type": "n1-standard-2",
                            "pool_size": 2,
                            "boot_disk_size_gb": 30,
                            "enable_nested_virtualization": True,
                        },
                    ],
                },
            })
        ```
        ### Workstation Config Encryption Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_key_ring = gcp.kms.KeyRing("default",
            name="workstation-cluster",
            location="us-central1")
        default_crypto_key = gcp.kms.CryptoKey("default",
            name="workstation-cluster",
            key_ring=default_key_ring.id)
        default_account = gcp.serviceaccount.Account("default",
            account_id="my-account",
            display_name="Service Account")
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                    "shielded_instance_config": {
                        "enable_secure_boot": True,
                        "enable_vtpm": True,
                    },
                },
            },
            encryption_key={
                "kms_key": default_crypto_key.id,
                "kms_key_service_account": default_account.email,
            })
        ```
        ### Workstation Config Allowed Ports

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                },
            },
            allowed_ports=[
                {
                    "first": 80,
                    "last": 80,
                },
                {
                    "first": 22,
                    "last": 22,
                },
                {
                    "first": 1024,
                    "last": 65535,
                },
            ])
        ```

        ## Import

        WorkstationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}`

        * `{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}`

        When using the `pulumi import` command, WorkstationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkstationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkstationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigAllowedPortArgs', 'WorkstationConfigAllowedPortArgsDict']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 container: Optional[pulumi.Input[Union['WorkstationConfigContainerArgs', 'WorkstationConfigContainerArgsDict']]] = None,
                 disable_tcp_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_audit_agent: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[Union['WorkstationConfigEncryptionKeyArgs', 'WorkstationConfigEncryptionKeyArgsDict']]] = None,
                 ephemeral_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigEphemeralDirectoryArgs', 'WorkstationConfigEphemeralDirectoryArgsDict']]]]] = None,
                 host: Optional[pulumi.Input[Union['WorkstationConfigHostArgs', 'WorkstationConfigHostArgsDict']]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_usable_workstations: Optional[pulumi.Input[builtins.int]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigPersistentDirectoryArgs', 'WorkstationConfigPersistentDirectoryArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigReadinessCheckArgs', 'WorkstationConfigReadinessCheckArgsDict']]]]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 running_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkstationConfigArgs.__new__(WorkstationConfigArgs)

            __props__.__dict__["allowed_ports"] = allowed_ports
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["container"] = container
            __props__.__dict__["disable_tcp_connections"] = disable_tcp_connections
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_audit_agent"] = enable_audit_agent
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["ephemeral_directories"] = ephemeral_directories
            __props__.__dict__["host"] = host
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["max_usable_workstations"] = max_usable_workstations
            __props__.__dict__["persistent_directories"] = persistent_directories
            __props__.__dict__["project"] = project
            __props__.__dict__["readiness_checks"] = readiness_checks
            __props__.__dict__["replica_zones"] = replica_zones
            __props__.__dict__["running_timeout"] = running_timeout
            if workstation_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_cluster_id'")
            __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
            if workstation_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_config_id'")
            __props__.__dict__["workstation_config_id"] = workstation_config_id
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["degraded"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkstationConfig, __self__).__init__(
            'gcp:workstations/workstationConfig:WorkstationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigAllowedPortArgs', 'WorkstationConfigAllowedPortArgsDict']]]]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigConditionArgs', 'WorkstationConfigConditionArgsDict']]]]] = None,
            container: Optional[pulumi.Input[Union['WorkstationConfigContainerArgs', 'WorkstationConfigContainerArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            degraded: Optional[pulumi.Input[builtins.bool]] = None,
            disable_tcp_connections: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_audit_agent: Optional[pulumi.Input[builtins.bool]] = None,
            encryption_key: Optional[pulumi.Input[Union['WorkstationConfigEncryptionKeyArgs', 'WorkstationConfigEncryptionKeyArgsDict']]] = None,
            ephemeral_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigEphemeralDirectoryArgs', 'WorkstationConfigEphemeralDirectoryArgsDict']]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            host: Optional[pulumi.Input[Union['WorkstationConfigHostArgs', 'WorkstationConfigHostArgsDict']]] = None,
            idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            max_usable_workstations: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigPersistentDirectoryArgs', 'WorkstationConfigPersistentDirectoryArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            readiness_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigReadinessCheckArgs', 'WorkstationConfigReadinessCheckArgsDict']]]]] = None,
            replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            running_timeout: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            workstation_config_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkstationConfig':
        """
        Get an existing WorkstationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigAllowedPortArgs', 'WorkstationConfigAllowedPortArgsDict']]]] allowed_ports: A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigConditionArgs', 'WorkstationConfigConditionArgsDict']]]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input[Union['WorkstationConfigContainerArgs', 'WorkstationConfigContainerArgsDict']] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        :param pulumi.Input[builtins.bool] disable_tcp_connections: Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_audit_agent: Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        :param pulumi.Input[Union['WorkstationConfigEncryptionKeyArgs', 'WorkstationConfigEncryptionKeyArgsDict']] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigEphemeralDirectoryArgs', 'WorkstationConfigEphemeralDirectoryArgsDict']]]] ephemeral_directories: Ephemeral directories which won't persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[Union['WorkstationConfigHostArgs', 'WorkstationConfigHostArgsDict']] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster config should reside.
        :param pulumi.Input[builtins.int] max_usable_workstations: Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        :param pulumi.Input[builtins.str] name: Full name of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigPersistentDirectoryArgs', 'WorkstationConfigPersistentDirectoryArgsDict']]]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationConfigReadinessCheckArgs', 'WorkstationConfigReadinessCheckArgsDict']]]] readiness_checks: Readiness checks to be performed on a workstation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replica_zones: Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
               If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        :param pulumi.Input[builtins.str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkstationConfigState.__new__(_WorkstationConfigState)

        __props__.__dict__["allowed_ports"] = allowed_ports
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["container"] = container
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["degraded"] = degraded
        __props__.__dict__["disable_tcp_connections"] = disable_tcp_connections
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_audit_agent"] = enable_audit_agent
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["ephemeral_directories"] = ephemeral_directories
        __props__.__dict__["etag"] = etag
        __props__.__dict__["host"] = host
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["max_usable_workstations"] = max_usable_workstations
        __props__.__dict__["name"] = name
        __props__.__dict__["persistent_directories"] = persistent_directories
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["readiness_checks"] = readiness_checks
        __props__.__dict__["replica_zones"] = replica_zones
        __props__.__dict__["running_timeout"] = running_timeout
        __props__.__dict__["uid"] = uid
        __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
        __props__.__dict__["workstation_config_id"] = workstation_config_id
        return WorkstationConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedPorts")
    def allowed_ports(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigAllowedPort']]:
        """
        A list of port ranges specifying single ports or ranges of ports that are externally accessible in the workstation. Allowed ports must be one of 22, 80, or within range 1024-65535. If not specified defaults to ports 22, 80, and ports 1024-65535.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_ports")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigCondition']]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output['outputs.WorkstationConfigContainer']:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def degraded(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @property
    @pulumi.getter(name="disableTcpConnections")
    def disable_tcp_connections(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
        """
        return pulumi.get(self, "disable_tcp_connections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableAuditAgent")
    def enable_audit_agent(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable Linux `auditd` logging on the workstation. When enabled, a service account must also be specified that has `logging.buckets.write` permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
        """
        return pulumi.get(self, "enable_audit_agent")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional['outputs.WorkstationConfigEncryptionKey']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="ephemeralDirectories")
    def ephemeral_directories(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigEphemeralDirectory']]:
        """
        Ephemeral directories which won't persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "ephemeral_directories")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output['outputs.WorkstationConfigHost']:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the workstation cluster config should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxUsableWorkstations")
    def max_usable_workstations(self) -> pulumi.Output[builtins.int]:
        """
        Maximum number of workstations under this configuration a user can have workstations.workstation.use permission on. Only enforced on CreateWorkstation API calls on the user issuing the API request.
        """
        return pulumi.get(self, "max_usable_workstations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigPersistentDirectory']]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="readinessChecks")
    def readiness_checks(self) -> pulumi.Output[Optional[Sequence['outputs.WorkstationConfigReadinessCheck']]]:
        """
        Readiness checks to be performed on a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_checks")

    @property
    @pulumi.getter(name="replicaZones")
    def replica_zones(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, `['us-central1-a', 'us-central1-f']`.
        If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
        """
        return pulumi.get(self, "replica_zones")

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

