# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import dumps
from typing import Annotated, Any, Dict, List, Optional, Self, Tuple, Union
from urllib.parse import quote

from pydantic import Field, StrictBool, StrictInt, StrictStr

from algoliasearch.analytics.config import AnalyticsConfig
from algoliasearch.analytics.models.direction import Direction
from algoliasearch.analytics.models.get_average_click_position_response import (
    GetAverageClickPositionResponse,
)
from algoliasearch.analytics.models.get_click_positions_response import (
    GetClickPositionsResponse,
)
from algoliasearch.analytics.models.get_click_through_rate_response import (
    GetClickThroughRateResponse,
)
from algoliasearch.analytics.models.get_conversation_rate_response import (
    GetConversationRateResponse,
)
from algoliasearch.analytics.models.get_no_click_rate_response import (
    GetNoClickRateResponse,
)
from algoliasearch.analytics.models.get_no_results_rate_response import (
    GetNoResultsRateResponse,
)
from algoliasearch.analytics.models.get_searches_count_response import (
    GetSearchesCountResponse,
)
from algoliasearch.analytics.models.get_searches_no_clicks_response import (
    GetSearchesNoClicksResponse,
)
from algoliasearch.analytics.models.get_searches_no_results_response import (
    GetSearchesNoResultsResponse,
)
from algoliasearch.analytics.models.get_status_response import GetStatusResponse
from algoliasearch.analytics.models.get_top_countries_response import (
    GetTopCountriesResponse,
)
from algoliasearch.analytics.models.get_top_filter_attributes_response import (
    GetTopFilterAttributesResponse,
)
from algoliasearch.analytics.models.get_top_filter_for_attribute_response import (
    GetTopFilterForAttributeResponse,
)
from algoliasearch.analytics.models.get_top_filters_no_results_response import (
    GetTopFiltersNoResultsResponse,
)
from algoliasearch.analytics.models.get_top_hits_response import GetTopHitsResponse
from algoliasearch.analytics.models.get_top_searches_response import (
    GetTopSearchesResponse,
)
from algoliasearch.analytics.models.get_users_count_response import (
    GetUsersCountResponse,
)
from algoliasearch.analytics.models.order_by import OrderBy
from algoliasearch.http.api_response import ApiResponse
from algoliasearch.http.request_options import RequestOptions
from algoliasearch.http.serializer import bodySerializer
from algoliasearch.http.transporter import Transporter
from algoliasearch.http.verb import Verb


class AnalyticsClient:
    """The Algolia 'AnalyticsClient' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("de" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = AnalyticsClient("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")
    _client_with_named_args = AnalyticsClient(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")

    See `AnalyticsClient.create_with_config` for advanced configuration.
    """

    _transporter: Transporter
    _config: AnalyticsConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: Optional[str] = None,
        transporter: Optional[Transporter] = None,
        config: Optional[AnalyticsConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = transporter._config

        if config is None:
            config = AnalyticsConfig(app_id, api_key, region)
        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = Transporter(config)
        self._transporter = transporter

    def create_with_config(
        config: AnalyticsConfig, transporter: Optional[Transporter] = None
    ) -> Self:
        """Allows creating a client with a customized `AnalyticsConfig` and `Transporter`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (AnalyticsConfig): The config of the API client.
        transporter (Transporter): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = AnalyticsClient.create_with_config(config=AnalyticsConfig(...))
        _client_with_custom_config_and_transporter = AnalyticsClient.create_with_config(config=AnalyticsConfig(...), transporter=Transporter(...))
        """
        if transporter is None:
            transporter = Transporter(config)

        return AnalyticsClient(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

    async def __aenter__(self) -> None:
        return self

    async def __aexit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        await self.close()

    async def close(self) -> None:
        """Closes the underlying `transporter` of the API client."""
        return await self._transporter.close()

    async def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_delete_with_http_info(path, parameters, request_options)
        ).deserialize(object)

    async def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_get_with_http_info(path, parameters, request_options)
        ).deserialize(object)

    async def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_post_with_http_info(
                path, parameters, body, request_options
            )
        ).deserialize(object)

    async def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_put_with_http_info(
                path, parameters, body, request_options
            )
        ).deserialize(object)

    async def get_average_click_position_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the average click position for the complete time range and for individual days. > **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't receive any click events for tracked searches. A _tracked_ search is a search request where the `clickAnalytics` parameter is `true`.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_average_click_position`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/clicks/averageClickPosition",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_average_click_position(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetAverageClickPositionResponse:
        """
        Return the average click position for the complete time range and for individual days. > **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't receive any click events for tracked searches. A _tracked_ search is a search request where the `clickAnalytics` parameter is `true`.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetAverageClickPositionResponse' result object.
        """
        return (
            await self.get_average_click_position_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetAverageClickPositionResponse)

    async def get_click_positions_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Show the number of clicks events and their associated position in the search results.  > **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't receive any click events for tracked searches. A _tracked_ search is a search request where the `clickAnalytics` parameter is `true`.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_click_positions`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/clicks/positions",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_click_positions(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetClickPositionsResponse:
        """
        Show the number of clicks events and their associated position in the search results.  > **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't receive any click events for tracked searches. A _tracked_ search is a search request where the `clickAnalytics` parameter is `true`.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetClickPositionsResponse' result object.
        """
        return (
            await self.get_click_positions_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetClickPositionsResponse)

    async def get_click_through_rate_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns a [click-through rate (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_click_through_rate`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/clicks/clickThroughRate",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_click_through_rate(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetClickThroughRateResponse:
        """
        Returns a [click-through rate (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetClickThroughRateResponse' result object.
        """
        return (
            await self.get_click_through_rate_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetClickThroughRateResponse)

    async def get_conversation_rate_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return a [conversion rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_conversation_rate`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/conversions/conversionRate",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_conversation_rate(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetConversationRateResponse:
        """
        Return a [conversion rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetConversationRateResponse' result object.
        """
        return (
            await self.get_conversation_rate_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetConversationRateResponse)

    async def get_no_click_rate_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for the complete given time range, as well as a value per day. It also returns the count of searches and searches without clicks.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_no_click_rate`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches/noClickRate",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_no_click_rate(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetNoClickRateResponse:
        """
        Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for the complete given time range, as well as a value per day. It also returns the count of searches and searches without clicks.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetNoClickRateResponse' result object.
        """
        return (
            await self.get_no_click_rate_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetNoClickRateResponse)

    async def get_no_results_rate_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the rate at which searches didn't return any results.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_no_results_rate`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches/noResultRate",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_no_results_rate(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetNoResultsRateResponse:
        """
        Returns the rate at which searches didn't return any results.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetNoResultsRateResponse' result object.
        """
        return (
            await self.get_no_results_rate_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetNoResultsRateResponse)

    async def get_searches_count_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the number of searches within a time range.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_searches_count`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches/count",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_searches_count(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetSearchesCountResponse:
        """
        Returns the number of searches within a time range.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetSearchesCountResponse' result object.
        """
        return (
            await self.get_searches_count_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetSearchesCountResponse)

    async def get_searches_no_clicks_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the most popular of the last 1,000 searches that didn't lead to any clicks.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_searches_no_clicks`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches/noClicks",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_searches_no_clicks(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetSearchesNoClicksResponse:
        """
        Return the most popular of the last 1,000 searches that didn't lead to any clicks.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetSearchesNoClicksResponse' result object.
        """
        return (
            await self.get_searches_no_clicks_with_http_info(
                index, start_date, end_date, limit, offset, tags, request_options
            )
        ).deserialize(GetSearchesNoClicksResponse)

    async def get_searches_no_results_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the most popular of the latest 1,000 searches that didn't return any results.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_searches_no_results`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches/noResults",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_searches_no_results(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetSearchesNoResultsResponse:
        """
        Returns the most popular of the latest 1,000 searches that didn't return any results.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetSearchesNoResultsResponse' result object.
        """
        return (
            await self.get_searches_no_results_with_http_info(
                index, start_date, end_date, limit, offset, tags, request_options
            )
        ).deserialize(GetSearchesNoResultsResponse)

    async def get_status_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the latest update time of the Analytics API for an index. If the index has been recently created or no search has been performed yet, `updatedAt` will be `null`. > **Note**: The Analytics API is updated every 5&nbsp;minutes.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError("Parameter `index` is required when calling `get_status`.")

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/status",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_status(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetStatusResponse:
        """
        Return the latest update time of the Analytics API for an index. If the index has been recently created or no search has been performed yet, `updatedAt` will be `null`. > **Note**: The Analytics API is updated every 5&nbsp;minutes.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetStatusResponse' result object.
        """
        return (
            await self.get_status_with_http_info(index, request_options)
        ).deserialize(GetStatusResponse)

    async def get_top_countries_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns top countries. Limited to the 1,000 most frequent ones.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_countries`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/countries",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_countries(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopCountriesResponse:
        """
        Returns top countries. Limited to the 1,000 most frequent ones.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopCountriesResponse' result object.
        """
        return (
            await self.get_top_countries_with_http_info(
                index, start_date, end_date, limit, offset, tags, request_options
            )
        ).deserialize(GetTopCountriesResponse)

    async def get_top_filter_attributes_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the most popular [filterable attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_filter_attributes`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if search is not None:
            _query_parameters.append(("search", search))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/filters",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_filter_attributes(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopFilterAttributesResponse:
        """
        Return the most popular [filterable attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopFilterAttributesResponse' result object.
        """
        return (
            await self.get_top_filter_attributes_with_http_info(
                index,
                search,
                start_date,
                end_date,
                limit,
                offset,
                tags,
                request_options,
            )
        ).deserialize(GetTopFilterAttributesResponse)

    async def get_top_filter_for_attribute_with_http_info(
        self,
        attribute: Annotated[StrictStr, Field(description="Attribute name.")],
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the most popular filter values for an attribute in the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param attribute: Attribute name. (required)
        :type attribute: str
        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if attribute is None:
            raise ValueError(
                "Parameter `attribute` is required when calling `get_top_filter_for_attribute`."
            )

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_filter_for_attribute`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if search is not None:
            _query_parameters.append(("search", search))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/filters/{attribute}".replace(
                "{attribute}", quote(str(attribute), safe="")
            ),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_filter_for_attribute(
        self,
        attribute: Annotated[StrictStr, Field(description="Attribute name.")],
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopFilterForAttributeResponse:
        """
        Returns the most popular filter values for an attribute in the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param attribute: Attribute name. (required)
        :type attribute: str
        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopFilterForAttributeResponse' result object.
        """
        return (
            await self.get_top_filter_for_attribute_with_http_info(
                attribute,
                index,
                search,
                start_date,
                end_date,
                limit,
                offset,
                tags,
                request_options,
            )
        ).deserialize(GetTopFilterForAttributeResponse)

    async def get_top_filters_no_results_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_filters_no_results`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if search is not None:
            _query_parameters.append(("search", search))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/filters/noResults",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_filters_no_results(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopFiltersNoResultsResponse:
        """
        Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000 most recently used filters.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopFiltersNoResultsResponse' result object.
        """
        return (
            await self.get_top_filters_no_results_with_http_info(
                index,
                search,
                start_date,
                end_date,
                limit,
                offset,
                tags,
                request_options,
            )
        ).deserialize(GetTopFiltersNoResultsResponse)

    async def get_top_hits_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        click_analytics: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search."
            ),
        ] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the most popular clicked results in the last 1,000 searches.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param click_analytics: Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search.
        :type click_analytics: bool
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_hits`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if search is not None:
            _query_parameters.append(("search", search))
        if click_analytics is not None:
            _query_parameters.append(("clickAnalytics", click_analytics))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/hits",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_hits(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        search: Annotated[Optional[StrictStr], Field(description="User query.")] = None,
        click_analytics: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search."
            ),
        ] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopHitsResponse:
        """
        Return the most popular clicked results in the last 1,000 searches.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param search: User query.
        :type search: str
        :param click_analytics: Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search.
        :type click_analytics: bool
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopHitsResponse' result object.
        """
        return (
            await self.get_top_hits_with_http_info(
                index,
                search,
                click_analytics,
                start_date,
                end_date,
                limit,
                offset,
                tags,
                request_options,
            )
        ).deserialize(GetTopHitsResponse)

    async def get_top_searches_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        click_analytics: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search."
            ),
        ] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        order_by: Annotated[
            Optional[OrderBy], Field(description="Reorder the results.")
        ] = None,
        direction: Annotated[
            Optional[Direction],
            Field(
                description="Sorting direction of the results: ascending or descending. "
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Returns the most popular of the latest 1,000 searches. For each search, also returns the number of hits.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param click_analytics: Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search.
        :type click_analytics: bool
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param order_by: Reorder the results.
        :type order_by: OrderBy
        :param direction: Sorting direction of the results: ascending or descending.
        :type direction: Direction
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_top_searches`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if click_analytics is not None:
            _query_parameters.append(("clickAnalytics", click_analytics))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if order_by is not None:
            _query_parameters.append(("orderBy", order_by))
        if direction is not None:
            _query_parameters.append(("direction", direction))
        if limit is not None:
            _query_parameters.append(("limit", limit))
        if offset is not None:
            _query_parameters.append(("offset", offset))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/searches",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_top_searches(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        click_analytics: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search."
            ),
        ] = None,
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        order_by: Annotated[
            Optional[OrderBy], Field(description="Reorder the results.")
        ] = None,
        direction: Annotated[
            Optional[Direction],
            Field(
                description="Sorting direction of the results: ascending or descending. "
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(description="Number of records to return (page size)."),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="Position of the starting record. Used for paging. 0 is the first record."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetTopSearchesResponse:
        """
        Returns the most popular of the latest 1,000 searches. For each search, also returns the number of hits.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param click_analytics: Whether to include [click and conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a search.
        :type click_analytics: bool
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param order_by: Reorder the results.
        :type order_by: OrderBy
        :param direction: Sorting direction of the results: ascending or descending.
        :type direction: Direction
        :param limit: Number of records to return (page size).
        :type limit: int
        :param offset: Position of the starting record. Used for paging. 0 is the first record.
        :type offset: int
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetTopSearchesResponse' result object.
        """
        return (
            await self.get_top_searches_with_http_info(
                index,
                click_analytics,
                start_date,
                end_date,
                order_by,
                direction,
                limit,
                offset,
                tags,
                request_options,
            )
        ).deserialize(GetTopSearchesResponse)

    async def get_users_count_with_http_info(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Return the count of unique users.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index is None:
            raise ValueError(
                "Parameter `index` is required when calling `get_users_count`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if index is not None:
            _query_parameters.append(("index", index))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))
        if tags is not None:
            _query_parameters.append(("tags", tags))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/users/count",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_users_count(
        self,
        index: Annotated[StrictStr, Field(description="Index name to target.")],
        start_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Start date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        end_date: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="End date (a string in the format `YYYY-MM-DD`) of the period to analyze."
            ),
        ] = None,
        tags: Annotated[
            Optional[StrictStr],
            Field(
                description="Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetUsersCountResponse:
        """
        Return the count of unique users.

        Required API Key ACLs:
          - analytics

        :param index: Index name to target. (required)
        :type index: str
        :param start_date: Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type start_date: str
        :param end_date: End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
        :type end_date: str
        :param tags: Filter analytics on the [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/) set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it must be URL-encoded.
        :type tags: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetUsersCountResponse' result object.
        """
        return (
            await self.get_users_count_with_http_info(
                index, start_date, end_date, tags, request_options
            )
        ).deserialize(GetUsersCountResponse)
