# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import dumps
from typing import Annotated, Any, Dict, List, Optional, Self, Tuple, Union
from urllib.parse import quote

from pydantic import Field, StrictBool, StrictInt, StrictStr

from algoliasearch.http.api_response import ApiResponse
from algoliasearch.http.request_options import RequestOptions
from algoliasearch.http.serializer import bodySerializer
from algoliasearch.http.transporter import Transporter
from algoliasearch.http.verb import Verb
from algoliasearch.ingestion.config import IngestionConfig
from algoliasearch.ingestion.models.action_type import ActionType
from algoliasearch.ingestion.models.authentication import Authentication
from algoliasearch.ingestion.models.authentication_create import AuthenticationCreate
from algoliasearch.ingestion.models.authentication_create_response import (
    AuthenticationCreateResponse,
)
from algoliasearch.ingestion.models.authentication_search import AuthenticationSearch
from algoliasearch.ingestion.models.authentication_sort_keys import (
    AuthenticationSortKeys,
)
from algoliasearch.ingestion.models.authentication_type import AuthenticationType
from algoliasearch.ingestion.models.authentication_update import AuthenticationUpdate
from algoliasearch.ingestion.models.authentication_update_response import (
    AuthenticationUpdateResponse,
)
from algoliasearch.ingestion.models.delete_response import DeleteResponse
from algoliasearch.ingestion.models.destination import Destination
from algoliasearch.ingestion.models.destination_create import DestinationCreate
from algoliasearch.ingestion.models.destination_create_response import (
    DestinationCreateResponse,
)
from algoliasearch.ingestion.models.destination_search import DestinationSearch
from algoliasearch.ingestion.models.destination_sort_keys import DestinationSortKeys
from algoliasearch.ingestion.models.destination_type import DestinationType
from algoliasearch.ingestion.models.destination_update import DestinationUpdate
from algoliasearch.ingestion.models.destination_update_response import (
    DestinationUpdateResponse,
)
from algoliasearch.ingestion.models.docker_source_discover import DockerSourceDiscover
from algoliasearch.ingestion.models.docker_source_streams import DockerSourceStreams
from algoliasearch.ingestion.models.event import Event
from algoliasearch.ingestion.models.event_sort_keys import EventSortKeys
from algoliasearch.ingestion.models.event_status import EventStatus
from algoliasearch.ingestion.models.event_type import EventType
from algoliasearch.ingestion.models.list_authentications_response import (
    ListAuthenticationsResponse,
)
from algoliasearch.ingestion.models.list_destinations_response import (
    ListDestinationsResponse,
)
from algoliasearch.ingestion.models.list_events_response import ListEventsResponse
from algoliasearch.ingestion.models.list_sources_response import ListSourcesResponse
from algoliasearch.ingestion.models.list_tasks_response import ListTasksResponse
from algoliasearch.ingestion.models.order_keys import OrderKeys
from algoliasearch.ingestion.models.platform_with_none import PlatformWithNone
from algoliasearch.ingestion.models.run import Run
from algoliasearch.ingestion.models.run_list_response import RunListResponse
from algoliasearch.ingestion.models.run_response import RunResponse
from algoliasearch.ingestion.models.run_sort_keys import RunSortKeys
from algoliasearch.ingestion.models.run_status import RunStatus
from algoliasearch.ingestion.models.source import Source
from algoliasearch.ingestion.models.source_create import SourceCreate
from algoliasearch.ingestion.models.source_create_response import SourceCreateResponse
from algoliasearch.ingestion.models.source_search import SourceSearch
from algoliasearch.ingestion.models.source_sort_keys import SourceSortKeys
from algoliasearch.ingestion.models.source_type import SourceType
from algoliasearch.ingestion.models.source_update import SourceUpdate
from algoliasearch.ingestion.models.source_update_response import SourceUpdateResponse
from algoliasearch.ingestion.models.task import Task
from algoliasearch.ingestion.models.task_create import TaskCreate
from algoliasearch.ingestion.models.task_create_response import TaskCreateResponse
from algoliasearch.ingestion.models.task_search import TaskSearch
from algoliasearch.ingestion.models.task_sort_keys import TaskSortKeys
from algoliasearch.ingestion.models.task_update import TaskUpdate
from algoliasearch.ingestion.models.task_update_response import TaskUpdateResponse
from algoliasearch.ingestion.models.trigger_type import TriggerType


class IngestionClient:
    """The Algolia 'IngestionClient' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("eu" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = IngestionClient("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")
    _client_with_named_args = IngestionClient(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")

    See `IngestionClient.create_with_config` for advanced configuration.
    """

    _transporter: Transporter
    _config: IngestionConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: str = None,
        transporter: Optional[Transporter] = None,
        config: Optional[IngestionConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = transporter._config

        if config is None:
            config = IngestionConfig(app_id, api_key, region)
        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = Transporter(config)
        self._transporter = transporter

    def create_with_config(
        config: IngestionConfig, transporter: Optional[Transporter] = None
    ) -> Self:
        """Allows creating a client with a customized `IngestionConfig` and `Transporter`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (IngestionConfig): The config of the API client.
        transporter (Transporter): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = IngestionClient.create_with_config(config=IngestionConfig(...))
        _client_with_custom_config_and_transporter = IngestionClient.create_with_config(config=IngestionConfig(...), transporter=Transporter(...))
        """
        if transporter is None:
            transporter = Transporter(config)

        return IngestionClient(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

    async def __aenter__(self) -> None:
        return self

    async def __aexit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        await self.close()

    async def close(self) -> None:
        """Closes the underlying `transporter` of the API client."""
        return await self._transporter.close()

    async def create_authentication_with_http_info(
        self,
        authentication_create: AuthenticationCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create a authentication.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_create:  (required)
        :type authentication_create: AuthenticationCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if authentication_create is None:
            raise ValueError(
                "Parameter `authentication_create` is required when calling `create_authentication`."
            )

        _data = {}
        if authentication_create is not None:
            _data = authentication_create

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/authentications",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def create_authentication(
        self,
        authentication_create: AuthenticationCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> AuthenticationCreateResponse:
        """
        Create a authentication.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_create:  (required)
        :type authentication_create: AuthenticationCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'AuthenticationCreateResponse' result object.
        """
        return (
            await self.create_authentication_with_http_info(
                authentication_create, request_options
            )
        ).deserialize(AuthenticationCreateResponse)

    async def create_destination_with_http_info(
        self,
        destination_create: DestinationCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create a destination.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_create:  (required)
        :type destination_create: DestinationCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if destination_create is None:
            raise ValueError(
                "Parameter `destination_create` is required when calling `create_destination`."
            )

        _data = {}
        if destination_create is not None:
            _data = destination_create

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/destinations",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def create_destination(
        self,
        destination_create: DestinationCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DestinationCreateResponse:
        """
        Create a destination.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_create:  (required)
        :type destination_create: DestinationCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DestinationCreateResponse' result object.
        """
        return (
            await self.create_destination_with_http_info(
                destination_create, request_options
            )
        ).deserialize(DestinationCreateResponse)

    async def create_source_with_http_info(
        self,
        source_create: SourceCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create a source.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_create:  (required)
        :type source_create: SourceCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_create is None:
            raise ValueError(
                "Parameter `source_create` is required when calling `create_source`."
            )

        _data = {}
        if source_create is not None:
            _data = source_create

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/sources",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def create_source(
        self,
        source_create: SourceCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> SourceCreateResponse:
        """
        Create a source.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_create:  (required)
        :type source_create: SourceCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'SourceCreateResponse' result object.
        """
        return (
            await self.create_source_with_http_info(source_create, request_options)
        ).deserialize(SourceCreateResponse)

    async def create_task_with_http_info(
        self,
        task_create: TaskCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create a task.


        :param task_create:  (required)
        :type task_create: TaskCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_create is None:
            raise ValueError(
                "Parameter `task_create` is required when calling `create_task`."
            )

        _data = {}
        if task_create is not None:
            _data = task_create

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/tasks",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def create_task(
        self,
        task_create: TaskCreate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> TaskCreateResponse:
        """
        Create a task.


        :param task_create:  (required)
        :type task_create: TaskCreate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'TaskCreateResponse' result object.
        """
        return (
            await self.create_task_with_http_info(task_create, request_options)
        ).deserialize(TaskCreateResponse)

    async def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_delete_with_http_info(path, parameters, request_options)
        ).deserialize(object)

    async def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_get_with_http_info(path, parameters, request_options)
        ).deserialize(object)

    async def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_post_with_http_info(
                path, parameters, body, request_options
            )
        ).deserialize(object)

    async def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: List[Tuple[str, str]] = []

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters.append((_qpkey, _qpvalue))

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/1{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        return (
            await self.custom_put_with_http_info(
                path, parameters, body, request_options
            )
        ).deserialize(object)

    async def delete_authentication_with_http_info(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Soft delete the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if authentication_id is None:
            raise ValueError(
                "Parameter `authentication_id` is required when calling `delete_authentication`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/authentications/{authenticationID}".replace(
                "{authenticationID}", quote(str(authentication_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_authentication(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeleteResponse:
        """
        Soft delete the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeleteResponse' result object.
        """
        return (
            await self.delete_authentication_with_http_info(
                authentication_id, request_options
            )
        ).deserialize(DeleteResponse)

    async def delete_destination_with_http_info(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Soft delete the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if destination_id is None:
            raise ValueError(
                "Parameter `destination_id` is required when calling `delete_destination`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/destinations/{destinationID}".replace(
                "{destinationID}", quote(str(destination_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_destination(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeleteResponse:
        """
        Soft delete the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeleteResponse' result object.
        """
        return (
            await self.delete_destination_with_http_info(
                destination_id, request_options
            )
        ).deserialize(DeleteResponse)

    async def delete_source_with_http_info(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Soft delete the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_id is None:
            raise ValueError(
                "Parameter `source_id` is required when calling `delete_source`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/sources/{sourceID}".replace(
                "{sourceID}", quote(str(source_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_source(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeleteResponse:
        """
        Soft delete the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeleteResponse' result object.
        """
        return (
            await self.delete_source_with_http_info(source_id, request_options)
        ).deserialize(DeleteResponse)

    async def delete_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Soft delete the task of the given taskID.


        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `delete_task`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/tasks/{taskID}".replace("{taskID}", quote(str(task_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeleteResponse:
        """
        Soft delete the task of the given taskID.


        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeleteResponse' result object.
        """
        return (
            await self.delete_task_with_http_info(task_id, request_options)
        ).deserialize(DeleteResponse)

    async def disable_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Disable the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `disable_task`."
            )

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/1/tasks/{taskID}/disable".replace(
                "{taskID}", quote(str(task_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def disable_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> TaskUpdateResponse:
        """
        Disable the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'TaskUpdateResponse' result object.
        """
        return (
            await self.disable_task_with_http_info(task_id, request_options)
        ).deserialize(TaskUpdateResponse)

    async def enable_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Enable the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `enable_task`."
            )

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/1/tasks/{taskID}/enable".replace(
                "{taskID}", quote(str(task_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def enable_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> TaskUpdateResponse:
        """
        Enable the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'TaskUpdateResponse' result object.
        """
        return (
            await self.enable_task_with_http_info(task_id, request_options)
        ).deserialize(TaskUpdateResponse)

    async def get_authentication_with_http_info(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if authentication_id is None:
            raise ValueError(
                "Parameter `authentication_id` is required when calling `get_authentication`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/authentications/{authenticationID}".replace(
                "{authenticationID}", quote(str(authentication_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_authentication(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Authentication:
        """
        Get the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Authentication' result object.
        """
        return (
            await self.get_authentication_with_http_info(
                authentication_id, request_options
            )
        ).deserialize(Authentication)

    async def get_authentications_with_http_info(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[AuthenticationType]],
            Field(description="The type of the authentications to retrieve."),
        ] = None,
        platform: Annotated[
            Optional[List[PlatformWithNone]],
            Field(description="The platform of the authentications to retrieve."),
        ] = None,
        sort: Annotated[
            Optional[AuthenticationSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of authentications for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the authentications to retrieve.
        :type type: List[AuthenticationType]
        :param platform: The platform of the authentications to retrieve.
        :type platform: List[PlatformWithNone]
        :param sort: The key by which the list should be sorted.
        :type sort: AuthenticationSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if type is not None:
            _query_parameters.append(("type", type))
        if platform is not None:
            _query_parameters.append(("platform", platform))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/authentications",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_authentications(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[AuthenticationType]],
            Field(description="The type of the authentications to retrieve."),
        ] = None,
        platform: Annotated[
            Optional[List[PlatformWithNone]],
            Field(description="The platform of the authentications to retrieve."),
        ] = None,
        sort: Annotated[
            Optional[AuthenticationSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListAuthenticationsResponse:
        """
        Get a list of authentications for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the authentications to retrieve.
        :type type: List[AuthenticationType]
        :param platform: The platform of the authentications to retrieve.
        :type platform: List[PlatformWithNone]
        :param sort: The key by which the list should be sorted.
        :type sort: AuthenticationSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListAuthenticationsResponse' result object.
        """
        return (
            await self.get_authentications_with_http_info(
                items_per_page, page, type, platform, sort, order, request_options
            )
        ).deserialize(ListAuthenticationsResponse)

    async def get_destination_with_http_info(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if destination_id is None:
            raise ValueError(
                "Parameter `destination_id` is required when calling `get_destination`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/destinations/{destinationID}".replace(
                "{destinationID}", quote(str(destination_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_destination(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Destination:
        """
        Get the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Destination' result object.
        """
        return (
            await self.get_destination_with_http_info(destination_id, request_options)
        ).deserialize(Destination)

    async def get_destinations_with_http_info(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[DestinationType]],
            Field(description="The type of the destinations to retrive."),
        ] = None,
        authentication_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The authenticationIDs of the destinations to retrive."),
        ] = None,
        sort: Annotated[
            Optional[DestinationSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of destinations for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the destinations to retrive.
        :type type: List[DestinationType]
        :param authentication_id: The authenticationIDs of the destinations to retrive.
        :type authentication_id: List[str]
        :param sort: The key by which the list should be sorted.
        :type sort: DestinationSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if type is not None:
            _query_parameters.append(("type", type))
        if authentication_id is not None:
            _query_parameters.append(("authenticationID", authentication_id))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/destinations",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_destinations(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[DestinationType]],
            Field(description="The type of the destinations to retrive."),
        ] = None,
        authentication_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The authenticationIDs of the destinations to retrive."),
        ] = None,
        sort: Annotated[
            Optional[DestinationSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListDestinationsResponse:
        """
        Get a list of destinations for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the destinations to retrive.
        :type type: List[DestinationType]
        :param authentication_id: The authenticationIDs of the destinations to retrive.
        :type authentication_id: List[str]
        :param sort: The key by which the list should be sorted.
        :type sort: DestinationSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListDestinationsResponse' result object.
        """
        return (
            await self.get_destinations_with_http_info(
                items_per_page,
                page,
                type,
                authentication_id,
                sort,
                order,
                request_options,
            )
        ).deserialize(ListDestinationsResponse)

    async def get_docker_source_streams_with_http_info(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieve a stream listing for a given Singer specification compatible docker type source ID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_id is None:
            raise ValueError(
                "Parameter `source_id` is required when calling `get_docker_source_streams`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/sources/{sourceID}/discover".replace(
                "{sourceID}", quote(str(source_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_docker_source_streams(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DockerSourceStreams:
        """
        Retrieve a stream listing for a given Singer specification compatible docker type source ID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DockerSourceStreams' result object.
        """
        return (
            await self.get_docker_source_streams_with_http_info(
                source_id, request_options
            )
        ).deserialize(DockerSourceStreams)

    async def get_event_with_http_info(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        event_id: Annotated[StrictStr, Field(description="The event UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a single event for a specific runID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param event_id: The event UUID. (required)
        :type event_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if run_id is None:
            raise ValueError("Parameter `run_id` is required when calling `get_event`.")

        if event_id is None:
            raise ValueError(
                "Parameter `event_id` is required when calling `get_event`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/runs/{runID}/events/{eventID}".replace(
                "{runID}", quote(str(run_id), safe="")
            ).replace("{eventID}", quote(str(event_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_event(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        event_id: Annotated[StrictStr, Field(description="The event UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Event:
        """
        Get a single event for a specific runID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param event_id: The event UUID. (required)
        :type event_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Event' result object.
        """
        return (
            await self.get_event_with_http_info(run_id, event_id, request_options)
        ).deserialize(Event)

    async def get_events_with_http_info(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        status: Annotated[
            Optional[List[EventStatus]],
            Field(description="Filter the status of the events."),
        ] = None,
        type: Annotated[
            Optional[List[EventType]],
            Field(description="Filter the type of the events."),
        ] = None,
        sort: Annotated[
            Optional[EventSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        start_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The start date (in RFC3339 format) of the events fetching window. Defaults to 'now'-3 hours if omitted."
            ),
        ] = None,
        end_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The end date (in RFC3339 format) of the events fetching window. Defaults to 'now' days if omitted."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of events associated to the given runID, for the given query parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param status: Filter the status of the events.
        :type status: List[EventStatus]
        :param type: Filter the type of the events.
        :type type: List[EventType]
        :param sort: The key by which the list should be sorted.
        :type sort: EventSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param start_date: The start date (in RFC3339 format) of the events fetching window. Defaults to 'now'-3 hours if omitted.
        :type start_date: str
        :param end_date: The end date (in RFC3339 format) of the events fetching window. Defaults to 'now' days if omitted.
        :type end_date: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if run_id is None:
            raise ValueError(
                "Parameter `run_id` is required when calling `get_events`."
            )

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if status is not None:
            _query_parameters.append(("status", status))
        if type is not None:
            _query_parameters.append(("type", type))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/runs/{runID}/events".replace(
                "{runID}", quote(str(run_id), safe="")
            ),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_events(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        status: Annotated[
            Optional[List[EventStatus]],
            Field(description="Filter the status of the events."),
        ] = None,
        type: Annotated[
            Optional[List[EventType]],
            Field(description="Filter the type of the events."),
        ] = None,
        sort: Annotated[
            Optional[EventSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        start_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The start date (in RFC3339 format) of the events fetching window. Defaults to 'now'-3 hours if omitted."
            ),
        ] = None,
        end_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The end date (in RFC3339 format) of the events fetching window. Defaults to 'now' days if omitted."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListEventsResponse:
        """
        Get a list of events associated to the given runID, for the given query parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param status: Filter the status of the events.
        :type status: List[EventStatus]
        :param type: Filter the type of the events.
        :type type: List[EventType]
        :param sort: The key by which the list should be sorted.
        :type sort: EventSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param start_date: The start date (in RFC3339 format) of the events fetching window. Defaults to 'now'-3 hours if omitted.
        :type start_date: str
        :param end_date: The end date (in RFC3339 format) of the events fetching window. Defaults to 'now' days if omitted.
        :type end_date: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListEventsResponse' result object.
        """
        return (
            await self.get_events_with_http_info(
                run_id,
                items_per_page,
                page,
                status,
                type,
                sort,
                order,
                start_date,
                end_date,
                request_options,
            )
        ).deserialize(ListEventsResponse)

    async def get_run_with_http_info(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a single run for the given ID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if run_id is None:
            raise ValueError("Parameter `run_id` is required when calling `get_run`.")

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/runs/{runID}".replace("{runID}", quote(str(run_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_run(
        self,
        run_id: Annotated[StrictStr, Field(description="The run UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Run:
        """
        Get a single run for the given ID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param run_id: The run UUID. (required)
        :type run_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Run' result object.
        """
        return (await self.get_run_with_http_info(run_id, request_options)).deserialize(
            Run
        )

    async def get_runs_with_http_info(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        status: Annotated[
            Optional[List[RunStatus]],
            Field(description="Filter the status of the runs."),
        ] = None,
        task_id: Annotated[
            Optional[StrictStr], Field(description="Filter by taskID.")
        ] = None,
        sort: Annotated[
            Optional[RunSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        start_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The start date (in RFC3339 format) of the runs fetching window. Defaults to 'now'-7 days if omitted."
            ),
        ] = None,
        end_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now' days if omitted."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of runs for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param status: Filter the status of the runs.
        :type status: List[RunStatus]
        :param task_id: Filter by taskID.
        :type task_id: str
        :param sort: The key by which the list should be sorted.
        :type sort: RunSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param start_date: The start date (in RFC3339 format) of the runs fetching window. Defaults to 'now'-7 days if omitted.
        :type start_date: str
        :param end_date: The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now' days if omitted.
        :type end_date: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if status is not None:
            _query_parameters.append(("status", status))
        if task_id is not None:
            _query_parameters.append(("taskID", task_id))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))
        if start_date is not None:
            _query_parameters.append(("startDate", start_date))
        if end_date is not None:
            _query_parameters.append(("endDate", end_date))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/runs",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_runs(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        status: Annotated[
            Optional[List[RunStatus]],
            Field(description="Filter the status of the runs."),
        ] = None,
        task_id: Annotated[
            Optional[StrictStr], Field(description="Filter by taskID.")
        ] = None,
        sort: Annotated[
            Optional[RunSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        start_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The start date (in RFC3339 format) of the runs fetching window. Defaults to 'now'-7 days if omitted."
            ),
        ] = None,
        end_date: Annotated[
            Optional[StrictStr],
            Field(
                description="The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now' days if omitted."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RunListResponse:
        """
        Get a list of runs for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param status: Filter the status of the runs.
        :type status: List[RunStatus]
        :param task_id: Filter by taskID.
        :type task_id: str
        :param sort: The key by which the list should be sorted.
        :type sort: RunSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param start_date: The start date (in RFC3339 format) of the runs fetching window. Defaults to 'now'-7 days if omitted.
        :type start_date: str
        :param end_date: The end date (in RFC3339 format) of the runs fetching window. Defaults to 'now' days if omitted.
        :type end_date: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RunListResponse' result object.
        """
        return (
            await self.get_runs_with_http_info(
                items_per_page,
                page,
                status,
                task_id,
                sort,
                order,
                start_date,
                end_date,
                request_options,
            )
        ).deserialize(RunListResponse)

    async def get_source_with_http_info(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_id is None:
            raise ValueError(
                "Parameter `source_id` is required when calling `get_source`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/sources/{sourceID}".replace(
                "{sourceID}", quote(str(source_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_source(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Source:
        """
        Get the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Source' result object.
        """
        return (
            await self.get_source_with_http_info(source_id, request_options)
        ).deserialize(Source)

    async def get_sources_with_http_info(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[SourceType]],
            Field(description="The type of the sources to retrieve."),
        ] = None,
        authentication_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="The authenticationIDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication. "
            ),
        ] = None,
        sort: Annotated[
            Optional[SourceSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of sources for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the sources to retrieve.
        :type type: List[SourceType]
        :param authentication_id: The authenticationIDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication.
        :type authentication_id: List[str]
        :param sort: The key by which the list should be sorted.
        :type sort: SourceSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if type is not None:
            _query_parameters.append(("type", type))
        if authentication_id is not None:
            _query_parameters.append(("authenticationID", authentication_id))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/sources",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_sources(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        type: Annotated[
            Optional[List[SourceType]],
            Field(description="The type of the sources to retrieve."),
        ] = None,
        authentication_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="The authenticationIDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication. "
            ),
        ] = None,
        sort: Annotated[
            Optional[SourceSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListSourcesResponse:
        """
        Get a list of sources for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param type: The type of the sources to retrieve.
        :type type: List[SourceType]
        :param authentication_id: The authenticationIDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication.
        :type authentication_id: List[str]
        :param sort: The key by which the list should be sorted.
        :type sort: SourceSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListSourcesResponse' result object.
        """
        return (
            await self.get_sources_with_http_info(
                items_per_page,
                page,
                type,
                authentication_id,
                sort,
                order,
                request_options,
            )
        ).deserialize(ListSourcesResponse)

    async def get_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError("Parameter `task_id` is required when calling `get_task`.")

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/tasks/{taskID}".replace("{taskID}", quote(str(task_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> Task:
        """
        Get the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'Task' result object.
        """
        return (
            await self.get_task_with_http_info(task_id, request_options)
        ).deserialize(Task)

    async def get_tasks_with_http_info(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        action: Annotated[
            Optional[List[ActionType]],
            Field(description="The action of the tasks to retrieve."),
        ] = None,
        enabled: Annotated[
            Optional[StrictBool],
            Field(description="Whether the task is enabled or not."),
        ] = None,
        source_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The sourceIDs of the tasks to retrive."),
        ] = None,
        destination_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The destinationIDs of the tasks to retrive."),
        ] = None,
        trigger_type: Annotated[
            Optional[List[TriggerType]],
            Field(description="The trigger type of the task."),
        ] = None,
        sort: Annotated[
            Optional[TaskSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Get a list of tasks for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param action: The action of the tasks to retrieve.
        :type action: List[ActionType]
        :param enabled: Whether the task is enabled or not.
        :type enabled: bool
        :param source_id: The sourceIDs of the tasks to retrive.
        :type source_id: List[str]
        :param destination_id: The destinationIDs of the tasks to retrive.
        :type destination_id: List[str]
        :param trigger_type: The trigger type of the task.
        :type trigger_type: List[TriggerType]
        :param sort: The key by which the list should be sorted.
        :type sort: TaskSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: List[Tuple[str, str]] = []

        if items_per_page is not None:
            _query_parameters.append(("itemsPerPage", items_per_page))
        if page is not None:
            _query_parameters.append(("page", page))
        if action is not None:
            _query_parameters.append(("action", action))
        if enabled is not None:
            _query_parameters.append(("enabled", enabled))
        if source_id is not None:
            _query_parameters.append(("sourceID", source_id))
        if destination_id is not None:
            _query_parameters.append(("destinationID", destination_id))
        if trigger_type is not None:
            _query_parameters.append(("triggerType", trigger_type))
        if sort is not None:
            _query_parameters.append(("sort", sort))
        if order is not None:
            _query_parameters.append(("order", order))

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/tasks",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_tasks(
        self,
        items_per_page: Annotated[
            Optional[StrictInt],
            Field(description="The number of items per page to return."),
        ] = None,
        page: Annotated[
            Optional[StrictInt],
            Field(description="The page number to fetch, starting at 1."),
        ] = None,
        action: Annotated[
            Optional[List[ActionType]],
            Field(description="The action of the tasks to retrieve."),
        ] = None,
        enabled: Annotated[
            Optional[StrictBool],
            Field(description="Whether the task is enabled or not."),
        ] = None,
        source_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The sourceIDs of the tasks to retrive."),
        ] = None,
        destination_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The destinationIDs of the tasks to retrive."),
        ] = None,
        trigger_type: Annotated[
            Optional[List[TriggerType]],
            Field(description="The trigger type of the task."),
        ] = None,
        sort: Annotated[
            Optional[TaskSortKeys],
            Field(description="The key by which the list should be sorted."),
        ] = None,
        order: Annotated[
            Optional[OrderKeys], Field(description="The order of the returned list.")
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListTasksResponse:
        """
        Get a list of tasks for the given query parameters, with pagination details.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param items_per_page: The number of items per page to return.
        :type items_per_page: int
        :param page: The page number to fetch, starting at 1.
        :type page: int
        :param action: The action of the tasks to retrieve.
        :type action: List[ActionType]
        :param enabled: Whether the task is enabled or not.
        :type enabled: bool
        :param source_id: The sourceIDs of the tasks to retrive.
        :type source_id: List[str]
        :param destination_id: The destinationIDs of the tasks to retrive.
        :type destination_id: List[str]
        :param trigger_type: The trigger type of the task.
        :type trigger_type: List[TriggerType]
        :param sort: The key by which the list should be sorted.
        :type sort: TaskSortKeys
        :param order: The order of the returned list.
        :type order: OrderKeys
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListTasksResponse' result object.
        """
        return (
            await self.get_tasks_with_http_info(
                items_per_page,
                page,
                action,
                enabled,
                source_id,
                destination_id,
                trigger_type,
                sort,
                order,
                request_options,
            )
        ).deserialize(ListTasksResponse)

    async def run_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Run the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError("Parameter `task_id` is required when calling `run_task`.")

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/tasks/{taskID}/run".replace(
                "{taskID}", quote(str(task_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def run_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RunResponse:
        """
        Run the task of the given taskID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_id: The task UUID. (required)
        :type task_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RunResponse' result object.
        """
        return (
            await self.run_task_with_http_info(task_id, request_options)
        ).deserialize(RunResponse)

    async def search_authentications_with_http_info(
        self,
        authentication_search: AuthenticationSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Search among authentications with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_search: (required)
        :type authentication_search: AuthenticationSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if authentication_search is None:
            raise ValueError(
                "Parameter `authentication_search` is required when calling `search_authentications`."
            )

        _data = {}
        if authentication_search is not None:
            _data = authentication_search

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/authentications/search",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def search_authentications(
        self,
        authentication_search: AuthenticationSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> List[Authentication]:
        """
        Search among authentications with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_search: (required)
        :type authentication_search: AuthenticationSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[Authentication]' result object.
        """
        return (
            await self.search_authentications_with_http_info(
                authentication_search, request_options
            )
        ).deserialize(List[Authentication])

    async def search_destinations_with_http_info(
        self,
        destination_search: DestinationSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Search among destinations with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_search: (required)
        :type destination_search: DestinationSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if destination_search is None:
            raise ValueError(
                "Parameter `destination_search` is required when calling `search_destinations`."
            )

        _data = {}
        if destination_search is not None:
            _data = destination_search

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/destinations/search",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def search_destinations(
        self,
        destination_search: DestinationSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> List[Destination]:
        """
        Search among destinations with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_search: (required)
        :type destination_search: DestinationSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[Destination]' result object.
        """
        return (
            await self.search_destinations_with_http_info(
                destination_search, request_options
            )
        ).deserialize(List[Destination])

    async def search_sources_with_http_info(
        self,
        source_search: SourceSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Search among sources with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_search: (required)
        :type source_search: SourceSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_search is None:
            raise ValueError(
                "Parameter `source_search` is required when calling `search_sources`."
            )

        _data = {}
        if source_search is not None:
            _data = source_search

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/sources/search",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def search_sources(
        self,
        source_search: SourceSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> List[Source]:
        """
        Search among sources with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_search: (required)
        :type source_search: SourceSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[Source]' result object.
        """
        return (
            await self.search_sources_with_http_info(source_search, request_options)
        ).deserialize(List[Source])

    async def search_tasks_with_http_info(
        self,
        task_search: TaskSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Search among tasks with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_search: (required)
        :type task_search: TaskSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_search is None:
            raise ValueError(
                "Parameter `task_search` is required when calling `search_tasks`."
            )

        _data = {}
        if task_search is not None:
            _data = task_search

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/tasks/search",
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def search_tasks(
        self,
        task_search: TaskSearch,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> List[Task]:
        """
        Search among tasks with a defined set of parameters.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param task_search: (required)
        :type task_search: TaskSearch
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[Task]' result object.
        """
        return (
            await self.search_tasks_with_http_info(task_search, request_options)
        ).deserialize(List[Task])

    async def trigger_docker_source_discover_with_http_info(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Trigger a stream listing request for a Singer specification compatible docker type source.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_id is None:
            raise ValueError(
                "Parameter `source_id` is required when calling `trigger_docker_source_discover`."
            )

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/sources/{sourceID}/discover".replace(
                "{sourceID}", quote(str(source_id), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def trigger_docker_source_discover(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DockerSourceDiscover:
        """
        Trigger a stream listing request for a Singer specification compatible docker type source.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DockerSourceDiscover' result object.
        """
        return (
            await self.trigger_docker_source_discover_with_http_info(
                source_id, request_options
            )
        ).deserialize(DockerSourceDiscover)

    async def update_authentication_with_http_info(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        authentication_update: AuthenticationUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Update the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param authentication_update: (required)
        :type authentication_update: AuthenticationUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if authentication_id is None:
            raise ValueError(
                "Parameter `authentication_id` is required when calling `update_authentication`."
            )

        if authentication_update is None:
            raise ValueError(
                "Parameter `authentication_update` is required when calling `update_authentication`."
            )

        _data = {}
        if authentication_update is not None:
            _data = authentication_update

        return await self._transporter.request(
            verb=Verb.PATCH,
            path="/1/authentications/{authenticationID}".replace(
                "{authenticationID}", quote(str(authentication_id), safe="")
            ),
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def update_authentication(
        self,
        authentication_id: Annotated[
            StrictStr, Field(description="The authentication UUID.")
        ],
        authentication_update: AuthenticationUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> AuthenticationUpdateResponse:
        """
        Update the authentication of the given authenticationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param authentication_id: The authentication UUID. (required)
        :type authentication_id: str
        :param authentication_update: (required)
        :type authentication_update: AuthenticationUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'AuthenticationUpdateResponse' result object.
        """
        return (
            await self.update_authentication_with_http_info(
                authentication_id, authentication_update, request_options
            )
        ).deserialize(AuthenticationUpdateResponse)

    async def update_destination_with_http_info(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        destination_update: DestinationUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Update the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param destination_update: (required)
        :type destination_update: DestinationUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if destination_id is None:
            raise ValueError(
                "Parameter `destination_id` is required when calling `update_destination`."
            )

        if destination_update is None:
            raise ValueError(
                "Parameter `destination_update` is required when calling `update_destination`."
            )

        _data = {}
        if destination_update is not None:
            _data = destination_update

        return await self._transporter.request(
            verb=Verb.PATCH,
            path="/1/destinations/{destinationID}".replace(
                "{destinationID}", quote(str(destination_id), safe="")
            ),
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def update_destination(
        self,
        destination_id: Annotated[
            StrictStr, Field(description="The destination UUID.")
        ],
        destination_update: DestinationUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DestinationUpdateResponse:
        """
        Update the destination of the given destinationID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param destination_id: The destination UUID. (required)
        :type destination_id: str
        :param destination_update: (required)
        :type destination_update: DestinationUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DestinationUpdateResponse' result object.
        """
        return (
            await self.update_destination_with_http_info(
                destination_id, destination_update, request_options
            )
        ).deserialize(DestinationUpdateResponse)

    async def update_source_with_http_info(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        source_update: SourceUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Update the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param source_update: (required)
        :type source_update: SourceUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if source_id is None:
            raise ValueError(
                "Parameter `source_id` is required when calling `update_source`."
            )

        if source_update is None:
            raise ValueError(
                "Parameter `source_update` is required when calling `update_source`."
            )

        _data = {}
        if source_update is not None:
            _data = source_update

        return await self._transporter.request(
            verb=Verb.PATCH,
            path="/1/sources/{sourceID}".replace(
                "{sourceID}", quote(str(source_id), safe="")
            ),
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def update_source(
        self,
        source_id: Annotated[StrictStr, Field(description="The source UUID.")],
        source_update: SourceUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> SourceUpdateResponse:
        """
        Update the source of the given sourceID.

        Required API Key ACLs:
          - addObject
                  - deleteIndex
                  - editSettings

        :param source_id: The source UUID. (required)
        :type source_id: str
        :param source_update: (required)
        :type source_update: SourceUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'SourceUpdateResponse' result object.
        """
        return (
            await self.update_source_with_http_info(
                source_id, source_update, request_options
            )
        ).deserialize(SourceUpdateResponse)

    async def update_task_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        task_update: TaskUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Update the task of the given taskID.


        :param task_id: The task UUID. (required)
        :type task_id: str
        :param task_update: (required)
        :type task_update: TaskUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `update_task`."
            )

        if task_update is None:
            raise ValueError(
                "Parameter `task_update` is required when calling `update_task`."
            )

        _data = {}
        if task_update is not None:
            _data = task_update

        return await self._transporter.request(
            verb=Verb.PATCH,
            path="/1/tasks/{taskID}".replace("{taskID}", quote(str(task_id), safe="")),
            request_options=self._request_options.merge(
                data=dumps(bodySerializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def update_task(
        self,
        task_id: Annotated[StrictStr, Field(description="The task UUID.")],
        task_update: TaskUpdate,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> TaskUpdateResponse:
        """
        Update the task of the given taskID.


        :param task_id: The task UUID. (required)
        :type task_id: str
        :param task_update: (required)
        :type task_update: TaskUpdate
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'TaskUpdateResponse' result object.
        """
        return (
            await self.update_task_with_http_info(task_id, task_update, request_options)
        ).deserialize(TaskUpdateResponse)
