# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, List, Optional, Self

from pydantic import BaseModel, Field, StrictStr

from algoliasearch.ingestion.models.big_commerce_channel import BigCommerceChannel
from algoliasearch.ingestion.models.big_commerce_metafield import BigCommerceMetafield


class SourceBigCommerce(BaseModel):
    """
    SourceBigCommerce
    """

    store_hash: Optional[StrictStr] = Field(
        default=None,
        description="The store hash identifying the store the shopper is signing in to.",
        alias="storeHash",
    )
    channel: Optional[BigCommerceChannel] = None
    custom_fields: Optional[List[StrictStr]] = Field(default=None, alias="customFields")
    product_metafields: Optional[List[BigCommerceMetafield]] = Field(
        default=None, alias="productMetafields"
    )
    variant_metafields: Optional[List[BigCommerceMetafield]] = Field(
        default=None, alias="variantMetafields"
    )

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SourceBigCommerce from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of
        # channel
        if self.channel:
            _dict["channel"] = self.channel.to_dict()
        # override the default output from pydantic by calling `to_dict()` of
        # each item in product_metafields (list)
        _items = []
        if self.product_metafields:
            for _item in self.product_metafields:
                if _item:
                    _items.append(_item.to_dict())
            _dict["productMetafields"] = _items
        # override the default output from pydantic by calling `to_dict()` of
        # each item in variant_metafields (list)
        _items = []
        if self.variant_metafields:
            for _item in self.variant_metafields:
                if _item:
                    _items.append(_item.to_dict())
            _dict["variantMetafields"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SourceBigCommerce from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "storeHash": obj.get("storeHash"),
                "channel": BigCommerceChannel.from_dict(obj.get("channel"))
                if obj.get("channel") is not None
                else None,
                "customFields": obj.get("customFields"),
                "productMetafields": [
                    BigCommerceMetafield.from_dict(_item)
                    for _item in obj.get("productMetafields")
                ]
                if obj.get("productMetafields") is not None
                else None,
                "variantMetafields": [
                    BigCommerceMetafield.from_dict(_item)
                    for _item in obj.get("variantMetafields")
                ]
                if obj.get("variantMetafields") is not None
                else None,
            }
        )
        return _obj
