# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, Optional, Self

from pydantic import BaseModel, Field, StrictBool, StrictStr

from algoliasearch.monitoring.models.region import Region
from algoliasearch.monitoring.models.server_status import ServerStatus
from algoliasearch.monitoring.models.type import Type


class Server(BaseModel):
    """
    Server
    """

    name: Optional[StrictStr] = Field(default=None, description="Server name.")
    region: Optional[Region] = None
    is_slave: Optional[StrictBool] = Field(
        default=False,
        description="Included to support legacy applications. Do not rely on this attribute being present in the response. Use `is_replica` instead. ",
    )
    is_replica: Optional[StrictBool] = Field(
        default=False,
        description="Indicates whether this server is a replica of another server.",
    )
    cluster: Optional[StrictStr] = Field(
        default=None, description="Name of the cluster to which this server belongs."
    )
    status: Optional[ServerStatus] = None
    type: Optional[Type] = None

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Server from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Server from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "region": obj.get("region"),
                "is_slave": obj.get("is_slave")
                if obj.get("is_slave") is not None
                else False,
                "is_replica": obj.get("is_replica")
                if obj.get("is_replica") is not None
                else False,
                "cluster": obj.get("cluster"),
                "status": obj.get("status"),
                "type": obj.get("type"),
            }
        )
        return _obj
