# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, Optional, Self

from pydantic import BaseModel, Field, StrictInt, StrictStr

from algoliasearch.query_suggestions.models.log_level import LogLevel


class GetLogFile200Response(BaseModel):
    """
    GetLogFile200Response
    """

    timestamp: Optional[StrictStr] = Field(
        default=None,
        description="Timestamp in [ISO-8601](https://wikipedia.org/wiki/ISO_8601) format.",
    )
    level: Optional[LogLevel] = None
    message: Optional[StrictStr] = Field(
        default=None, description="Details about this log entry."
    )
    context_level: Optional[StrictInt] = Field(
        default=None,
        description="Level indicating the position of a suggestion in a hierarchy of records.   For example, a `contextLevel` of 1 indicates that this suggestion belongs to a previous suggestion with `contextLevel` 0. ",
        alias="contextLevel",
    )

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of GetLogFile200Response from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of GetLogFile200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "timestamp": obj.get("timestamp"),
                "level": obj.get("level"),
                "message": obj.get("message"),
                "contextLevel": obj.get("contextLevel"),
            }
        )
        return _obj
