# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, Optional, Self

from pydantic import BaseModel, Field

from algoliasearch.recommend.models.automatic_facet_filters import AutomaticFacetFilters
from algoliasearch.recommend.models.consequence_query import ConsequenceQuery
from algoliasearch.recommend.models.rendering_content import RenderingContent


class Params(BaseModel):
    """
    Additional search parameters.
    """

    query: Optional[ConsequenceQuery] = None
    automatic_facet_filters: Optional[AutomaticFacetFilters] = Field(
        default=None, alias="automaticFacetFilters"
    )
    automatic_optional_facet_filters: Optional[AutomaticFacetFilters] = Field(
        default=None, alias="automaticOptionalFacetFilters"
    )
    rendering_content: Optional[RenderingContent] = Field(
        default=None, alias="renderingContent"
    )

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Params from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of
        # query
        if self.query:
            _dict["query"] = self.query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of
        # automatic_facet_filters
        if self.automatic_facet_filters:
            _dict["automaticFacetFilters"] = self.automatic_facet_filters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of
        # automatic_optional_facet_filters
        if self.automatic_optional_facet_filters:
            _dict[
                "automaticOptionalFacetFilters"
            ] = self.automatic_optional_facet_filters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of
        # rendering_content
        if self.rendering_content:
            _dict["renderingContent"] = self.rendering_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Params from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "query": ConsequenceQuery.from_dict(obj.get("query"))
                if obj.get("query") is not None
                else None,
                "automaticFacetFilters": AutomaticFacetFilters.from_dict(
                    obj.get("automaticFacetFilters")
                )
                if obj.get("automaticFacetFilters") is not None
                else None,
                "automaticOptionalFacetFilters": AutomaticFacetFilters.from_dict(
                    obj.get("automaticOptionalFacetFilters")
                )
                if obj.get("automaticOptionalFacetFilters") is not None
                else None,
                "renderingContent": RenderingContent.from_dict(
                    obj.get("renderingContent")
                )
                if obj.get("renderingContent") is not None
                else None,
            }
        )
        return _obj
