# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, List, Optional, Self

from pydantic import BaseModel, Field, StrictBool, StrictStr

from algoliasearch.recommend.models.condition import Condition
from algoliasearch.recommend.models.consequence import Consequence
from algoliasearch.recommend.models.rule_response_metadata import RuleResponseMetadata


class RuleResponse(BaseModel):
    """
    Rule object.
    """

    metadata: Optional[RuleResponseMetadata] = Field(default=None, alias="_metadata")
    object_id: StrictStr = Field(
        description="Unique identifier for a rule object.", alias="objectID"
    )
    conditions: Optional[List[Condition]] = Field(
        default=None,
        description="[Conditions](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/#conditions) required to activate a rule. You can use up to 25 conditions per rule. ",
    )
    consequence: Optional[Consequence] = None
    description: Optional[StrictStr] = Field(
        default=None,
        description="Description of the rule's purpose. This can be helpful for display in the Algolia dashboard.",
    )
    enabled: Optional[StrictBool] = Field(
        default=True,
        description="Indicates whether to enable the rule. If it isn't enabled, it isn't applied at query time.",
    )

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RuleResponse from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of
        # metadata
        if self.metadata:
            _dict["_metadata"] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of
        # each item in conditions (list)
        _items = []
        if self.conditions:
            for _item in self.conditions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["conditions"] = _items
        # override the default output from pydantic by calling `to_dict()` of
        # consequence
        if self.consequence:
            _dict["consequence"] = self.consequence.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of RuleResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "_metadata": RuleResponseMetadata.from_dict(obj.get("_metadata"))
                if obj.get("_metadata") is not None
                else None,
                "objectID": obj.get("objectID"),
                "conditions": [
                    Condition.from_dict(_item) for _item in obj.get("conditions")
                ]
                if obj.get("conditions") is not None
                else None,
                "consequence": Consequence.from_dict(obj.get("consequence"))
                if obj.get("consequence") is not None
                else None,
                "description": obj.get("description"),
                "enabled": obj.get("enabled")
                if obj.get("enabled") is not None
                else True,
            }
        )
        return _obj
