# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""
from __future__ import annotations

from json import loads
from typing import Any, Dict, List, Optional, Self

from pydantic import BaseModel, Field, StrictBool, StrictInt

from algoliasearch.search.models.facet_hits import FacetHits


class SearchForFacetValuesResponse(BaseModel):
    """
    SearchForFacetValuesResponse
    """

    facet_hits: List[FacetHits] = Field(alias="facetHits")
    exhaustive_facets_count: StrictBool = Field(
        description="See the `facetsCount` field of the `exhaustive` object in the response.",
        alias="exhaustiveFacetsCount",
    )
    processing_time_ms: Optional[StrictInt] = Field(
        default=None,
        description="Time the server took to process the request, in milliseconds.",
        alias="processingTimeMS",
    )

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SearchForFacetValuesResponse from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of
        # each item in facet_hits (list)
        _items = []
        if self.facet_hits:
            for _item in self.facet_hits:
                if _item:
                    _items.append(_item.to_dict())
            _dict["facetHits"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SearchForFacetValuesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "facetHits": [
                    FacetHits.from_dict(_item) for _item in obj.get("facetHits")
                ]
                if obj.get("facetHits") is not None
                else None,
                "exhaustiveFacetsCount": obj.get("exhaustiveFacetsCount"),
                "processingTimeMS": obj.get("processingTimeMS"),
            }
        )
        return _obj
