from setuptools import setup

setup(
    name="chivel",
    version="0.6.0",
    description="For easily interfacing with the screen, just as a human would.",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    # long_description="Chivel is a Python module that allows you to interact with the screen in a way that mimics human behavior. It provides functions for recording and playing back mouse and keyboard actions, making it useful for automation tasks.",
    author="Mitchell Talyat",
    packages=["chivel"],
    package_dir={"chivel": "chivel"},
    package_data={"chivel": [
        "chivel.pyd", 
        "chivel.pyi",
        "archive.dll",
        "bz2.dll",
        "gif.dll",
        "jpeg62.dll",
        "leptonica-1.85.0.dll",
        "libcrypto-3-x64.dll",
        "libcurl.dll",
        "liblzma.dll",
        "libpng16.dll",
        "libsharpyuv.dll",
        "libssl-3-x64.dll",
        "libwebp.dll",
        "libwebpdecoder.dll",
        "libwebpdemux.dll",
        "libwebpmux.dll",
        "libxml2.dll",
        "lz4.dll",
        "opencv_world4110.dll",
        "openjp2.dll",
        "tesseract55.dll",
        "tiff.dll",
        "turbojpeg.dll",
        "zlib1.dll",
        "zstd.dll",
        "tessdata/*"
    ]},
    include_package_data=True,
)