# 📂 Organizador de Arquivos

## 🌟 Introdução
O **Organizador de Arquivos** é um assistente mágico em Python que coloca ordem na sua bagunça digital! ✨
- 🗂️ Classifica arquivos por extensão
- 🎯 Cria pastas automaticamente
- 🧹 Remove duplicatas

## ⚙️ Instalação

### 📋 Pré-requisitos
- 🐍 Python instalado ([Baixe aqui](https://www.python.org/downloads/))

### 📥 Download
1. Baixe o `file_organizer.py`
2. Salve onde preferir!

## 🚀 Como Usar

1. 💻 Abra seu terminal favorito
```bash
python file_organizer.py
```

2. 📁 Digite o caminho da pasta que deseja organizar

3. ✨ Pronto! O script vai:
   - 📊 Classificar seus arquivos
   - 📂 Criar pastas organizadas
   - 🧹 Limpar duplicatas

## 🛠️ Referência API

### 📚 Classe FileOrganizer

#### 🎯 Métodos Principais
- 🔧 `__init__(directory)`
  - Inicia o organizador
  - 📂 Define diretório alvo

- 📊 `classify_files()`
  - 🔍 Analisa tipos de arquivo
  - 📝 Prepara classificação

- 📁 `create_folders_and_move()`
  - 🏗️ Cria estrutura de pastas
  - 🚀 Move arquivos
  
- 🧹 `remove_duplicates()`
  - 🔍 Detecta arquivos iguais
  - 🗑️ Remove duplicatas

## 👥 Como Contribuir

### 🌟 Passos para Contribuição
1. 🔄 Fork o projeto
2. 🌿 Crie sua branch:
```bash
git checkout -b minha-contribuicao
```

3. ✨ Faça suas alterações e commit:
```bash
git commit -m "✨ Adiciona novo recurso incrível"
```

4. 📤 Push para sua branch:
```bash
git push origin minha-contribuicao
```

5. 🎉 Abra um PR!

## 📜 Licença
MIT License ⚖️ - [Veja detalhes](LICENSE)

---
### 🌟 Recursos Especiais
- 🚀 Organização automática
- 🧹 Limpeza inteligente
- 📊 Classificação eficiente
- 🔄 Processo automatizado

---
💪 **Desenvolvido com ❤️ para organizar sua vida digital** ✨
