# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: google/protobuf/any.proto, google/protobuf/api.proto, google/protobuf/descriptor.proto, google/protobuf/duration.proto, google/protobuf/empty.proto, google/protobuf/field_mask.proto, google/protobuf/source_context.proto, google/protobuf/struct.proto, google/protobuf/timestamp.proto, google/protobuf/type.proto, google/protobuf/wrappers.proto
# plugin: python-betterproto2
# This file has been @generated

__all__ = (
    "Any",
    "Api",
    "BoolValue",
    "BytesValue",
    "DescriptorProto",
    "DescriptorProtoExtensionRange",
    "DescriptorProtoReservedRange",
    "DoubleValue",
    "Duration",
    "Edition",
    "Empty",
    "Enum",
    "EnumDescriptorProto",
    "EnumDescriptorProtoEnumReservedRange",
    "EnumOptions",
    "EnumValue",
    "EnumValueDescriptorProto",
    "EnumValueOptions",
    "ExtensionRangeOptions",
    "ExtensionRangeOptionsDeclaration",
    "ExtensionRangeOptionsVerificationState",
    "FeatureSet",
    "FeatureSetDefaults",
    "FeatureSetDefaultsFeatureSetEditionDefault",
    "FeatureSetEnforceNamingStyle",
    "FeatureSetEnumType",
    "FeatureSetFieldPresence",
    "FeatureSetJsonFormat",
    "FeatureSetMessageEncoding",
    "FeatureSetRepeatedFieldEncoding",
    "FeatureSetUtf8Validation",
    "FeatureSetVisibilityFeature",
    "FeatureSetVisibilityFeatureDefaultSymbolVisibility",
    "Field",
    "FieldCardinality",
    "FieldDescriptorProto",
    "FieldDescriptorProtoLabel",
    "FieldDescriptorProtoType",
    "FieldKind",
    "FieldMask",
    "FieldOptions",
    "FieldOptionsCType",
    "FieldOptionsEditionDefault",
    "FieldOptionsFeatureSupport",
    "FieldOptionsJsType",
    "FieldOptionsOptionRetention",
    "FieldOptionsOptionTargetType",
    "FileDescriptorProto",
    "FileDescriptorSet",
    "FileOptions",
    "FileOptionsOptimizeMode",
    "FloatValue",
    "GeneratedCodeInfo",
    "GeneratedCodeInfoAnnotation",
    "GeneratedCodeInfoAnnotationSemantic",
    "Int32Value",
    "Int64Value",
    "ListValue",
    "MessageOptions",
    "Method",
    "MethodDescriptorProto",
    "MethodOptions",
    "MethodOptionsIdempotencyLevel",
    "Mixin",
    "NullValue",
    "OneofDescriptorProto",
    "OneofOptions",
    "Option",
    "ServiceDescriptorProto",
    "ServiceOptions",
    "SourceCodeInfo",
    "SourceCodeInfoLocation",
    "SourceContext",
    "StringValue",
    "Struct",
    "SymbolVisibility",
    "Syntax",
    "Timestamp",
    "Type",
    "UInt32Value",
    "UInt64Value",
    "UninterpretedOption",
    "UninterpretedOptionNamePart",
    "Value",
)

import datetime
import re
import typing
import warnings
from dataclasses import dataclass

import betterproto2
import dateutil.parser
from google.protobuf.descriptor import Descriptor, EnumDescriptor

from ...google_proto_descriptor_pool import default_google_proto_descriptor_pool
from ...message_pool import default_message_pool

_COMPILER_VERSION = "0.9.0"
betterproto2.check_compiler_version(_COMPILER_VERSION)


class Edition(betterproto2.Enum):
    """
    The full set of known editions.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name["Edition"]

    UNKNOWN = 0
    """
    A placeholder for an unknown edition value.
    """

    LEGACY = 900
    """
    A placeholder edition for specifying default behaviors *before* a feature
    was first introduced.  This is effectively an "infinite past".
    """

    PROTO2 = 998
    """
    Legacy syntax "editions".  These pre-date editions, but behave much like
    distinct editions.  These can't be used to specify the edition of proto
    files, but feature definitions must supply proto2/proto3 defaults for
    backwards compatibility.
    """

    PROTO3 = 999

    _2023 = 1000
    """
    Editions that have been released.  The specific values are arbitrary and
    should not be depended on, but they will always be time-ordered for easy
    comparison.
    """

    _2024 = 1001

    _1_TEST_ONLY = 1
    """
    Placeholder editions for testing feature resolution.  These should not be
    used or relied on outside of tests.
    """

    _2_TEST_ONLY = 2

    _99997_TEST_ONLY = 99997

    _99998_TEST_ONLY = 99998

    _99999_TEST_ONLY = 99999

    MAX = 2147483647
    """
    Placeholder for specifying unbounded edition support.  This should only
    ever be used by plugins that can expect to never require any changes to
    support a new edition.
    """

    @classmethod
    def betterproto_value_to_renamed_proto_names(cls) -> dict[int, str]:
        return {
            0: "EDITION_UNKNOWN",
            900: "EDITION_LEGACY",
            998: "EDITION_PROTO2",
            999: "EDITION_PROTO3",
            1000: "EDITION_2023",
            1001: "EDITION_2024",
            1: "EDITION_1_TEST_ONLY",
            2: "EDITION_2_TEST_ONLY",
            99997: "EDITION_99997_TEST_ONLY",
            99998: "EDITION_99998_TEST_ONLY",
            99999: "EDITION_99999_TEST_ONLY",
            2147483647: "EDITION_MAX",
        }

    @classmethod
    def betterproto_renamed_proto_names_to_value(cls) -> dict[str, int]:
        return {
            "EDITION_UNKNOWN": 0,
            "EDITION_LEGACY": 900,
            "EDITION_PROTO2": 998,
            "EDITION_PROTO3": 999,
            "EDITION_2023": 1000,
            "EDITION_2024": 1001,
            "EDITION_1_TEST_ONLY": 1,
            "EDITION_2_TEST_ONLY": 2,
            "EDITION_99997_TEST_ONLY": 99997,
            "EDITION_99998_TEST_ONLY": 99998,
            "EDITION_99999_TEST_ONLY": 99999,
            "EDITION_MAX": 2147483647,
        }


class ExtensionRangeOptionsVerificationState(betterproto2.Enum):
    """
    The verification state of the extension range.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "ExtensionRangeOptions.VerificationState"
        ]

    DECLARATION = 0
    """
    All the extensions of the range must be declared.
    """

    UNVERIFIED = 1


class FeatureSetEnforceNamingStyle(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.EnforceNamingStyle"
        ]

    ENFORCE_NAMING_STYLE_UNKNOWN = 0

    STYLE2024 = 1

    STYLE_LEGACY = 2


class FeatureSetEnumType(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.EnumType"
        ]

    ENUM_TYPE_UNKNOWN = 0

    OPEN = 1

    CLOSED = 2


class FeatureSetFieldPresence(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.FieldPresence"
        ]

    FIELD_PRESENCE_UNKNOWN = 0

    EXPLICIT = 1

    IMPLICIT = 2

    LEGACY_REQUIRED = 3


class FeatureSetJsonFormat(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.JsonFormat"
        ]

    JSON_FORMAT_UNKNOWN = 0

    ALLOW = 1

    LEGACY_BEST_EFFORT = 2


class FeatureSetMessageEncoding(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.MessageEncoding"
        ]

    MESSAGE_ENCODING_UNKNOWN = 0

    LENGTH_PREFIXED = 1

    DELIMITED = 2


class FeatureSetRepeatedFieldEncoding(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.RepeatedFieldEncoding"
        ]

    REPEATED_FIELD_ENCODING_UNKNOWN = 0

    PACKED = 1

    EXPANDED = 2


class FeatureSetUtf8Validation(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.Utf8Validation"
        ]

    UTF8_VALIDATION_UNKNOWN = 0

    VERIFY = 2

    NONE = 3


class FeatureSetVisibilityFeatureDefaultSymbolVisibility(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FeatureSet.VisibilityFeature.DefaultSymbolVisibility"
        ]

    DEFAULT_SYMBOL_VISIBILITY_UNKNOWN = 0

    EXPORT_ALL = 1
    """
    Default pre-EDITION_2024, all UNSET visibility are export.
    """

    EXPORT_TOP_LEVEL = 2
    """
    All top-level symbols default to export, nested default to local.
    """

    LOCAL_ALL = 3
    """
    All symbols default to local.
    """

    STRICT = 4
    """
    All symbols local by default. Nested types cannot be exported.
    With special case caveat for message { enum {} reserved 1 to max; }
    This is the recommended setting for new protos.
    """


class FieldCardinality(betterproto2.Enum):
    """
    Whether a field is optional, required, or repeated.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.enum_types_by_name[
            "Field.Cardinality"
        ]

    UNKNOWN = 0
    """
    For fields with unknown cardinality.
    """

    OPTIONAL = 1
    """
    For optional fields.
    """

    REQUIRED = 2
    """
    For required fields. Proto2 syntax only.
    """

    REPEATED = 3
    """
    For repeated fields.
    """

    @classmethod
    def betterproto_value_to_renamed_proto_names(cls) -> dict[int, str]:
        return {
            0: "CARDINALITY_UNKNOWN",
            1: "CARDINALITY_OPTIONAL",
            2: "CARDINALITY_REQUIRED",
            3: "CARDINALITY_REPEATED",
        }

    @classmethod
    def betterproto_renamed_proto_names_to_value(cls) -> dict[str, int]:
        return {
            "CARDINALITY_UNKNOWN": 0,
            "CARDINALITY_OPTIONAL": 1,
            "CARDINALITY_REQUIRED": 2,
            "CARDINALITY_REPEATED": 3,
        }


class FieldKind(betterproto2.Enum):
    """
    Basic field types.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.enum_types_by_name["Field.Kind"]

    TYPE_UNKNOWN = 0
    """
    Field type unknown.
    """

    TYPE_DOUBLE = 1
    """
    Field type double.
    """

    TYPE_FLOAT = 2
    """
    Field type float.
    """

    TYPE_INT64 = 3
    """
    Field type int64.
    """

    TYPE_UINT64 = 4
    """
    Field type uint64.
    """

    TYPE_INT32 = 5
    """
    Field type int32.
    """

    TYPE_FIXED64 = 6
    """
    Field type fixed64.
    """

    TYPE_FIXED32 = 7
    """
    Field type fixed32.
    """

    TYPE_BOOL = 8
    """
    Field type bool.
    """

    TYPE_STRING = 9
    """
    Field type string.
    """

    TYPE_GROUP = 10
    """
    Field type group. Proto2 syntax only, and deprecated.
    """

    TYPE_MESSAGE = 11
    """
    Field type message.
    """

    TYPE_BYTES = 12
    """
    Field type bytes.
    """

    TYPE_UINT32 = 13
    """
    Field type uint32.
    """

    TYPE_ENUM = 14
    """
    Field type enum.
    """

    TYPE_SFIXED32 = 15
    """
    Field type sfixed32.
    """

    TYPE_SFIXED64 = 16
    """
    Field type sfixed64.
    """

    TYPE_SINT32 = 17
    """
    Field type sint32.
    """

    TYPE_SINT64 = 18
    """
    Field type sint64.
    """


class FieldDescriptorProtoLabel(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldDescriptorProto.Label"
        ]

    OPTIONAL = 1
    """
    0 is reserved for errors
    """

    REPEATED = 3

    REQUIRED = 2
    """
    The required label is only allowed in google.protobuf.  In proto3 and Editions
    it's explicitly prohibited.  In Editions, the `field_presence` feature
    can be used to get this behavior.
    """

    @classmethod
    def betterproto_value_to_renamed_proto_names(cls) -> dict[int, str]:
        return {
            1: "LABEL_OPTIONAL",
            3: "LABEL_REPEATED",
            2: "LABEL_REQUIRED",
        }

    @classmethod
    def betterproto_renamed_proto_names_to_value(cls) -> dict[str, int]:
        return {
            "LABEL_OPTIONAL": 1,
            "LABEL_REPEATED": 3,
            "LABEL_REQUIRED": 2,
        }


class FieldDescriptorProtoType(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldDescriptorProto.Type"
        ]

    DOUBLE = 1
    """
    0 is reserved for errors.
    Order is weird for historical reasons.
    """

    FLOAT = 2

    INT64 = 3
    """
    Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
    negative values are likely.
    """

    UINT64 = 4

    INT32 = 5
    """
    Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
    negative values are likely.
    """

    FIXED64 = 6

    FIXED32 = 7

    BOOL = 8

    STRING = 9

    GROUP = 10
    """
    Tag-delimited aggregate.
    Group type is deprecated and not supported after google.protobuf. However, Proto3
    implementations should still be able to parse the group wire format and
    treat group fields as unknown fields.  In Editions, the group wire format
    can be enabled via the `message_encoding` feature.
    """

    MESSAGE = 11
    """
    Length-delimited aggregate.
    """

    BYTES = 12
    """
    New in version 2.
    """

    UINT32 = 13

    ENUM = 14

    SFIXED32 = 15

    SFIXED64 = 16

    SINT32 = 17
    """
    Uses ZigZag encoding.
    """

    SINT64 = 18
    """
    Uses ZigZag encoding.
    """

    @classmethod
    def betterproto_value_to_renamed_proto_names(cls) -> dict[int, str]:
        return {
            1: "TYPE_DOUBLE",
            2: "TYPE_FLOAT",
            3: "TYPE_INT64",
            4: "TYPE_UINT64",
            5: "TYPE_INT32",
            6: "TYPE_FIXED64",
            7: "TYPE_FIXED32",
            8: "TYPE_BOOL",
            9: "TYPE_STRING",
            10: "TYPE_GROUP",
            11: "TYPE_MESSAGE",
            12: "TYPE_BYTES",
            13: "TYPE_UINT32",
            14: "TYPE_ENUM",
            15: "TYPE_SFIXED32",
            16: "TYPE_SFIXED64",
            17: "TYPE_SINT32",
            18: "TYPE_SINT64",
        }

    @classmethod
    def betterproto_renamed_proto_names_to_value(cls) -> dict[str, int]:
        return {
            "TYPE_DOUBLE": 1,
            "TYPE_FLOAT": 2,
            "TYPE_INT64": 3,
            "TYPE_UINT64": 4,
            "TYPE_INT32": 5,
            "TYPE_FIXED64": 6,
            "TYPE_FIXED32": 7,
            "TYPE_BOOL": 8,
            "TYPE_STRING": 9,
            "TYPE_GROUP": 10,
            "TYPE_MESSAGE": 11,
            "TYPE_BYTES": 12,
            "TYPE_UINT32": 13,
            "TYPE_ENUM": 14,
            "TYPE_SFIXED32": 15,
            "TYPE_SFIXED64": 16,
            "TYPE_SINT32": 17,
            "TYPE_SINT64": 18,
        }


class FieldOptionsCType(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldOptions.CType"
        ]

    STRING = 0
    """
    Default mode.
    """

    CORD = 1
    """
    The option [ctype=CORD] may be applied to a non-repeated field of type
    "bytes". It indicates that in C++, the data should be stored in a Cord
    instead of a string.  For very large strings, this may reduce memory
    fragmentation. It may also allow better performance when parsing from a
    Cord, or when parsing with aliasing enabled, as the parsed Cord may then
    alias the original buffer.
    """

    STRING_PIECE = 2


class FieldOptionsJsType(betterproto2.Enum):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldOptions.JSType"
        ]

    JS_NORMAL = 0
    """
    Use the default type.
    """

    JS_STRING = 1
    """
    Use JavaScript strings.
    """

    JS_NUMBER = 2
    """
    Use JavaScript numbers.
    """


class FieldOptionsOptionRetention(betterproto2.Enum):
    """
    If set to RETENTION_SOURCE, the option will be omitted from the binary.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldOptions.OptionRetention"
        ]

    RETENTION_UNKNOWN = 0

    RETENTION_RUNTIME = 1

    RETENTION_SOURCE = 2


class FieldOptionsOptionTargetType(betterproto2.Enum):
    """
    This indicates the types of entities that the field may apply to when used
    as an option. If it is unset, then the field may be freely used as an
    option on any kind of entity.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FieldOptions.OptionTargetType"
        ]

    TARGET_TYPE_UNKNOWN = 0

    TARGET_TYPE_FILE = 1

    TARGET_TYPE_EXTENSION_RANGE = 2

    TARGET_TYPE_MESSAGE = 3

    TARGET_TYPE_FIELD = 4

    TARGET_TYPE_ONEOF = 5

    TARGET_TYPE_ENUM = 6

    TARGET_TYPE_ENUM_ENTRY = 7

    TARGET_TYPE_SERVICE = 8

    TARGET_TYPE_METHOD = 9


class FileOptionsOptimizeMode(betterproto2.Enum):
    """
    Generated classes can be optimized for speed or code size.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "FileOptions.OptimizeMode"
        ]

    SPEED = 1
    """
    Generate complete code for parsing, serialization,
    """

    CODE_SIZE = 2
    """
    etc.

    Use ReflectionOps to implement these methods.
    """

    LITE_RUNTIME = 3
    """
    Generate code using MessageLite and the lite runtime.
    """


class GeneratedCodeInfoAnnotationSemantic(betterproto2.Enum):
    """
    Represents the identified object's effect on the element in the original
    .proto file.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "GeneratedCodeInfo.Annotation.Semantic"
        ]

    NONE = 0
    """
    There is no effect or the effect is indescribable.
    """

    SET = 1
    """
    The element is set or otherwise mutated.
    """

    ALIAS = 2
    """
    An alias to the element is returned.
    """


class MethodOptionsIdempotencyLevel(betterproto2.Enum):
    """
    Is this method side-effect-free (or safe in HTTP parlance), or idempotent,
    or neither? HTTP based RPC implementation may choose GET verb for safe
    methods, and PUT verb for idempotent methods instead of the default POST.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "MethodOptions.IdempotencyLevel"
        ]

    IDEMPOTENCY_UNKNOWN = 0

    NO_SIDE_EFFECTS = 1
    """
    implies idempotent
    """

    IDEMPOTENT = 2
    """
    idempotent, but may have side effects
    """


class NullValue(betterproto2.Enum):
    """
    `NullValue` is a singleton enumeration to represent the null value for the
    `Value` type union.

    The JSON representation for `NullValue` is JSON `null`.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_STRUCT_PROTO_DESCRIPTOR.enum_types_by_name["NullValue"]

    NULL_VALUE = 0
    """
    Null value.
    """


class SymbolVisibility(betterproto2.Enum):
    """
    Describes the 'visibility' of a symbol with respect to the proto import
    system. Symbols can only be imported when the visibility rules do not prevent
    it (ex: local symbols cannot be imported).  Visibility modifiers can only set
    on `message` and `enum` as they are the only types available to be referenced
    from other files.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.enum_types_by_name[
            "SymbolVisibility"
        ]

    VISIBILITY_UNSET = 0

    VISIBILITY_LOCAL = 1

    VISIBILITY_EXPORT = 2


class Syntax(betterproto2.Enum):
    """
    The syntax in which a protocol buffer element is defined.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> EnumDescriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.enum_types_by_name["Syntax"]

    PROTO2 = 0
    """
    Syntax `proto2`.
    """

    PROTO3 = 1
    """
    Syntax `proto3`.
    """

    EDITIONS = 2
    """
    Syntax `editions`.
    """

    @classmethod
    def betterproto_value_to_renamed_proto_names(cls) -> dict[int, str]:
        return {
            0: "SYNTAX_PROTO2",
            1: "SYNTAX_PROTO3",
            2: "SYNTAX_EDITIONS",
        }

    @classmethod
    def betterproto_renamed_proto_names_to_value(cls) -> dict[str, int]:
        return {
            "SYNTAX_PROTO2": 0,
            "SYNTAX_PROTO3": 1,
            "SYNTAX_EDITIONS": 2,
        }


@dataclass(eq=False, repr=False)
class Any(betterproto2.Message):
    """
    `Any` contains an arbitrary serialized protocol buffer message along with a
    URL that describes the type of the serialized message.

    Protobuf library provides support to pack/unpack Any values in the form
    of utility functions or additional generated methods of the Any type.

    Example 1: Pack and unpack a message in C++.

        Foo foo = ...;
        Any any;
        any.PackFrom(foo);
        ...
        if (any.UnpackTo(&foo)) {
          ...
        }

    Example 2: Pack and unpack a message in Java.

        Foo foo = ...;
        Any any = Any.pack(foo);
        ...
        if (any.is(Foo.class)) {
          foo = any.unpack(Foo.class);
        }
        // or ...
        if (any.isSameTypeAs(Foo.getDefaultInstance())) {
          foo = any.unpack(Foo.getDefaultInstance());
        }

     Example 3: Pack and unpack a message in Python.

        foo = Foo(...)
        any = Any()
        any.Pack(foo)
        ...
        if any.Is(Foo.DESCRIPTOR):
          any.Unpack(foo)
          ...

     Example 4: Pack and unpack a message in Go

         foo := &pb.Foo{...}
         any, err := anypb.New(foo)
         if err != nil {
           ...
         }
         ...
         foo := &pb.Foo{}
         if err := any.UnmarshalTo(foo); err != nil {
           ...
         }

    The pack methods provided by protobuf library will by default use
    'type.googleapis.com/full.type.name' as the type URL and the unpack
    methods only use the fully qualified type name after the last '/'
    in the type URL, for example "foo.bar.com/x/y.z" will yield type
    name "y.z".

    JSON
    ====
    The JSON representation of an `Any` value uses the regular
    representation of the deserialized, embedded message, with an
    additional field `@type` which contains the type URL. Example:

        package google.profile;
        message Person {
          string first_name = 1;
          string last_name = 2;
        }

        {
          "@type": "type.googleapis.com/google.profile.Person",
          "firstName": <string>,
          "lastName": <string>
        }

    If the embedded message type is well-known and has a custom JSON
    representation, that representation will be embedded adding a field
    `value` which holds the custom JSON in addition to the `@type`
    field. Example (for message [google.protobuf.Duration][]):

        {
          "@type": "type.googleapis.com/google.protobuf.Duration",
          "value": "1.212s"
        }
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_ANY_PROTO_DESCRIPTOR.message_types_by_name["Any"]

    type_url: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    A URL/resource name that uniquely identifies the type of the serialized
    protocol buffer message. This string must contain at least
    one "/" character. The last segment of the URL's path must represent
    the fully qualified name of the type (as in
    `path/google.protobuf.Duration`). The name should be in a canonical form
    (e.g., leading "." is not accepted).

    In practice, teams usually precompile into the binary all types that they
    expect it to use in the context of Any. However, for URLs which use the
    scheme `http`, `https`, or no scheme, one can optionally set up a type
    server that maps type URLs to message definitions as follows:

    * If no scheme is provided, `https` is assumed.
    * An HTTP GET on the URL must yield a [google.protobuf.Type][]
      value in binary format, or produce an error.
    * Applications are allowed to cache lookup results based on the
      URL, or have them precompiled into a binary to avoid any
      lookup. Therefore, binary compatibility needs to be preserved
      on changes to types. (Use versioned type names to manage
      breaking changes.)

    Note: this functionality is not currently available in the official
    protobuf release, and it is not used for type URLs beginning with
    type.googleapis.com. As of May 2023, there are no widely used type server
    implementations and no plans to implement one.

    Schemes other than `http`, `https` (or the empty scheme) might be
    used with implementation specific semantics.
    """

    value: "bytes" = betterproto2.field(2, betterproto2.TYPE_BYTES)
    """
    Must be a valid serialized protocol buffer of the above specified type.
    """

    @classmethod
    def pack(
        cls,
        message: betterproto2.Message,
        message_pool: "betterproto2.MessagePool | None" = None,
    ) -> "Any":
        """
        Pack the given message in the `Any` object.

        The message type must be registered in the message pool, which is done automatically when the module defining
        the message type is imported.
        """
        message_pool = message_pool or default_message_pool

        type_url = message_pool.type_to_url[type(message)]
        value = bytes(message)

        return cls(type_url=type_url, value=value)

    def unpack(
        self, message_pool: "betterproto2.MessagePool | None" = None
    ) -> betterproto2.Message | None:
        """
        Return the message packed inside the `Any` object.

        The target message type must be registered in the message pool, which is done automatically when the module
        defining the message type is imported.
        """
        if not self.type_url:
            return None

        message_pool = message_pool or default_message_pool

        try:
            message_type = message_pool.url_to_type[self.type_url]
        except KeyError:
            raise TypeError(f"Can't unpack unregistered type: {self.type_url}")

        return message_type.parse(self.value)

    def to_dict(self, **kwargs) -> dict[str, typing.Any]:
        # TODO allow passing a message pool to `to_dict`
        output: dict[str, typing.Any] = {"@type": self.type_url}

        value = self.unpack()

        if value is None:
            return output

        if type(value).to_dict == betterproto2.Message.to_dict:
            output.update(value.to_dict(**kwargs))
        else:
            output["value"] = value.to_dict(**kwargs)

        return output

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        value = dict(value)  # Make a copy

        type_url = value.pop("@type", None)
        msg_cls = default_message_pool.url_to_type.get(type_url, None)

        if not msg_cls:
            raise TypeError(f"Can't unpack unregistered type: {type_url}")

        if not msg_cls.to_dict == betterproto2.Message.to_dict:
            value = value["value"]

        return cls(
            type_url=type_url,
            value=bytes(
                msg_cls.from_dict(value, ignore_unknown_fields=ignore_unknown_fields)
            ),
        )


default_message_pool.register_message("google.protobuf", "Any", Any)


@dataclass(eq=False, repr=False)
class Api(betterproto2.Message):
    """
    Api is a light-weight descriptor for an API Interface.

    Interfaces are also described as "protocol buffer services" in some contexts,
    such as by the "service" keyword in a .proto file, but they are different
    from API Services, which represent a concrete implementation of an interface
    as opposed to simply a description of methods and bindings. They are also
    sometimes simply referred to as "APIs" in other contexts, such as the name of
    this message itself. See https://cloud.google.com/apis/design/glossary for
    detailed terminology.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_API_PROTO_DESCRIPTOR.message_types_by_name["Api"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The fully qualified name of this interface, including package name
    followed by the interface's simple name.
    """

    methods: "list[Method]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The methods of this interface, in unspecified order.
    """

    options: "list[Option]" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Any metadata attached to the interface.
    """

    version: "str" = betterproto2.field(4, betterproto2.TYPE_STRING)
    """
    A version string for this interface. If specified, must have the form
    `major-version.minor-version`, as in `1.10`. If the minor version is
    omitted, it defaults to zero. If the entire version field is empty, the
    major version is derived from the package name, as outlined below. If the
    field is not empty, the version in the package name will be verified to be
    consistent with what is provided here.

    The versioning schema uses [semantic
    versioning](http://semver.org) where the major version number
    indicates a breaking change and the minor version an additive,
    non-breaking change. Both version numbers are signals to users
    what to expect from different versions, and should be carefully
    chosen based on the product plan.

    The major version is also reflected in the package name of the
    interface, which must end in `v<major-version>`, as in
    `google.feature.v1`. For major versions 0 and 1, the suffix can
    be omitted. Zero major versions must only be used for
    experimental, non-GA interfaces.
    """

    source_context: "SourceContext | None" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Source context for the protocol buffer service represented by this
    message.
    """

    mixins: "list[Mixin]" = betterproto2.field(
        6, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Included interfaces. See [Mixin][].
    """

    syntax: "Syntax" = betterproto2.field(
        7, betterproto2.TYPE_ENUM, default_factory=lambda: Syntax(0)
    )
    """
    The source syntax of the service.
    """


default_message_pool.register_message("google.protobuf", "Api", Api)


@dataclass(eq=False, repr=False)
class BoolValue(betterproto2.Message):
    """
    Wrapper message for `bool`.

    The JSON representation for `BoolValue` is JSON `true` and `false`.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "BoolValue"
        ]

    value: "bool" = betterproto2.field(1, betterproto2.TYPE_BOOL)
    """
    The bool value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, bool):
            return BoolValue(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: bool) -> "BoolValue":
        return BoolValue(value=wrapped)

    def to_wrapped(self) -> bool:
        return self.value


default_message_pool.register_message("google.protobuf", "BoolValue", BoolValue)


@dataclass(eq=False, repr=False)
class BytesValue(betterproto2.Message):
    """
    Wrapper message for `bytes`.

    The JSON representation for `BytesValue` is JSON string.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "BytesValue"
        ]

    value: "bytes" = betterproto2.field(1, betterproto2.TYPE_BYTES)
    """
    The bytes value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, bytes):
            return BytesValue(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: bytes) -> "BytesValue":
        return BytesValue(value=wrapped)

    def to_wrapped(self) -> bytes:
        return self.value


default_message_pool.register_message("google.protobuf", "BytesValue", BytesValue)


@dataclass(eq=False, repr=False)
class DescriptorProto(betterproto2.Message):
    """
    Describes a message type.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "DescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    field: "list[FieldDescriptorProto]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )

    extension: "list[FieldDescriptorProto]" = betterproto2.field(
        6, betterproto2.TYPE_MESSAGE, repeated=True
    )

    nested_type: "list[DescriptorProto]" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, repeated=True
    )

    enum_type: "list[EnumDescriptorProto]" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, repeated=True
    )

    extension_range: "list[DescriptorProtoExtensionRange]" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, repeated=True
    )

    oneof_decl: "list[OneofDescriptorProto]" = betterproto2.field(
        8, betterproto2.TYPE_MESSAGE, repeated=True
    )

    options: "MessageOptions | None" = betterproto2.field(
        7, betterproto2.TYPE_MESSAGE, optional=True
    )

    reserved_range: "list[DescriptorProtoReservedRange]" = betterproto2.field(
        9, betterproto2.TYPE_MESSAGE, repeated=True
    )

    reserved_name: "list[str]" = betterproto2.field(
        10, betterproto2.TYPE_STRING, repeated=True
    )
    """
    Reserved field names, which may not be used by fields in the same message.
    A given name may only be reserved once.
    """

    visibility: "SymbolVisibility" = betterproto2.field(
        11, betterproto2.TYPE_ENUM, default_factory=lambda: SymbolVisibility(0)
    )
    """
    Support for `export` and `local` keywords on enums.
    """


default_message_pool.register_message(
    "google.protobuf", "DescriptorProto", DescriptorProto
)


@dataclass(eq=False, repr=False)
class DescriptorProtoExtensionRange(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "DescriptorProto.ExtensionRange"
        ]

    start: "int" = betterproto2.field(1, betterproto2.TYPE_INT32)
    """
    Inclusive.
    """

    end: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Exclusive.
    """

    options: "ExtensionRangeOptions | None" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, optional=True
    )


default_message_pool.register_message(
    "google.protobuf", "DescriptorProto.ExtensionRange", DescriptorProtoExtensionRange
)


@dataclass(eq=False, repr=False)
class DescriptorProtoReservedRange(betterproto2.Message):
    """
    Range of reserved tag numbers. Reserved tag numbers may not be used by
    fields or extension ranges in the same message. Reserved ranges may
    not overlap.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "DescriptorProto.ReservedRange"
        ]

    start: "int" = betterproto2.field(1, betterproto2.TYPE_INT32)
    """
    Inclusive.
    """

    end: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Exclusive.
    """


default_message_pool.register_message(
    "google.protobuf", "DescriptorProto.ReservedRange", DescriptorProtoReservedRange
)


@dataclass(eq=False, repr=False)
class DoubleValue(betterproto2.Message):
    """
    Wrapper message for `double`.

    The JSON representation for `DoubleValue` is JSON number.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "DoubleValue"
        ]

    value: "float" = betterproto2.field(1, betterproto2.TYPE_DOUBLE)
    """
    The double value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, float):
            return DoubleValue(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: float) -> "DoubleValue":
        return DoubleValue(value=wrapped)

    def to_wrapped(self) -> float:
        return self.value


default_message_pool.register_message("google.protobuf", "DoubleValue", DoubleValue)


@dataclass(eq=False, repr=False)
class Duration(betterproto2.Message):
    """
    A Duration represents a signed, fixed-length span of time represented
    as a count of seconds and fractions of seconds at nanosecond
    resolution. It is independent of any calendar and concepts like "day"
    or "month". It is related to Timestamp in that the difference between
    two Timestamp values is a Duration and it can be added or subtracted
    from a Timestamp. Range is approximately +-10,000 years.

    # Examples

    Example 1: Compute Duration from two Timestamps in pseudo code.

        Timestamp start = ...;
        Timestamp end = ...;
        Duration duration = ...;

        duration.seconds = end.seconds - start.seconds;
        duration.nanos = end.nanos - start.nanos;

        if (duration.seconds < 0 && duration.nanos > 0) {
          duration.seconds += 1;
          duration.nanos -= 1000000000;
        } else if (duration.seconds > 0 && duration.nanos < 0) {
          duration.seconds -= 1;
          duration.nanos += 1000000000;
        }

    Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.

        Timestamp start = ...;
        Duration duration = ...;
        Timestamp end = ...;

        end.seconds = start.seconds + duration.seconds;
        end.nanos = start.nanos + duration.nanos;

        if (end.nanos < 0) {
          end.seconds -= 1;
          end.nanos += 1000000000;
        } else if (end.nanos >= 1000000000) {
          end.seconds += 1;
          end.nanos -= 1000000000;
        }

    Example 3: Compute Duration from datetime.timedelta in Python.

        td = datetime.timedelta(days=3, minutes=10)
        duration = Duration()
        duration.FromTimedelta(td)

    # JSON Mapping

    In JSON format, the Duration type is encoded as a string rather than an
    object, where the string ends in the suffix "s" (indicating seconds) and
    is preceded by the number of seconds, with nanoseconds expressed as
    fractional seconds. For example, 3 seconds with 0 nanoseconds should be
    encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
    be expressed in JSON format as "3.000000001s", and 3 seconds and 1
    microsecond should be expressed in JSON format as "3.000001s".
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DURATION_PROTO_DESCRIPTOR.message_types_by_name[
            "Duration"
        ]

    seconds: "int" = betterproto2.field(1, betterproto2.TYPE_INT64)
    """
    Signed seconds of the span of time. Must be from -315,576,000,000
    to +315,576,000,000 inclusive. Note: these bounds are computed from:
    60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    """

    nanos: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Signed fractions of a second at nanosecond resolution of the span
    of time. Durations less than one second are represented with a 0
    `seconds` field and a positive or negative `nanos` field. For durations
    of one second or more, a non-zero value for the `nanos` field must be
    of the same sign as the `seconds` field. Must be from -999,999,999
    to +999,999,999 inclusive.
    """

    @classmethod
    def from_timedelta(
        cls,
        delta: datetime.timedelta,
        *,
        _1_microsecond: datetime.timedelta = datetime.timedelta(microseconds=1),
    ) -> "Duration":
        total_ms = delta // _1_microsecond
        seconds = int(total_ms / 1e6)
        nanos = int((total_ms % 1e6) * 1e3)
        return cls(seconds, nanos)

    def to_timedelta(self) -> datetime.timedelta:
        return datetime.timedelta(seconds=self.seconds, microseconds=self.nanos / 1e3)

    @staticmethod
    def delta_to_json(delta: datetime.timedelta) -> str:
        parts = str(delta.total_seconds()).split(".")
        if len(parts) > 1:
            while len(parts[1]) not in (3, 6, 9):
                parts[1] = f"{parts[1]}0"
        return f"{'.'.join(parts)}s"

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, str):
            if not re.match(r"^\d+(\.\d+)?s$", value):
                raise ValueError(f"Invalid duration string: {value}")

            seconds = float(value[:-1])
            return Duration(
                seconds=int(seconds), nanos=int((seconds - int(seconds)) * 1e9)
            )

        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        # If the output format is PYTHON, we should have kept the wrapped type without building the real class
        assert output_format == betterproto2.OutputFormat.PROTO_JSON

        assert 0 <= self.nanos < 1e9

        if self.nanos == 0:
            return f"{self.seconds}s"

        nanos = f"{self.nanos:09d}".rstrip("0")
        if len(nanos) < 3:
            nanos += "0" * (3 - len(nanos))

        return f"{self.seconds}.{nanos}s"

    @staticmethod
    def from_wrapped(wrapped: datetime.timedelta) -> "Duration":
        return Duration.from_timedelta(wrapped)

    def to_wrapped(self) -> datetime.timedelta:
        return self.to_timedelta()


default_message_pool.register_message("google.protobuf", "Duration", Duration)


@dataclass(eq=False, repr=False)
class Empty(betterproto2.Message):
    """
    A generic empty message that you can re-use to avoid defining duplicated
    empty messages in your APIs. A typical example is to use it as the request
    or the response type of an API method. For instance:

        service Foo {
          rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);
        }
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_EMPTY_PROTO_DESCRIPTOR.message_types_by_name["Empty"]

    pass


default_message_pool.register_message("google.protobuf", "Empty", Empty)


@dataclass(eq=False, repr=False)
class Enum(betterproto2.Message):
    """
    Enum type definition.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.message_types_by_name["Enum"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    Enum type name.
    """

    enumvalue: "list[EnumValue]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Enum value definitions.
    """

    options: "list[Option]" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Protocol buffer options.
    """

    source_context: "SourceContext | None" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    The source context.
    """

    syntax: "Syntax" = betterproto2.field(
        5, betterproto2.TYPE_ENUM, default_factory=lambda: Syntax(0)
    )
    """
    The source syntax.
    """

    edition: "str" = betterproto2.field(6, betterproto2.TYPE_STRING)
    """
    The source edition string, only valid when syntax is SYNTAX_EDITIONS.
    """


default_message_pool.register_message("google.protobuf", "Enum", Enum)


@dataclass(eq=False, repr=False)
class EnumDescriptorProto(betterproto2.Message):
    """
    Describes an enum type.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "EnumDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    value: "list[EnumValueDescriptorProto]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )

    options: "EnumOptions | None" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, optional=True
    )

    reserved_range: "list[EnumDescriptorProtoEnumReservedRange]" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Range of reserved numeric values. Reserved numeric values may not be used
    by enum values in the same enum declaration. Reserved ranges may not
    overlap.
    """

    reserved_name: "list[str]" = betterproto2.field(
        5, betterproto2.TYPE_STRING, repeated=True
    )
    """
    Reserved enum value names, which may not be reused. A given name may only
    be reserved once.
    """

    visibility: "SymbolVisibility" = betterproto2.field(
        6, betterproto2.TYPE_ENUM, default_factory=lambda: SymbolVisibility(0)
    )
    """
    Support for `export` and `local` keywords on enums.
    """


default_message_pool.register_message(
    "google.protobuf", "EnumDescriptorProto", EnumDescriptorProto
)


@dataclass(eq=False, repr=False)
class EnumDescriptorProtoEnumReservedRange(betterproto2.Message):
    """
    Range of reserved numeric values. Reserved values may not be used by
    entries in the same enum. Reserved ranges may not overlap.

    Note that this is distinct from DescriptorProto.ReservedRange in that it
    is inclusive such that it can appropriately represent the entire int32
    domain.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "EnumDescriptorProto.EnumReservedRange"
        ]

    start: "int" = betterproto2.field(1, betterproto2.TYPE_INT32)
    """
    Inclusive.
    """

    end: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Inclusive.
    """


default_message_pool.register_message(
    "google.protobuf",
    "EnumDescriptorProto.EnumReservedRange",
    EnumDescriptorProtoEnumReservedRange,
)


@dataclass(eq=False, repr=False)
class EnumOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "EnumOptions"
        ]

    allow_alias: "bool" = betterproto2.field(2, betterproto2.TYPE_BOOL)
    """
    Set this option to true to allow mapping different tag names to the same
    value.
    """

    deprecated: "bool" = betterproto2.field(3, betterproto2.TYPE_BOOL)
    """
    Is this enum deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for the enum, or it will be completely ignored; in the very least, this
    is a formalization for deprecating enums.
    """

    deprecated_legacy_json_field_conflicts: "bool" = betterproto2.field(
        6, betterproto2.TYPE_BOOL
    )
    """
    Enable the legacy handling of JSON field name conflicts.  This lowercases
    and strips underscored from the fields before comparison in proto3 only.
    The new behavior takes `json_name` into account and applies to proto2 as
    well.
    TODO Remove this legacy behavior once downstream teams have
    had time to migrate.
    """

    features: "FeatureSet | None" = betterproto2.field(
        7, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("deprecated_legacy_json_field_conflicts"):
            warnings.warn(
                "EnumOptions.deprecated_legacy_json_field_conflicts is deprecated",
                DeprecationWarning,
            )


default_message_pool.register_message("google.protobuf", "EnumOptions", EnumOptions)


@dataclass(eq=False, repr=False)
class EnumValue(betterproto2.Message):
    """
    Enum value definition.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.message_types_by_name["EnumValue"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    Enum value name.
    """

    number: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Enum value number.
    """

    options: "list[Option]" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Protocol buffer options.
    """


default_message_pool.register_message("google.protobuf", "EnumValue", EnumValue)


@dataclass(eq=False, repr=False)
class EnumValueDescriptorProto(betterproto2.Message):
    """
    Describes a value within an enum.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "EnumValueDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    number: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)

    options: "EnumValueOptions | None" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, optional=True
    )


default_message_pool.register_message(
    "google.protobuf", "EnumValueDescriptorProto", EnumValueDescriptorProto
)


@dataclass(eq=False, repr=False)
class EnumValueOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "EnumValueOptions"
        ]

    deprecated: "bool" = betterproto2.field(1, betterproto2.TYPE_BOOL)
    """
    Is this enum value deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for the enum value, or it will be completely ignored; in the very least,
    this is a formalization for deprecating enum values.
    """

    features: "FeatureSet | None" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    debug_redact: "bool" = betterproto2.field(3, betterproto2.TYPE_BOOL)
    """
    Indicate that fields annotated with this enum value should not be printed
    out when using debug formats, e.g. when the field contains sensitive
    credentials.
    """

    feature_support: "FieldOptionsFeatureSupport | None" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Information about the support window of a feature value.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """


default_message_pool.register_message(
    "google.protobuf", "EnumValueOptions", EnumValueOptions
)


@dataclass(eq=False, repr=False)
class ExtensionRangeOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "ExtensionRangeOptions"
        ]

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """

    declaration: "list[ExtensionRangeOptionsDeclaration]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    For external users: DO NOT USE. We are in the process of open sourcing
    extension declaration and executing internal cleanups before it can be
    used externally.
    """

    features: "FeatureSet | None" = betterproto2.field(
        50, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    """

    verification: "ExtensionRangeOptionsVerificationState" = betterproto2.field(
        3,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: ExtensionRangeOptionsVerificationState(0),
    )
    """
    The verification state of the range.
    TODO: flip the default to DECLARATION once all empty ranges
    are marked as UNVERIFIED.
    """


default_message_pool.register_message(
    "google.protobuf", "ExtensionRangeOptions", ExtensionRangeOptions
)


@dataclass(eq=False, repr=False)
class ExtensionRangeOptionsDeclaration(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "ExtensionRangeOptions.Declaration"
        ]

    number: "int" = betterproto2.field(1, betterproto2.TYPE_INT32)
    """
    The extension number declared within the extension range.
    """

    full_name: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    The fully-qualified name of the extension field. There must be a leading
    dot in front of the full name.
    """

    type: "str" = betterproto2.field(3, betterproto2.TYPE_STRING)
    """
    The fully-qualified type name of the extension field. Unlike
    Metadata.type, Declaration.type must have a leading dot for messages
    and enums.
    """

    reserved: "bool" = betterproto2.field(5, betterproto2.TYPE_BOOL)
    """
    If true, indicates that the number is reserved in the extension range,
    and any extension field with the number will fail to compile. Set this
    when a declared extension field is deleted.
    """

    repeated: "bool" = betterproto2.field(6, betterproto2.TYPE_BOOL)
    """
    If true, indicates that the extension must be defined as repeated.
    Otherwise the extension must be defined as optional.
    """


default_message_pool.register_message(
    "google.protobuf",
    "ExtensionRangeOptions.Declaration",
    ExtensionRangeOptionsDeclaration,
)


@dataclass(eq=False, repr=False)
class FeatureSet(betterproto2.Message):
    """
    ===================================================================
    Features

    TODO Enums in C++ gencode (and potentially other languages) are
    not well scoped.  This means that each of the feature enums below can clash
    with each other.  The short names we've chosen maximize call-site
    readability, but leave us very open to this scenario.  A future feature will
    be designed and implemented to handle this, hopefully before we ever hit a
    conflict here.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FeatureSet"
        ]

    field_presence: "FeatureSetFieldPresence" = betterproto2.field(
        1, betterproto2.TYPE_ENUM, default_factory=lambda: FeatureSetFieldPresence(0)
    )

    enum_type: "FeatureSetEnumType" = betterproto2.field(
        2, betterproto2.TYPE_ENUM, default_factory=lambda: FeatureSetEnumType(0)
    )

    repeated_field_encoding: "FeatureSetRepeatedFieldEncoding" = betterproto2.field(
        3,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: FeatureSetRepeatedFieldEncoding(0),
    )

    utf8_validation: "FeatureSetUtf8Validation" = betterproto2.field(
        4, betterproto2.TYPE_ENUM, default_factory=lambda: FeatureSetUtf8Validation(0)
    )

    message_encoding: "FeatureSetMessageEncoding" = betterproto2.field(
        5, betterproto2.TYPE_ENUM, default_factory=lambda: FeatureSetMessageEncoding(0)
    )

    json_format: "FeatureSetJsonFormat" = betterproto2.field(
        6, betterproto2.TYPE_ENUM, default_factory=lambda: FeatureSetJsonFormat(0)
    )

    enforce_naming_style: "FeatureSetEnforceNamingStyle" = betterproto2.field(
        7,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: FeatureSetEnforceNamingStyle(0),
    )

    default_symbol_visibility: "FeatureSetVisibilityFeatureDefaultSymbolVisibility" = (
        betterproto2.field(
            8,
            betterproto2.TYPE_ENUM,
            default_factory=lambda: FeatureSetVisibilityFeatureDefaultSymbolVisibility(
                0
            ),
        )
    )


default_message_pool.register_message("google.protobuf", "FeatureSet", FeatureSet)


@dataclass(eq=False, repr=False)
class FeatureSetVisibilityFeature(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FeatureSet.VisibilityFeature"
        ]

    pass


default_message_pool.register_message(
    "google.protobuf", "FeatureSet.VisibilityFeature", FeatureSetVisibilityFeature
)


@dataclass(eq=False, repr=False)
class FeatureSetDefaults(betterproto2.Message):
    """
    A compiled specification for the defaults of a set of features.  These
    messages are generated from FeatureSet extensions and can be used to seed
    feature resolution. The resolution with this object becomes a simple search
    for the closest matching edition, followed by proto merges.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FeatureSetDefaults"
        ]

    defaults: "list[FeatureSetDefaultsFeatureSetEditionDefault]" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, repeated=True
    )

    minimum_edition: "Edition" = betterproto2.field(
        4, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The minimum supported edition (inclusive) when this was constructed.
    Editions before this will not have defaults.
    """

    maximum_edition: "Edition" = betterproto2.field(
        5, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The maximum known edition (inclusive) when this was constructed. Editions
    after this will not have reliable defaults.
    """


default_message_pool.register_message(
    "google.protobuf", "FeatureSetDefaults", FeatureSetDefaults
)


@dataclass(eq=False, repr=False)
class FeatureSetDefaultsFeatureSetEditionDefault(betterproto2.Message):
    """
    A map from every known edition with a unique set of defaults to its
    defaults. Not all editions may be contained here.  For a given edition,
    the defaults at the closest matching edition ordered at or before it should
    be used.  This field must be in strict ascending order by edition.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FeatureSetDefaults.FeatureSetEditionDefault"
        ]

    edition: "Edition" = betterproto2.field(
        3, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )

    overridable_features: "FeatureSet | None" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Defaults of features that can be overridden in this edition.
    """

    fixed_features: "FeatureSet | None" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Defaults of features that can't be overridden in this edition.
    """


default_message_pool.register_message(
    "google.protobuf",
    "FeatureSetDefaults.FeatureSetEditionDefault",
    FeatureSetDefaultsFeatureSetEditionDefault,
)


@dataclass(eq=False, repr=False)
class Field(betterproto2.Message):
    """
    A single field of a message type.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.message_types_by_name["Field"]

    kind: "FieldKind" = betterproto2.field(
        1, betterproto2.TYPE_ENUM, default_factory=lambda: FieldKind(0)
    )
    """
    The field type.
    """

    cardinality: "FieldCardinality" = betterproto2.field(
        2, betterproto2.TYPE_ENUM, default_factory=lambda: FieldCardinality(0)
    )
    """
    The field cardinality.
    """

    number: "int" = betterproto2.field(3, betterproto2.TYPE_INT32)
    """
    The field number.
    """

    name: "str" = betterproto2.field(4, betterproto2.TYPE_STRING)
    """
    The field name.
    """

    type_url: "str" = betterproto2.field(6, betterproto2.TYPE_STRING)
    """
    The field type URL, without the scheme, for message or enumeration
    types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
    """

    oneof_index: "int" = betterproto2.field(7, betterproto2.TYPE_INT32)
    """
    The index of the field type in `Type.oneofs`, for message or enumeration
    types. The first type has index 1; zero means the type is not in the list.
    """

    packed: "bool" = betterproto2.field(8, betterproto2.TYPE_BOOL)
    """
    Whether to use alternative packed wire representation.
    """

    options: "list[Option]" = betterproto2.field(
        9, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The protocol buffer options.
    """

    json_name: "str" = betterproto2.field(10, betterproto2.TYPE_STRING)
    """
    The field JSON name.
    """

    default_value: "str" = betterproto2.field(11, betterproto2.TYPE_STRING)
    """
    The string value of the default value of this field. Proto2 syntax only.
    """


default_message_pool.register_message("google.protobuf", "Field", Field)


@dataclass(eq=False, repr=False)
class FieldDescriptorProto(betterproto2.Message):
    """
    Describes a field within a message.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FieldDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    number: "int" = betterproto2.field(3, betterproto2.TYPE_INT32)

    label: "FieldDescriptorProtoLabel" = betterproto2.field(
        4, betterproto2.TYPE_ENUM, default_factory=lambda: FieldDescriptorProtoLabel(0)
    )

    type: "FieldDescriptorProtoType" = betterproto2.field(
        5, betterproto2.TYPE_ENUM, default_factory=lambda: FieldDescriptorProtoType(0)
    )
    """
    If type_name is set, this need not be set.  If both this and type_name
    are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.
    """

    type_name: "str" = betterproto2.field(6, betterproto2.TYPE_STRING)
    """
    For message and enum types, this is the name of the type.  If the name
    starts with a '.', it is fully-qualified.  Otherwise, C++-like scoping
    rules are used to find the type (i.e. first the nested types within this
    message are searched, then within the parent, on up to the root
    namespace).
    """

    extendee: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    For extensions, this is the name of the type being extended.  It is
    resolved in the same manner as type_name.
    """

    default_value: "str" = betterproto2.field(7, betterproto2.TYPE_STRING)
    """
    For numeric types, contains the original text representation of the value.
    For booleans, "true" or "false".
    For strings, contains the default text contents (not escaped in any way).
    For bytes, contains the C escaped value.  All bytes >= 128 are escaped.
    """

    oneof_index: "int" = betterproto2.field(9, betterproto2.TYPE_INT32)
    """
    If set, gives the index of a oneof in the containing type's oneof_decl
    list.  This field is a member of that oneof.
    """

    json_name: "str" = betterproto2.field(10, betterproto2.TYPE_STRING)
    """
    JSON name of this field. The value is set by protocol compiler. If the
    user has set a "json_name" option on this field, that option's value
    will be used. Otherwise, it's deduced from the field's name by converting
    it to camelCase.
    """

    options: "FieldOptions | None" = betterproto2.field(
        8, betterproto2.TYPE_MESSAGE, optional=True
    )

    proto3_optional: "bool" = betterproto2.field(17, betterproto2.TYPE_BOOL)
    """
    If true, this is a proto3 "optional". When a proto3 field is optional, it
    tracks presence regardless of field type.

    When proto3_optional is true, this field must belong to a oneof to signal
    to old proto3 clients that presence is tracked for this field. This oneof
    is known as a "synthetic" oneof, and this field must be its sole member
    (each proto3 optional field gets its own synthetic oneof). Synthetic oneofs
    exist in the descriptor only, and do not generate any API. Synthetic oneofs
    must be ordered after all "real" oneofs.

    For message fields, proto3_optional doesn't create any semantic change,
    since non-repeated message fields always track presence. However it still
    indicates the semantic detail of whether the user wrote "optional" or not.
    This can be useful for round-tripping the .proto file. For consistency we
    give message fields a synthetic oneof also, even though it is not required
    to track presence. This is especially important because the parser can't
    tell if a field is a message or an enum, so it must always create a
    synthetic oneof.

    Proto2 optional fields do not set this flag, because they already indicate
    optional with `LABEL_OPTIONAL`.
    """


default_message_pool.register_message(
    "google.protobuf", "FieldDescriptorProto", FieldDescriptorProto
)


@dataclass(eq=False, repr=False)
class FieldMask(betterproto2.Message):
    """
    `FieldMask` represents a set of symbolic field paths, for example:

        paths: "f.a"
        paths: "f.b.d"

    Here `f` represents a field in some root message, `a` and `b`
    fields in the message found in `f`, and `d` a field found in the
    message in `f.b`.

    Field masks are used to specify a subset of fields that should be
    returned by a get operation or modified by an update operation.
    Field masks also have a custom JSON encoding (see below).

    # Field Masks in Projections

    When used in the context of a projection, a response message or
    sub-message is filtered by the API to only contain those fields as
    specified in the mask. For example, if the mask in the previous
    example is applied to a response message as follows:

        f {
          a : 22
          b {
            d : 1
            x : 2
          }
          y : 13
        }
        z: 8

    The result will not contain specific values for fields x,y and z
    (their value will be set to the default, and omitted in proto text
    output):

        f {
          a : 22
          b {
            d : 1
          }
        }

    A repeated field is not allowed except at the last position of a
    paths string.

    If a FieldMask object is not present in a get operation, the
    operation applies to all fields (as if a FieldMask of all fields
    had been specified).

    Note that a field mask does not necessarily apply to the
    top-level response message. In case of a REST get operation, the
    field mask applies directly to the response, but in case of a REST
    list operation, the mask instead applies to each individual message
    in the returned resource list. In case of a REST custom method,
    other definitions may be used. Where the mask applies will be
    clearly documented together with its declaration in the API.  In
    any case, the effect on the returned resource/resources is required
    behavior for APIs.

    # Field Masks in Update Operations

    A field mask in update operations specifies which fields of the
    targeted resource are going to be updated. The API is required
    to only change the values of the fields as specified in the mask
    and leave the others untouched. If a resource is passed in to
    describe the updated values, the API ignores the values of all
    fields not covered by the mask.

    If a repeated field is specified for an update operation, new values will
    be appended to the existing repeated field in the target resource. Note that
    a repeated field is only allowed in the last position of a `paths` string.

    If a sub-message is specified in the last position of the field mask for an
    update operation, then new value will be merged into the existing sub-message
    in the target resource.

    For example, given the target message:

        f {
          b {
            d: 1
            x: 2
          }
          c: [1]
        }

    And an update message:

        f {
          b {
            d: 10
          }
          c: [2]
        }

    then if the field mask is:

     paths: ["f.b", "f.c"]

    then the result will be:

        f {
          b {
            d: 10
            x: 2
          }
          c: [1, 2]
        }

    An implementation may provide options to override this default behavior for
    repeated and message fields.

    In order to reset a field's value to the default, the field must
    be in the mask and set to the default value in the provided resource.
    Hence, in order to reset all fields of a resource, provide a default
    instance of the resource and set all fields in the mask, or do
    not provide a mask as described below.

    If a field mask is not present on update, the operation applies to
    all fields (as if a field mask of all fields has been specified).
    Note that in the presence of schema evolution, this may mean that
    fields the client does not know and has therefore not filled into
    the request will be reset to their default. If this is unwanted
    behavior, a specific service may require a client to always specify
    a field mask, producing an error if not.

    As with get operations, the location of the resource which
    describes the updated values in the request message depends on the
    operation kind. In any case, the effect of the field mask is
    required to be honored by the API.

    ## Considerations for HTTP REST

    The HTTP kind of an update operation which uses a field mask must
    be set to PATCH instead of PUT in order to satisfy HTTP semantics
    (PUT must only be used for full updates).

    # JSON Encoding of Field Masks

    In JSON, a field mask is encoded as a single string where paths are
    separated by a comma. Fields name in each path are converted
    to/from lower-camel naming conventions.

    As an example, consider the following message declarations:

        message Profile {
          User user = 1;
          Photo photo = 2;
        }
        message User {
          string display_name = 1;
          string address = 2;
        }

    In proto a field mask for `Profile` may look as such:

        mask {
          paths: "user.display_name"
          paths: "photo"
        }

    In JSON, the same mask is represented as below:

        {
          mask: "user.displayName,photo"
        }

    # Field Masks and Oneof Fields

    Field masks treat fields in oneofs just as regular fields. Consider the
    following message:

        message SampleMessage {
          oneof test_oneof {
            string name = 4;
            SubMessage sub_message = 9;
          }
        }

    The field mask can be:

        mask {
          paths: "name"
        }

    Or:

        mask {
          paths: "sub_message"
        }

    Note that oneof type names ("test_oneof" in this case) cannot be used in
    paths.

    ## Field Mask Verification

    The implementation of any API method which has a FieldMask type field in the
    request should verify the included field paths, and return an
    `INVALID_ARGUMENT` error if any path is unmappable.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_FIELD_MASK_PROTO_DESCRIPTOR.message_types_by_name[
            "FieldMask"
        ]

    paths: "list[str]" = betterproto2.field(1, betterproto2.TYPE_STRING, repeated=True)
    """
    The set of field mask paths.
    """


default_message_pool.register_message("google.protobuf", "FieldMask", FieldMask)


@dataclass(eq=False, repr=False)
class FieldOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FieldOptions"
        ]

    ctype: "FieldOptionsCType" = betterproto2.field(
        1, betterproto2.TYPE_ENUM, default_factory=lambda: FieldOptionsCType(0)
    )
    """
    NOTE: ctype is deprecated. Use `features.(pb.cpp).string_type` instead.
    The ctype option instructs the C++ code generator to use a different
    representation of the field than it normally would.  See the specific
    options below.  This option is only implemented to support use of
    [ctype=CORD] and [ctype=STRING] (the default) on non-repeated fields of
    type "bytes" in the open source release.
    TODO: make ctype actually deprecated.
    """

    packed: "bool" = betterproto2.field(2, betterproto2.TYPE_BOOL)
    """
    The packed option can be enabled for repeated primitive fields to enable
    a more efficient representation on the wire. Rather than repeatedly
    writing the tag and type for each element, the entire array is encoded as
    a single length-delimited blob. In proto3, only explicit setting it to
    false will avoid using packed encoding.  This option is prohibited in
    Editions, but the `repeated_field_encoding` feature can be used to control
    the behavior.
    """

    jstype: "FieldOptionsJsType" = betterproto2.field(
        6, betterproto2.TYPE_ENUM, default_factory=lambda: FieldOptionsJsType(0)
    )
    """
    The jstype option determines the JavaScript type used for values of the
    field.  The option is permitted only for 64 bit integral and fixed types
    (int64, uint64, sint64, fixed64, sfixed64).  A field with jstype JS_STRING
    is represented as JavaScript string, which avoids loss of precision that
    can happen when a large value is converted to a floating point JavaScript.
    Specifying JS_NUMBER for the jstype causes the generated JavaScript code to
    use the JavaScript "number" type.  The behavior of the default option
    JS_NORMAL is implementation dependent.

    This option is an enum to permit additional types to be added, e.g.
    goog.math.Integer.
    """

    lazy: "bool" = betterproto2.field(5, betterproto2.TYPE_BOOL)
    """
    Should this field be parsed lazily?  Lazy applies only to message-type
    fields.  It means that when the outer message is initially parsed, the
    inner message's contents will not be parsed but instead stored in encoded
    form.  The inner message will actually be parsed when it is first accessed.

    This is only a hint.  Implementations are free to choose whether to use
    eager or lazy parsing regardless of the value of this option.  However,
    setting this option true suggests that the protocol author believes that
    using lazy parsing on this field is worth the additional bookkeeping
    overhead typically needed to implement it.

    This option does not affect the public interface of any generated code;
    all method signatures remain the same.  Furthermore, thread-safety of the
    interface is not affected by this option; const methods remain safe to
    call from multiple threads concurrently, while non-const methods continue
    to require exclusive access.

    Note that lazy message fields are still eagerly verified to check
    ill-formed wireformat or missing required fields. Calling IsInitialized()
    on the outer message would fail if the inner message has missing required
    fields. Failed verification would result in parsing failure (except when
    uninitialized messages are acceptable).
    """

    unverified_lazy: "bool" = betterproto2.field(15, betterproto2.TYPE_BOOL)
    """
    unverified_lazy does no correctness checks on the byte stream. This should
    only be used where lazy with verification is prohibitive for performance
    reasons.
    """

    deprecated: "bool" = betterproto2.field(3, betterproto2.TYPE_BOOL)
    """
    Is this field deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for accessors, or it will be completely ignored; in the very least, this
    is a formalization for deprecating fields.
    """

    weak: "bool" = betterproto2.field(10, betterproto2.TYPE_BOOL)
    """
    For Google-internal migration only. Do not use.
    """

    debug_redact: "bool" = betterproto2.field(16, betterproto2.TYPE_BOOL)
    """
    Indicate that the field value should not be printed out when using debug
    formats, e.g. when the field contains sensitive credentials.
    """

    retention: "FieldOptionsOptionRetention" = betterproto2.field(
        17,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: FieldOptionsOptionRetention(0),
    )

    targets: "list[FieldOptionsOptionTargetType]" = betterproto2.field(
        19, betterproto2.TYPE_ENUM, repeated=True
    )

    edition_defaults: "list[FieldOptionsEditionDefault]" = betterproto2.field(
        20, betterproto2.TYPE_MESSAGE, repeated=True
    )

    features: "FeatureSet | None" = betterproto2.field(
        21, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    feature_support: "FieldOptionsFeatureSupport | None" = betterproto2.field(
        22, betterproto2.TYPE_MESSAGE, optional=True
    )

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """


default_message_pool.register_message("google.protobuf", "FieldOptions", FieldOptions)


@dataclass(eq=False, repr=False)
class FieldOptionsEditionDefault(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FieldOptions.EditionDefault"
        ]

    edition: "Edition" = betterproto2.field(
        3, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )

    value: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    Textproto value.
    """


default_message_pool.register_message(
    "google.protobuf", "FieldOptions.EditionDefault", FieldOptionsEditionDefault
)


@dataclass(eq=False, repr=False)
class FieldOptionsFeatureSupport(betterproto2.Message):
    """
    Information about the support window of a feature.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FieldOptions.FeatureSupport"
        ]

    edition_introduced: "Edition" = betterproto2.field(
        1, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The edition that this feature was first available in.  In editions
    earlier than this one, the default assigned to EDITION_LEGACY will be
    used, and proto files will not be able to override it.
    """

    edition_deprecated: "Edition" = betterproto2.field(
        2, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The edition this feature becomes deprecated in.  Using this after this
    edition may trigger warnings.
    """

    deprecation_warning: "str" = betterproto2.field(3, betterproto2.TYPE_STRING)
    """
    The deprecation warning text if this feature is used after the edition it
    was marked deprecated in.
    """

    edition_removed: "Edition" = betterproto2.field(
        4, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The edition this feature is no longer available in.  In editions after
    this one, the last default assigned will be used, and proto files will
    not be able to override it.
    """


default_message_pool.register_message(
    "google.protobuf", "FieldOptions.FeatureSupport", FieldOptionsFeatureSupport
)


@dataclass(eq=False, repr=False)
class FileDescriptorProto(betterproto2.Message):
    """
    Describes a complete .proto file.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FileDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    file name, relative to root of source tree
    """

    package: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    e.g. "foo", "foo.bar", etc.
    """

    dependency: "list[str]" = betterproto2.field(
        3, betterproto2.TYPE_STRING, repeated=True
    )
    """
    Names of files imported by this file.
    """

    public_dependency: "list[int]" = betterproto2.field(
        10, betterproto2.TYPE_INT32, repeated=True
    )
    """
    Indexes of the public imported files in the dependency list above.
    """

    weak_dependency: "list[int]" = betterproto2.field(
        11, betterproto2.TYPE_INT32, repeated=True
    )
    """
    Indexes of the weak imported files in the dependency list.
    For Google-internal migration only. Do not use.
    """

    option_dependency: "list[str]" = betterproto2.field(
        15, betterproto2.TYPE_STRING, repeated=True
    )
    """
    Names of files imported by this file purely for the purpose of providing
    option extensions. These are excluded from the dependency list above.
    """

    message_type: "list[DescriptorProto]" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    All top-level definitions in this file.
    """

    enum_type: "list[EnumDescriptorProto]" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, repeated=True
    )

    service: "list[ServiceDescriptorProto]" = betterproto2.field(
        6, betterproto2.TYPE_MESSAGE, repeated=True
    )

    extension: "list[FieldDescriptorProto]" = betterproto2.field(
        7, betterproto2.TYPE_MESSAGE, repeated=True
    )

    options: "FileOptions | None" = betterproto2.field(
        8, betterproto2.TYPE_MESSAGE, optional=True
    )

    source_code_info: "SourceCodeInfo | None" = betterproto2.field(
        9, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    This field contains optional information about the original source code.
    You may safely remove this entire field without harming runtime
    functionality of the descriptors -- the information is needed only by
    development tools.
    """

    syntax: "str" = betterproto2.field(12, betterproto2.TYPE_STRING)
    """
    The syntax of the proto file.
    The supported values are "proto2", "proto3", and "editions".

    If `edition` is present, this value must be "editions".
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    edition: "Edition" = betterproto2.field(
        14, betterproto2.TYPE_ENUM, default_factory=lambda: Edition(0)
    )
    """
    The edition of the proto file.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """


default_message_pool.register_message(
    "google.protobuf", "FileDescriptorProto", FileDescriptorProto
)


@dataclass(eq=False, repr=False)
class FileDescriptorSet(betterproto2.Message):
    """
    The protocol compiler can output a FileDescriptorSet containing the .proto
    files it parses.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FileDescriptorSet"
        ]

    file: "list[FileDescriptorProto]" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, repeated=True
    )


default_message_pool.register_message(
    "google.protobuf", "FileDescriptorSet", FileDescriptorSet
)


@dataclass(eq=False, repr=False)
class FileOptions(betterproto2.Message):
    """
    ===================================================================
    Options

    Each of the definitions above may have "options" attached.  These are
    just annotations which may cause code to be generated slightly differently
    or may contain hints for code that manipulates protocol messages.

    Clients may define custom options as extensions of the *Options messages.
    These extensions may not yet be known at parsing time, so the parser cannot
    store the values in them.  Instead it stores them in a field in the *Options
    message called uninterpreted_option. This field must have the same name
    across all *Options messages. We then use this field to populate the
    extensions when we build a descriptor, at which point all protos have been
    parsed and so all extensions are known.

    Extension numbers for custom options may be chosen as follows:
    * For options which will only be used within a single application or
      organization, or for experimental options, use field numbers 50000
      through 99999.  It is up to you to ensure that you do not use the
      same number for multiple options.
    * For options which will be published and used publicly by multiple
      independent entities, e-mail protobuf-global-extension-registry@google.com
      to reserve extension numbers. Simply provide your project name (e.g.
      Objective-C plugin) and your project website (if available) -- there's no
      need to explain how you intend to use them. Usually you only need one
      extension number. You can declare multiple options with only one extension
      number by putting them in a sub-message. See the Custom Options section of
      the docs for examples:
      https://developers.google.com/protocol-buffers/docs/proto#options
      If this turns out to be popular, a web service will be set up
      to automatically assign option numbers.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "FileOptions"
        ]

    java_package: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    Sets the Java package where classes generated from this .proto will be
    placed.  By default, the proto package is used, but this is often
    inappropriate because proto packages do not normally start with backwards
    domain names.
    """

    java_outer_classname: "str" = betterproto2.field(8, betterproto2.TYPE_STRING)
    """
    Controls the name of the wrapper Java class generated for the .proto file.
    That class will always contain the .proto file's getDescriptor() method as
    well as any top-level extensions defined in the .proto file.
    If java_multiple_files is disabled, then all the other classes from the
    .proto file will be nested inside the single wrapper outer class.
    """

    java_multiple_files: "bool" = betterproto2.field(10, betterproto2.TYPE_BOOL)
    """
    If enabled, then the Java code generator will generate a separate .java
    file for each top-level message, enum, and service defined in the .proto
    file.  Thus, these types will *not* be nested inside the wrapper class
    named by java_outer_classname.  However, the wrapper class will still be
    generated to contain the file's getDescriptor() method as well as any
    top-level extensions defined in the file.
    """

    java_generate_equals_and_hash: "bool" = betterproto2.field(
        20, betterproto2.TYPE_BOOL
    )
    """
    This option does nothing.
    """

    java_string_check_utf8: "bool" = betterproto2.field(27, betterproto2.TYPE_BOOL)
    """
    A proto2 file can set this to true to opt in to UTF-8 checking for Java,
    which will throw an exception if invalid UTF-8 is parsed from the wire or
    assigned to a string field.

    TODO: clarify exactly what kinds of field types this option
    applies to, and update these docs accordingly.

    Proto3 files already perform these checks. Setting the option explicitly to
    false has no effect: it cannot be used to opt proto3 files out of UTF-8
    checks.
    """

    optimize_for: "FileOptionsOptimizeMode" = betterproto2.field(
        9, betterproto2.TYPE_ENUM, default_factory=lambda: FileOptionsOptimizeMode(0)
    )

    go_package: "str" = betterproto2.field(11, betterproto2.TYPE_STRING)
    """
    Sets the Go package where structs generated from this .proto will be
    placed. If omitted, the Go package will be derived from the following:
      - The basename of the package import path, if provided.
      - Otherwise, the package statement in the .proto file, if present.
      - Otherwise, the basename of the .proto file, without extension.
    """

    cc_generic_services: "bool" = betterproto2.field(16, betterproto2.TYPE_BOOL)
    """
    Should generic services be generated in each language?  "Generic" services
    are not specific to any particular RPC system.  They are generated by the
    main code generators in each language (without additional plugins).
    Generic services were the only kind of service generation supported by
    early versions of google.protobuf.

    Generic services are now considered deprecated in favor of using plugins
    that generate code specific to your particular RPC system.  Therefore,
    these default to false.  Old code which depends on generic services should
    explicitly set them to true.
    """

    java_generic_services: "bool" = betterproto2.field(17, betterproto2.TYPE_BOOL)

    py_generic_services: "bool" = betterproto2.field(18, betterproto2.TYPE_BOOL)

    deprecated: "bool" = betterproto2.field(23, betterproto2.TYPE_BOOL)
    """
    Is this file deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for everything in the file, or it will be completely ignored; in the very
    least, this is a formalization for deprecating files.
    """

    cc_enable_arenas: "bool" = betterproto2.field(31, betterproto2.TYPE_BOOL)
    """
    Enables the use of arenas for the proto messages in this file. This applies
    only to generated classes for C++.
    """

    objc_class_prefix: "str" = betterproto2.field(36, betterproto2.TYPE_STRING)
    """
    Sets the objective c class prefix which is prepended to all objective c
    generated classes from this .proto. There is no default.
    """

    csharp_namespace: "str" = betterproto2.field(37, betterproto2.TYPE_STRING)
    """
    Namespace for generated classes; defaults to the package.
    """

    swift_prefix: "str" = betterproto2.field(39, betterproto2.TYPE_STRING)
    """
    By default Swift generators will take the proto package and CamelCase it
    replacing '.' with underscore and use that to prefix the types/symbols
    defined. When this options is provided, they will use this value instead
    to prefix the types/symbols defined.
    """

    php_class_prefix: "str" = betterproto2.field(40, betterproto2.TYPE_STRING)
    """
    Sets the php class prefix which is prepended to all php generated classes
    from this .proto. Default is empty.
    """

    php_namespace: "str" = betterproto2.field(41, betterproto2.TYPE_STRING)
    """
    Use this option to change the namespace of php generated classes. Default
    is empty. When this option is empty, the package name will be used for
    determining the namespace.
    """

    php_metadata_namespace: "str" = betterproto2.field(44, betterproto2.TYPE_STRING)
    """
    Use this option to change the namespace of php generated metadata classes.
    Default is empty. When this option is empty, the proto file name will be
    used for determining the namespace.
    """

    ruby_package: "str" = betterproto2.field(45, betterproto2.TYPE_STRING)
    """
    Use this option to change the package of ruby generated classes. Default
    is empty. When this option is not set, the package name will be used for
    determining the ruby package.
    """

    features: "FeatureSet | None" = betterproto2.field(
        50, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here.
    See the documentation for the "Options" section above.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("java_generate_equals_and_hash"):
            warnings.warn(
                "FileOptions.java_generate_equals_and_hash is deprecated",
                DeprecationWarning,
            )


default_message_pool.register_message("google.protobuf", "FileOptions", FileOptions)


@dataclass(eq=False, repr=False)
class FloatValue(betterproto2.Message):
    """
    Wrapper message for `float`.

    The JSON representation for `FloatValue` is JSON number.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "FloatValue"
        ]

    value: "float" = betterproto2.field(1, betterproto2.TYPE_FLOAT)
    """
    The float value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, float):
            return FloatValue(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: float) -> "FloatValue":
        return FloatValue(value=wrapped)

    def to_wrapped(self) -> float:
        return self.value


default_message_pool.register_message("google.protobuf", "FloatValue", FloatValue)


@dataclass(eq=False, repr=False)
class GeneratedCodeInfo(betterproto2.Message):
    """
    Describes the relationship between generated code and its original source
    file. A GeneratedCodeInfo message is associated with only one generated
    source file, but may contain references to different source .proto files.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "GeneratedCodeInfo"
        ]

    annotation: "list[GeneratedCodeInfoAnnotation]" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    An Annotation connects some span of text in generated code to an element
    of its generating .proto file.
    """


default_message_pool.register_message(
    "google.protobuf", "GeneratedCodeInfo", GeneratedCodeInfo
)


@dataclass(eq=False, repr=False)
class GeneratedCodeInfoAnnotation(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "GeneratedCodeInfo.Annotation"
        ]

    path: "list[int]" = betterproto2.field(1, betterproto2.TYPE_INT32, repeated=True)
    """
    Identifies the element in the original source .proto file. This field
    is formatted the same as SourceCodeInfo.Location.path.
    """

    source_file: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    Identifies the filesystem path to the original source .proto.
    """

    begin: "int" = betterproto2.field(3, betterproto2.TYPE_INT32)
    """
    Identifies the starting offset in bytes in the generated code
    that relates to the identified object.
    """

    end: "int" = betterproto2.field(4, betterproto2.TYPE_INT32)
    """
    Identifies the ending offset in bytes in the generated code that
    relates to the identified object. The end offset should be one past
    the last relevant byte (so the length of the text = end - begin).
    """

    semantic: "GeneratedCodeInfoAnnotationSemantic" = betterproto2.field(
        5,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: GeneratedCodeInfoAnnotationSemantic(0),
    )


default_message_pool.register_message(
    "google.protobuf", "GeneratedCodeInfo.Annotation", GeneratedCodeInfoAnnotation
)


@dataclass(eq=False, repr=False)
class Int32Value(betterproto2.Message):
    """
    Wrapper message for `int32`.

    The JSON representation for `Int32Value` is JSON number.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "Int32Value"
        ]

    value: "int" = betterproto2.field(1, betterproto2.TYPE_INT32)
    """
    The int32 value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, int):
            return Int32Value(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: int) -> "Int32Value":
        return Int32Value(value=wrapped)

    def to_wrapped(self) -> int:
        return self.value


default_message_pool.register_message("google.protobuf", "Int32Value", Int32Value)


@dataclass(eq=False, repr=False)
class Int64Value(betterproto2.Message):
    """
    Wrapper message for `int64`.

    The JSON representation for `Int64Value` is JSON string.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "Int64Value"
        ]

    value: "int" = betterproto2.field(1, betterproto2.TYPE_INT64)
    """
    The int64 value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, int):
            return Int64Value(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: int) -> "Int64Value":
        return Int64Value(value=wrapped)

    def to_wrapped(self) -> int:
        return self.value


default_message_pool.register_message("google.protobuf", "Int64Value", Int64Value)


@dataclass(eq=False, repr=False)
class ListValue(betterproto2.Message):
    """
    `ListValue` is a wrapper around a repeated field of values.

    The JSON representation for `ListValue` is JSON array.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_STRUCT_PROTO_DESCRIPTOR.message_types_by_name[
            "ListValue"
        ]

    values: "list[Value]" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Repeated field of dynamically typed values.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        return cls(values=[Value.from_dict(v) for v in value])

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        # If the output format is PYTHON, we should have kept the wrapped type without building the real class
        assert output_format == betterproto2.OutputFormat.PROTO_JSON

        return [value.to_dict() for value in self.values]


default_message_pool.register_message("google.protobuf", "ListValue", ListValue)


@dataclass(eq=False, repr=False)
class MessageOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "MessageOptions"
        ]

    message_set_wire_format: "bool" = betterproto2.field(1, betterproto2.TYPE_BOOL)
    """
    Set true to use the old proto1 MessageSet wire format for extensions.
    This is provided for backwards-compatibility with the MessageSet wire
    format.  You should not use this for any other reason:  It's less
    efficient, has fewer features, and is more complicated.

    The message must be defined exactly as follows:
      message Foo {
        option message_set_wire_format = true;
        extensions 4 to max;
      }
    Note that the message cannot have any defined fields; MessageSets only
    have extensions.

    All extensions of your type must be singular messages; e.g. they cannot
    be int32s, enums, or repeated messages.

    Because this is an option, the above two restrictions are not enforced by
    the protocol compiler.
    """

    no_standard_descriptor_accessor: "bool" = betterproto2.field(
        2, betterproto2.TYPE_BOOL
    )
    """
    Disables the generation of the standard "descriptor()" accessor, which can
    conflict with a field of the same name.  This is meant to make migration
    from proto1 easier; new code should avoid fields named "descriptor".
    """

    deprecated: "bool" = betterproto2.field(3, betterproto2.TYPE_BOOL)
    """
    Is this message deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for the message, or it will be completely ignored; in the very least,
    this is a formalization for deprecating messages.
    """

    map_entry: "bool" = betterproto2.field(7, betterproto2.TYPE_BOOL)
    """
    Whether the message is an automatically generated map entry type for the
    maps field.

    For maps fields:
        map<KeyType, ValueType> map_field = 1;
    The parsed descriptor looks like:
        message MapFieldEntry {
            option map_entry = true;
            optional KeyType key = 1;
            optional ValueType value = 2;
        }
        repeated MapFieldEntry map_field = 1;

    Implementations may choose not to generate the map_entry=true message, but
    use a native map in the target language to hold the keys and values.
    The reflection APIs in such implementations still need to work as
    if the field is a repeated message field.

    NOTE: Do not set the option in .proto files. Always use the maps syntax
    instead. The option should only be implicitly set by the proto compiler
    parser.
    """

    deprecated_legacy_json_field_conflicts: "bool" = betterproto2.field(
        11, betterproto2.TYPE_BOOL
    )
    """
    Enable the legacy handling of JSON field name conflicts.  This lowercases
    and strips underscored from the fields before comparison in proto3 only.
    The new behavior takes `json_name` into account and applies to proto2 as
    well.

    This should only be used as a temporary measure against broken builds due
    to the change in behavior for JSON field name conflicts.

    TODO This is legacy behavior we plan to remove once downstream
    teams have had time to migrate.
    """

    features: "FeatureSet | None" = betterproto2.field(
        12, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("deprecated_legacy_json_field_conflicts"):
            warnings.warn(
                "MessageOptions.deprecated_legacy_json_field_conflicts is deprecated",
                DeprecationWarning,
            )


default_message_pool.register_message(
    "google.protobuf", "MessageOptions", MessageOptions
)


@dataclass(eq=False, repr=False)
class Method(betterproto2.Message):
    """
    Method represents a method of an API interface.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_API_PROTO_DESCRIPTOR.message_types_by_name["Method"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The simple name of this method.
    """

    request_type_url: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    A URL of the input message type.
    """

    request_streaming: "bool" = betterproto2.field(3, betterproto2.TYPE_BOOL)
    """
    If true, the request is streamed.
    """

    response_type_url: "str" = betterproto2.field(4, betterproto2.TYPE_STRING)
    """
    The URL of the output message type.
    """

    response_streaming: "bool" = betterproto2.field(5, betterproto2.TYPE_BOOL)
    """
    If true, the response is streamed.
    """

    options: "list[Option]" = betterproto2.field(
        6, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    Any metadata attached to the method.
    """

    syntax: "Syntax" = betterproto2.field(
        7, betterproto2.TYPE_ENUM, default_factory=lambda: Syntax(0)
    )
    """
    The source syntax of this method.
    """


default_message_pool.register_message("google.protobuf", "Method", Method)


@dataclass(eq=False, repr=False)
class MethodDescriptorProto(betterproto2.Message):
    """
    Describes a method of a service.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "MethodDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    input_type: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    Input and output type names.  These are resolved in the same way as
    FieldDescriptorProto.type_name, but must refer to a message type.
    """

    output_type: "str" = betterproto2.field(3, betterproto2.TYPE_STRING)

    options: "MethodOptions | None" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, optional=True
    )

    client_streaming: "bool" = betterproto2.field(5, betterproto2.TYPE_BOOL)
    """
    Identifies if client streams multiple client messages
    """

    server_streaming: "bool" = betterproto2.field(6, betterproto2.TYPE_BOOL)
    """
    Identifies if server streams multiple server messages
    """


default_message_pool.register_message(
    "google.protobuf", "MethodDescriptorProto", MethodDescriptorProto
)


@dataclass(eq=False, repr=False)
class MethodOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "MethodOptions"
        ]

    deprecated: "bool" = betterproto2.field(33, betterproto2.TYPE_BOOL)
    """
    Note:  Field numbers 1 through 32 are reserved for Google's internal RPC
      framework.  We apologize for hoarding these numbers to ourselves, but
      we were already using them long before we decided to release Protocol
      Buffers.

    Is this method deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for the method, or it will be completely ignored; in the very least,
    this is a formalization for deprecating methods.
    """

    idempotency_level: "MethodOptionsIdempotencyLevel" = betterproto2.field(
        34,
        betterproto2.TYPE_ENUM,
        default_factory=lambda: MethodOptionsIdempotencyLevel(0),
    )

    features: "FeatureSet | None" = betterproto2.field(
        35, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """


default_message_pool.register_message("google.protobuf", "MethodOptions", MethodOptions)


@dataclass(eq=False, repr=False)
class Mixin(betterproto2.Message):
    """
    Declares an API Interface to be included in this interface. The including
    interface must redeclare all the methods from the included interface, but
    documentation and options are inherited as follows:

    - If after comment and whitespace stripping, the documentation
      string of the redeclared method is empty, it will be inherited
      from the original method.

    - Each annotation belonging to the service config (http,
      visibility) which is not set in the redeclared method will be
      inherited.

    - If an http annotation is inherited, the path pattern will be
      modified as follows. Any version prefix will be replaced by the
      version of the including interface plus the [root][] path if
      specified.

    Example of a simple mixin:

        package google.acl.v1;
        service AccessControl {
          // Get the underlying ACL object.
          rpc GetAcl(GetAclRequest) returns (Acl) {
            option (google.api.http).get = "/v1/{resource=**}:getAcl";
          }
        }

        package google.storage.v2;
        service Storage {
          rpc GetAcl(GetAclRequest) returns (Acl);

          // Get a data record.
          rpc GetData(GetDataRequest) returns (Data) {
            option (google.api.http).get = "/v2/{resource=**}";
          }
        }

    Example of a mixin configuration:

        apis:
        - name: google.storage.v2.Storage
          mixins:
          - name: google.acl.v1.AccessControl

    The mixin construct implies that all methods in `AccessControl` are
    also declared with same name and request/response types in
    `Storage`. A documentation generator or annotation processor will
    see the effective `Storage.GetAcl` method after inheriting
    documentation and annotations as follows:

        service Storage {
          // Get the underlying ACL object.
          rpc GetAcl(GetAclRequest) returns (Acl) {
            option (google.api.http).get = "/v2/{resource=**}:getAcl";
          }
          ...
        }

    Note how the version in the path pattern changed from `v1` to `v2`.

    If the `root` field in the mixin is specified, it should be a
    relative path under which inherited HTTP paths are placed. Example:

        apis:
        - name: google.storage.v2.Storage
          mixins:
          - name: google.acl.v1.AccessControl
            root: acls

    This implies the following inherited HTTP annotation:

        service Storage {
          // Get the underlying ACL object.
          rpc GetAcl(GetAclRequest) returns (Acl) {
            option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";
          }
          ...
        }
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_API_PROTO_DESCRIPTOR.message_types_by_name["Mixin"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The fully qualified name of the interface which is included.
    """

    root: "str" = betterproto2.field(2, betterproto2.TYPE_STRING)
    """
    If non-empty specifies a path under which inherited HTTP paths
    are rooted.
    """


default_message_pool.register_message("google.protobuf", "Mixin", Mixin)


@dataclass(eq=False, repr=False)
class OneofDescriptorProto(betterproto2.Message):
    """
    Describes a oneof.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "OneofDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    options: "OneofOptions | None" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, optional=True
    )


default_message_pool.register_message(
    "google.protobuf", "OneofDescriptorProto", OneofDescriptorProto
)


@dataclass(eq=False, repr=False)
class OneofOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "OneofOptions"
        ]

    features: "FeatureSet | None" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """


default_message_pool.register_message("google.protobuf", "OneofOptions", OneofOptions)


@dataclass(eq=False, repr=False)
class Option(betterproto2.Message):
    """
    A protocol buffer option, which can be attached to a message, field,
    enumeration, etc.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.message_types_by_name["Option"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The option's name. For protobuf built-in options (options defined in
    descriptor.proto), this is the short name. For example, `"map_entry"`.
    For custom options, it should be the fully-qualified name. For example,
    `"google.api.http"`.
    """

    value: "Any | None" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    The option's value packed in an Any message. If the value is a primitive,
    the corresponding wrapper type defined in google/protobuf/wrappers.proto
    should be used. If the value is an enum, it should be stored as an int32
    value using the google.protobuf.Int32Value type.
    """


default_message_pool.register_message("google.protobuf", "Option", Option)


@dataclass(eq=False, repr=False)
class ServiceDescriptorProto(betterproto2.Message):
    """
    Describes a service.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "ServiceDescriptorProto"
        ]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    method: "list[MethodDescriptorProto]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )

    options: "ServiceOptions | None" = betterproto2.field(
        3, betterproto2.TYPE_MESSAGE, optional=True
    )


default_message_pool.register_message(
    "google.protobuf", "ServiceDescriptorProto", ServiceDescriptorProto
)


@dataclass(eq=False, repr=False)
class ServiceOptions(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "ServiceOptions"
        ]

    features: "FeatureSet | None" = betterproto2.field(
        34, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    Any features defined in the specific edition.
    WARNING: This field should only be used by protobuf plugins or special
    cases like the proto compiler. Other uses are discouraged and
    developers should rely on the protoreflect APIs for their client language.
    """

    deprecated: "bool" = betterproto2.field(33, betterproto2.TYPE_BOOL)
    """
    Note:  Field numbers 1 through 32 are reserved for Google's internal RPC
      framework.  We apologize for hoarding these numbers to ourselves, but
      we were already using them long before we decided to release Protocol
      Buffers.

    Is this service deprecated?
    Depending on the target platform, this can emit Deprecated annotations
    for the service, or it will be completely ignored; in the very least,
    this is a formalization for deprecating services.
    """

    uninterpreted_option: "list[UninterpretedOption]" = betterproto2.field(
        999, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The parser stores options it doesn't recognize here. See above.
    """


default_message_pool.register_message(
    "google.protobuf", "ServiceOptions", ServiceOptions
)


@dataclass(eq=False, repr=False)
class SourceCodeInfo(betterproto2.Message):
    """
    ===================================================================
    Optional source code info

    Encapsulates information about the original source file from which a
    FileDescriptorProto was generated.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "SourceCodeInfo"
        ]

    location: "list[SourceCodeInfoLocation]" = betterproto2.field(
        1, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    A Location identifies a piece of source code in a .proto file which
    corresponds to a particular definition.  This information is intended
    to be useful to IDEs, code indexers, documentation generators, and similar
    tools.

    For example, say we have a file like:
      message Foo {
        optional string foo = 1;
      }
    Let's look at just the field definition:
      optional string foo = 1;
      ^       ^^     ^^  ^  ^^^
      a       bc     de  f  ghi
    We have the following locations:
      span   path               represents
      [a,i)  [ 4, 0, 2, 0 ]     The whole field definition.
      [a,b)  [ 4, 0, 2, 0, 4 ]  The label (optional).
      [c,d)  [ 4, 0, 2, 0, 5 ]  The type (string).
      [e,f)  [ 4, 0, 2, 0, 1 ]  The name (foo).
      [g,h)  [ 4, 0, 2, 0, 3 ]  The number (1).

    Notes:
    - A location may refer to a repeated field itself (i.e. not to any
      particular index within it).  This is used whenever a set of elements are
      logically enclosed in a single code segment.  For example, an entire
      extend block (possibly containing multiple extension definitions) will
      have an outer location whose path refers to the "extensions" repeated
      field without an index.
    - Multiple locations may have the same path.  This happens when a single
      logical declaration is spread out across multiple places.  The most
      obvious example is the "extend" block again -- there may be multiple
      extend blocks in the same scope, each of which will have the same path.
    - A location's span is not always a subset of its parent's span.  For
      example, the "extendee" of an extension declaration appears at the
      beginning of the "extend" block and is shared by all extensions within
      the block.
    - Just because a location's span is a subset of some other location's span
      does not mean that it is a descendant.  For example, a "group" defines
      both a type and a field in a single declaration.  Thus, the locations
      corresponding to the type and field and their components will overlap.
    - Code which tries to interpret locations should probably be designed to
      ignore those that it doesn't understand, as more types of locations could
      be recorded in the future.
    """


default_message_pool.register_message(
    "google.protobuf", "SourceCodeInfo", SourceCodeInfo
)


@dataclass(eq=False, repr=False)
class SourceCodeInfoLocation(betterproto2.Message):
    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "SourceCodeInfo.Location"
        ]

    path: "list[int]" = betterproto2.field(1, betterproto2.TYPE_INT32, repeated=True)
    """
    Identifies which part of the FileDescriptorProto was defined at this
    location.

    Each element is a field number or an index.  They form a path from
    the root FileDescriptorProto to the place where the definition appears.
    For example, this path:
      [ 4, 3, 2, 7, 1 ]
    refers to:
      file.message_type(3)  // 4, 3
          .field(7)         // 2, 7
          .name()           // 1
    This is because FileDescriptorProto.message_type has field number 4:
      repeated DescriptorProto message_type = 4;
    and DescriptorProto.field has field number 2:
      repeated FieldDescriptorProto field = 2;
    and FieldDescriptorProto.name has field number 1:
      optional string name = 1;

    Thus, the above path gives the location of a field name.  If we removed
    the last element:
      [ 4, 3, 2, 7 ]
    this path refers to the whole field declaration (from the beginning
    of the label to the terminating semicolon).
    """

    span: "list[int]" = betterproto2.field(2, betterproto2.TYPE_INT32, repeated=True)
    """
    Always has exactly three or four elements: start line, start column,
    end line (optional, otherwise assumed same as start line), end column.
    These are packed into a single field for efficiency.  Note that line
    and column numbers are zero-based -- typically you will want to add
    1 to each before displaying to a user.
    """

    leading_comments: "str" = betterproto2.field(3, betterproto2.TYPE_STRING)
    """
    If this SourceCodeInfo represents a complete declaration, these are any
    comments appearing before and after the declaration which appear to be
    attached to the declaration.

    A series of line comments appearing on consecutive lines, with no other
    tokens appearing on those lines, will be treated as a single comment.

    leading_detached_comments will keep paragraphs of comments that appear
    before (but not connected to) the current element. Each paragraph,
    separated by empty lines, will be one comment element in the repeated
    field.

    Only the comment content is provided; comment markers (e.g. //) are
    stripped out.  For block comments, leading whitespace and an asterisk
    will be stripped from the beginning of each line other than the first.
    Newlines are included in the output.

    Examples:

      optional int32 foo = 1;  // Comment attached to foo.
      // Comment attached to bar.
      optional int32 bar = 2;

      optional string baz = 3;
      // Comment attached to baz.
      // Another line attached to baz.

      // Comment attached to moo.
      //
      // Another line attached to moo.
      optional double moo = 4;

      // Detached comment for corge. This is not leading or trailing comments
      // to moo or corge because there are blank lines separating it from
      // both.

      // Detached comment for corge paragraph 2.

      optional string corge = 5;
      /* Block comment attached
       * to corge.  Leading asterisks
       * will be removed. */
      /* Block comment attached to
       * grault. */
      optional int32 grault = 6;

      // ignored detached comments.
    """

    trailing_comments: "str" = betterproto2.field(4, betterproto2.TYPE_STRING)

    leading_detached_comments: "list[str]" = betterproto2.field(
        6, betterproto2.TYPE_STRING, repeated=True
    )


default_message_pool.register_message(
    "google.protobuf", "SourceCodeInfo.Location", SourceCodeInfoLocation
)


@dataclass(eq=False, repr=False)
class SourceContext(betterproto2.Message):
    """
    `SourceContext` represents information about the source of a
    protobuf element, like the file in which it is defined.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_SOURCE_CONTEXT_PROTO_DESCRIPTOR.message_types_by_name[
            "SourceContext"
        ]

    file_name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The path-qualified name of the .proto file that contained the associated
    protobuf element.  For example: `"google/protobuf/source_context.proto"`.
    """


default_message_pool.register_message("google.protobuf", "SourceContext", SourceContext)


@dataclass(eq=False, repr=False)
class StringValue(betterproto2.Message):
    """
    Wrapper message for `string`.

    The JSON representation for `StringValue` is JSON string.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "StringValue"
        ]

    value: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The string value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, str):
            return StringValue(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: str) -> "StringValue":
        return StringValue(value=wrapped)

    def to_wrapped(self) -> str:
        return self.value


default_message_pool.register_message("google.protobuf", "StringValue", StringValue)


@dataclass(eq=False, repr=False)
class Struct(betterproto2.Message):
    """
    `Struct` represents a structured data value, consisting of fields
    which map to dynamically typed values. In some languages, `Struct`
    might be supported by a native representation. For example, in
    scripting languages like JS a struct is represented as an
    object. The details of that representation are described together
    with the proto support for the language.

    The JSON representation for `Struct` is JSON object.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_STRUCT_PROTO_DESCRIPTOR.message_types_by_name["Struct"]

    fields: "dict[str, Value]" = betterproto2.field(
        1,
        betterproto2.TYPE_MAP,
        map_meta=betterproto2.map_meta(
            betterproto2.TYPE_STRING, betterproto2.TYPE_MESSAGE
        ),
    )
    """
    Unordered map of dynamically typed values.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        assert isinstance(value, dict)

        fields: dict[str, Value] = {}

        for key, val in value.items():
            fields[key] = Value.from_dict(val)

        return cls(fields=fields)  # type: ignore[reportArgumentType]

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        # If the output format is PYTHON, we should have kept the wrapped type without building the real class
        assert output_format == betterproto2.OutputFormat.PROTO_JSON

        return {
            key: value.to_dict(
                output_format=output_format,
                casing=casing,
                include_default_values=include_default_values,
            )
            for key, value in self.fields.items()
        }


default_message_pool.register_message("google.protobuf", "Struct", Struct)


@dataclass(eq=False, repr=False)
class Timestamp(betterproto2.Message):
    """
    A Timestamp represents a point in time independent of any time zone or local
    calendar, encoded as a count of seconds and fractions of seconds at
    nanosecond resolution. The count is relative to an epoch at UTC midnight on
    January 1, 1970, in the proleptic Gregorian calendar which extends the
    Gregorian calendar backwards to year one.

    All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap
    second table is needed for interpretation, using a [24-hour linear
    smear](https://developers.google.com/time/smear).

    The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By
    restricting to that range, we ensure that we can convert to and from [RFC
    3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.

    # Examples

    Example 1: Compute Timestamp from POSIX `time()`.

        Timestamp timestamp;
        timestamp.set_seconds(time(NULL));
        timestamp.set_nanos(0);

    Example 2: Compute Timestamp from POSIX `gettimeofday()`.

        struct timeval tv;
        gettimeofday(&tv, NULL);

        Timestamp timestamp;
        timestamp.set_seconds(tv.tv_sec);
        timestamp.set_nanos(tv.tv_usec * 1000);

    Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.

        FILETIME ft;
        GetSystemTimeAsFileTime(&ft);
        UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;

        // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z
        // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.
        Timestamp timestamp;
        timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));
        timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));

    Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.

        long millis = System.currentTimeMillis();

        Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)
            .setNanos((int) ((millis % 1000) * 1000000)).build();

    Example 5: Compute Timestamp from Java `Instant.now()`.

        Instant now = Instant.now();

        Timestamp timestamp =
            Timestamp.newBuilder().setSeconds(now.getEpochSecond())
                .setNanos(now.getNano()).build();

    Example 6: Compute Timestamp from current time in Python.

        timestamp = Timestamp()
        timestamp.GetCurrentTime()

    # JSON Mapping

    In JSON format, the Timestamp type is encoded as a string in the
    [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the
    format is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z"
    where {year} is always expressed using four digits while {month}, {day},
    {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional
    seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),
    are optional. The "Z" suffix indicates the timezone ("UTC"); the timezone
    is required. A proto3 JSON serializer should always use UTC (as indicated by
    "Z") when printing the Timestamp type and a proto3 JSON parser should be
    able to accept both UTC and other timezones (as indicated by an offset).

    For example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past
    01:30 UTC on January 15, 2017.

    In JavaScript, one can convert a Date object to this format using the
    standard
    [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString)
    method. In Python, a standard `datetime.datetime` object can be converted
    to this format using
    [`strftime`](https://docs.python.org/2/library/time.html#time.strftime) with
    the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one can use
    the Joda Time's [`ISODateTimeFormat.dateTime()`](
    http://joda-time.sourceforge.net/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime()
    ) to obtain a formatter capable of generating timestamps in this format.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TIMESTAMP_PROTO_DESCRIPTOR.message_types_by_name[
            "Timestamp"
        ]

    seconds: "int" = betterproto2.field(1, betterproto2.TYPE_INT64)
    """
    Represents seconds of UTC time since Unix epoch
    1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
    9999-12-31T23:59:59Z inclusive.
    """

    nanos: "int" = betterproto2.field(2, betterproto2.TYPE_INT32)
    """
    Non-negative fractions of a second at nanosecond resolution. Negative
    second values with fractions must still have non-negative nanos values
    that count forward in time. Must be from 0 to 999,999,999
    inclusive.
    """

    @classmethod
    def from_datetime(cls, dt: datetime.datetime) -> "Timestamp":
        if not dt.tzinfo:
            raise ValueError("datetime must be timezone aware")

        dt = dt.astimezone(datetime.timezone.utc)

        # manual epoch offset calulation to avoid rounding errors,
        # to support negative timestamps (before 1970) and skirt
        # around datetime bugs (apparently 0 isn't a year in [0, 9999]??)
        offset = dt - datetime.datetime(1970, 1, 1, tzinfo=datetime.timezone.utc)
        # below is the same as timedelta.total_seconds() but without dividing by 1e6
        # so we end up with microseconds as integers instead of seconds as float
        offset_us = (
            offset.days * 24 * 60 * 60 + offset.seconds
        ) * 10**6 + offset.microseconds
        seconds, us = divmod(offset_us, 10**6)
        return cls(seconds, us * 1000)

    def to_datetime(self) -> datetime.datetime:
        # datetime.fromtimestamp() expects a timestamp in seconds, not microseconds
        # if we pass it as a floating point number, we will run into rounding errors
        # see also #407
        offset = datetime.timedelta(
            seconds=self.seconds, microseconds=self.nanos // 1000
        )
        return datetime.datetime(1970, 1, 1, tzinfo=datetime.timezone.utc) + offset

    @staticmethod
    def timestamp_to_json(dt: datetime.datetime) -> str:
        nanos = dt.microsecond * 1e3
        if dt.tzinfo is not None:
            # change timezone aware datetime objects to utc
            dt = dt.astimezone(datetime.timezone.utc)
        copy = dt.replace(microsecond=0, tzinfo=None)
        result = copy.isoformat()
        if (nanos % 1e9) == 0:
            # If there are 0 fractional digits, the fractional
            # point '.' should be omitted when serializing.
            return f"{result}Z"
        if (nanos % 1e6) == 0:
            # Serialize 3 fractional digits.
            return f"{result}.{int(nanos // 1e6):03d}Z"
        if (nanos % 1e3) == 0:
            # Serialize 6 fractional digits.
            return f"{result}.{int(nanos // 1e3):06d}Z"
        # Serialize 9 fractional digits.
        return f"{result}.{nanos:09d}"

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, str):
            dt = dateutil.parser.isoparse(value)
            dt = dt.astimezone(datetime.timezone.utc)
            return Timestamp.from_datetime(dt)

        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        # If the output format is PYTHON, we should have kept the wraped type without building the real class
        assert output_format == betterproto2.OutputFormat.PROTO_JSON

        return Timestamp.timestamp_to_json(self.to_datetime())

    @staticmethod
    def from_wrapped(wrapped: datetime.datetime) -> "Timestamp":
        return Timestamp.from_datetime(wrapped)

    def to_wrapped(self) -> datetime.datetime:
        return self.to_datetime()


default_message_pool.register_message("google.protobuf", "Timestamp", Timestamp)


@dataclass(eq=False, repr=False)
class Type(betterproto2.Message):
    """
    A protocol buffer message type.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR.message_types_by_name["Type"]

    name: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)
    """
    The fully qualified message name.
    """

    fields: "list[Field]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The list of fields.
    """

    oneofs: "list[str]" = betterproto2.field(3, betterproto2.TYPE_STRING, repeated=True)
    """
    The list of types appearing in `oneof` definitions in this type.
    """

    options: "list[Option]" = betterproto2.field(
        4, betterproto2.TYPE_MESSAGE, repeated=True
    )
    """
    The protocol buffer options.
    """

    source_context: "SourceContext | None" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, optional=True
    )
    """
    The source context.
    """

    syntax: "Syntax" = betterproto2.field(
        6, betterproto2.TYPE_ENUM, default_factory=lambda: Syntax(0)
    )
    """
    The source syntax.
    """

    edition: "str" = betterproto2.field(7, betterproto2.TYPE_STRING)
    """
    The source edition string, only valid when syntax is SYNTAX_EDITIONS.
    """


default_message_pool.register_message("google.protobuf", "Type", Type)


@dataclass(eq=False, repr=False)
class UInt32Value(betterproto2.Message):
    """
    Wrapper message for `uint32`.

    The JSON representation for `UInt32Value` is JSON number.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "UInt32Value"
        ]

    value: "int" = betterproto2.field(1, betterproto2.TYPE_UINT32)
    """
    The uint32 value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, int):
            return UInt32Value(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: int) -> "UInt32Value":
        return UInt32Value(value=wrapped)

    def to_wrapped(self) -> int:
        return self.value


default_message_pool.register_message("google.protobuf", "UInt32Value", UInt32Value)


@dataclass(eq=False, repr=False)
class UInt64Value(betterproto2.Message):
    """
    Wrapper message for `uint64`.

    The JSON representation for `UInt64Value` is JSON string.

    Not recommended for use in new APIs, but still useful for legacy APIs and
    has no plan to be removed.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR.message_types_by_name[
            "UInt64Value"
        ]

    value: "int" = betterproto2.field(1, betterproto2.TYPE_UINT64)
    """
    The uint64 value.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        if isinstance(value, int):
            return UInt64Value(value=value)
        return super().from_dict(value, ignore_unknown_fields=ignore_unknown_fields)

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        return self.value

    @staticmethod
    def from_wrapped(wrapped: int) -> "UInt64Value":
        return UInt64Value(value=wrapped)

    def to_wrapped(self) -> int:
        return self.value


default_message_pool.register_message("google.protobuf", "UInt64Value", UInt64Value)


@dataclass(eq=False, repr=False)
class UninterpretedOption(betterproto2.Message):
    """
    A message representing a option the parser does not recognize. This only
    appears in options protos created by the compiler::Parser class.
    DescriptorPool resolves these when building Descriptor objects. Therefore,
    options protos in descriptor objects (e.g. returned by Descriptor::options(),
    or produced by Descriptor::CopyTo()) will never have UninterpretedOptions
    in them.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "UninterpretedOption"
        ]

    name: "list[UninterpretedOptionNamePart]" = betterproto2.field(
        2, betterproto2.TYPE_MESSAGE, repeated=True
    )

    identifier_value: "str" = betterproto2.field(3, betterproto2.TYPE_STRING)
    """
    The value of the uninterpreted option, in whatever type the tokenizer
    identified it as during parsing. Exactly one of these should be set.
    """

    positive_int_value: "int" = betterproto2.field(4, betterproto2.TYPE_UINT64)

    negative_int_value: "int" = betterproto2.field(5, betterproto2.TYPE_INT64)

    double_value: "float" = betterproto2.field(6, betterproto2.TYPE_DOUBLE)

    string_value: "bytes" = betterproto2.field(7, betterproto2.TYPE_BYTES)

    aggregate_value: "str" = betterproto2.field(8, betterproto2.TYPE_STRING)


default_message_pool.register_message(
    "google.protobuf", "UninterpretedOption", UninterpretedOption
)


@dataclass(eq=False, repr=False)
class UninterpretedOptionNamePart(betterproto2.Message):
    """
    The name of the uninterpreted option.  Each string represents a segment in
    a dot-separated name.  is_extension is true iff a segment represents an
    extension (denoted with parentheses in options specs in .proto files).
    E.g.,{ ["foo", false], ["bar.baz", true], ["moo", false] } represents
    "foo.(bar.baz).moo".
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR.message_types_by_name[
            "UninterpretedOption.NamePart"
        ]

    name_part: "str" = betterproto2.field(1, betterproto2.TYPE_STRING)

    is_extension: "bool" = betterproto2.field(2, betterproto2.TYPE_BOOL)


default_message_pool.register_message(
    "google.protobuf", "UninterpretedOption.NamePart", UninterpretedOptionNamePart
)


@dataclass(eq=False, repr=False)
class Value(betterproto2.Message):
    """
    `Value` represents a dynamically typed value which can be either
    null, a number, a string, a boolean, a recursive struct value, or a
    list of values. A producer of value is expected to set one of these
    variants. Absence of any variant indicates an error.

    The JSON representation for `Value` is JSON value.

    Oneofs:
        - kind: The kind of value.
    """

    @betterproto2.staticproperty
    @staticmethod
    def DESCRIPTOR() -> Descriptor:
        return GOOGLE_PROTOBUF_STRUCT_PROTO_DESCRIPTOR.message_types_by_name["Value"]

    null_value: "NullValue | None" = betterproto2.field(
        1, betterproto2.TYPE_ENUM, optional=True, group="kind"
    )
    """
    Represents a null value.
    """

    number_value: "float | None" = betterproto2.field(
        2, betterproto2.TYPE_DOUBLE, optional=True, group="kind"
    )
    """
    Represents a double value.
    """

    string_value: "str | None" = betterproto2.field(
        3, betterproto2.TYPE_STRING, optional=True, group="kind"
    )
    """
    Represents a string value.
    """

    bool_value: "bool | None" = betterproto2.field(
        4, betterproto2.TYPE_BOOL, optional=True, group="kind"
    )
    """
    Represents a boolean value.
    """

    struct_value: "Struct | None" = betterproto2.field(
        5, betterproto2.TYPE_MESSAGE, optional=True, group="kind"
    )
    """
    Represents a structured value.
    """

    list_value: "ListValue | None" = betterproto2.field(
        6, betterproto2.TYPE_MESSAGE, optional=True, group="kind"
    )
    """
    Represents a repeated `Value`.
    """

    @classmethod
    def from_dict(cls, value, *, ignore_unknown_fields: bool = False):
        match value:
            case bool() as b:
                return cls(bool_value=b)
            case int() | float() as num:
                return cls(number_value=num)
            case str() as s:
                return cls(string_value=s)
            case list() as l:
                return cls(list_value=ListValue.from_dict(l))
            case dict() as d:
                return cls(struct_value=Struct.from_dict(d))
            case None:
                return cls(null_value=NullValue.NULL_VALUE)
        raise ValueError(f"Unknown value type: {type(value)}")

    def to_dict(
        self,
        *,
        output_format: betterproto2.OutputFormat = betterproto2.OutputFormat.PROTO_JSON,
        casing: betterproto2.Casing = betterproto2.Casing.CAMEL,
        include_default_values: bool = False,
    ) -> dict[str, typing.Any] | typing.Any:
        # If the output format is PYTHON, we should have kept the wrapped type without building the real class
        assert output_format == betterproto2.OutputFormat.PROTO_JSON

        match self:
            case Value(null_value=NullValue.NULL_VALUE):
                return None
            case Value(bool_value=bool(b)):
                return b
            case Value(number_value=int(num)) | Value(number_value=float(num)):
                return num
            case Value(string_value=str(s)):
                return s
            case Value(list_value=ListValue(values=l)):
                return [v.to_dict() for v in l]
            case Value(struct_value=Struct(fields=f)):
                return {k: v.to_dict() for k, v in f.items()}

        raise ValueError("Invalid value")


default_message_pool.register_message("google.protobuf", "Value", Value)


GOOGLE_PROTOBUF_DESCRIPTOR_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n google/protobuf/descriptor.proto\x12\x0fgoogle.protobuf"[\n\x11FileDescriptorSet\x128\n\x04file\x18\x01 \x03(\x0b2$.google.protobuf.FileDescriptorProtoR\x04file*\x0c\x08\x80\xec\xca\xff\x01\x10\x81\xec\xca\xff\x01"\xc5\x05\n\x13FileDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n\x07package\x18\x02 \x01(\tR\x07package\x12\x1e\n\ndependency\x18\x03 \x03(\tR\ndependency\x12+\n\x11public_dependency\x18\n \x03(\x05R\x10publicDependency\x12\'\n\x0fweak_dependency\x18\x0b \x03(\x05R\x0eweakDependency\x12+\n\x11option_dependency\x18\x0f \x03(\tR\x10optionDependency\x12C\n\x0cmessage_type\x18\x04 \x03(\x0b2 .google.protobuf.DescriptorProtoR\x0bmessageType\x12A\n\tenum_type\x18\x05 \x03(\x0b2$.google.protobuf.EnumDescriptorProtoR\x08enumType\x12A\n\x07service\x18\x06 \x03(\x0b2\'.google.protobuf.ServiceDescriptorProtoR\x07service\x12C\n\textension\x18\x07 \x03(\x0b2%.google.protobuf.FieldDescriptorProtoR\textension\x126\n\x07options\x18\x08 \x01(\x0b2\x1c.google.protobuf.FileOptionsR\x07options\x12I\n\x10source_code_info\x18\t \x01(\x0b2\x1f.google.protobuf.SourceCodeInfoR\x0esourceCodeInfo\x12\x16\n\x06syntax\x18\x0c \x01(\tR\x06syntax\x122\n\x07edition\x18\x0e \x01(\x0e2\x18.google.protobuf.EditionR\x07edition"\xfc\x06\n\x0fDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12;\n\x05field\x18\x02 \x03(\x0b2%.google.protobuf.FieldDescriptorProtoR\x05field\x12C\n\textension\x18\x06 \x03(\x0b2%.google.protobuf.FieldDescriptorProtoR\textension\x12A\n\x0bnested_type\x18\x03 \x03(\x0b2 .google.protobuf.DescriptorProtoR\nnestedType\x12A\n\tenum_type\x18\x04 \x03(\x0b2$.google.protobuf.EnumDescriptorProtoR\x08enumType\x12X\n\x0fextension_range\x18\x05 \x03(\x0b2/.google.protobuf.DescriptorProto.ExtensionRangeR\x0eextensionRange\x12D\n\noneof_decl\x18\x08 \x03(\x0b2%.google.protobuf.OneofDescriptorProtoR\toneofDecl\x129\n\x07options\x18\x07 \x01(\x0b2\x1f.google.protobuf.MessageOptionsR\x07options\x12U\n\x0ereserved_range\x18\t \x03(\x0b2..google.protobuf.DescriptorProto.ReservedRangeR\rreservedRange\x12#\n\rreserved_name\x18\n \x03(\tR\x0creservedName\x12A\n\nvisibility\x18\x0b \x01(\x0e2!.google.protobuf.SymbolVisibilityR\nvisibility\x1az\n\x0eExtensionRange\x12\x14\n\x05start\x18\x01 \x01(\x05R\x05start\x12\x10\n\x03end\x18\x02 \x01(\x05R\x03end\x12@\n\x07options\x18\x03 \x01(\x0b2&.google.protobuf.ExtensionRangeOptionsR\x07options\x1a7\n\rReservedRange\x12\x14\n\x05start\x18\x01 \x01(\x05R\x05start\x12\x10\n\x03end\x18\x02 \x01(\x05R\x03end"\xca\x04\n\x15ExtensionRangeOptions\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption\x12Y\n\x0bdeclaration\x18\x02 \x03(\x0b22.google.protobuf.ExtensionRangeOptions.DeclarationR\x0bdeclarationB\x03\x88\x01\x02\x127\n\x08features\x182 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12m\n\x0cverification\x18\x03 \x01(\x0e28.google.protobuf.ExtensionRangeOptions.VerificationState:\nUNVERIFIEDR\x0cverificationB\x03\x88\x01\x02\x1a\x94\x01\n\x0bDeclaration\x12\x16\n\x06number\x18\x01 \x01(\x05R\x06number\x12\x1b\n\tfull_name\x18\x02 \x01(\tR\x08fullName\x12\x12\n\x04type\x18\x03 \x01(\tR\x04type\x12\x1a\n\x08reserved\x18\x05 \x01(\x08R\x08reserved\x12\x1a\n\x08repeated\x18\x06 \x01(\x08R\x08repeatedJ\x04\x08\x04\x10\x05"2\n\x11VerificationState\x12\r\n\x0bDECLARATION\x12\x0e\n\nUNVERIFIED\x10\x01*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02"\xc1\x06\n\x14FieldDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x16\n\x06number\x18\x03 \x01(\x05R\x06number\x12A\n\x05label\x18\x04 \x01(\x0e2+.google.protobuf.FieldDescriptorProto.LabelR\x05label\x12>\n\x04type\x18\x05 \x01(\x0e2*.google.protobuf.FieldDescriptorProto.TypeR\x04type\x12\x1b\n\ttype_name\x18\x06 \x01(\tR\x08typeName\x12\x1a\n\x08extendee\x18\x02 \x01(\tR\x08extendee\x12#\n\rdefault_value\x18\x07 \x01(\tR\x0cdefaultValue\x12\x1f\n\x0boneof_index\x18\t \x01(\x05R\noneofIndex\x12\x1b\n\tjson_name\x18\n \x01(\tR\x08jsonName\x127\n\x07options\x18\x08 \x01(\x0b2\x1d.google.protobuf.FieldOptionsR\x07options\x12\'\n\x0fproto3_optional\x18\x11 \x01(\x08R\x0eproto3Optional"\xb6\x02\n\x04Type\x12\x0f\n\x0bTYPE_DOUBLE\x10\x01\x12\x0e\n\nTYPE_FLOAT\x10\x02\x12\x0e\n\nTYPE_INT64\x10\x03\x12\x0f\n\x0bTYPE_UINT64\x10\x04\x12\x0e\n\nTYPE_INT32\x10\x05\x12\x10\n\x0cTYPE_FIXED64\x10\x06\x12\x10\n\x0cTYPE_FIXED32\x10\x07\x12\r\n\tTYPE_BOOL\x10\x08\x12\x0f\n\x0bTYPE_STRING\x10\t\x12\x0e\n\nTYPE_GROUP\x10\n\x12\x10\n\x0cTYPE_MESSAGE\x10\x0b\x12\x0e\n\nTYPE_BYTES\x10\x0c\x12\x0f\n\x0bTYPE_UINT32\x10\r\x12\r\n\tTYPE_ENUM\x10\x0e\x12\x11\n\rTYPE_SFIXED32\x10\x0f\x12\x11\n\rTYPE_SFIXED64\x10\x10\x12\x0f\n\x0bTYPE_SINT32\x10\x11\x12\x0f\n\x0bTYPE_SINT64\x10\x12"C\n\x05Label\x12\x12\n\x0eLABEL_OPTIONAL\x10\x01\x12\x12\n\x0eLABEL_REPEATED\x10\x03\x12\x12\n\x0eLABEL_REQUIRED\x10\x02"c\n\x14OneofDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x127\n\x07options\x18\x02 \x01(\x0b2\x1d.google.protobuf.OneofOptionsR\x07options"\xa6\x03\n\x13EnumDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12?\n\x05value\x18\x02 \x03(\x0b2).google.protobuf.EnumValueDescriptorProtoR\x05value\x126\n\x07options\x18\x03 \x01(\x0b2\x1c.google.protobuf.EnumOptionsR\x07options\x12]\n\x0ereserved_range\x18\x04 \x03(\x0b26.google.protobuf.EnumDescriptorProto.EnumReservedRangeR\rreservedRange\x12#\n\rreserved_name\x18\x05 \x03(\tR\x0creservedName\x12A\n\nvisibility\x18\x06 \x01(\x0e2!.google.protobuf.SymbolVisibilityR\nvisibility\x1a;\n\x11EnumReservedRange\x12\x14\n\x05start\x18\x01 \x01(\x05R\x05start\x12\x10\n\x03end\x18\x02 \x01(\x05R\x03end"\x83\x01\n\x18EnumValueDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x16\n\x06number\x18\x02 \x01(\x05R\x06number\x12;\n\x07options\x18\x03 \x01(\x0b2!.google.protobuf.EnumValueOptionsR\x07options"\xa7\x01\n\x16ServiceDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12>\n\x06method\x18\x02 \x03(\x0b2&.google.protobuf.MethodDescriptorProtoR\x06method\x129\n\x07options\x18\x03 \x01(\x0b2\x1f.google.protobuf.ServiceOptionsR\x07options"\x89\x02\n\x15MethodDescriptorProto\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n\ninput_type\x18\x02 \x01(\tR\tinputType\x12\x1f\n\x0boutput_type\x18\x03 \x01(\tR\noutputType\x128\n\x07options\x18\x04 \x01(\x0b2\x1e.google.protobuf.MethodOptionsR\x07options\x120\n\x10client_streaming\x18\x05 \x01(\x08:\x05falseR\x0fclientStreaming\x120\n\x10server_streaming\x18\x06 \x01(\x08:\x05falseR\x0fserverStreaming"\xad\t\n\x0bFileOptions\x12!\n\x0cjava_package\x18\x01 \x01(\tR\x0bjavaPackage\x120\n\x14java_outer_classname\x18\x08 \x01(\tR\x12javaOuterClassname\x125\n\x13java_multiple_files\x18\n \x01(\x08:\x05falseR\x11javaMultipleFiles\x12D\n\x1djava_generate_equals_and_hash\x18\x14 \x01(\x08R\x19javaGenerateEqualsAndHashB\x02\x18\x01\x12:\n\x16java_string_check_utf8\x18\x1b \x01(\x08:\x05falseR\x13javaStringCheckUtf8\x12S\n\x0coptimize_for\x18\t \x01(\x0e2).google.protobuf.FileOptions.OptimizeMode:\x05SPEEDR\x0boptimizeFor\x12\x1d\n\ngo_package\x18\x0b \x01(\tR\tgoPackage\x125\n\x13cc_generic_services\x18\x10 \x01(\x08:\x05falseR\x11ccGenericServices\x129\n\x15java_generic_services\x18\x11 \x01(\x08:\x05falseR\x13javaGenericServices\x125\n\x13py_generic_services\x18\x12 \x01(\x08:\x05falseR\x11pyGenericServices\x12%\n\ndeprecated\x18\x17 \x01(\x08:\x05falseR\ndeprecated\x12.\n\x10cc_enable_arenas\x18\x1f \x01(\x08:\x04trueR\x0eccEnableArenas\x12*\n\x11objc_class_prefix\x18$ \x01(\tR\x0fobjcClassPrefix\x12)\n\x10csharp_namespace\x18% \x01(\tR\x0fcsharpNamespace\x12!\n\x0cswift_prefix\x18\' \x01(\tR\x0bswiftPrefix\x12(\n\x10php_class_prefix\x18( \x01(\tR\x0ephpClassPrefix\x12#\n\rphp_namespace\x18) \x01(\tR\x0cphpNamespace\x124\n\x16php_metadata_namespace\x18, \x01(\tR\x14phpMetadataNamespace\x12!\n\x0cruby_package\x18- \x01(\tR\x0brubyPackage\x127\n\x08features\x182 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption":\n\x0cOptimizeMode\x12\t\n\x05SPEED\x10\x01\x12\r\n\tCODE_SIZE\x10\x02\x12\x10\n\x0cLITE_RUNTIME\x10\x03*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02J\x04\x08*\x10+J\x04\x08&\x10\'R\x14php_generic_services"\xf4\x03\n\x0eMessageOptions\x12<\n\x17message_set_wire_format\x18\x01 \x01(\x08:\x05falseR\x14messageSetWireFormat\x12L\n\x1fno_standard_descriptor_accessor\x18\x02 \x01(\x08:\x05falseR\x1cnoStandardDescriptorAccessor\x12%\n\ndeprecated\x18\x03 \x01(\x08:\x05falseR\ndeprecated\x12\x1b\n\tmap_entry\x18\x07 \x01(\x08R\x08mapEntry\x12V\n&deprecated_legacy_json_field_conflicts\x18\x0b \x01(\x08R"deprecatedLegacyJsonFieldConflictsB\x02\x18\x01\x127\n\x08features\x18\x0c \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02J\x04\x08\x04\x10\x05J\x04\x08\x05\x10\x06J\x04\x08\x06\x10\x07J\x04\x08\x08\x10\tJ\x04\x08\t\x10\n"\x95\r\n\x0cFieldOptions\x12A\n\x05ctype\x18\x01 \x01(\x0e2#.google.protobuf.FieldOptions.CType:\x06STRINGR\x05ctype\x12\x16\n\x06packed\x18\x02 \x01(\x08R\x06packed\x12G\n\x06jstype\x18\x06 \x01(\x0e2$.google.protobuf.FieldOptions.JSType:\tJS_NORMALR\x06jstype\x12\x19\n\x04lazy\x18\x05 \x01(\x08:\x05falseR\x04lazy\x12.\n\x0funverified_lazy\x18\x0f \x01(\x08:\x05falseR\x0eunverifiedLazy\x12%\n\ndeprecated\x18\x03 \x01(\x08:\x05falseR\ndeprecated\x12\x19\n\x04weak\x18\n \x01(\x08:\x05falseR\x04weak\x12(\n\x0cdebug_redact\x18\x10 \x01(\x08:\x05falseR\x0bdebugRedact\x12K\n\tretention\x18\x11 \x01(\x0e2-.google.protobuf.FieldOptions.OptionRetentionR\tretention\x12H\n\x07targets\x18\x13 \x03(\x0e2..google.protobuf.FieldOptions.OptionTargetTypeR\x07targets\x12W\n\x10edition_defaults\x18\x14 \x03(\x0b2,.google.protobuf.FieldOptions.EditionDefaultR\x0feditionDefaults\x127\n\x08features\x18\x15 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12U\n\x0ffeature_support\x18\x16 \x01(\x0b2,.google.protobuf.FieldOptions.FeatureSupportR\x0efeatureSupport\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption\x1aZ\n\x0eEditionDefault\x122\n\x07edition\x18\x03 \x01(\x0e2\x18.google.protobuf.EditionR\x07edition\x12\x14\n\x05value\x18\x02 \x01(\tR\x05value\x1a\x96\x02\n\x0eFeatureSupport\x12G\n\x12edition_introduced\x18\x01 \x01(\x0e2\x18.google.protobuf.EditionR\x11editionIntroduced\x12G\n\x12edition_deprecated\x18\x02 \x01(\x0e2\x18.google.protobuf.EditionR\x11editionDeprecated\x12/\n\x13deprecation_warning\x18\x03 \x01(\tR\x12deprecationWarning\x12A\n\x0fedition_removed\x18\x04 \x01(\x0e2\x18.google.protobuf.EditionR\x0eeditionRemoved"-\n\x05CType\x12\x08\n\x06STRING\x12\x08\n\x04CORD\x10\x01\x12\x10\n\x0cSTRING_PIECE\x10\x02"3\n\x06JSType\x12\x0b\n\tJS_NORMAL\x12\r\n\tJS_STRING\x10\x01\x12\r\n\tJS_NUMBER\x10\x02"S\n\x0fOptionRetention\x12\x13\n\x11RETENTION_UNKNOWN\x12\x15\n\x11RETENTION_RUNTIME\x10\x01\x12\x14\n\x10RETENTION_SOURCE\x10\x02"\x8a\x02\n\x10OptionTargetType\x12\x15\n\x13TARGET_TYPE_UNKNOWN\x12\x14\n\x10TARGET_TYPE_FILE\x10\x01\x12\x1f\n\x1bTARGET_TYPE_EXTENSION_RANGE\x10\x02\x12\x17\n\x13TARGET_TYPE_MESSAGE\x10\x03\x12\x15\n\x11TARGET_TYPE_FIELD\x10\x04\x12\x15\n\x11TARGET_TYPE_ONEOF\x10\x05\x12\x14\n\x10TARGET_TYPE_ENUM\x10\x06\x12\x1a\n\x16TARGET_TYPE_ENUM_ENTRY\x10\x07\x12\x17\n\x13TARGET_TYPE_SERVICE\x10\x08\x12\x16\n\x12TARGET_TYPE_METHOD\x10\t*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02J\x04\x08\x04\x10\x05J\x04\x08\x12\x10\x13"\xac\x01\n\x0cOneofOptions\x127\n\x08features\x18\x01 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02"\xd1\x02\n\x0bEnumOptions\x12\x1f\n\x0ballow_alias\x18\x02 \x01(\x08R\nallowAlias\x12%\n\ndeprecated\x18\x03 \x01(\x08:\x05falseR\ndeprecated\x12V\n&deprecated_legacy_json_field_conflicts\x18\x06 \x01(\x08R"deprecatedLegacyJsonFieldConflictsB\x02\x18\x01\x127\n\x08features\x18\x07 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02J\x04\x08\x05\x10\x06"\xd8\x02\n\x10EnumValueOptions\x12%\n\ndeprecated\x18\x01 \x01(\x08:\x05falseR\ndeprecated\x127\n\x08features\x18\x02 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12(\n\x0cdebug_redact\x18\x03 \x01(\x08:\x05falseR\x0bdebugRedact\x12U\n\x0ffeature_support\x18\x04 \x01(\x0b2,.google.protobuf.FieldOptions.FeatureSupportR\x0efeatureSupport\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02"\xd5\x01\n\x0eServiceOptions\x127\n\x08features\x18" \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12%\n\ndeprecated\x18! \x01(\x08:\x05falseR\ndeprecated\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02"\x97\x03\n\rMethodOptions\x12%\n\ndeprecated\x18! \x01(\x08:\x05falseR\ndeprecated\x12q\n\x11idempotency_level\x18" \x01(\x0e2/.google.protobuf.MethodOptions.IdempotencyLevel:\x13IDEMPOTENCY_UNKNOWNR\x10idempotencyLevel\x127\n\x08features\x18# \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x08features\x12X\n\x14uninterpreted_option\x18\xe7\x07 \x03(\x0b2$.google.protobuf.UninterpretedOptionR\x13uninterpretedOption"N\n\x10IdempotencyLevel\x12\x15\n\x13IDEMPOTENCY_UNKNOWN\x12\x13\n\x0fNO_SIDE_EFFECTS\x10\x01\x12\x0e\n\nIDEMPOTENT\x10\x02*\t\x08\xe8\x07\x10\x80\x80\x80\x80\x02"\x9a\x03\n\x13UninterpretedOption\x12A\n\x04name\x18\x02 \x03(\x0b2-.google.protobuf.UninterpretedOption.NamePartR\x04name\x12)\n\x10identifier_value\x18\x03 \x01(\tR\x0fidentifierValue\x12,\n\x12positive_int_value\x18\x04 \x01(\x04R\x10positiveIntValue\x12,\n\x12negative_int_value\x18\x05 \x01(\x03R\x10negativeIntValue\x12!\n\x0cdouble_value\x18\x06 \x01(\x01R\x0bdoubleValue\x12!\n\x0cstring_value\x18\x07 \x01(\x0cR\x0bstringValue\x12\'\n\x0faggregate_value\x18\x08 \x01(\tR\x0eaggregateValue\x1aJ\n\x08NamePart\x12\x1b\n\tname_part\x18\x01 \x02(\tR\x08namePart\x12!\n\x0cis_extension\x18\x02 \x02(\x08R\x0bisExtension"\xe6\x0e\n\nFeatureSet\x12\x90\x01\n\x0efield_presence\x18\x01 \x01(\x0e2).google.protobuf.FeatureSet.FieldPresenceR\rfieldPresenceB>\x88\x01\x01\x9a\x01\x02\x04\x01\xa2\x01\r\x18\x84\x07\x12\x08EXPLICIT\xa2\x01\r\x18\xe7\x07\x12\x08IMPLICIT\xa2\x01\r\x18\xe8\x07\x12\x08EXPLICIT\xb2\x01\x03\x08\xe8\x07\x12k\n\tenum_type\x18\x02 \x01(\x0e2$.google.protobuf.FeatureSet.EnumTypeR\x08enumTypeB(\x88\x01\x01\x9a\x01\x02\x06\x01\xa2\x01\x0b\x18\x84\x07\x12\x06CLOSED\xa2\x01\t\x18\xe7\x07\x12\x04OPEN\xb2\x01\x03\x08\xe8\x07\x12\x97\x01\n\x17repeated_field_encoding\x18\x03 \x01(\x0e21.google.protobuf.FeatureSet.RepeatedFieldEncodingR\x15repeatedFieldEncodingB,\x88\x01\x01\x9a\x01\x02\x04\x01\xa2\x01\r\x18\x84\x07\x12\x08EXPANDED\xa2\x01\x0b\x18\xe7\x07\x12\x06PACKED\xb2\x01\x03\x08\xe8\x07\x12}\n\x0futf8_validation\x18\x04 \x01(\x0e2*.google.protobuf.FeatureSet.Utf8ValidationR\x0eutf8ValidationB(\x88\x01\x01\x9a\x01\x02\x04\x01\xa2\x01\t\x18\x84\x07\x12\x04NONE\xa2\x01\x0b\x18\xe7\x07\x12\x06VERIFY\xb2\x01\x03\x08\xe8\x07\x12}\n\x10message_encoding\x18\x05 \x01(\x0e2+.google.protobuf.FeatureSet.MessageEncodingR\x0fmessageEncodingB%\x88\x01\x01\x9a\x01\x02\x04\x01\xa2\x01\x14\x18\x84\x07\x12\x0fLENGTH_PREFIXED\xb2\x01\x03\x08\xe8\x07\x12\x7f\n\x0bjson_format\x18\x06 \x01(\x0e2&.google.protobuf.FeatureSet.JsonFormatR\njsonFormatB6\x88\x01\x01\x9a\x01\x03\x03\x06\x01\xa2\x01\x17\x18\x84\x07\x12\x12LEGACY_BEST_EFFORT\xa2\x01\n\x18\xe7\x07\x12\x05ALLOW\xb2\x01\x03\x08\xe8\x07\x12\x9c\x01\n\x14enforce_naming_style\x18\x07 \x01(\x0e2..google.protobuf.FeatureSet.EnforceNamingStyleR\x12enforceNamingStyleB:\x88\x01\x02\x9a\x01\t\x01\x02\x03\x04\x05\x06\x07\x08\t\xa2\x01\x11\x18\x84\x07\x12\x0cSTYLE_LEGACY\xa2\x01\x0e\x18\xe9\x07\x12\tSTYLE2024\xb2\x01\x03\x08\xe9\x07\x12\xba\x01\n\x19default_symbol_visibility\x18\x08 \x01(\x0e2E.google.protobuf.FeatureSet.VisibilityFeature.DefaultSymbolVisibilityR\x17defaultSymbolVisibilityB7\x88\x01\x02\x9a\x01\x01\x01\xa2\x01\x0f\x18\x84\x07\x12\nEXPORT_ALL\xa2\x01\x15\x18\xe9\x07\x12\x10EXPORT_TOP_LEVEL\xb2\x01\x03\x08\xe9\x07\x1a\x9e\x01\n\x11VisibilityFeature"\x7f\n\x17DefaultSymbolVisibility\x12#\n!DEFAULT_SYMBOL_VISIBILITY_UNKNOWN\x12\x0e\n\nEXPORT_ALL\x10\x01\x12\x14\n\x10EXPORT_TOP_LEVEL\x10\x02\x12\r\n\tLOCAL_ALL\x10\x03\x12\n\n\x06STRICT\x10\x04J\x08\x08\x01\x10\x80\x80\x80\x80\x02"Z\n\rFieldPresence\x12\x18\n\x16FIELD_PRESENCE_UNKNOWN\x12\x0c\n\x08EXPLICIT\x10\x01\x12\x0c\n\x08IMPLICIT\x10\x02\x12\x13\n\x0fLEGACY_REQUIRED\x10\x03"5\n\x08EnumType\x12\x13\n\x11ENUM_TYPE_UNKNOWN\x12\x08\n\x04OPEN\x10\x01\x12\n\n\x06CLOSED\x10\x02"T\n\x15RepeatedFieldEncoding\x12!\n\x1fREPEATED_FIELD_ENCODING_UNKNOWN\x12\n\n\x06PACKED\x10\x01\x12\x0c\n\x08EXPANDED\x10\x02"G\n\x0eUtf8Validation\x12\x19\n\x17UTF8_VALIDATION_UNKNOWN\x12\n\n\x06VERIFY\x10\x02\x12\x08\n\x04NONE\x10\x03"\x04\x08\x01\x10\x01"Q\n\x0fMessageEncoding\x12\x1a\n\x18MESSAGE_ENCODING_UNKNOWN\x12\x13\n\x0fLENGTH_PREFIXED\x10\x01\x12\r\n\tDELIMITED\x10\x02"F\n\nJsonFormat\x12\x15\n\x13JSON_FORMAT_UNKNOWN\x12\t\n\x05ALLOW\x10\x01\x12\x16\n\x12LEGACY_BEST_EFFORT\x10\x02"U\n\x12EnforceNamingStyle\x12\x1e\n\x1cENFORCE_NAMING_STYLE_UNKNOWN\x12\r\n\tSTYLE2024\x10\x01\x12\x10\n\x0cSTYLE_LEGACY\x10\x02*\x06\x08\xe8\x07\x10\x8bN*\x06\x08\x8bN\x10\x90N*\x06\x08\x90N\x10\x91NJ\x06\x08\xe7\x07\x10\xe8\x07"\xef\x03\n\x12FeatureSetDefaults\x12X\n\x08defaults\x18\x01 \x03(\x0b2<.google.protobuf.FeatureSetDefaults.FeatureSetEditionDefaultR\x08defaults\x12A\n\x0fminimum_edition\x18\x04 \x01(\x0e2\x18.google.protobuf.EditionR\x0eminimumEdition\x12A\n\x0fmaximum_edition\x18\x05 \x01(\x0e2\x18.google.protobuf.EditionR\x0emaximumEdition\x1a\xf8\x01\n\x18FeatureSetEditionDefault\x122\n\x07edition\x18\x03 \x01(\x0e2\x18.google.protobuf.EditionR\x07edition\x12N\n\x14overridable_features\x18\x04 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\x13overridableFeatures\x12B\n\x0efixed_features\x18\x05 \x01(\x0b2\x1b.google.protobuf.FeatureSetR\rfixedFeaturesJ\x04\x08\x01\x10\x02J\x04\x08\x02\x10\x03R\x08features"\xb5\x02\n\x0eSourceCodeInfo\x12D\n\x08location\x18\x01 \x03(\x0b2(.google.protobuf.SourceCodeInfo.LocationR\x08location\x1a\xce\x01\n\x08Location\x12\x16\n\x04path\x18\x01 \x03(\x05R\x04pathB\x02\x10\x01\x12\x16\n\x04span\x18\x02 \x03(\x05R\x04spanB\x02\x10\x01\x12)\n\x10leading_comments\x18\x03 \x01(\tR\x0fleadingComments\x12+\n\x11trailing_comments\x18\x04 \x01(\tR\x10trailingComments\x12:\n\x19leading_detached_comments\x18\x06 \x03(\tR\x17leadingDetachedComments*\x0c\x08\x80\xec\xca\xff\x01\x10\x81\xec\xca\xff\x01"\xce\x02\n\x11GeneratedCodeInfo\x12M\n\nannotation\x18\x01 \x03(\x0b2-.google.protobuf.GeneratedCodeInfo.AnnotationR\nannotation\x1a\xe9\x01\n\nAnnotation\x12\x16\n\x04path\x18\x01 \x03(\x05R\x04pathB\x02\x10\x01\x12\x1f\n\x0bsource_file\x18\x02 \x01(\tR\nsourceFile\x12\x14\n\x05begin\x18\x03 \x01(\x05R\x05begin\x12\x10\n\x03end\x18\x04 \x01(\x05R\x03end\x12R\n\x08semantic\x18\x05 \x01(\x0e26.google.protobuf.GeneratedCodeInfo.Annotation.SemanticR\x08semantic"&\n\x08Semantic\x12\x06\n\x04NONE\x12\x07\n\x03SET\x10\x01\x12\t\n\x05ALIAS\x10\x02*\xa5\x02\n\x07Edition\x12\x11\n\x0fEDITION_UNKNOWN\x12\x13\n\x0eEDITION_LEGACY\x10\x84\x07\x12\x13\n\x0eEDITION_PROTO2\x10\xe6\x07\x12\x13\n\x0eEDITION_PROTO3\x10\xe7\x07\x12\x11\n\x0cEDITION_2023\x10\xe8\x07\x12\x11\n\x0cEDITION_2024\x10\xe9\x07\x12\x17\n\x13EDITION_1_TEST_ONLY\x10\x01\x12\x17\n\x13EDITION_2_TEST_ONLY\x10\x02\x12\x1d\n\x17EDITION_99997_TEST_ONLY\x10\x9d\x8d\x06\x12\x1d\n\x17EDITION_99998_TEST_ONLY\x10\x9e\x8d\x06\x12\x1d\n\x17EDITION_99999_TEST_ONLY\x10\x9f\x8d\x06\x12\x13\n\x0bEDITION_MAX\x10\xff\xff\xff\xff\x07*S\n\x10SymbolVisibility\x12\x12\n\x10VISIBILITY_UNSET\x12\x14\n\x10VISIBILITY_LOCAL\x10\x01\x12\x15\n\x11VISIBILITY_EXPORT\x10\x02B~\n\x13com.google.protobufB\x10DescriptorProtosH\x01Z-google.golang.org/protobuf/types/descriptorpb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1aGoogle.Protobuf.Reflection'
)
GOOGLE_PROTOBUF_ANY_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x19google/protobuf/any.proto\x12\x0fgoogle.protobuf"6\n\x03Any\x12\x19\n\x08type_url\x18\x01 \x01(\tR\x07typeUrl\x12\x14\n\x05value\x18\x02 \x01(\x0cR\x05valueBv\n\x13com.google.protobufB\x08AnyProtoP\x01Z,google.golang.org/protobuf/types/known/anypb\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_SOURCE_CONTEXT_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n$google/protobuf/source_context.proto\x12\x0fgoogle.protobuf",\n\rSourceContext\x12\x1b\n\tfile_name\x18\x01 \x01(\tR\x08fileNameB\x8a\x01\n\x13com.google.protobufB\x12SourceContextProtoP\x01Z6google.golang.org/protobuf/types/known/sourcecontextpb\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_TYPE_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1agoogle/protobuf/type.proto\x12\x0fgoogle.protobuf\x1a\x19google/protobuf/any.proto\x1a$google/protobuf/source_context.proto"\xa7\x02\n\x04Type\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12.\n\x06fields\x18\x02 \x03(\x0b2\x16.google.protobuf.FieldR\x06fields\x12\x16\n\x06oneofs\x18\x03 \x03(\tR\x06oneofs\x121\n\x07options\x18\x04 \x03(\x0b2\x17.google.protobuf.OptionR\x07options\x12E\n\x0esource_context\x18\x05 \x01(\x0b2\x1e.google.protobuf.SourceContextR\rsourceContext\x12/\n\x06syntax\x18\x06 \x01(\x0e2\x17.google.protobuf.SyntaxR\x06syntax\x12\x18\n\x07edition\x18\x07 \x01(\tR\x07edition"\xb0\x06\n\x05Field\x12/\n\x04kind\x18\x01 \x01(\x0e2\x1b.google.protobuf.Field.KindR\x04kind\x12D\n\x0bcardinality\x18\x02 \x01(\x0e2".google.protobuf.Field.CardinalityR\x0bcardinality\x12\x16\n\x06number\x18\x03 \x01(\x05R\x06number\x12\x12\n\x04name\x18\x04 \x01(\tR\x04name\x12\x19\n\x08type_url\x18\x06 \x01(\tR\x07typeUrl\x12\x1f\n\x0boneof_index\x18\x07 \x01(\x05R\noneofIndex\x12\x16\n\x06packed\x18\x08 \x01(\x08R\x06packed\x121\n\x07options\x18\t \x03(\x0b2\x17.google.protobuf.OptionR\x07options\x12\x1b\n\tjson_name\x18\n \x01(\tR\x08jsonName\x12#\n\rdefault_value\x18\x0b \x01(\tR\x0cdefaultValue"\xc6\x02\n\x04Kind\x12\x0e\n\x0cTYPE_UNKNOWN\x12\x0f\n\x0bTYPE_DOUBLE\x10\x01\x12\x0e\n\nTYPE_FLOAT\x10\x02\x12\x0e\n\nTYPE_INT64\x10\x03\x12\x0f\n\x0bTYPE_UINT64\x10\x04\x12\x0e\n\nTYPE_INT32\x10\x05\x12\x10\n\x0cTYPE_FIXED64\x10\x06\x12\x10\n\x0cTYPE_FIXED32\x10\x07\x12\r\n\tTYPE_BOOL\x10\x08\x12\x0f\n\x0bTYPE_STRING\x10\t\x12\x0e\n\nTYPE_GROUP\x10\n\x12\x10\n\x0cTYPE_MESSAGE\x10\x0b\x12\x0e\n\nTYPE_BYTES\x10\x0c\x12\x0f\n\x0bTYPE_UINT32\x10\r\x12\r\n\tTYPE_ENUM\x10\x0e\x12\x11\n\rTYPE_SFIXED32\x10\x0f\x12\x11\n\rTYPE_SFIXED64\x10\x10\x12\x0f\n\x0bTYPE_SINT32\x10\x11\x12\x0f\n\x0bTYPE_SINT64\x10\x12"r\n\x0bCardinality\x12\x15\n\x13CARDINALITY_UNKNOWN\x12\x18\n\x14CARDINALITY_OPTIONAL\x10\x01\x12\x18\n\x14CARDINALITY_REQUIRED\x10\x02\x12\x18\n\x14CARDINALITY_REPEATED\x10\x03"\x99\x02\n\x04Enum\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x128\n\tenumvalue\x18\x02 \x03(\x0b2\x1a.google.protobuf.EnumValueR\tenumvalue\x121\n\x07options\x18\x03 \x03(\x0b2\x17.google.protobuf.OptionR\x07options\x12E\n\x0esource_context\x18\x04 \x01(\x0b2\x1e.google.protobuf.SourceContextR\rsourceContext\x12/\n\x06syntax\x18\x05 \x01(\x0e2\x17.google.protobuf.SyntaxR\x06syntax\x12\x18\n\x07edition\x18\x06 \x01(\tR\x07edition"j\n\tEnumValue\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x16\n\x06number\x18\x02 \x01(\x05R\x06number\x121\n\x07options\x18\x03 \x03(\x0b2\x17.google.protobuf.OptionR\x07options"H\n\x06Option\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12*\n\x05value\x18\x02 \x01(\x0b2\x14.google.protobuf.AnyR\x05value*A\n\x06Syntax\x12\x0f\n\rSYNTAX_PROTO2\x12\x11\n\rSYNTAX_PROTO3\x10\x01\x12\x13\n\x0fSYNTAX_EDITIONS\x10\x02B{\n\x13com.google.protobufB\tTypeProtoP\x01Z-google.golang.org/protobuf/types/known/typepb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_TIMESTAMP_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1fgoogle/protobuf/timestamp.proto\x12\x0fgoogle.protobuf";\n\tTimestamp\x12\x18\n\x07seconds\x18\x01 \x01(\x03R\x07seconds\x12\x14\n\x05nanos\x18\x02 \x01(\x05R\x05nanosB\x85\x01\n\x13com.google.protobufB\x0eTimestampProtoP\x01Z2google.golang.org/protobuf/types/known/timestamppb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_EMPTY_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1bgoogle/protobuf/empty.proto\x12\x0fgoogle.protobuf"\x07\n\x05EmptyB}\n\x13com.google.protobufB\nEmptyProtoP\x01Z.google.golang.org/protobuf/types/known/emptypb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_API_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x19google/protobuf/api.proto\x12\x0fgoogle.protobuf\x1a$google/protobuf/source_context.proto\x1a\x1agoogle/protobuf/type.proto"\xc1\x02\n\x03Api\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x121\n\x07methods\x18\x02 \x03(\x0b2\x17.google.protobuf.MethodR\x07methods\x121\n\x07options\x18\x03 \x03(\x0b2\x17.google.protobuf.OptionR\x07options\x12\x18\n\x07version\x18\x04 \x01(\tR\x07version\x12E\n\x0esource_context\x18\x05 \x01(\x0b2\x1e.google.protobuf.SourceContextR\rsourceContext\x12.\n\x06mixins\x18\x06 \x03(\x0b2\x16.google.protobuf.MixinR\x06mixins\x12/\n\x06syntax\x18\x07 \x01(\x0e2\x17.google.protobuf.SyntaxR\x06syntax"\xb2\x02\n\x06Method\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12(\n\x10request_type_url\x18\x02 \x01(\tR\x0erequestTypeUrl\x12+\n\x11request_streaming\x18\x03 \x01(\x08R\x10requestStreaming\x12*\n\x11response_type_url\x18\x04 \x01(\tR\x0fresponseTypeUrl\x12-\n\x12response_streaming\x18\x05 \x01(\x08R\x11responseStreaming\x121\n\x07options\x18\x06 \x03(\x0b2\x17.google.protobuf.OptionR\x07options\x12/\n\x06syntax\x18\x07 \x01(\x0e2\x17.google.protobuf.SyntaxR\x06syntax"/\n\x05Mixin\x12\x12\n\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n\x04root\x18\x02 \x01(\tR\x04rootBv\n\x13com.google.protobufB\x08ApiProtoP\x01Z,google.golang.org/protobuf/types/known/apipb\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_STRUCT_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1cgoogle/protobuf/struct.proto\x12\x0fgoogle.protobuf"\x98\x01\n\x06Struct\x12;\n\x06fields\x18\x01 \x03(\x0b2#.google.protobuf.Struct.FieldsEntryR\x06fields\x1aQ\n\x0bFieldsEntry\x12\x10\n\x03key\x18\x01 \x01(\tR\x03key\x12,\n\x05value\x18\x02 \x01(\x0b2\x16.google.protobuf.ValueR\x05value:\x028\x01"\xb2\x02\n\x05Value\x12;\n\nnull_value\x18\x01 \x01(\x0e2\x1a.google.protobuf.NullValueH\x00R\tnullValue\x12#\n\x0cnumber_value\x18\x02 \x01(\x01H\x00R\x0bnumberValue\x12#\n\x0cstring_value\x18\x03 \x01(\tH\x00R\x0bstringValue\x12\x1f\n\nbool_value\x18\x04 \x01(\x08H\x00R\tboolValue\x12<\n\x0cstruct_value\x18\x05 \x01(\x0b2\x17.google.protobuf.StructH\x00R\x0bstructValue\x12;\n\nlist_value\x18\x06 \x01(\x0b2\x1a.google.protobuf.ListValueH\x00R\tlistValueB\x06\n\x04kind";\n\tListValue\x12.\n\x06values\x18\x01 \x03(\x0b2\x16.google.protobuf.ValueR\x06values*\x19\n\tNullValue\x12\x0c\n\nNULL_VALUEB\x7f\n\x13com.google.protobufB\x0bStructProtoP\x01Z/google.golang.org/protobuf/types/known/structpb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_FIELD_MASK_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n google/protobuf/field_mask.proto\x12\x0fgoogle.protobuf"!\n\tFieldMask\x12\x14\n\x05paths\x18\x01 \x03(\tR\x05pathsB\x85\x01\n\x13com.google.protobufB\x0eFieldMaskProtoP\x01Z2google.golang.org/protobuf/types/known/fieldmaskpb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_WRAPPERS_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1egoogle/protobuf/wrappers.proto\x12\x0fgoogle.protobuf"#\n\x0bDoubleValue\x12\x14\n\x05value\x18\x01 \x01(\x01R\x05value""\n\nFloatValue\x12\x14\n\x05value\x18\x01 \x01(\x02R\x05value""\n\nInt64Value\x12\x14\n\x05value\x18\x01 \x01(\x03R\x05value"#\n\x0bUInt64Value\x12\x14\n\x05value\x18\x01 \x01(\x04R\x05value""\n\nInt32Value\x12\x14\n\x05value\x18\x01 \x01(\x05R\x05value"#\n\x0bUInt32Value\x12\x14\n\x05value\x18\x01 \x01(\rR\x05value"!\n\tBoolValue\x12\x14\n\x05value\x18\x01 \x01(\x08R\x05value"#\n\x0bStringValue\x12\x14\n\x05value\x18\x01 \x01(\tR\x05value""\n\nBytesValue\x12\x14\n\x05value\x18\x01 \x01(\x0cR\x05valueB\x83\x01\n\x13com.google.protobufB\rWrappersProtoP\x01Z1google.golang.org/protobuf/types/known/wrapperspb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
GOOGLE_PROTOBUF_DURATION_PROTO_DESCRIPTOR = default_google_proto_descriptor_pool.AddSerializedFile(
    b'\n\x1egoogle/protobuf/duration.proto\x12\x0fgoogle.protobuf":\n\x08Duration\x12\x18\n\x07seconds\x18\x01 \x01(\x03R\x07seconds\x12\x14\n\x05nanos\x18\x02 \x01(\x05R\x05nanosB\x83\x01\n\x13com.google.protobufB\rDurationProtoP\x01Z1google.golang.org/protobuf/types/known/durationpb\xf8\x01\x01\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3'
)
