# Contributing to desto

Thank you for your interest in contributing! This project values kind communication, understanding, and respect. Whether you're fixing bugs, improving documentation, or suggesting new features, your contributions are welcome.

## How to Contribute

- **Open Communication:** Please discuss any major changes or ideas in an issue before making a pull request. This helps ensure your work aligns with the project's goals.
- **Respect:** Be kind and constructive in all interactions.
- **Transparency:** Be clear about what your change does and why. Include context and reasoning in issues and pull requests.

## Submitting Issues

- Provide as much detail as possible (steps to reproduce, environment, etc.).

## Submitting Pull Requests

1. Fork the repository and create your branch from `main`.
2. Make your changes, following good code practices and adding tests if appropriate.
3. Ensure your code passes linting and tests (`uv run --extra dev pytest tests/` and `uv run --extra dev ruff check .`).
4. Open a pull request with a clear description of your changes.

## Code of Conduct

Please be respectful and inclusive. Disrespectful or inappropriate behavior will not be tolerated.