# RPC Client

Auto-generated WebSocket RPC Client with Environment Detection.

## Installation

```bash
pip install -r requirements.txt
```

## Usage

### Auto-detect environment

```python
from client import RPCClient

# Auto-detect from DJANGO_ENV or ENV
client = RPCClient()
await client.connect()

# Or use factory method
client = RPCClient.from_env()
await client.connect()
```

### Explicit environment

```python
client = RPCClient.from_env("production")
await client.connect()
```

### Custom URL

```python
client = RPCClient("wss://custom.api.com/ws")
await client.connect()
```

## Environment Variables

The client detects environment in this priority order:
1. `DJANGO_ENV` (for Django projects)
2. `ENV` (generic fallback)
3. `DEBUG` flag (true=development, false=production)
4. Default: `development`

### Supported aliases:
- `dev`, `devel`, `develop`, `local` → `development`
- `prod` → `production`
- `stage` → `staging`
- `test` → `testing`

## Example

```python
import asyncio
import os
from client import RPCClient
from models import CreateUserParams

async def main():
    # Set environment
    os.environ["DJANGO_ENV"] = "production"

    # Client auto-detects and uses production URL
    client = RPCClient.from_env()
    await client.connect()

    try:
        # Call RPC methods
        result = await client.create_user(params)
        result = await client.get_user(params)
        result = await client.list_users(params)
    finally:
        await client.disconnect()

if __name__ == "__main__":
    asyncio.run(main())
```

## Generated by

django_ipc codegen