# RPC Client

Auto-generated WebSocket RPC Client with Environment Detection.

## Installation

```bash
npm install
```

## Build

```bash
npm run build
```

## Usage

### Auto-detect environment

```typescript
import { RPCClient } from './client';

// Auto-detect from NODE_ENV or DJANGO_ENV
const client = new RPCClient();
await client.connect();

// Or use factory method
const client = RPCClient.fromEnv();
await client.connect();
```

### Explicit environment

```typescript
const client = RPCClient.fromEnv('production');
await client.connect();
```

### Custom URL

```typescript
const client = new RPCClient('wss://custom.api.com/ws');
await client.connect();
```

## Environment Variables

The client detects environment in this priority order:
1. `NODE_ENV` (standard for Node.js/frontend)
2. `DJANGO_ENV` (for Django compatibility)
3. `ENV` (generic fallback)
4. Default: `development`

### Supported aliases:
- `dev`, `devel`, `develop`, `local` → `development`
- `prod` → `production`
- `stage` → `staging`
- `test` → `testing`

## Example

```typescript
// Set environment
process.env.NODE_ENV = 'production';

// Client auto-detects and uses production URL
const client = new RPCClient();
await client.connect();

// Call RPC methods
const result = await client.createUser(params);
const result = await client.getUser(params);
const result = await client.listUsers(params);

await client.disconnect();
```

## Generated by

django_ipc codegen