# FiMDPEnv - Environments for FiMDP

**FiMDPEnv** is a Python package that provides realistic simulation environments that model real-world consumption Markov decision processes (consumption MDPs). The package is primarily designed to help in testing and benchmarking the tools in the [FiMDP] package. Apart from the consumption MDPs, the package also provides tools to analyze, manipulate, and visualize the environment and any strategies generated by the FiMDP package.

# Installation

FiMDPEnv can be installed using pip from PyPI
```
pip install -U fimdpenv
```

# Usage and Examples

The directory [examples](https://github.com/FiMDP/FiMDPEnv/tree/master/examples) contains several [Jupyter] notebooks that explain how to create instances of different environments and interface them with FiMDP. The following visualizations illustrate different environments currently available in FiMDPEnv. These environments model (i) the stochastic dynamics of one or more unmanned underwater vehicles (UUVs) operating with limited onboard energy storage capacity, and, (ii) the stochastic energy consumption of an autonomous electric vehicle (AEV) operating in the busy streets of Manhattan, New York.


<p align="center">
<img src="https://raw.githubusercontent.com/FiMDP/FiMDPEnv/master/images/uuvenvdemo.gif" alt="Multiple agents following energy-aware policies in SynchronousMultiAgentEnv environment." align="center" height="250" width="350" >
<br>
<em>Multiple agents following energy-aware policies in UUVEnv environment.</em>
</p>

<p align="center">
<img src="https://raw.githubusercontent.com/FiMDP/FiMDPEnv/master/images/aevenvdemo.png" alt="An agent following an energy-aware policy in AEVEnv." align="center" height="250" width="350" >
<br>
<em>An agent following an energy-aware policy in AEVEnv.</em>
</p>

### Contact
If you have any trouble with the installation, or have any questions, raise an issue or email [Pranay Thangeda](contact@prny.me).



[FiMDP]: (https://github.com/FiMDP/FiMDP)
[Jupyter]: https://jupyter.org
